/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.google.common.collect.ImmutableMap;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.service.IManagementProtocolService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.IKeystoreManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.IAMManager;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cert.component.OpenstackDependedCertificateService;
import com.huawei.ism.drm.openstack.model.OpenStackServiceEndPoint;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZone;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.msg.CloudAvailableZone;
import com.huawei.ism.drm.openstack.sdk.msg.CloudInfra;
import com.huawei.ism.drm.openstack.sdk.msg.DomainInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.serviceinstance.SDRRegisterHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.cbb.cloudservice.sdk.model.MultiCloudProjectIdMapping;
import com.huawei.lego.cbb.cloudservice.sdk.util.MultiCloudUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.meter.dao.MeterDao;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@Service(name="com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService", desc="", interfaceClass=IOpenstackResourceService.class)
public class OpenstackResourceServiceImpl
extends BaseService
implements IOpenstackResourceService {
    private static final Log LOG = LogFactory.getInstance(OpenstackResourceServiceImpl.class);
    private static final Set<String> SERVICE_TYPE_SET = new HashSet<String>(Arrays.asList("compute", "network", "volume", "agent", "compute-ext", "metering", "image", "apicom", "csha", "elb", "cce", "rds", "dcs", "manila", "filemeter"));
    private static final String DEFAULT_MULTI_CLOUD_DISPATCHER_SUPPORT_LIST = "v2/[0-9a-zA-Z]{1,32}/volumes/[0-9a-zA-Z-]{1,36};v2\\.1/[0-9a-zA-Z]{1,32}/servers/[0-9a-zA-Z-]{1,36};v2/flavors/detail";
    private static final int NOT_REQUIRED_SERVICE_TYPE_NUMBER = 8;
    private MeterDao meterDao;
    private OpenstackDependedCertificateService openstackDependedCertificateService;

    public MeterDao getMeterDao() {
        return this.meterDao;
    }

    public void setMeterDao(MeterDao meterDao) {
        this.meterDao = meterDao;
    }

    public List<OpenStackAvailabilityZone> getAvailabilityZones(String openstackUuid, String regionUuid, String projectUuid, Boolean zoneState) {
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)("Param is empty:projectUuid=" + projectUuid));
            throw new LegoCheckedException(1073947393L);
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        ICinderManager manager = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        if (!regionUuid.contains(":")) {
            regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, regionUuid);
        }
        List<OpenStackAvailabilityZone> result = manager.getAzs(regionUuid, tokenId, projectUuid);
        if (zoneState != null && result != null && !result.isEmpty()) {
            result.removeIf(az -> !zoneState.equals(az.getZoneAvailable()));
        }
        return result;
    }

    public List<OpenStackProject> getProjectFromDB(String openstackUuid, Boolean isEnable) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.error((Object)("Param is empty:openstackUuid=" + openstackUuid));
            throw new LegoCheckedException(1073947393L);
        }
        OpenstackInfo open = ManagerFactory.getInstance().getRegOpenstack(openstackUuid);
        String unscopedToken = TokenUtil.getInstance().getTokenId(open, null);
        IKeystoreManager keystoreMgr = ManagerFactory.getInstance().getKeystoreManagerByVersion(null, open.isUseIAM());
        List<OpenStackProject> openStackProjects = keystoreMgr.getProjects(open, unscopedToken);
        openStackProjects.sort(Comparator.comparing(ManagedObject::getName));
        if (VerifyUtil.isEmpty((Object)isEnable)) {
            return openStackProjects;
        }
        ArrayList<OpenStackProject> openStackProjectsReturn = new ArrayList<OpenStackProject>();
        for (OpenStackProject osp : openStackProjects) {
            if (!isEnable.equals(osp.getEnabled())) continue;
            openStackProjectsReturn.add(osp);
        }
        return openStackProjectsReturn;
    }

    public OpenStackProject getProjectByProjectUUid(String projectUUid) {
        if (VerifyUtil.isEmpty((String)projectUUid)) {
            LOG.error((Object)("Param is projectUUid=" + projectUUid));
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObject managedObject = CommonDAOLocator.getMoDao().getMoByUuid(projectUUid, Boolean.valueOf(true));
        if (!VerifyUtil.isEmpty((Object)managedObject) && !VerifyUtil.isEmpty((String)managedObject.getName()) && managedObject instanceof OpenStackProject) {
            return (OpenStackProject)managedObject;
        }
        LOG.info((Object)"Can't find project from DB,find it from OpenStack,projectUUid=%s", new Object[]{projectUUid});
        OpenstackInfo open = ManagerFactory.getInstance().getRegOpenstack(OpenStackCommonUtil.getOpenstackUuidFromStr(projectUUid));
        String unscopedToken = TokenUtil.getInstance().getTokenId(open, null);
        IKeystoreManager keystoreMgr = ManagerFactory.getInstance().getKeystoreManagerByVersion(null, open.isUseIAM());
        List<OpenStackProject> projList = keystoreMgr.getProjects(open, unscopedToken);
        for (OpenStackProject openStackProject : projList) {
            if (!openStackProject.getUuid().equals(projectUUid)) continue;
            return openStackProject;
        }
        return null;
    }

    public List<OpenStackRegion> getRegionFromDB(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.error((Object)("Param is empty:openstackUuid=" + openstackUuid));
            throw new LegoCheckedException(1073947393L);
        }
        return CommonDAOLocator.getMoDao().find("from OpenStackRegion where parentMo.uuid = ? order by name", new Object[]{openstackUuid});
    }

    public void updateRegion(OpenStackRegion region) {
        try {
            CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)region);
        }
        catch (HibernateException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("updateRegion:" + region.getUuid()), (long)1073947393L, (String[])new String[0], (Log)LOG);
        }
    }

    public List<OpenStackServiceEndPoint> getEndPointFromDB(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.error((Object)("Param is empty:openstackUuid=" + openstackUuid));
            throw new LegoCheckedException(1073947393L);
        }
        return CommonDAOLocator.getMoDao().find("from OpenStackServiceEndPoint where topMoUuid = ? order by name", new Object[]{openstackUuid});
    }

    public void updateRegionService(String openstackUuid, Map<String, List<OpenStackServiceEndPoint>> regionServiceMap) {
        List<OpenStackServiceEndPoint> currentEndPointList;
        List<OpenStackServiceEndPoint> saveEndPointList;
        List<OpenStackServiceEndPoint> delEndPointList;
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty(regionServiceMap)) {
            LOG.error((Object)("Param is empty:openstackUuid=" + openstackUuid));
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, OpenStackRegion> regionMap = new HashMap<String, OpenStackRegion>();
        List<OpenStackRegion> regionList = this.getRegionFromDB(openstackUuid);
        long count = regionList.size() + regionServiceMap.size();
        if (count > 128L) {
            LOG.error((Object)"Private cloud rule region quantity is more than [%s]", 128L);
            throw new SpecCheckedException("openstack_region_quantity", 128L, count);
        }
        if (!VerifyUtil.isEmpty(regionList)) {
            for (OpenStackRegion openStackRegion : regionList) {
                regionMap.put(OpenStackCommonUtil.getIdFromUuid(openStackRegion.getUuid()), openStackRegion);
            }
        }
        if (VerifyUtil.isEmpty(delEndPointList = this.getDelEndPointList(regionServiceMap, saveEndPointList = this.construecEndPointList(openstackUuid, regionServiceMap, regionMap), currentEndPointList = this.getEndPointFromDB(openstackUuid))) && VerifyUtil.isEmpty(saveEndPointList)) {
            LOG.error((Object)"EndPointList is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        this.updateDb(saveEndPointList, delEndPointList);
        this.refreshEndpoint(saveEndPointList);
        this.openstackDependedCertificateService.registerOpenstackCert(this.getEndPointFromDB(openstackUuid));
        SDRRegisterHelper.getInstance().registerSDR();
    }

    private List<OpenStackServiceEndPoint> getDelEndPointList(Map<String, List<OpenStackServiceEndPoint>> regionServiceMap, List<OpenStackServiceEndPoint> saveEndPointList, List<OpenStackServiceEndPoint> currentEndPointList) {
        ArrayList<OpenStackServiceEndPoint> delEndPointList = new ArrayList<OpenStackServiceEndPoint>();
        if (!VerifyUtil.isEmpty(currentEndPointList)) {
            for (OpenStackServiceEndPoint endPoint : currentEndPointList) {
                if (!regionServiceMap.containsKey(OpenStackCommonUtil.getIdFromUuid(endPoint.getRegionUuid()))) continue;
                delEndPointList.add(endPoint);
            }
            if (currentEndPointList.size() - delEndPointList.size() + saveEndPointList.size() <= 0) {
                LOG.error((Object)"can not delete all endPoint");
                throw new LegoCheckedException(1073947482L);
            }
        }
        return delEndPointList;
    }

    private void updateDb(List<OpenStackServiceEndPoint> saveEndPointList, List<OpenStackServiceEndPoint> delEndPointList) {
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (OpenStackServiceEndPoint delEndPoint : delEndPointList) {
                session.delete((Object)delEndPoint);
            }
            for (OpenStackServiceEndPoint saveEndPoint : saveEndPointList) {
                session.save((Object)saveEndPoint);
            }
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            LOG.error((Object)("save AzPairs failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            DBOperationUtil.rollbackSession((Session)session);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    private void refreshEndpoint(List<OpenStackServiceEndPoint> endPointList) {
        HashMap regionEndpointMap = new HashMap();
        for (OpenStackServiceEndPoint endpoint : endPointList) {
            String regionUuid = endpoint.getRegionUuid();
            if (!regionEndpointMap.containsKey(regionUuid)) {
                HashMap endpointMap = new HashMap();
                regionEndpointMap.put(regionUuid, endpointMap);
            }
            Map map = (Map)regionEndpointMap.get(regionUuid);
            map.put(endpoint.getServiceType(), endpoint.getServiceUrl());
        }
        ServiceEndpointUtil.getInstance().refreshEndpointMap(regionEndpointMap);
    }

    private List<OpenStackServiceEndPoint> construecEndPointList(String openstackUuid, Map<String, List<OpenStackServiceEndPoint>> regionServiceMap, Map<String, OpenStackRegion> regionMap) {
        ArrayList<OpenStackServiceEndPoint> saveEndPointList = new ArrayList<OpenStackServiceEndPoint>();
        for (Map.Entry<String, List<OpenStackServiceEndPoint>> entry : regionServiceMap.entrySet()) {
            String regionId = entry.getKey();
            List<OpenStackServiceEndPoint> list = entry.getValue();
            if (VerifyUtil.isEmpty(list)) continue;
            OpenStackRegion openStackRegion = regionMap.get(regionId);
            if (VerifyUtil.isEmpty((Object)openStackRegion)) {
                LOG.error((Object)"Region not exist:%s", new Object[]{regionId});
                throw new LegoCheckedException(2117645L);
            }
            if (SERVICE_TYPE_SET.size() != list.size() && SERVICE_TYPE_SET.size() - 8 > list.size()) {
                LOG.error((Object)("Service size wrong:" + list.size()));
                throw new LegoCheckedException(1073947393L);
            }
            for (OpenStackServiceEndPoint endPoint : list) {
                String serviceId = UUIDGenerator.getUUID();
                endPoint.setServiceId(serviceId);
                endPoint.setUuid(OpenStackCommonUtil.getObjectUuid(openstackUuid, serviceId));
                endPoint.setRegionUuid(OpenStackCommonUtil.getObjectUuid(openstackUuid, regionId));
                if (!SERVICE_TYPE_SET.contains(endPoint.getServiceType())) {
                    LOG.error((Object)("ServiceType not exist:" + endPoint.getServiceType()));
                    throw new LegoCheckedException(1073947393L);
                }
                if (VerifyUtil.isEmpty((String)endPoint.getServiceUrl()) || !ParamChecker.checkUrl((String)endPoint.getServiceUrl())) {
                    LOG.error((Object)("ServiceUrl is null:" + endPoint));
                    throw new LegoCheckedException(1073947393L);
                }
                endPoint.setServiceUrl(IAMManager.getValidUrl(endPoint.getServiceUrl()));
                endPoint.setTopMoUuid(openstackUuid);
                endPoint.setParentMo((ManagedObject)openStackRegion);
                saveEndPointList.add(endPoint);
            }
        }
        return saveEndPointList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpenStackVolTypeMapping> getVolTypeMappingsFromDB(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.error((Object)"OpenstackUuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            Criteria crit = session.createCriteria(OpenStackVolTypeMapping.class);
            crit.add((Criterion)Restrictions.like((String)"uuid", (Object)(openstackUuid + "%")));
            crit.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"objectType"), (Criterion)Restrictions.eq((String)"objectType", (Object)ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue())));
            List list = crit.list();
            return list;
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public List<OpenStackVolTypeMapping> getVolTypeMappingsFromDB() {
        return CommonDAOLocator.getMoDao().find("from OpenStackVolTypeMapping where objectType = null or objectType = 'ECS_BMS'", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpenStackVolTypeMapping> getResourceMapping(String openstackUuid, String objectType) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.error((Object)"OpenstackUuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)objectType) || ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue().equalsIgnoreCase(objectType)) {
            return this.getVolTypeMappingsFromDB(openstackUuid);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            Criteria crit = session.createCriteria(OpenStackVolTypeMapping.class);
            crit.add((Criterion)Restrictions.like((String)"uuid", (Object)(openstackUuid + "%")));
            crit.add(Restrictions.in((String)"objectType", (Object[])new Object[]{objectType.toUpperCase(Locale.ROOT)}));
            List list = crit.list();
            return list;
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public List<OpenStackVolTypeMapping> getResourceMappingByRegionAz(String objectType, String primaryRegionAz, String secondRegionAz) {
        VerifyUtil.checkObject((Object)primaryRegionAz);
        StringBuilder sqlBuilder = new StringBuilder("from OpenStackVolTypeMapping where ");
        ArrayList<String> conditions = new ArrayList<String>();
        if (VerifyUtil.isEmpty((String)objectType) || "ECS_BMS".equalsIgnoreCase(objectType)) {
            sqlBuilder.append("(objectType is null or objectType = 'ECS_BMS') ");
        } else {
            sqlBuilder.append("objectType = ? ");
            conditions.add(objectType.toUpperCase(Locale.ROOT));
        }
        if (VerifyUtil.isEmpty((String)secondRegionAz)) {
            sqlBuilder.append("and(primaryAzId = ? or secondAzId = ?)");
            conditions.add(primaryRegionAz);
            conditions.add(primaryRegionAz);
        } else {
            sqlBuilder.append("and((primaryAzId = ? and secondAzId = ?) or (primaryAzId = ? and secondAzId = ?))");
            conditions.addAll(Arrays.asList(primaryRegionAz, secondRegionAz));
            conditions.addAll(Arrays.asList(secondRegionAz, primaryRegionAz));
        }
        return CommonDAOLocator.getMoDao().find(sqlBuilder.toString(), conditions.toArray(new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpenStackAvailabilityZoneMapping> getAvailabilityZoneMappingsFromDB(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.error((Object)"OpenstackUuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            Criteria crit = session.createCriteria(OpenStackAvailabilityZoneMapping.class);
            crit.add((Criterion)Restrictions.like((String)"uuid", (Object)(openstackUuid + "%")));
            List list = crit.list();
            return list;
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void saveAvailabilityZoneMappingInDB(OpenStackAvailabilityZoneMapping mapping) {
        if (VerifyUtil.isEmpty((Object)mapping)) {
            LOG.error((Object)"Param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            session.save((Object)mapping);
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            LOG.error((Object)("Save AzPairs failed." + e));
            DBOperationUtil.rollbackSession((Session)session);
            throw new LegoCheckedException(0x300001L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void deleteAvailabilityZoneMappingInDB(List<OpenStackAvailabilityZoneMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            LOG.error((Object)"Param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            for (OpenStackAvailabilityZoneMapping mapping : mappings) {
                session.delete((Object)mapping);
            }
            session.flush();
        }
        catch (HibernateException e) {
            LOG.error((Object)("Deleted AzPairs failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(2117645L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void saveVolTypeMappingInDB(List<OpenStackVolTypeMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            LOG.error((Object)"Param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (OpenStackVolTypeMapping mapping : mappings) {
                session.save((Object)mapping);
            }
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            LOG.error((Object)("Save voltypemapping failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            DBOperationUtil.rollbackSession((Session)session);
            throw new LegoCheckedException(0x300001L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void deleteVolTypeMappingInDB(List<OpenStackVolTypeMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            LOG.error((Object)"Param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            for (OpenStackVolTypeMapping mapping : mappings) {
                session.delete((Object)mapping);
            }
            session.flush();
        }
        catch (HibernateException e) {
            LOG.error((Object)("Deleted voltypemapping failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(2117645L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public List<OpenStackAvailabilityZoneMapping> getAvailabilityZoneMappingsFromDB() {
        return CommonDAOLocator.getMoDao().find("from OpenStackAvailabilityZoneMapping", new Object[0]);
    }

    public List<OpenStackAvailabilityZoneMapping> getAZMappingsByObjectType(String objectType) {
        StringBuilder sql = new StringBuilder("from OpenStackAvailabilityZoneMapping");
        if (VerifyUtil.isEmpty((String)objectType)) {
            return this.getAvailabilityZoneMappingsFromDB();
        }
        if (ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue().equalsIgnoreCase(objectType)) {
            sql.append(" where objectType  = ? or objectType = null");
        } else {
            sql.append(" where objectType  = ?");
        }
        return CommonDAOLocator.getMoDao().find(sql.toString(), new Object[]{objectType.toUpperCase(Locale.ROOT)});
    }

    public List<OpenStackAvailabilityZoneMapping> getAZMappingsByObjectType(String openstackUuid, String objectType) {
        StringBuilder sql = new StringBuilder("from OpenStackAvailabilityZoneMapping  where uuid like ?");
        if (VerifyUtil.isEmpty((String)objectType)) {
            return this.getAvailabilityZoneMappingsFromDB(openstackUuid);
        }
        if (ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue().equalsIgnoreCase(objectType)) {
            sql.append(" and (objectType  = ? or objectType = null)");
        } else {
            sql.append(" and objectType  = ?");
        }
        return CommonDAOLocator.getMoDao().find(sql.toString(), new Object[]{openstackUuid + "%", objectType.toUpperCase(Locale.ROOT)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenStackAvailabilityZoneMapping getSlaveAzNameByAzPairInDB(String azName) {
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            Criteria crit = session.createCriteria(OpenStackAvailabilityZoneMapping.class);
            crit.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"primaryAz", (Object)azName), (Criterion)Restrictions.eq((String)"secondAz", (Object)azName)));
            List mappings = crit.list();
            if (VerifyUtil.isEmpty((Collection)mappings)) {
                LOG.error((Object)"Az Pairs not exists in DB.");
                OpenStackAvailabilityZoneMapping openStackAvailabilityZoneMapping = null;
                return openStackAvailabilityZoneMapping;
            }
            OpenStackAvailabilityZoneMapping openStackAvailabilityZoneMapping = (OpenStackAvailabilityZoneMapping)mappings.get(0);
            return openStackAvailabilityZoneMapping;
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public List<Map<String, Object>> getVHACSDRMapping(String regionId, ServiceInstaceEnumDefine.ServiceInstanceTypeE instanceType) {
        return OpenStackCommonUtil.getVHACSDRMapping(regionId, this, instanceType);
    }

    public void updateVolTypeMappingInDB(List<OpenStackVolTypeMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            LOG.error((Object)"Update volumeType mapping failed.param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (OpenStackVolTypeMapping mapping : mappings) {
                session.saveOrUpdate((Object)mapping);
            }
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            LOG.error((Object)("update voltypemapping failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            DBOperationUtil.rollbackSession((Session)session);
            throw new LegoCheckedException(2117645L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void setOpenstackDependedCertificateService(OpenstackDependedCertificateService openstackDependedCertificateService) {
        this.openstackDependedCertificateService = openstackDependedCertificateService;
    }

    public JSONObject queryHwStackInfo() {
        IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
        List cloudInfraList = scOperation.queryCloudInfras();
        JSONObject hwStackInfoObject = new JSONObject();
        if (!VerifyUtil.isEmpty((Collection)cloudInfraList)) {
            JSONArray cloudInfraArray = new JSONArray();
            cloudInfraList.forEach(cloudInfra -> cloudInfraArray.add((Object)this.convertCloudInfra((CloudInfra)cloudInfra)));
            hwStackInfoObject.put((Object)"cloudInfras", (Object)cloudInfraArray);
            this.queryProjects(hwStackInfoObject);
        }
        return hwStackInfoObject;
    }

    private void queryProjects(JSONObject hwStackInfoObject) {
        FusionSphereOpenStack fusionSphereOpenStack = OpenStackCommonUtil.getOpenstack();
        if (VerifyUtil.isEmpty((Object)fusionSphereOpenStack)) {
            return;
        }
        Map pgPropsMap = ProtectGroupUtil.getAllPgProps();
        HashSet<String> allProjectIdSet = new HashSet<String>();
        for (Map props : pgPropsMap.values()) {
            String drProjectId;
            String projectId = OpenStackCommonUtil.getIdFromUuid((String)props.get("projectId"));
            if (!VerifyUtil.isEmpty((String)projectId)) {
                allProjectIdSet.add(projectId);
            }
            if (VerifyUtil.isEmpty((String)(drProjectId = OpenStackCommonUtil.getIdFromUuid((String)props.get("drProjectId"))))) continue;
            allProjectIdSet.add(drProjectId);
        }
        List<OpenStackProject> allProjectList = this.getProjectFromDB(fusionSphereOpenStack.getUuid(), true);
        JSONArray projectArray = new JSONArray();
        allProjectList.forEach(project -> {
            String projectId = OpenStackCommonUtil.getIdFromUuid(project.getUuid());
            if (allProjectIdSet.contains(projectId)) {
                JSONObject projectObject = new JSONObject();
                projectObject.put((Object)"projectId", (Object)projectId);
                projectObject.put((Object)"projectName", (Object)project.getName());
                projectArray.add((Object)projectObject);
            }
        });
        if (projectArray.size() > 0) {
            hwStackInfoObject.put((Object)"projects", (Object)projectArray);
        }
    }

    private JSONObject convertCloudInfra(CloudInfra cloudInfra) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"regionId", (Object)cloudInfra.getRegionId());
        jsonObject.put((Object)"regionName", (Object)cloudInfra.getRegionName());
        jsonObject.put((Object)"regionLocales", (Object)cloudInfra.getRegionLocales());
        IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
        List cloudAvailableZoneList = scOperation.queryAvailableZones(cloudInfra.getId());
        if (!VerifyUtil.isEmpty((Collection)cloudAvailableZoneList)) {
            JSONArray cloudAvailableZoneArray = new JSONArray();
            cloudAvailableZoneList.forEach(cloudAvailableZone -> cloudAvailableZoneArray.add((Object)this.convertCloudAvailableZone((CloudAvailableZone)cloudAvailableZone)));
            jsonObject.put((Object)"availableZones", (Object)cloudAvailableZoneArray);
        }
        return jsonObject;
    }

    private JSONObject convertCloudAvailableZone(CloudAvailableZone cloudAvailableZone) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"azId", (Object)cloudAvailableZone.getAzId());
        jsonObject.put((Object)"azName", (Object)cloudAvailableZone.getName());
        return jsonObject;
    }

    public void updateMeterInstName(String instId, String instName) {
        this.meterDao.updateMeterRecord(instId, instName);
    }

    public String dispatchCloudService(String projectId, String regionId, String service, String path) {
        if (VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)service) || VerifyUtil.isEmpty((String)path)) {
            LOG.error((Object)"Param is empty:regionId=%s, projectId=%s, service=%s, path=%s.", new Object[]{regionId, projectId, service, path});
            throw new LegoCheckedException(1073947393L);
        }
        this.checkPath(path);
        LOG.info((Object)"Dispatch for path %s", new Object[]{path});
        List openstackList = CommonDAOLocator.getMoDao().getAllMo(FusionSphereOpenStack.class);
        if (VerifyUtil.isEmpty((Collection)openstackList)) {
            LOG.error((Object)"Openstack instance is not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        FusionSphereOpenStack openstack = (FusionSphereOpenStack)CommonUtil.getFirstElement((Collection)openstackList);
        String regionUuid = openstack.getUuid() + ":" + regionId;
        String baseUrl = "";
        switch (service) {
            case "nova": {
                baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
                baseUrl = baseUrl.replace("/v2.1", "");
                break;
            }
            case "nova-ext": {
                baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute-ext");
                baseUrl = baseUrl.replace("/v1.0", "");
                break;
            }
            case "neutron": {
                baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "network");
                break;
            }
            case "cinder": {
                baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
                baseUrl = baseUrl.replace("/v2", "");
                break;
            }
            default: {
                LOG.error((Object)"Unexpected service type %s", new Object[]{service});
                throw new LegoCheckedException(1073947393L);
            }
        }
        String subCloudProjectId = MultiCloudUtil.convertToTargetRegion((String)projectId, (String)regionId);
        String newPath = path.replaceAll(projectId, subCloudProjectId);
        OpenstackInfo openstackInfo = AuthenticationHelper.getInstance().getOpenstackInfo();
        String subCloudTokenId = TokenUtil.getInstance().getTokenId(openstackInfo, openstackInfo.getUuid() + ":" + regionId, openstackInfo.getUuid() + ":" + subCloudProjectId);
        LOG.debug((Object)"DispatchCloudService path %s -> %s %s.", new Object[]{path, baseUrl, newPath});
        return ClientUtil.sendGetRequest(baseUrl + newPath, subCloudTokenId);
    }

    private void checkPath(String path) {
        String supportListConfigValue = LegoConfig.getInstance().getKeyValue("multi.cloud.dispatcher.support.list", DEFAULT_MULTI_CLOUD_DISPATCHER_SUPPORT_LIST);
        List<String> supportList = Arrays.asList(supportListConfigValue.split(";"));
        for (String urlPattern : supportList) {
            Pattern pattern = Pattern.compile(urlPattern);
            Matcher matcher = pattern.matcher(Normalizer.normalize(path, Normalizer.Form.NFKC));
            if (!matcher.matches()) continue;
            return;
        }
        LOG.error((Object)"The path %s not in support list.", new Object[]{path});
        throw new LegoCheckedException(1073947393L);
    }

    public boolean checkMappingVaild(MultiCloudProjectIdMapping mapping) {
        if (VerifyUtil.isEmpty((Object)mapping) || VerifyUtil.isEmpty((String)mapping.getCenterCloudProjectId()) || VerifyUtil.isEmpty((String)mapping.getRegionCloudProjectId()) || VerifyUtil.isEmpty((String)mapping.getRegionId())) {
            LOG.error((Object)"One or more field of the mapping is empty.");
            return false;
        }
        if (mapping.getCenterCloudProjectId().equals(mapping.getRegionCloudProjectId())) {
            LOG.debug((Object)"The project id of the central cloud and non-central cloud are the same. No need check.");
            return true;
        }
        FusionSphereOpenStack fusionSphereOpenStack = OpenStackCommonUtil.getOpenstack();
        OpenstackInfo open = ManagerFactory.getInstance().getRegOpenstack(fusionSphereOpenStack.getUuid());
        if (!open.isUseIAM()) {
            LOG.error((Object)"Only IAM authentication is supported.");
            return false;
        }
        String centerToken = TokenUtil.getInstance().getTokenId(open, null);
        Optional<String> centerUniqueIdOptional = this.getProjectUniqueIdFromIam(mapping.getCenterCloudProjectId(), open, centerToken);
        if (!centerUniqueIdOptional.isPresent()) {
            LOG.error((Object)"Can not find project %s at center cloud.", new Object[]{mapping.getCenterCloudProjectId()});
            return false;
        }
        String regionToken = TokenUtil.getInstance().getTokenId(open, mapping.getRegionId(), null);
        Optional<String> regionUniqueIdOptional = this.getProjectUniqueIdFromIam(mapping.getRegionCloudProjectId(), open, regionToken);
        if (!regionUniqueIdOptional.isPresent()) {
            LOG.error((Object)"Can not find project %s at non-center cloud.", new Object[]{mapping.getCenterCloudProjectId()});
            return false;
        }
        return centerUniqueIdOptional.get().equals(regionUniqueIdOptional.get());
    }

    public void validIamAuth(String openstackUuid, String userName, String password) {
        List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions((Map)ImmutableMap.of((Object)"sn", (Object)openstackUuid));
        List networkEntities = CommonDAOLocator.getBaseDao().createCriteria(NetworkEntity.class, criterionList.toArray(new Criterion[0]));
        if (VerifyUtil.isEmpty((Collection)networkEntities)) {
            LOG.error((Object)"Openstack %s not exist.", new Object[]{openstackUuid});
            throw new LegoCheckedException(201L);
        }
        long moId = ((NetworkEntity)networkEntities.get(0)).getMoId();
        IManagementProtocolService service = (IManagementProtocolService)ServiceLocator.getInstance().getService(IManagementProtocolService.class);
        NeMgrProtocolExtend extend = service.findByMoId(Long.valueOf(moId));
        OpenstackResourceServiceImpl.checkOpenStackPassword(userName, password, extend);
    }

    private static void checkOpenStackPassword(String userName, String password, NeMgrProtocolExtend extend) {
        Map paramMap = extend.getExtendParams();
        OpenstackInfo openInfo = new OpenstackInfo();
        String isIam = (String)paramMap.get("authType");
        openInfo.setUseIAM("IAM".equals(isIam));
        openInfo.setPort((String)paramMap.get("port"));
        openInfo.setDomainName((String)paramMap.get("domain"));
        openInfo.setIp(extend.getNetworkIpAddress());
        openInfo.setUser(userName);
        openInfo.setPasswd(password);
        LOG.info((Object)"CheckOpenStackPasswd:%s, ip:%s,  port:%s", new Object[]{isIam, openInfo.getIp(), openInfo.getPort()});
        String token = TokenUtil.getInstance().getTokenId(openInfo, null);
        if (VerifyUtil.isEmpty((String)token)) {
            throw new LegoCheckedException(1073947691L);
        }
    }

    private Optional<String> getProjectUniqueIdFromIam(String projectId, OpenstackInfo open, String token) {
        IKeystoreManager keystoreMgr = ManagerFactory.getInstance().getKeystoreManagerByVersion(null, open.isUseIAM());
        List<OpenStackProject> projectList = keystoreMgr.getProjects(open, token);
        if (VerifyUtil.isEmpty(projectList)) {
            LOG.error((Object)"The projects from iam is empty.");
            return Optional.empty();
        }
        Optional<OpenStackProject> projectOptional = projectList.stream().filter(project -> projectId.equals(OpenStackCommonUtil.getIdFromUuid(project.getUuid()))).findFirst();
        if (!projectOptional.isPresent()) {
            LOG.error((Object)"Can not find project %s.", new Object[]{projectId});
            return Optional.empty();
        }
        OpenStackProject openStackProject = projectOptional.get();
        Optional<DomainInfo> domainOptional = keystoreMgr.getDomain(open, token, openStackProject.getDomainId());
        if (!domainOptional.isPresent()) {
            LOG.error((Object)"Can not find domain %s.", new Object[]{openStackProject.getDomainId()});
            return Optional.empty();
        }
        DomainInfo domain = domainOptional.get();
        return Optional.of(String.format(Locale.ENGLISH, "%s,%s", openStackProject.getName(), domain.getName()));
    }
}

