/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.CreateServerInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@Service(name="com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService", desc="", interfaceClass=IVirtualMachineService.class)
public class VirtualMachineServiceImpl
extends BaseService
implements IVirtualMachineService {
    private static final Log LOG = LogFactory.getInstance(VirtualMachineServiceImpl.class);
    private static final String ATTACH_VOL_SEMAPHORE_DEFAULT_STORAGE_SN = "unknown_storage_sn";
    private static final String ATTACH_VOL_STORAGE_PARALLELISM_CONFIG = "volume.attach.storage.parallel";
    private static final int ATTACH_VOL_STORAGE_PARALLELISM_DEFAULT = 20;
    private static final int ATTACH_VOL_STORAGE_PARALLELISM_MIN = 10;
    private static final int ATTACH_VOL_STORAGE_PARALLELISM_MAX = 40;
    private static final String ATTACH_VOL_SEMAPHORE_DEFAULT_HOST_ID = "unknown_host_id";
    private static final String ATTACH_VOL_HOST_PARALLELISM_CONFIG = "volume.attach.host.parallel";
    private static final int ATTACH_VOL_HOST_PARALLELISM_DEFAULT = 3;
    private static final int ATTACH_VOL_HOST_PARALLELISM_MIN = 1;
    private static final int ATTACH_VOL_HOST_PARALLELISM_MAX = 5;
    private final ConcurrentHashMap<String, Semaphore> attachVolStorageSemaphoreMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Semaphore> attachVolHostSemaphoreMap = new ConcurrentHashMap();

    private Semaphore getAttachVolStorageSemaphoreBySn(String storageSn) {
        String notEmptySn = VerifyUtil.isEmpty((String)storageSn) ? ATTACH_VOL_SEMAPHORE_DEFAULT_STORAGE_SN : storageSn;
        return this.attachVolStorageSemaphoreMap.computeIfAbsent(notEmptySn, s -> {
            int attachVolParallelism = LegoConfig.getInstance().getInt(ATTACH_VOL_STORAGE_PARALLELISM_CONFIG, 20, 10, 40);
            return new Semaphore(attachVolParallelism, true);
        });
    }

    private Semaphore getAttachVolHostSemaphoreBySn(String storageSn, String hostId) {
        String notEmptyStorageSn = VerifyUtil.isEmpty((String)storageSn) ? ATTACH_VOL_SEMAPHORE_DEFAULT_STORAGE_SN : storageSn;
        String notEmptyHostId = VerifyUtil.isEmpty((String)hostId) ? ATTACH_VOL_SEMAPHORE_DEFAULT_HOST_ID : hostId;
        String semaphoreKey = notEmptyStorageSn + ":" + notEmptyHostId;
        return this.attachVolHostSemaphoreMap.computeIfAbsent(semaphoreKey, s -> {
            int attachVolParallelism = LegoConfig.getInstance().getInt(ATTACH_VOL_HOST_PARALLELISM_CONFIG, 3, 1, 5);
            return new Semaphore(attachVolParallelism, true);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithAttachVolSemaphore(String storageSn, String hostId, long timeout, Supplier<T> task) {
        T t;
        LOG.info((Object)"Start trying acquire attach volume semaphore for storage %s and host %s success.", new Object[]{SecurityUtil.desensitizeId((String)storageSn), SecurityUtil.desensitizeId((String)hostId)});
        Semaphore storageSemaphore = this.getAttachVolStorageSemaphoreBySn(storageSn);
        try {
            if (!storageSemaphore.tryAcquire(timeout, TimeUnit.SECONDS)) {
                LOG.error((Object)"Trying acquire attach volume semaphore for storage %s timeout.", new Object[]{SecurityUtil.desensitizeId((String)storageSn)});
                throw new LegoCheckedException(0x300001L);
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Thread is interrupted when trying acquire attach volume semaphore for storage %s.", new Object[]{SecurityUtil.desensitizeId((String)storageSn)});
            throw new LegoCheckedException(0x300001L);
        }
        try {
            LOG.debug((Object)"Trying acquire attach volume semaphore for storage %s success.", new Object[]{SecurityUtil.desensitizeId((String)storageSn)});
            t = this.runWithAttachVolHostSemaphore(storageSn, hostId, timeout, task);
            storageSemaphore.release();
        }
        catch (Throwable throwable) {
            storageSemaphore.release();
            LOG.debug((Object)"Released attach volume semaphore for storage %s.", new Object[]{SecurityUtil.desensitizeId((String)storageSn)});
            throw throwable;
        }
        LOG.debug((Object)"Released attach volume semaphore for storage %s.", new Object[]{SecurityUtil.desensitizeId((String)storageSn)});
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runWithAttachVolHostSemaphore(String storageSn, String hostId, long timeout, Supplier<T> task) {
        T t;
        Semaphore hostSemaphore = this.getAttachVolHostSemaphoreBySn(storageSn, hostId);
        try {
            if (!hostSemaphore.tryAcquire(timeout, TimeUnit.SECONDS)) {
                LOG.error((Object)"Trying acquire attach volume semaphore for storage %s and host %s timeout.", new Object[]{SecurityUtil.desensitizeId((String)storageSn), SecurityUtil.desensitizeId((String)hostId)});
                throw new LegoCheckedException(0x300001L);
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Thread is interrupted when trying acquire attach volume semaphore for storage %s and host %s.", new Object[]{SecurityUtil.desensitizeId((String)storageSn), SecurityUtil.desensitizeId((String)hostId)});
            throw new LegoCheckedException(0x300001L);
        }
        try {
            LOG.info((Object)"Trying acquire attach volume semaphore for storage %s and host %s success.", new Object[]{SecurityUtil.desensitizeId((String)storageSn), SecurityUtil.desensitizeId((String)hostId)});
            t = task.get();
            hostSemaphore.release();
        }
        catch (Throwable throwable) {
            hostSemaphore.release();
            LOG.debug((Object)"Released attach volume semaphore for storage %s and host %s.", new Object[]{SecurityUtil.desensitizeId((String)storageSn), SecurityUtil.desensitizeId((String)hostId)});
            throw throwable;
        }
        LOG.debug((Object)"Released attach volume semaphore for storage %s and host %s.", new Object[]{SecurityUtil.desensitizeId((String)storageSn), SecurityUtil.desensitizeId((String)hostId)});
        return t;
    }

    public Page pageQueryVmsByOpenstackUuid(String openstackUuid, String orderBy, int pageNo, int pageSize, boolean isAsc) {
        return new Page();
    }

    public List<OpenStackVM> queryVmByUuids(String regionUuid, String projectUuid, String ... vmUuids) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((Object[])vmUuids)) {
            LOG.warn((Object)"vmuuid is empty", 90160758786989L);
            return new ArrayList<OpenStackVM>();
        }
        HashSet<String> vmUuidSet = new HashSet<String>();
        for (String uuid : vmUuids) {
            vmUuidSet.add(uuid);
        }
        List<OpenStackVM> vmList = this.getVmInfosFromOpenstack(regionUuid, projectUuid);
        Iterator<OpenStackVM> iterator = vmList.iterator();
        while (iterator.hasNext()) {
            if (vmUuidSet.contains(iterator.next().getUuid())) continue;
            iterator.remove();
        }
        return vmList;
    }

    public List<OpenStackVM> getVmInfos(String regionUuid, String projUuid, String azName) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)azName)) {
            LOG.error((Object)"Query param is empty");
            return new ArrayList<OpenStackVM>();
        }
        List<OpenStackVM> vmList = this.getVmInfosFromOpenstack(regionUuid, projUuid);
        Iterator<OpenStackVM> iterator = vmList.iterator();
        while (iterator.hasNext()) {
            if (azName.equals(iterator.next().getAzName())) continue;
            iterator.remove();
        }
        return vmList;
    }

    public List<OpenStackVM> getVmInfosFromOpenstack(String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Regionuuid or projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager mgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        return mgr.getVms(regionUuid, tokenId, projUuid);
    }

    public OpenStackVM createVm(String regionUuid, String projUuid, String tokenId, CreateServerInfo createInfo) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createInfo)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        INovaManager novaManger = ManagerFactory.getInstance().getNovaManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        AsyncTaskResponse response = novaManger.createVm(regionUuid, projUuid, tokenId, createInfo);
        if (!response.isSuccess()) {
            String[] errParam = null;
            if (null != response.getTaskResult() && response.getTaskResult() instanceof OpenStackVM) {
                OpenStackVM result = (OpenStackVM)response.getTaskResult();
                errParam = new String[]{result.getUuid()};
                LOG.error((Object)("Create volume failed:" + result.getUuid()));
            }
            throw new LegoCheckedException(1073948363L, errParam);
        }
        return (OpenStackVM)response.getTaskResult();
    }
}

