/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource.authentication;

import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;

public class CertificateCache {
    private static final Log LOG = LogFactory.getInstance(CertificateCache.class);
    private static final int REST_STATUS_SUCCESS_CODE = 200;
    private static final CertificateCache INSTANCE = new CertificateCache();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private X509CertificateHolder certificate;
    private X509CertificateHolder gmCertificate;
    private boolean needUpdate = true;

    private CertificateCache() {
    }

    public static CertificateCache getInstance() {
        return INSTANCE;
    }

    public void updateAll() throws LegoCheckedException {
        this.lock.writeLock().lock();
        try {
            this.updateCertificate(false);
            this.updateCertificate(true);
            TokenUtil.getInstance().clearAllTokenCache();
            this.needUpdate = false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private X509CertificateHolder updateCertificate(boolean isGm) {
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        StringBuilder urlBuilder = new StringBuilder("https://").append(open.getIp()).append(":").append(open.getPort()).append(OpenstackEnumDefine.RequestUrl.IAM_SIGNCA.getUri());
        if (isGm) {
            urlBuilder.append("?is_gm=true");
        }
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String certificateStr = this.sendGet(urlBuilder.toString(), tokenId);
        if (VerifyUtil.isEmpty((String)certificateStr)) {
            throw new LegoCheckedException("Get new certificate response is empty. is_gm=" + isGm);
        }
        X509CertificateHolder newCertificate = CertificateCache.readCertificate(certificateStr);
        if (isGm) {
            this.gmCertificate = newCertificate;
        } else {
            this.certificate = newCertificate;
        }
        LOG.info((Object)"Update certificate success. is_gm=%s", new Object[]{isGm});
        return newCertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CertificateHolder getCertificate(boolean isGm) {
        X509CertificateHolder result;
        this.lock.readLock().lock();
        if (this.needUpdate) {
            this.resetCache();
        }
        try {
            result = isGm ? this.gmCertificate : this.certificate;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (result != null) {
            return result;
        }
        this.lock.writeLock().lock();
        try {
            X509CertificateHolder x509CertificateHolder = result = isGm ? this.gmCertificate : this.certificate;
            if (result == null) {
                result = this.updateCertificate(isGm);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    private void resetCache() {
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
        try {
            if (!this.needUpdate) {
                return;
            }
            this.certificate = null;
            this.gmCertificate = null;
            TokenUtil.getInstance().clearAllTokenCache();
            this.needUpdate = false;
        }
        finally {
            this.lock.readLock().lock();
            this.lock.writeLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static X509CertificateHolder readCertificate(String certificateStr) {
        try (StringReader certReader = new StringReader(certificateStr);){
            Throwable throwable;
            PEMParser pemParser;
            block25: {
                X509CertificateHolder x509CertificateHolder;
                block26: {
                    pemParser = new PEMParser((Reader)certReader);
                    throwable = null;
                    Object pemObject = pemParser.readObject();
                    if (!(pemObject instanceof X509CertificateHolder)) break block25;
                    x509CertificateHolder = (X509CertificateHolder)pemObject;
                    if (pemParser == null) return x509CertificateHolder;
                    if (throwable == null) break block26;
                    try {
                        pemParser.close();
                        return x509CertificateHolder;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return x509CertificateHolder;
                    }
                }
                pemParser.close();
                return x509CertificateHolder;
            }
            try {
                try {
                    throw new LegoCheckedException("Read certificate content is not correct.");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (pemParser == null) throw throwable4;
                if (throwable == null) {
                    pemParser.close();
                    throw throwable4;
                }
                try {
                    pemParser.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new LegoCheckedException("Read Certificate with exception.", (Throwable)e);
        }
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }

    private String sendGet(String url, String tokenId) {
        try {
            AuthenticationHelper helper = AuthenticationHelper.getInstance();
            ServiceResponse response = helper.sendGet(url, helper.getHeaders(tokenId));
            if (200 == response.getStatusCode()) {
                return response.getResponseString();
            }
            LOG.error((Object)("UpdateCertificate sendGet failed:" + response.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error((Object)("UpdateCertificate sendGet error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }
}

