/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.ServiceInstanceBackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IImageManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.bo.VmInfoBO;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackImage;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStoragePoolRemoteDevInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStorageResourcePool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolAttachment;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.Capability;
import com.huawei.ism.drm.openstack.sdk.msg.CpuInfo;
import com.huawei.ism.drm.openstack.sdk.msg.CpuVendor;
import com.huawei.ism.drm.openstack.sdk.msg.CpuVendorCapability;
import com.huawei.ism.drm.openstack.sdk.msg.GuestOSType;
import com.huawei.ism.drm.openstack.sdk.msg.HypervisorInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ImageMetadataInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OpenStackAllInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OsConfig;
import com.huawei.ism.drm.openstack.sdk.msg.SystemCapability;
import com.huawei.ism.drm.openstack.sdk.msg.VMFlavor;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.sdk.struct.Project;
import com.huawei.ism.drm.openstack.sdk.struct.Region;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceRecoveryImpl;
import com.huawei.ism.drm.openstack.serviceinstance.BuildVmInfoModel;
import com.huawei.ism.drm.openstack.serviceinstance.ProjectInfo;
import com.huawei.ism.drm.openstack.serviceinstance.ProtectExecutingVmsQueue;
import com.huawei.ism.drm.openstack.serviceinstance.task.CreateInstanceTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.ServiceInstanceReplicationSyncTask;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCheckPhVmUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CollectionUtils;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.springframework.dao.DataAccessException;

public abstract class AbstractServiceInstanceCreateImpl
extends AbstractServiceInstanceRecoveryImpl {
    private static final Log logger = LogFactory.getInstance(AbstractServiceInstanceCreateImpl.class);
    private static final Set<Integer> CHECK_SAME_DEV_TEMPLATE_TYPES = ImmutableSet.of((Object)21, (Object)22, (Object)56);
    private ServiceInstanceReplicationSyncTask serviceInstanceReplicationSyncTask;

    public ServiceInstanceReplicationSyncTask getServiceInstanceReplicationSyncTask() {
        return this.serviceInstanceReplicationSyncTask;
    }

    public void setServiceInstanceReplicationSyncTask(ServiceInstanceReplicationSyncTask serviceInstanceReplicationSyncTask) {
        this.serviceInstanceReplicationSyncTask = serviceInstanceReplicationSyncTask;
    }

    public String createServiceInstance(ProtectGroup pg, ExtendParamInfo extendParam) {
        this.refactorPg(pg);
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        if (null != extendParam && extendParam.isCheck()) {
            return OpenstackCache.run(() -> {
                OpenstackCache.preloadVmAndVolume(pg);
                this.checkCreateInstanceParam(pg);
                return null;
            });
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        CreateInstanceTask task = new CreateInstanceTask(projectId, serviceType, pg, this.serviceInstanceReplicationSyncTask);
        task.setEvsQuota(Optional.ofNullable(extendParam).map(ExtendParamInfo::getEvsQuota).orElse(null));
        OrderInstanceInfo inst = this.createOrderInstanceInfo(null, pg.getName(), serviceType, projectId, regionUuid);
        this.updateTaskInfo(ServiceInstaceEnumDefine.ServiceInstanceOperateType.ADD_INSTANCE, extendParam, task, inst, null);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    protected void refactorPg(ProtectGroup pg) {
        FusionSphereOpenStack openstack = this.getOpenstack();
        String openstackUuid = openstack.getUuid();
        Site site = this.getSite(openstack.getSn());
        pg.setProductSiteId(site.getUuid());
        pg.setProductSiteName(site.getName());
        pg.setPoProviderSN(openstackUuid);
        String templateUuid = this.getOriginalTemplate(pg.getTemplate().getType()).getUuid();
        pg.getTemplate().setUuid(templateUuid);
        this.refactorPgProps(pg, openstackUuid);
        this.refactorPos(pg.getPolist(), openstackUuid);
    }

    public void checkCreateInstanceParam(ProtectGroup pg) {
        OpenStackStorageResourcePool drHyperMetorPool;
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjectUuid = (String)pg.getProps().get("drProjectId");
        this.checkInstanceNameIsRepeat(pg);
        this.checkInstanceVMParam(pg);
        Map<String, String> volumeTypeMap = this.getTypeInfoMap(pg.getPolist());
        if (!this.isRealVolumesType(regionUuid, projectUuid, volumeTypeMap)) {
            logger.error((Object)"Volume types are not really");
            throw new LegoCheckedException(1073948116L);
        }
        String azIdentity = this.getAzIdentity(pg, serviceType);
        this.updateProtectGroupDrVolType(serviceType, pg.getPolist(), azIdentity, regionUuid, pg);
        HashSet<String> srcVolTypeSet = new HashSet<String>();
        HashSet<String> drVolTypeSet = new HashSet<String>();
        HashSet<String> drHyperVolTypeSet = new HashSet<String>();
        OpenStackCommonUtil.getVolTypeSet(pg.getPolist(), srcVolTypeSet, drVolTypeSet, drHyperVolTypeSet);
        if (!this.checkVolTypeFromSameDev(regionUuid, projectUuid, srcVolTypeSet) || !this.checkVolTypeFromSameDev(drRegionUuid, projectUuid, drVolTypeSet)) {
            logger.error((Object)"Volume types are not from the same dev");
            throw new LegoCheckedException(1073948415L);
        }
        if ((ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(serviceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceType)) && !this.checkVolTypeFromSameDev(regionUuid, projectUuid, drHyperVolTypeSet)) {
            logger.error((Object)"DR HyperMetor volume types are not from the same dev");
            throw new LegoCheckedException(1073948415L);
        }
        String srcVolType = (String)CommonUtil.getFirstElement(srcVolTypeSet);
        String drVolType = (String)CommonUtil.getFirstElement(drVolTypeSet);
        String drHyperMetorVolType = (String)CommonUtil.getFirstElement(drHyperVolTypeSet);
        logger.info((Object)("Choose one type to check:srcType=" + srcVolType + " drVolType=" + drVolType));
        OpenStackStorageResourcePool pool = this.getResPoolByVolumeType(regionUuid, projectUuid, srcVolType);
        OpenStackStorageResourcePool drPool = this.getResPoolByVolumeType(drRegionUuid, drProjectUuid, drVolType);
        if (!this.checkVolumeType(pool, serviceType) || !this.checkPoolsConnectWithEatchOther(pool, drPool, serviceType)) {
            logger.error((Object)"The resource pool is not a valid pool");
            throw new LegoCheckedException(1073948114L);
        }
        if (!(!ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(serviceType) && !ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceType) || this.checkVolumeType(drHyperMetorPool = this.getResPoolByVolumeType(regionUuid, projectUuid, drHyperMetorVolType), serviceType) && this.checkPoolsConnectWithEatchOther(pool, drHyperMetorPool, ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue()) && this.checkPoolsConnectWithEatchOther(drHyperMetorPool, drPool, ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue()))) {
            logger.error((Object)"The resource pool is not hypermetro pool or not replication pool");
            throw new LegoCheckedException(1073948114L);
        }
        String upgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE");
        if (!VerifyUtil.isEmpty((String)upgradeType) && ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue().equals(serviceType) || VerifyUtil.isEmpty((String)upgradeType) && this.isNeedCheckOccupiedVm(serviceType)) {
            String drAzName = (String)pg.getProps().get("drZoneName");
            this.checkOccupiedVm(new ProjectInfo(serviceType, projectUuid, drProjectUuid, "occupied_vm"), pg.getPolist(), OpenStackCommonUtil.initOpenStackAvailabilityZoneMapping(OpenStackCommonUtil.getIdFromUuid(regionUuid), OpenStackCommonUtil.getIdFromUuid(drRegionUuid), drAzName));
            if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceType)) {
                String prodRegionDrZoneName = (String)pg.getProps().get("prod_region_drZoneName");
                this.checkOccupiedVm(new ProjectInfo(ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue(), projectUuid, projectUuid, "csha_occupied_vm"), pg.getPolist(), OpenStackCommonUtil.initOpenStackAvailabilityZoneMapping(OpenStackCommonUtil.getIdFromUuid(regionUuid), OpenStackCommonUtil.getIdFromUuid(regionUuid), prodRegionDrZoneName));
            }
        }
    }

    protected String getAzIdentity(ProtectGroup pg, String serviceType) {
        String azIdentity;
        String regionName = OpenStackBasicUtil.getIdFromUuid((String)pg.getProps().get("regionId"));
        String drRegionName = OpenStackBasicUtil.getIdFromUuid((String)pg.getProps().get("drRegionId"));
        String azName = (String)pg.getProps().get("zoneName");
        String drAzName = (String)pg.getProps().get("drZoneName");
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceType)) {
            String prodRegionDrZoneName = (String)pg.getProps().get("prod_region_drZoneName");
            azIdentity = OpenStackBasicUtil.getSortStr(new String[]{OpenStackVolTypeMapping.getMappingAzId((String)regionName, (String)azName), OpenStackVolTypeMapping.getMappingAzId((String)drRegionName, (String)drAzName), OpenStackVolTypeMapping.getMappingAzId((String)regionName, (String)prodRegionDrZoneName)});
        } else {
            azIdentity = OpenStackVolTypeMapping.getAzIdentity((String)regionName, (String)azName, (String)drRegionName, (String)drAzName);
        }
        return azIdentity;
    }

    public boolean isNeedCheckOccupiedVm(String serviceType) {
        return ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(serviceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(serviceType) || (ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue().equals(serviceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceType)) && OpenStackCommonUtil.isCurrentFCVersionHighThan63();
    }

    private void checkInstanceVMParam(ProtectGroup pg) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String azName = (String)pg.getProps().get("zoneName");
        Set vmUuidSet = CollectionUtils.mapToSet((Collection)pg.getPolist(), ProtectObject::getMoUuid);
        this.checkValidityOfProductionVM(regionUuid, projectUuid, azName, vmUuidSet);
        this.checkUnSupportVolume(pg, pg.getPolist(), regionUuid, projectUuid);
        if (!this.checkVolumesOfVm(regionUuid, projectUuid, pg.getPolist())) {
            logger.error((Object)"Will operate volume not in use with vm");
            throw new LegoCheckedException(1073948112L);
        }
        this.updateProtectGroupVolType(regionUuid, projectUuid, pg.getPolist());
    }

    private Site getSite(String openstackSn) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(openstackSn);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            logger.error((Object)"DrResource is not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site site = siteService.getSiteById(drResource.getSiteId());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"Site is not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        return site;
    }

    protected PolicyTemplate getOriginalTemplate(int templateType) {
        String hql = "from PolicyTemplate as pt where pt.type=? and isSystemDefine = 1";
        try {
            List list = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{templateType});
            if (list.isEmpty()) {
                logger.error((Object)"The hypermetro template is empty");
                throw new LegoCheckedException(1073947393L);
            }
            return (PolicyTemplate)CommonUtil.getFirstElement((Collection)list);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Get hypermetro PolicyTemplate failed");
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }

    private void refactorPgProps(ProtectGroup pg, String openstackUuid) {
        pg.getProps().put("regionId", OpenStackCommonUtil.getObjectUuid(openstackUuid, (String)pg.getProps().get("regionId")));
        pg.getProps().put("projectId", OpenStackCommonUtil.getObjectUuid(openstackUuid, (String)pg.getProps().get("projectId")));
        pg.getProps().put("drRegionId", OpenStackCommonUtil.getObjectUuid(openstackUuid, (String)pg.getProps().get("drRegionId")));
        pg.getProps().put("drProjectId", OpenStackCommonUtil.getObjectUuid(openstackUuid, (String)pg.getProps().get("drProjectId")));
        if (pg.getTemplate().getType() == 34 || pg.getTemplate().getType() == 37) {
            pg.getProps().put("originalAvailableRegion", OpenStackCommonUtil.getObjectUuid(openstackUuid, (String)pg.getProps().get("originalAvailableRegion")));
        }
    }

    protected void refactorPos(Set<ProtectObject> pos, String openstackUuid) {
        for (ProtectObject po : pos) {
            po.setMoUuid(OpenStackCommonUtil.getObjectUuid(openstackUuid, po.getMoUuid()));
            String volumeConfigStr = (String)po.getProps().get("volumeConfig");
            JSONArray array = JSONArray.fromObject((Object)volumeConfigStr);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = array.getJSONObject(i);
                json.put((Object)"volumeId", (Object)OpenStackCommonUtil.getObjectUuid(openstackUuid, json.getString("volumeId")));
            }
            po.getProps().put("volumeConfig", array.toString());
        }
    }

    protected void checkValidityOfProductionVM(String regionUuid, String projectUuid, String azName, Set<String> vmUuidSet) {
        List<OpenStackVM> vmList = this.getVMByUuids(regionUuid, projectUuid, vmUuidSet);
        if (vmList.size() != vmUuidSet.size()) {
            logger.info((Object)"Some vms not exist");
            throw new LegoCheckedException(2117645L, "some vms not exist");
        }
        if (!this.checkVMSIntfaceExist(regionUuid, projectUuid, vmUuidSet, vmList)) {
            logger.info((Object)"Some vms don't have any interfaces.");
            throw new LegoCheckedException(1073948120L, "some vms don't have any interfaces.");
        }
        if (this.isVmExistRollBackTask(vmUuidSet)) {
            logger.info((Object)("VM has RollBack task, vm uuids is " + vmUuidSet.toString()));
            throw new LegoCheckedException(1073948118L, "VM has RollBack task");
        }
        if (!this.checkPoExists(vmUuidSet)) {
            logger.error((Object)"The vm is already be protected.");
            throw new LegoCheckedException(1073948113L);
        }
        if (!this.checkVmWithAz(regionUuid, projectUuid, azName, vmUuidSet)) {
            logger.error((Object)"The vm is not in az ");
            throw new LegoCheckedException(1073948111L);
        }
        if (!this.checkTagsAndIsSameTag(vmList)) {
            logger.error((Object)"The vm tags error.");
            throw new LegoCheckedException(1073948415L);
        }
        this.checkExpiryorSoftdelete(vmList);
    }

    protected boolean checkPoExists(Set<String> vmUuids) {
        String sql = "select moUuid from ProtectObject where moUuid in (:ids) and protectGroup.pgId is not null";
        List uuids = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByNamedParam(sql, "ids", vmUuids);
        return VerifyUtil.isEmpty((Collection)uuids);
    }

    private boolean checkVmWithAz(String regionUuid, String projectUuid, String azName, Set<String> vmUuidSet) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
        for (OpenStackVM vm : vmList) {
            if (!vmUuidSet.contains(vm.getUuid()) || azName.equals(vm.getAzName())) continue;
            logger.error((Object)("vmName=" + vm.getName() + " vm's AzName=" + vm.getAzName() + " is not in Az:" + azName));
            return false;
        }
        return true;
    }

    private boolean checkTagsAndIsSameTag(List<OpenStackVM> vmList) {
        if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            return true;
        }
        HashSet<String> tags = new HashSet<String>();
        for (OpenStackVM openStackVM : vmList) {
            if (VerifyUtil.isEmpty((Collection)openStackVM.getTags()) || !openStackVM.getTags().contains("__single_storage")) {
                return false;
            }
            if (openStackVM.getTags().contains("__single_storage") && !openStackVM.getTags().contains("__type_baremetal")) {
                tags.add("__single_storage");
                continue;
            }
            if (!openStackVM.getTags().contains("__type_baremetal")) continue;
            tags.add("__type_baremetal");
        }
        return tags.size() == 1;
    }

    private void checkExpiryorSoftdelete(List<OpenStackVM> vmList) {
        if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            return;
        }
        for (OpenStackVM openStackVM : vmList) {
            if (!this.checkVmIllegalStatus(openStackVM)) continue;
            String vmName = openStackVM.getName();
            logger.error((Object)"The vm status error.");
            throw new LegoCheckedException(1073948136L, new String[]{vmName});
        }
    }

    protected void updateProtectGroupVolType(String regionUuid, String projectUuid, Set<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList)) {
            return;
        }
        Map<String, String> volAndVolTypeMap = OpenStackCommonUtil.getVolAndVolTypeMap(regionUuid, projectUuid);
        for (ProtectObject po : poList) {
            String volConfigStr = (String)po.getProps().get("volumeConfig");
            JSONArray array = JSONArray.fromObject((Object)volConfigStr);
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                JSONObject json = array.getJSONObject(i);
                if (json.containsKey((Object)"volumeType") && !VerifyUtil.isEmpty((String)json.getString("volumeType"))) continue;
                String volId = OpenStackCommonUtil.getIdFromUuid(json.getString("volumeId"));
                if (!volAndVolTypeMap.containsKey(volId)) {
                    logger.error((Object)("Vol(" + volId + ") is not exist and not set voltype."));
                    continue;
                }
                json.put((Object)"volumeType", (Object)volAndVolTypeMap.get(volId));
                logger.debug((Object)("VM(" + po.getMoUuid() + ") volType is " + volAndVolTypeMap.get(volId)));
            }
            po.getProps().put("volumeConfig", array.toString());
        }
    }

    protected Map<String, String> getTypeInfoMap(Set<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> typeInfoMap = new HashMap<String, String>();
        for (ProtectObject po : poList) {
            String volConfigStr = (String)po.getProps().get("volumeConfig");
            JSONArray array = JSONArray.fromObject((Object)volConfigStr);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = array.getJSONObject(i);
                String volumeUuid = json.getString("volumeId");
                String volumeType = json.getString("volumeType");
                typeInfoMap.put(volumeUuid, volumeType);
            }
        }
        return typeInfoMap;
    }

    protected boolean isRealVolumesType(String regionUuid, String projectUuid, Map<String, String> volumeTypeMap) {
        if (VerifyUtil.isEmpty(volumeTypeMap) || volumeTypeMap.size() == 0) {
            logger.error((Object)"VolumesMap is empty ");
            return false;
        }
        ArrayList<String> volumeUuidList = new ArrayList<String>(volumeTypeMap.keySet());
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List volumes = volumeService.queryVolumesByUuid(regionUuid, projectUuid, volumeUuidList, false);
        if (null == volumes || volumes.size() != volumeUuidList.size()) {
            logger.error((Object)"Query volumes by uuid,volume's size  not equals uuid size ");
            return false;
        }
        for (OpenStackVolume volume : volumes) {
            String type = volumeTypeMap.get(volume.getUuid());
            if (!type.equals(volume.getVolType())) {
                logger.error((Object)(volume.getUuid() + " volume type parameter is" + type + ",but the volume' real type is " + volume.getVolType()));
                return false;
            }
            if (!Integer.valueOf(OpenstackEnumDefine.VolumeStatusE.MAINTENANCE.getValue()).equals(volume.getStatus())) continue;
            logger.error((Object)("Volume status not normal,name:" + volume.getName() + " status:" + volume.getStatus()));
            throw new LegoCheckedException(1073948416L);
        }
        return true;
    }

    protected void updateProtectGroupDrVolType(String serviceType, Set<ProtectObject> poList, String azIdentity, String regionUuid, ProtectGroup pg) {
        if (VerifyUtil.isEmpty(poList)) {
            return;
        }
        String openStackUuid = this.getOpenstack().getUuid();
        List volTypeList = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getVolTypeMappingsFromDB(openStackUuid);
        Iterator volTypeIterator = volTypeList.iterator();
        while (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(serviceType) && !ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceType) && volTypeIterator.hasNext()) {
            OpenStackVolTypeMapping openStackVolTypeMapping = (OpenStackVolTypeMapping)volTypeIterator.next();
            if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)serviceType) != ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)openStackVolTypeMapping.getType())) {
                volTypeIterator.remove();
                continue;
            }
            if (VerifyUtil.isEmpty((String)openStackVolTypeMapping.getAzIdentity()) || openStackVolTypeMapping.getAzIdentity().equals(azIdentity)) continue;
            volTypeIterator.remove();
        }
        AbstractServiceInstanceCreateImpl.getProtectGroupDrVolType(serviceType, regionUuid, poList, azIdentity, volTypeList, pg);
        logger.debug((Object)("VolTypeList is " + volTypeList.toString()));
    }

    protected boolean checkPoolsConnectWithEatchOther(OpenStackStorageResourcePool one, OpenStackStorageResourcePool other, String serviceType) {
        if (VerifyUtil.isEmpty((Object)one) || VerifyUtil.isEmpty((Object)other)) {
            logger.error((Object)"The pool is empty.");
            return false;
        }
        if (one.getLocalDevSn().equals(other.getLocalDevSn())) {
            logger.error((Object)"Two storage resource pool are the same.");
            return false;
        }
        one.generateRemoteDevInfo();
        other.generateRemoteDevInfo();
        String devSn = one.getLocalDevSn();
        logger.debug((Object)"LocalDevSn = %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
        List remoteDevList = ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue().equals(serviceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(serviceType) ? other.getRemoteHyperMetroDevs() : other.getRemoteDevs();
        if (remoteDevList == null) {
            logger.error((Object)"Not found remoteDev.");
            return false;
        }
        for (OpenStackStoragePoolRemoteDevInfo remoteDev : remoteDevList) {
            logger.debug((Object)"Remote dev sn = %s.", new Object[]{SecurityUtil.desensitizeId((String)remoteDev.getDevSn())});
            if (!devSn.equals(remoteDev.getDevSn())) continue;
            return true;
        }
        return false;
    }

    protected void checkOccupiedVm(ProjectInfo projectInfo, Set<ProtectObject> pos, OpenStackAvailabilityZoneMapping mapping) {
        logger.debug((Object)("CheckOccupiedVm:" + projectInfo.getInstanceType()));
        HashMap<String, String> vmAndOccvmMap = new HashMap<String, String>();
        for (ProtectObject po : pos) {
            String serverId = OpenStackCommonUtil.getIdFromUuid(po.getMoUuid());
            String occupiedVmId = OpenStackCommonUtil.getIdFromUuid((String)po.getProps().get(projectInfo.getOccupiedVMKey()));
            if (VerifyUtil.isEmpty((String)occupiedVmId)) {
                logger.error((Object)("The vm(" + serverId + ") not set occupied vm"));
                throw new LegoCheckedException(1073948908L);
            }
            if (vmAndOccvmMap.containsValue(occupiedVmId)) {
                logger.error((Object)("The vm(" + occupiedVmId + ") has been uesd."));
                throw new LegoCheckedException(1073948130L);
            }
            vmAndOccvmMap.put(serverId, occupiedVmId);
        }
        Map<String, List<VmInfoBO>> matchedVms = this.queryAvailableOccupiedVmMap(projectInfo.getInstanceType(), OpenStackCommonUtil.getIdFromUuid(projectInfo.getProjectUuid()), OpenStackCommonUtil.getIdFromUuid(projectInfo.getRemoteProjectUuid()), vmAndOccvmMap.keySet(), mapping);
        for (Map.Entry entry : vmAndOccvmMap.entrySet()) {
            String srcVmId = (String)entry.getKey();
            String occVmId = (String)entry.getValue();
            List<VmInfoBO> avalibelVms = matchedVms.get(srcVmId);
            if (VerifyUtil.isEmpty(avalibelVms)) {
                logger.error((Object)("The vm(" + occVmId + ") is not avalible because srcvm has no matched vm."));
                throw new LegoCheckedException(1073948130L);
            }
            boolean isMatched = false;
            for (VmInfoBO avalibelVm : avalibelVms) {
                if (!occVmId.equals(OpenStackCommonUtil.getIdFromUuid(avalibelVm.getServerId()))) continue;
                isMatched = true;
                break;
            }
            if (isMatched) continue;
            logger.error((Object)("The vm(" + occVmId + ") is not avalible."));
            throw new LegoCheckedException(1073948130L);
        }
    }

    public static String findDrVolType(String srVolType, List<OpenStackVolTypeMapping> volTypeList, ProtectGroup pg) {
        if (VerifyUtil.isEmpty((String)srVolType) || VerifyUtil.isEmpty(volTypeList)) {
            return null;
        }
        String drVolType = null;
        ArrayList<InstanceVolTypeMapping> drVolTypeList = new ArrayList<InstanceVolTypeMapping>();
        for (OpenStackVolTypeMapping volTypeMap : volTypeList) {
            InstanceVolTypeMapping matchVolumeType;
            if (volTypeMap.getPrimaryVolType().equals(srVolType)) {
                drVolType = volTypeMap.getSecondVolType();
                matchVolumeType = new InstanceVolTypeMapping(srVolType, drVolType, null, volTypeMap.getPriority());
                drVolTypeList.add(matchVolumeType);
                continue;
            }
            if (!volTypeMap.getSecondVolType().equals(srVolType)) continue;
            drVolType = volTypeMap.getPrimaryVolType();
            matchVolumeType = new InstanceVolTypeMapping(srVolType, drVolType, null, volTypeMap.getPriority());
            drVolTypeList.add(matchVolumeType);
        }
        if (drVolTypeList.size() > 1) {
            String drVolumeType = AbstractServiceInstanceCreateImpl.getDrSameDevVolumeType(pg, drVolTypeList);
            if (!VerifyUtil.isEmpty((String)drVolumeType)) {
                return drVolumeType;
            }
            OpenStackBasicUtil.sortVolumeTypeByPriority(drVolTypeList);
            return ((InstanceVolTypeMapping)drVolTypeList.get(0)).getDrVolumeType();
        }
        if (drVolTypeList.size() == 1) {
            return ((InstanceVolTypeMapping)drVolTypeList.get(0)).getDrVolumeType();
        }
        StringBuilder volumeTypeBuilder = new StringBuilder();
        for (OpenStackVolTypeMapping tempVolumeType : volTypeList) {
            volumeTypeBuilder.append(tempVolumeType.toString() + ", ");
        }
        logger.error((Object)("Source VolType do not have find Dr VolType.srVolType=" + srVolType + ", DrVolTypeList=" + volumeTypeBuilder.toString()));
        return null;
    }

    private static String getDrSameDevVolumeType(ProtectGroup pg, List<InstanceVolTypeMapping> drVolTypeList) {
        JSONObject volConfig;
        if (VerifyUtil.isEmpty((Object)pg)) {
            return null;
        }
        if (!CHECK_SAME_DEV_TEMPLATE_TYPES.contains(pg.getTemplate().getType())) {
            return null;
        }
        ProtectGroup dbPg = QueryProtectGroupRefineService.getInstance().getProtectGroupBasicInfo(pg.getUuid(), true);
        if (VerifyUtil.isEmpty((Object)dbPg)) {
            logger.info((Object)"The protect group(%s) is not existed.", new Object[]{pg.getUuid()});
            return null;
        }
        Set po = dbPg.getPolist();
        if (VerifyUtil.isEmpty((Collection)po)) {
            return null;
        }
        String otherDrVolType = "";
        String volConfigStr = (String)((ProtectObject)po.iterator().next()).getProps().get("volumeConfig");
        JSONArray volConfigList = JSONArray.fromObject((Object)volConfigStr);
        for (int i = 0; i < volConfigList.size() && VerifyUtil.isEmpty((String)(otherDrVolType = (volConfig = volConfigList.getJSONObject(i)).getString("drVolumeType", ""))); ++i) {
        }
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjectUuid = (String)pg.getProps().get("drProjectId");
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        for (InstanceVolTypeMapping volTypeMap : drVolTypeList) {
            List volTypeList = volumeService.getVolumeTypesByName(new HashSet<String>(Arrays.asList(volTypeMap.getDrVolumeType(), otherDrVolType)), drRegionUuid, drProjectUuid);
            if (!volumeService.isVolTypesFromSameDev(volTypeList)) continue;
            return volTypeMap.getDrVolumeType();
        }
        return null;
    }

    @Deprecated
    public List<VmInfoBO> queryAvailableOccupiedVms(String regionId, String projectId, String serverId, String remoteRegionId, String remoteProjectId, String remoteAzName) {
        OpenStackAvailabilityZoneMapping zoneMapping = OpenStackCommonUtil.initOpenStackAvailabilityZoneMapping(regionId, remoteRegionId, remoteAzName);
        return this.queryAvailableOccupiedVms(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), serverId, projectId, remoteProjectId, zoneMapping);
    }

    public List<VmInfoBO> queryAvailableOccupiedVms(String instanceType, String serverId, String projectId, String remoteProjectId, OpenStackAvailabilityZoneMapping zoneMapping) {
        return OpenstackCache.run(() -> {
            ArrayList<String> serverIdList = new ArrayList<String>();
            serverIdList.add(serverId);
            Map<String, List<VmInfoBO>> result = this.queryAvailableOccupiedVmMap(instanceType, projectId, remoteProjectId, serverIdList, zoneMapping);
            return result.get(serverId);
        });
    }

    public Map<String, List<VmInfoBO>> queryAvailableOccupiedVmMap(String instanceType, String projectId, String remoteProjectId, Collection<String> serverIdList, OpenStackAvailabilityZoneMapping zoneMapping) {
        String regionId = zoneMapping.getPrimaryRegionId();
        String remoteRegionId = zoneMapping.getSecondRegionId();
        String remoteAzName = zoneMapping.getSecondAzId();
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(instanceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(instanceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(instanceType)) {
            return this.queryAvailableOccupiedVmMap(regionId, projectId, serverIdList, remoteRegionId, remoteProjectId, remoteAzName);
        }
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue().equals(instanceType)) {
            return this.vailableOccupiedVmMap(regionId, projectId, serverIdList, remoteAzName);
        }
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public Map<String, List<VmInfoBO>> queryAvailableOccupiedVmMap(String regionId, String projectId, Collection<String> serverIdList, String remoteRegionId, String remoteProjectId, String remoteAzName) {
        FusionSphereOpenStack openstack = this.getOpenstack();
        String openstackUuid = openstack.getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, regionId);
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
        String remoteProjectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, remoteProjectId);
        String remoteRegionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, remoteRegionId);
        OpenstackCache.preloadVmAndVolume(new Project(new Region(regionUuid), projectUuid), new Project(new Region(remoteRegionUuid), remoteProjectUuid));
        OpenStackAllInfo openStackAllInfo = this.getOpenStackAllInfo(openstackUuid, regionUuid, projectUuid, remoteProjectUuid, remoteRegionUuid);
        Map<String, VMFlavor> flavorMap = this.getFlavorMap(openStackAllInfo.getRemoteVmFlavorList());
        Map<String, String> vmAndBootVolFirmType = this.getStringStringMap(remoteRegionId, remoteAzName, openStackAllInfo);
        HashMap<String, List<VmInfoBO>> result = new HashMap<String, List<VmInfoBO>>();
        for (String serverId : serverIdList) {
            this.buildVmInfo(new BuildVmInfoModel(openstackUuid, regionUuid, projectUuid, remoteProjectUuid, remoteRegionUuid, openStackAllInfo, serverId), flavorMap, vmAndBootVolFirmType, result);
        }
        return result;
    }

    private OpenStackAllInfo getOpenStackAllInfo(String openstackUuid, String regionUuid, String projectUuid, String remoteProjectUuid, String remoteRegionUuid) {
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        IImageManager imageMgr = ManagerFactory.getInstance().getImageManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        String remoteTokenId = TokenUtil.getInstance().getRegionTokenId(remoteRegionUuid, remoteProjectUuid);
        Future prdVmsFuture = ExecutionService.commit((Callable)new VmCallable(novaMgr, regionUuid, tokenId, projectUuid));
        Future prdVolsFuture = ExecutionService.commit((Callable)new VolumeCallable(volumeService, regionUuid, projectUuid));
        Future prdImgsFuture = ExecutionService.submit((Callable)new ImageCallable(imageMgr, regionUuid, tokenId));
        Future prdVisorFuture = ExecutionService.submit((Callable)new VisorCallable(novaMgr, regionUuid, projectUuid, tokenId));
        Future remoteVmsFuture = ExecutionService.commit((Callable)new VmCallable(novaMgr, remoteRegionUuid, remoteTokenId, remoteProjectUuid));
        Future remoteVisorFuture = ExecutionService.submit((Callable)new VisorCallable(novaMgr, remoteRegionUuid, remoteProjectUuid, remoteTokenId));
        Future remoteVolsFuture = ExecutionService.commit((Callable)new VolumeCallable(volumeService, remoteRegionUuid, remoteProjectUuid));
        Future remoteImgsFuture = ExecutionService.submit((Callable)new ImageCallable(imageMgr, remoteRegionUuid, remoteTokenId));
        Future remoteFlavorFuture = ExecutionService.submit((Callable)new FlavorCallable(novaMgr, remoteRegionUuid, remoteTokenId, remoteProjectUuid));
        Future systemCapabilityFuture = ExecutionService.submit((Callable)new SystemCapabilityCallable(novaMgr, regionUuid, tokenId));
        OpenStackAllInfo openStackAllInfo = new OpenStackAllInfo();
        openStackAllInfo.setProductVmList((List)this.getFromFuture(prdVmsFuture));
        openStackAllInfo.setProductVolumeList((List)this.getFromFuture(prdVolsFuture));
        openStackAllInfo.setProductImageList((List)this.getFromFuture(prdImgsFuture));
        openStackAllInfo.setProductHypervisorInfoList((List)this.getFromFuture(prdVisorFuture));
        openStackAllInfo.setRemoteVmList((List)this.getFromFuture(remoteVmsFuture));
        openStackAllInfo.setRemoteVolumeList((List)this.getFromFuture(remoteVolsFuture));
        openStackAllInfo.setRemoteImageList((List)this.getFromFuture(remoteImgsFuture));
        openStackAllInfo.setRemoteVmFlavorList((List)this.getFromFuture(remoteFlavorFuture));
        openStackAllInfo.setRemoteHypervisorInfoList((List)this.getFromFuture(remoteVisorFuture));
        openStackAllInfo.setSystemCapabilities((List)this.getFromFuture(systemCapabilityFuture));
        openStackAllInfo.setAvailableVMs(new ArrayList(openStackAllInfo.getRemoteVmList()));
        return openStackAllInfo;
    }

    private Map<String, String> getStringStringMap(String remoteRegionId, String remoteAzName, OpenStackAllInfo openStackAllInfo) {
        Set<String> usedVms = this.getUsedPlaceHoldVmUuids();
        logger.debug((Object)"Start filter occupiedVm of region %s, vm number is %s.", new Object[]{remoteRegionId, openStackAllInfo.getRemoteVmList().size()});
        HashMap<String, String> vmAndBootVolFirmType = new HashMap<String, String>();
        this.occupiedVmBaseFilter(remoteAzName, usedVms, openStackAllInfo, vmAndBootVolFirmType);
        logger.debug((Object)"After base filter of region %s, occupiedVm number is %s.", new Object[]{remoteRegionId, openStackAllInfo.getRemoteVolumeList()});
        return vmAndBootVolFirmType;
    }

    private void buildVmInfo(BuildVmInfoModel buildVminfoModel, Map<String, VMFlavor> flavorMap, Map<String, String> vmAndBootVolFirmType, Map<String, List<VmInfoBO>> result) {
        String vmUuid = OpenStackCommonUtil.getObjectUuid(buildVminfoModel.getOpenstackUuid(), buildVminfoModel.getServerId());
        OpenStackVM produceOpenStackVM = null;
        for (OpenStackVM openStackVM : buildVminfoModel.getOpenStackAllInfo().getProductVmList()) {
            if (!vmUuid.equals(openStackVM.getUuid())) continue;
            produceOpenStackVM = openStackVM;
            break;
        }
        if (VerifyUtil.isEmpty(produceOpenStackVM)) {
            logger.debug((Object)"vmInfo is empty", 90160758786989L);
            return;
        }
        ArrayList<OpenStackVM> remoteOpenStackVMList = new ArrayList<OpenStackVM>(buildVminfoModel.getOpenStackAllInfo().getAvailableVMs());
        Iterator<OpenStackVM> iterator = remoteOpenStackVMList.iterator();
        if (!VerifyUtil.isEmpty(remoteOpenStackVMList)) {
            this.extracted(buildVminfoModel, vmAndBootVolFirmType, produceOpenStackVM, remoteOpenStackVMList, iterator);
        }
        ArrayList<VmInfoBO> vmInfoBOList = new ArrayList<VmInfoBO>();
        for (OpenStackVM vm : remoteOpenStackVMList) {
            String poVmId = CommUtil.combineString((String[])new String[]{buildVminfoModel.getRemoteRegionUuid(), OpenStackCommonUtil.getIdFromUuid(vm.getUuid())});
            if (ProtectExecutingVmsQueue.isContainVm(poVmId)) continue;
            vmInfoBOList.add(this.convertOpenStackVMToVMInfoBo(null, vm, flavorMap.get(vm.getFlavorId())));
        }
        result.put(buildVminfoModel.getServerId(), vmInfoBOList);
    }

    private void extracted(BuildVmInfoModel buildVminfoModel, Map<String, String> vmAndBootVolFirmType, OpenStackVM produceOpenStackVM, List<OpenStackVM> remoteOpenStackVMList, Iterator<OpenStackVM> iterator) {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            this.rootDeviceNameFilter(buildVminfoModel.getOpenStackAllInfo().getProductHypervisorInfoList(), produceOpenStackVM, iterator);
            if (!VerifyUtil.isEmpty(remoteOpenStackVMList) && !produceOpenStackVM.getTags().contains("__type_baremetal")) {
                this.filterImageFirmwareType(produceOpenStackVM, remoteOpenStackVMList.iterator(), buildVminfoModel.getOpenStackAllInfo().getProductVolumeList(), vmAndBootVolFirmType);
            }
            if (LegoConfig.getInstance().getBoolean("is.support.phytium.hygon", Boolean.valueOf(true)).booleanValue()) {
                this.filterCpuVendorAndArch(produceOpenStackVM, buildVminfoModel.getOpenStackAllInfo(), remoteOpenStackVMList.iterator());
            }
            logger.debug((Object)"After filter ImageFirmwareType of %s, occupiedVm number is %s.", new Object[]{buildVminfoModel.getServerId(), remoteOpenStackVMList.size()});
        } else {
            String hwDiskBus = this.getHwDiskBus(buildVminfoModel.getRegionUuid(), buildVminfoModel.getProjectUuid(), produceOpenStackVM, buildVminfoModel.getOpenStackAllInfo().getProductVolumeList(), buildVminfoModel.getOpenStackAllInfo().getProductImageList());
            this.filterHwDiskBus(iterator, buildVminfoModel.getRemoteProjectUuid(), hwDiskBus, buildVminfoModel.getRemoteRegionUuid(), buildVminfoModel.getOpenStackAllInfo().getRemoteVolumeList(), buildVminfoModel.getOpenStackAllInfo().getRemoteImageList());
            logger.debug((Object)"After filter HwDiskBus of %s, occupiedVm number is %s.", new Object[]{buildVminfoModel.getServerId(), remoteOpenStackVMList.size()});
        }
    }

    private void filterCpuVendorAndArch(OpenStackVM produceOpenStackVM, OpenStackAllInfo openStackAllInfo, Iterator<OpenStackVM> remoteOpenStackVMIterator) {
        while (remoteOpenStackVMIterator.hasNext()) {
            OpenStackVM remoteOpenStackVM = remoteOpenStackVMIterator.next();
            if (this.checkCpuVendorsAndArchitecture(produceOpenStackVM, remoteOpenStackVM, openStackAllInfo, openStackAllInfo.getRemoteHypervisorInfoList())) continue;
            remoteOpenStackVMIterator.remove();
        }
    }

    private void filterImageFirmwareType(OpenStackVM produceOpenStackVM, Iterator<OpenStackVM> remoteOpenStackVMIterator, List<OpenStackVolume> volumeList, Map<String, String> vmAndBootVolFirmType) {
        String hwFirmwareType = this.getBootVolumeFirmwareType(produceOpenStackVM, volumeList);
        while (remoteOpenStackVMIterator.hasNext()) {
            OpenStackVM remoteOpenStackVM = remoteOpenStackVMIterator.next();
            String remoteVMFirmwareType = vmAndBootVolFirmType.get(remoteOpenStackVM.getUuid());
            if (!VerifyUtil.isEmpty((String)remoteVMFirmwareType) && hwFirmwareType.equalsIgnoreCase(remoteVMFirmwareType)) continue;
            logger.error((Object)"Firmware Type Not Equal: PhVm  firmware type is %s, remoteVm(%s) firmware type is %s.", new Object[]{hwFirmwareType, remoteOpenStackVM.getName(), remoteVMFirmwareType});
            remoteOpenStackVMIterator.remove();
        }
    }

    private String getBootVolumeFirmwareType(OpenStackVM produceOpenStackVM, List<OpenStackVolume> volumeList) {
        String hwFirmwareType = null;
        OpenStackVolume openStackVolume = AbstractServiceInstanceCreateImpl.filterBootVolume(produceOpenStackVM, volumeList);
        if (!VerifyUtil.isEmpty((Object)openStackVolume) && !VerifyUtil.isEmpty((Map)openStackVolume.getVolumeImageMetadata())) {
            hwFirmwareType = (String)openStackVolume.getVolumeImageMetadata().get("hw_firmware_type");
        }
        if (VerifyUtil.isEmpty(hwFirmwareType) || "--".equals(hwFirmwareType)) {
            hwFirmwareType = OpenstackEnumDefine.HwFirmwareTypeE.BIOS.getValue();
        }
        return hwFirmwareType;
    }

    private void rootDeviceNameFilter(List<HypervisorInfo> hypervisorInfoList, OpenStackVM produceOpenStackVM, Iterator<OpenStackVM> iterator) {
        logger.debug((Object)("root_device_name filter, ProductVM, name:" + produceOpenStackVM.getName() + ", projectUuid:" + produceOpenStackVM.getProjectUuid() + ",ProductVM tags=" + produceOpenStackVM.getTags()));
        if (!VerifyUtil.isEmpty((Collection)produceOpenStackVM.getTags()) && produceOpenStackVM.getTags().contains("__type_baremetal")) {
            logger.info((Object)("root_device_name filter, ProductVM, name:" + produceOpenStackVM.getName() + " is baremetal, Do not check root device name, projectUuid:" + produceOpenStackVM.getProjectUuid() + ",ProductVM tags=" + produceOpenStackVM.getTags()));
            return;
        }
        HypervisorInfo hyperVisirForPdVm = this.getHypervisorForPdVm(produceOpenStackVM, hypervisorInfoList);
        if (hyperVisirForPdVm != null && !"FusionCompute".equals(hyperVisirForPdVm.getHypervisorType())) {
            while (iterator.hasNext()) {
                OpenStackVM temVM = iterator.next();
                if (VerifyUtil.isEmpty((String)temVM.getBootDevName()) || VerifyUtil.isEmpty((String)produceOpenStackVM.getBootDevName()) || !temVM.getBootDevName().equals(produceOpenStackVM.getBootDevName())) {
                    logger.debug((Object)("root_device_name don't match, remove PhVM, name:" + temVM.getName() + ", projectUuid:" + temVM.getProjectUuid()));
                    iterator.remove();
                    continue;
                }
                if (this.checkProdAndDrVMHasSameBridge(produceOpenStackVM, temVM)) continue;
                logger.debug((Object)"filterCSHAPlaceHoldVM:vm:%s, bridge not equal to %s,phVM:%s,bridge:%s", new Object[]{produceOpenStackVM.getName(), produceOpenStackVM.getMetadata().get("cascaded.instance_extrainfo"), temVM.getName(), temVM.getMetadata().get("cascaded.instance_extrainfo")});
                iterator.remove();
            }
        }
        if (VerifyUtil.isEmpty((Object)hyperVisirForPdVm)) {
            logger.error((Object)("no hyperVisor host matched for ProductVM, name:" + produceOpenStackVM.getName() + ", projectUuid:" + produceOpenStackVM.getProjectUuid() + ";remove all PhVM"));
            while (iterator.hasNext()) {
                iterator.remove();
            }
        }
    }

    private HypervisorInfo getHypervisorForPdVm(OpenStackVM produceOpenStackVM, List<HypervisorInfo> hypervisorInfoList) {
        for (HypervisorInfo hi : hypervisorInfoList) {
            if (!produceOpenStackVM.getHypervisorHostName().equals(hi.getName())) continue;
            return hi;
        }
        logger.info((Object)"no hypervisor host match ");
        return null;
    }

    private void occupiedVmBaseFilter(String remoteAzName, Set<String> usedVms, OpenStackAllInfo openStackAllInfo, Map<String, String> vmAndBootVolFirmType) {
        List remoteAllVm = openStackAllInfo.getAvailableVMs();
        ListIterator remoteAllVmIterator = remoteAllVm.listIterator();
        while (remoteAllVmIterator.hasNext()) {
            OpenStackVM remoteOpenStackVM = (OpenStackVM)remoteAllVmIterator.next();
            List<String> remoteVolumeIdList = OpenStackCommonUtil.getListFromStr(remoteOpenStackVM.getVolumeAttached(), ",");
            if (!remoteAzName.equals(remoteOpenStackVM.getAzName()) || this.checkIllegalVmStatus(remoteOpenStackVM, remoteVolumeIdList, openStackAllInfo.getRemoteVolumeList(), vmAndBootVolFirmType) || usedVms.contains(remoteOpenStackVM.getUuid())) {
                logger.debug((Object)"Remote Vm not match basic rule of occupiedVm. Vm name: %s, remoteAzName: %s ,Vm AZ name: %s, usedVms contains is: %s, VM status is: %s, VM tags: %s, Vm volume size: %s.", new Object[]{remoteOpenStackVM.getName(), remoteAzName, remoteOpenStackVM.getAzName(), usedVms.contains(remoteOpenStackVM.getUuid()), remoteOpenStackVM.getStatus(), remoteOpenStackVM.getTags(), remoteVolumeIdList.size()});
                remoteAllVmIterator.remove();
                continue;
            }
            if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63()) continue;
            if (this.checkIllegalVmTag(remoteOpenStackVM)) {
                logger.debug((Object)("occupiedVm not match tagis illegal.vmname=" + remoteOpenStackVM.getName() + ", remoteOpenStackVM tags=" + remoteOpenStackVM.getTags()));
                remoteAllVmIterator.remove();
                continue;
            }
            if (this.checkVmIllegalStatus(remoteOpenStackVM)) {
                logger.debug((Object)("occupiedVm status is illegal.vmname=" + remoteOpenStackVM.getName()));
                remoteAllVmIterator.remove();
                continue;
            }
            if (!this.checkVmPdDrTag(remoteOpenStackVM)) continue;
            logger.debug((Object)("checkVmSelfProperties vm :" + remoteOpenStackVM.getName() + " have  __type_dr or __type_pd tag, vm tags=" + remoteOpenStackVM.getTags()));
            remoteAllVmIterator.remove();
        }
        openStackAllInfo.setAvailableVMs(remoteAllVm);
    }

    private boolean checkVmPdDrTag(OpenStackVM vm) {
        if (VerifyUtil.isEmpty((Object)vm)) {
            logger.debug((Object)"check illegal vm tag failed.vm is null");
            throw new LegoCheckedException(1073947393L);
        }
        Set tags = vm.getTags();
        return !VerifyUtil.isEmpty((Collection)tags) && (tags.contains("__type_pd") || tags.contains("__type_dr"));
    }

    private boolean checkIllegalVmStatus(OpenStackVM remoteOpenStackVM, List<String> remoteVolumeIdList, List<OpenStackVolume> remoteVolumeList, Map<String, String> vmAndBootVolFirmwareType) {
        boolean result;
        if (OpenStackCommonUtil.isBareMetalServer(remoteOpenStackVM)) {
            return false;
        }
        OpenStackVolume bootVolume = AbstractServiceInstanceCreateImpl.filterBootVolume(remoteOpenStackVM, remoteVolumeList);
        boolean noBootVolume = VerifyUtil.isEmpty((Object)bootVolume);
        boolean bl = result = !Integer.valueOf(OpenstackEnumDefine.VmStatusE.SHUTOFF.getValue()).equals(remoteOpenStackVM.getStatus()) || remoteVolumeIdList.size() > 1 || noBootVolume;
        if (!result && !VerifyUtil.isEmpty((Map)bootVolume.getVolumeImageMetadata())) {
            String value = (String)bootVolume.getVolumeImageMetadata().get("hw_firmware_type");
            value = VerifyUtil.isEmpty((String)value) || "--".equals(value) ? OpenstackEnumDefine.HwFirmwareTypeE.BIOS.getValue() : value;
            vmAndBootVolFirmwareType.put(remoteOpenStackVM.getUuid(), value);
        }
        return result;
    }

    private boolean checkIllegalVmTag(OpenStackVM vm) {
        if (null == vm) {
            logger.debug((Object)"check illegal vm tag failed.vm is null");
            throw new LegoCheckedException(1073947393L);
        }
        Set tags = vm.getTags();
        return VerifyUtil.isEmpty((Collection)tags) || !tags.contains("__single_storage");
    }

    public Map<String, List<VmInfoBO>> vailableOccupiedVmMap(String regionId, String projectId, Collection<String> serverIdList, String remoteAzName) {
        FusionSphereOpenStack openstack = this.getOpenstack();
        String openstackUuid = openstack.getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, regionId);
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        OpenstackCache.preloadVmAndVolume(new Project(new Region(regionUuid), projectUuid));
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        IImageManager imageMgr = ManagerFactory.getInstance().getImageManager(openstackUuid);
        Future prdVmsFuture = ExecutionService.commit((Callable)new VmCallable(novaMgr, regionUuid, tokenId, projectUuid));
        Future prdVolsFuture = ExecutionService.commit((Callable)new VolumeCallable(volumeService, regionUuid, projectUuid));
        Future prdImgsFuture = ExecutionService.submit((Callable)new ImageCallable(imageMgr, regionUuid, tokenId));
        Future prdFlavorFuture = ExecutionService.submit((Callable)new FlavorCallable(novaMgr, regionUuid, tokenId, projectUuid));
        Future prdVisorFuture = ExecutionService.submit((Callable)new VisorCallable(novaMgr, regionUuid, projectUuid, tokenId));
        Future systemCapabilityFuture = ExecutionService.submit((Callable)new SystemCapabilityCallable(novaMgr, regionUuid, tokenId));
        OpenStackAllInfo openStackAllInfo = new OpenStackAllInfo();
        openStackAllInfo.setProductVmList((List)this.getFromFuture(prdVmsFuture));
        openStackAllInfo.setProductVolumeList((List)this.getFromFuture(prdVolsFuture));
        openStackAllInfo.setProductImageList((List)this.getFromFuture(prdImgsFuture));
        openStackAllInfo.setProductVmFlavorList((List)this.getFromFuture(prdFlavorFuture));
        openStackAllInfo.setProductHypervisorInfoList((List)this.getFromFuture(prdVisorFuture));
        openStackAllInfo.setSystemCapabilities((List)this.getFromFuture(systemCapabilityFuture));
        Map<String, VMFlavor> flavorMap = this.getFlavorMap(openStackAllInfo.getProductVmFlavorList());
        Set<String> usedVms = this.getUsedPlaceHoldVmUuids();
        ArrayList<OpenStackVM> occupiedVMList = new ArrayList<OpenStackVM>();
        this.baseFilter(remoteAzName, openStackAllInfo.getProductVmList(), usedVms, occupiedVMList);
        HashMap<String, List<VmInfoBO>> result = new HashMap<String, List<VmInfoBO>>();
        HashMap<String, String> hwDiskBusMap = new HashMap<String, String>();
        for (String serverId : serverIdList) {
            String vmUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, serverId);
            OpenStackVM produceOpenStackVM = null;
            for (OpenStackVM openStackVM : openStackAllInfo.getProductVmList()) {
                if (!vmUuid.equals(openStackVM.getUuid())) continue;
                produceOpenStackVM = openStackVM;
                break;
            }
            if (VerifyUtil.isEmpty(produceOpenStackVM)) {
                logger.warn((Object)"vmInfo is empty", 90160758786989L);
                continue;
            }
            ArrayList<OpenStackVM> occupiedVMListForVm = new ArrayList<OpenStackVM>(occupiedVMList);
            if (!VerifyUtil.isEmpty(occupiedVMListForVm)) {
                if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                    this.filterCSHAPHVMByRootDevName(produceOpenStackVM, occupiedVMListForVm, openStackAllInfo);
                } else {
                    this.filterCSHAPlaceHoldVM(regionUuid, projectUuid, openStackAllInfo, hwDiskBusMap, produceOpenStackVM, occupiedVMListForVm);
                }
            }
            ArrayList<VmInfoBO> vmInfoBOList = new ArrayList<VmInfoBO>();
            for (OpenStackVM vm : occupiedVMListForVm) {
                vmInfoBOList.add(this.convertOpenStackVMToVMInfoBo(null, vm, flavorMap.get(vm.getFlavorId())));
            }
            result.put(serverId, vmInfoBOList);
        }
        return result;
    }

    private void baseFilter(String remoteAzName, List<OpenStackVM> openStackVMList, Set<String> usedVms, List<OpenStackVM> occupiedVMList) {
        if (null == openStackVMList) {
            return;
        }
        for (OpenStackVM vm : openStackVMList) {
            Set tags = vm.getTags();
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63() && (VerifyUtil.isEmpty((Collection)tags) || this.checkVmIllegalStatus(vm) || this.checkIllegalTag(tags))) {
                logger.debug((Object)"VM status is illegal or tags is illegal.");
                continue;
            }
            List<String> remoteVolumeIdList = OpenStackCommonUtil.getListFromStr(vm.getVolumeAttached(), ",");
            if (!remoteAzName.equals(vm.getAzName()) || !Integer.valueOf(OpenstackEnumDefine.VmStatusE.SHUTOFF.getValue()).equals(vm.getStatus()) || remoteVolumeIdList.size() > 1 || this.phVmHasUsed(usedVms, vm)) continue;
            occupiedVMList.add(vm);
        }
    }

    private boolean checkIllegalTag(Set<String> tags) {
        logger.debug((Object)("vm tags are : " + tags));
        return !tags.contains("__single_storage") || tags.contains("__type_pd") || tags.contains("__type_dr") || tags.contains("__type_csha");
    }

    private boolean phVmHasUsed(Set<String> usedVms, OpenStackVM vm) {
        return usedVms.contains(vm.getUuid()) || usedVms.contains(OpenStackCommonUtil.getIdFromUuid(vm.getUuid()));
    }

    private void filterCSHAPHVMByRootDevName(OpenStackVM produceOpenStackVM, List<OpenStackVM> occupiedVMListForVm, OpenStackAllInfo openStackAllInfo) {
        Iterator<OpenStackVM> iterator = occupiedVMListForVm.iterator();
        while (iterator.hasNext()) {
            OpenStackVM temVM = iterator.next();
            HypervisorInfo hyperVisirForPdVm = this.getHypervisorForPdVm(produceOpenStackVM, openStackAllInfo.getProductHypervisorInfoList());
            if (!VerifyUtil.isEmpty((String)produceOpenStackVM.getImageId()) && produceOpenStackVM.getImageId().equals(temVM.getImageId())) {
                logger.debug((Object)("filterCSHAPlaceHoldVM:vm:" + produceOpenStackVM.getName() + " same iamgeId:" + produceOpenStackVM.getImageId() + ",phVM:" + temVM.getName() + ",imageId:" + temVM.getImageId()));
                if (hyperVisirForPdVm == null || "FusionCompute".equals(hyperVisirForPdVm.getHypervisorType()) || this.checkProdAndDrVMHasSameBridge(produceOpenStackVM, temVM)) continue;
                logger.debug((Object)"filterCSHAPlaceHoldVM:vm:%s, bridge not equal to %s,phVM:%s,bridge:%s", new Object[]{produceOpenStackVM.getName(), produceOpenStackVM.getMetadata().get("cascaded.instance_extrainfo"), temVM.getName(), temVM.getMetadata().get("cascaded.instance_extrainfo")});
            }
            this.extracted(produceOpenStackVM, openStackAllInfo, iterator, temVM, hyperVisirForPdVm);
        }
    }

    private void extracted(OpenStackVM produceOpenStackVM, OpenStackAllInfo openStackAllInfo, Iterator<OpenStackVM> iterator, OpenStackVM temVM, HypervisorInfo hyperVisirForPdVm) {
        if (hyperVisirForPdVm != null && !"FusionCompute".equals(hyperVisirForPdVm.getHypervisorType())) {
            if (VerifyUtil.isEmpty((String)temVM.getBootDevName()) || VerifyUtil.isEmpty((String)produceOpenStackVM.getBootDevName()) || !temVM.getBootDevName().equals(produceOpenStackVM.getBootDevName())) {
                logger.error((Object)"Root_device_name don't match; PhVM name:%s,projectUuid:%s", new Object[]{temVM.getName(), temVM.getProjectUuid()});
                iterator.remove();
                return;
            }
            if (!this.checkProdAndDrVMHasSameBridge(produceOpenStackVM, temVM)) {
                logger.debug((Object)"filterCSHAPlaceHoldVM:vm:%s, bridge not equal to %s,phVM:%s,bridge:%s", new Object[]{produceOpenStackVM.getName(), produceOpenStackVM.getMetadata().get("cascaded.instance_extrainfo"), temVM.getName(), temVM.getMetadata().get("cascaded.instance_extrainfo")});
                iterator.remove();
            }
        }
        if (VerifyUtil.isEmpty((Object)hyperVisirForPdVm)) {
            logger.error((Object)"No hyperVisor host matched for ProductVM, name:%s, projectUuid:%s;remove PhVM, name:%s", new Object[]{produceOpenStackVM.getName(), produceOpenStackVM.getProjectUuid(), temVM.getName()});
            iterator.remove();
        }
        if (LegoConfig.getInstance().getBoolean("is.support.phytium.hygon", Boolean.valueOf(true)).booleanValue() && !this.checkCpuVendorsAndArchitecture(produceOpenStackVM, temVM, openStackAllInfo, openStackAllInfo.getProductHypervisorInfoList())) {
            logger.debug((Object)"The DR VM (%s) architecture vendor verification fails.", new Object[]{String.valueOf(temVM.getMoId())});
            iterator.remove();
        }
    }

    private boolean checkCpuVendorsAndArchitecture(OpenStackVM productVM, OpenStackVM tempVm, OpenStackAllInfo openStackAllInfo, List<HypervisorInfo> hypervisorInfos) {
        if (!productVM.getCpuVendor().equals(tempVm.getCpuVendor())) {
            logger.debug((Object)"The CPU vendors are different. pdVm(%s):[%s], drVm(%s):[%s].", new Object[]{String.valueOf(productVM.getUuid()), productVM.getCpuVendor(), tempVm.getUuid(), tempVm.getCpuVendor()});
            return false;
        }
        if (OpenstackEnumDefine.ArchitectureAndCpuVendor.PHYTIUM.getCpuVendor().equals(tempVm.getCpuVendor())) {
            HypervisorInfo hypervisorInfo = this.getHypervisorForPdVm(tempVm, hypervisorInfos);
            String tmpCpuModel = Optional.ofNullable(hypervisorInfo).map(HypervisorInfo::getCpuInfo).map(CpuInfo::getModel).orElse(null);
            if (VerifyUtil.isEmpty((String)tmpCpuModel)) {
                logger.error((Object)"Failed to obtain the CPU model of the placeholder VM(%s).", new Object[]{String.valueOf(tempVm.getMoId())});
                return true;
            }
            String imageId = productVM.getMetadata().getOrDefault("metering.image_id", "");
            if (VerifyUtil.isEmpty((String)imageId)) {
                logger.error((Object)"The current image id is empty.");
                return true;
            }
            if (VerifyUtil.isEmpty((Collection)openStackAllInfo.getProductImageList())) {
                logger.error((Object)"The current image list is empty.");
                return true;
            }
            OpenStackImage productImage = openStackAllInfo.getProductImageList().stream().filter(e -> imageId.equals(e.getId())).findFirst().orElse(null);
            if (productImage == null) {
                logger.error((Object)"The image(%s) cannot be found.", new Object[]{imageId});
                return true;
            }
            if (openStackAllInfo.getSystemCapabilities().isEmpty()) {
                logger.error((Object)"The SIA information is empty.");
                return true;
            }
            List guestOSTypeList = Optional.ofNullable(openStackAllInfo.getSystemCapabilities().get(0)).map(SystemCapability::getCapabilities).map(Capability::getOsConfig).map(OsConfig::getGuestOSType).orElse(new ArrayList());
            logger.debug((Object)"The number of images to be queried is %s", new Object[]{String.valueOf(guestOSTypeList.size())});
            GuestOSType guestOSType = guestOSTypeList.stream().filter(e -> productImage.getOsType().equalsIgnoreCase(e.getOsType()) && productImage.getOsVersion().equals(e.getName() + " " + e.getOsBit() + "bit")).findFirst().orElse(null);
            List supportModel = Optional.ofNullable(guestOSType).map(GuestOSType::getCpuVendorCapabilities).map(CpuVendorCapability::getPhytium).map(CpuVendor::getSupportedCpuModel).orElse(new ArrayList());
            logger.debug((Object)"The CPU architecture supported by production VMs is as follows: %s", new Object[]{String.join((CharSequence)",", supportModel)});
            return supportModel.stream().anyMatch(e -> "all".equals(e) || e.equals(tmpCpuModel));
        }
        return true;
    }

    private void filterCSHAPlaceHoldVM(String regionUuid, String projectUuid, OpenStackAllInfo openStackAllInfo, Map<String, String> hwDiskBusMap, OpenStackVM produceOpenStackVM, List<OpenStackVM> occupiedVMListForVm) {
        Iterator<OpenStackVM> iterator = occupiedVMListForVm.iterator();
        while (iterator.hasNext()) {
            String hwDiskBusTemp;
            OpenStackVM temVM = iterator.next();
            if (!VerifyUtil.isEmpty((String)produceOpenStackVM.getImageId()) && produceOpenStackVM.getImageId().equals(temVM.getImageId())) {
                logger.debug((Object)("filterCSHAPlaceHoldVM:vm:" + produceOpenStackVM.getName() + " same iamgeId:" + produceOpenStackVM.getImageId() + ",phVM:" + temVM.getName() + ",imageId:" + temVM.getImageId()));
                continue;
            }
            String hwDiskBus = this.getHwDiskBus(hwDiskBusMap, regionUuid, projectUuid, produceOpenStackVM, openStackAllInfo.getProductVolumeList(), openStackAllInfo.getProductImageList());
            if (VerifyUtil.isEmpty((String)hwDiskBus) || hwDiskBus.equals(hwDiskBusTemp = this.getHwDiskBus(hwDiskBusMap, regionUuid, projectUuid, temVM, openStackAllInfo.getProductVolumeList(), openStackAllInfo.getProductImageList()))) continue;
            logger.debug((Object)("filterCSHAPlaceHoldVM:produce VM:" + produceOpenStackVM.getName() + ",hwDiskBus:" + hwDiskBus + " is not the same hwDiskBus,for placeHoldVm:" + temVM.getName() + ",hwDiskBus:" + hwDiskBusTemp));
            iterator.remove();
        }
    }

    protected VmInfoBO convertOpenStackVMToVMInfoBo(Map<String, String> vmStorage, OpenStackVM vm, VMFlavor vf) {
        VmInfoBO vmInfoBO = new VmInfoBO();
        vmInfoBO.setServerId(OpenStackCommonUtil.getIdFromUuid(vm.getUuid()));
        vmInfoBO.setName(vm.getName());
        if (!VerifyUtil.isEmpty((Object)vf)) {
            vmInfoBO.setCpu(vf.getVcpus());
            vmInfoBO.setRam(vf.getRam());
        }
        vmInfoBO.setVmStatus(OpenstackEnumDefine.VmStatusE.getStatusByValue((int)vm.getStatus()).getType());
        vmInfoBO.setDescription(vm.getDescription());
        if (!VerifyUtil.isEmpty((Collection)vm.getTags())) {
            vmInfoBO.setTags(new ArrayList(vm.getTags()));
        }
        if (vmStorage != null) {
            vmInfoBO.setStorageSn(vmStorage.get(vm.getUuid()));
        }
        vmInfoBO.setIp(vm.getAddressIp());
        vmInfoBO.setIpv6(vm.getAddressIpv6());
        return vmInfoBO;
    }

    protected Map<String, VMFlavor> getFlavorMap(List<VMFlavor> vmFlavor) {
        HashMap<String, VMFlavor> flavorMap = new HashMap<String, VMFlavor>();
        for (VMFlavor vf : vmFlavor) {
            flavorMap.put(vf.getId(), vf);
        }
        return flavorMap;
    }

    private void filterHwDiskBus(Iterator<OpenStackVM> iterator, String remoteProjectUuid, String hwDiskBus, String remoteRegionUuid, List<OpenStackVolume> remoteVolumeList, List<OpenStackImage> remoteImageList) {
        if (VerifyUtil.isEmpty((String)hwDiskBus)) {
            return;
        }
        while (iterator.hasNext()) {
            OpenStackVM remoteOpenStackVM = iterator.next();
            String remoteHwDiskBus = this.getHwDiskBus(remoteRegionUuid, remoteProjectUuid, remoteOpenStackVM, remoteVolumeList, remoteImageList);
            if (hwDiskBus.equals(remoteHwDiskBus)) continue;
            iterator.remove();
        }
    }

    private String getHwDiskBus(Map<String, String> hwDiskBusMap, String regionUuid, String projectUuid, OpenStackVM vmInfo, List<OpenStackVolume> volumeList, List<OpenStackImage> imageList) {
        String hwDiskBus = hwDiskBusMap.get(vmInfo.getUuid());
        if (VerifyUtil.isEmpty((String)hwDiskBus)) {
            hwDiskBus = this.getHwDiskBus(regionUuid, projectUuid, vmInfo, volumeList, imageList);
        }
        if (!VerifyUtil.isEmpty((String)hwDiskBus)) {
            hwDiskBusMap.put(vmInfo.getUuid(), hwDiskBus);
        }
        return hwDiskBus;
    }

    private String getHwDiskBus(String regionUuid, String projectUuid, OpenStackVM vmInfo, List<OpenStackVolume> volumeList, List<OpenStackImage> imageList) {
        IVolumeService volumeService;
        ImageMetadataInfo queryImageMedata;
        String hwDiskBus = null;
        OpenStackVolume openStackVolume = AbstractServiceInstanceCreateImpl.filterBootVolume(vmInfo, volumeList);
        if (!VerifyUtil.isEmpty((Object)openStackVolume) && !VerifyUtil.isEmpty((Object)(queryImageMedata = (volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).queryImageMetadata(openStackVolume.getUuid(), regionUuid, projectUuid)))) {
            hwDiskBus = queryImageMedata.getHwDiskBus();
        }
        if (!VerifyUtil.isEmpty(hwDiskBus)) {
            return hwDiskBus;
        }
        String imageId = vmInfo.getImageId();
        if (VerifyUtil.isEmpty((String)imageId) || VerifyUtil.isEmpty(imageList)) {
            logger.debug((Object)("getHwDiskBus:" + vmInfo.getName() + ",imageId:" + imageId));
            return null;
        }
        for (OpenStackImage openStackImage : imageList) {
            if (!imageId.equals(openStackImage.getId())) continue;
            return openStackImage.getHwDiskBus();
        }
        return null;
    }

    public static OpenStackVolume filterBootVolume(OpenStackVM vmInfo, List<OpenStackVolume> volumeList) {
        String bootDevName = vmInfo.getBootDevName();
        for (OpenStackVolume openStackVolume : volumeList) {
            openStackVolume.generateAttachmentInfo();
            for (OpenStackVolAttachment attachment : openStackVolume.getAttachments()) {
                if (VerifyUtil.isEmpty((String)vmInfo.getUuid()) || !vmInfo.getUuid().equals(attachment.getVmUuid()) || VerifyUtil.isEmpty((String)attachment.getDevice()) || !attachment.getDevice().equals(bootDevName)) continue;
                logger.debug((Object)("vm name" + vmInfo.getName() + ": boot volume is " + openStackVolume.getUuid() + ", boot volume name=" + openStackVolume.getName()));
                return openStackVolume;
            }
        }
        logger.debug((Object)("vm name" + vmInfo.getName() + ": boot volume is null"));
        return null;
    }

    private Set<String> getUsedPlaceHoldVmUuids() {
        String hql = "from RecoverySetting where name = ?";
        List settings = CommonDAOLocator.getMoDao().getHibernateTemplate().find(hql, new Object[]{"PLACEHOLDVM"});
        HashSet<String> usedVms = new HashSet<String>();
        if (!VerifyUtil.isEmpty((Collection)settings)) {
            for (RecoverySetting setting : settings) {
                usedVms.add(setting.getValue());
            }
        }
        String cshahql = "from RecoverySetting where name = ?";
        List cshaSettings = CommonDAOLocator.getMoDao().getHibernateTemplate().find(cshahql, new Object[]{"CSHAPLACEHOLDVM"});
        if (!VerifyUtil.isEmpty((Collection)cshaSettings)) {
            for (RecoverySetting cshaSetting : cshaSettings) {
                usedVms.add(cshaSetting.getValue());
            }
        }
        String queryMouuidSql = "select moUuid from ProtectObject";
        List moUuidList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryMouuidSql, new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)moUuidList)) {
            for (String moUuid : moUuidList) {
                usedVms.add(moUuid);
            }
        }
        OpenStackCheckPhVmUtil.addCurrentPhVmsToSet(usedVms);
        return usedVms;
    }

    protected void updateTaskInfo(ServiceInstaceEnumDefine.ServiceInstanceOperateType operateType, ExtendParamInfo extendParam, AbstractBackTask task, OrderInstanceInfo inst, ServiceInstance instance) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order_instinfo", inst);
        if (extendParam != null) {
            param.put("subscription_id", extendParam.getSubscriptionId());
            param.put("order_result_callback", extendParam.getOrderResultCallback());
            param.put("should_report_quota_separately", extendParam.isShouldReportQuotaSeparately());
        }
        task.setExtendParam(param);
        inst.setBeforeDrVolList(OpenStackCommonUtil.findAllDrVolumes(inst.getInstanceId()));
        inst.setOperateType(operateType);
        if (instance != null) {
            inst.setBeforeStutas(instance.getStatus());
        }
    }

    protected OrderInstanceInfo createOrderInstanceInfo(String instId, String instName, String instType, String proId, String regionId) {
        OrderInstanceInfo inst = new OrderInstanceInfo();
        inst.setInstanceId(instId);
        inst.setInstanceName(instName);
        inst.setInstanceType(instType);
        inst.setProjectId(OpenStackCommonUtil.getIdFromUuid(proId));
        inst.setRegionId(OpenStackCommonUtil.getIdFromUuid(regionId));
        return inst;
    }

    protected void checkLicense(ProtectGroup protectGroup) {
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseControl.checkEnablePgCount(protectGroup);
    }

    protected boolean checkVmIllegalStatus(OpenStackVM vm) {
        Map metadata = vm.getMetadata();
        if (VerifyUtil.isEmpty((Map)metadata)) {
            logger.debug((Object)("vm metadata is null.vm name:" + vm.getName()));
            return false;
        }
        String softDelete = (String)metadata.get("__softdelete");
        if (!VerifyUtil.isEmpty((String)softDelete) && "true".equals(softDelete)) {
            logger.debug((Object)("vm is softDelete, vm name:" + vm.getName() + ",vm metadata=" + metadata));
            return true;
        }
        String expiryDate = (String)metadata.get("server_expiry");
        if (!VerifyUtil.isEmpty((String)expiryDate) && this.compareDate(expiryDate)) {
            logger.debug((Object)("vm is expiry,vm name:" + vm.getName() + ", Date:" + expiryDate));
            return true;
        }
        return false;
    }

    private boolean compareDate(String expiryDate) {
        if ("0".equals(expiryDate)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        long time2 = 0L;
        try {
            time2 = simpleDateFormat.parse(expiryDate).getTime();
        }
        catch (ParseException e) {
            logger.debug((Object)("expiryDate is illegal (" + expiryDate + "):" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return time2 <= System.currentTimeMillis() && 0L != time2;
    }

    private Object getFromFuture(Future future) {
        try {
            Object obj = future.get();
            return obj;
        }
        catch (InterruptedException e1) {
            logger.error((Object)"catch InterruptedException, getFromFuture error:", (Throwable)e1);
            ExceptionUtil.rethrowException((Throwable)e1, (String)"", (long)-1L, null, (Log)logger);
        }
        catch (ExecutionException e2) {
            logger.error((Object)"catch ExecutionException, getFromFuture error:", (Throwable)e2);
            ExceptionUtil.rethrowException((Throwable)e2, (String)"", (long)-1L, null, (Log)logger);
        }
        return null;
    }

    public static void getProtectGroupDrVolType(String serviceType, String regionUuid, Set<ProtectObject> poList, String azIdentity, List<OpenStackVolTypeMapping> volTypeList, ProtectGroup pg) {
        ArrayList<Map<String, Object>> maps = new ArrayList();
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(serviceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceType)) {
            maps = OpenStackCommonUtil.getVHACSDRMapping(OpenStackCommonUtil.getIdFromUuid(regionUuid), (IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class), ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)serviceType));
        }
        for (ProtectObject po : poList) {
            String volConfigStr = (String)po.getProps().get("volumeConfig");
            JSONArray array = JSONArray.fromObject((Object)volConfigStr);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = array.getJSONObject(i);
                String drVolType = json.containsKey((Object)"drVolumeType") ? json.getString("drVolumeType") : "";
                String srVolType = json.getString("volumeType");
                if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(serviceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceType)) {
                    OpenStackCommonUtil.getVolumeTypeForVhaCsdr(maps, azIdentity, json, po, serviceType);
                    continue;
                }
                String string = drVolType = VerifyUtil.isEmpty((String)drVolType) ? AbstractServiceInstanceCreateImpl.findDrVolType(srVolType, volTypeList, pg) : drVolType;
                if (VerifyUtil.isEmpty((String)drVolType)) {
                    logger.error((Object)(srVolType + " doesn't have the corresponding drVolType"));
                    throw new LegoCheckedException(1073948122L, new String[]{srVolType});
                }
                json.put((Object)"drVolumeType", (Object)drVolType);
                logger.info((Object)("vm(" + po.getMoUuid() + ") drVolType is " + drVolType));
            }
            po.getProps().put("volumeConfig", array.toString());
        }
    }

    protected void checkInstanceNameIsRepeat(ProtectGroup pg) {
        CreateProtectGroupRefineService instanceService = CreateProtectGroupRefineService.getInstance();
        boolean notRepeatName = instanceService.checkGroupName(null, pg.getName());
        if (!notRepeatName) {
            logger.error((Object)"Instance name repeated! instanceName: %s.", new Object[]{pg.getName()});
            throw new LegoCheckedException(1073947717L);
        }
    }

    private boolean checkProdAndDrVMHasSameBridge(OpenStackVM prodOpenStackVM, OpenStackVM drOpenStackVM) {
        boolean prodVMNotConfig = OpenStackCommonUtil.checkVmNotConfigBridge(prodOpenStackVM);
        boolean drVMNotconfig = OpenStackCommonUtil.checkVmNotConfigBridge(drOpenStackVM);
        boolean configBridge = prodVMNotConfig && drVMNotconfig;
        boolean prodExistAndPhNotExist = !VerifyUtil.isEmpty((String)((String)prodOpenStackVM.getMetadata().get("cascaded.instance_extrainfo"))) && !VerifyUtil.isEmpty((String)((String)drOpenStackVM.getMetadata().get("cascaded.instance_extrainfo"))) && ((String)prodOpenStackVM.getMetadata().get("cascaded.instance_extrainfo")).contains("pcibridge:2") && ((String)drOpenStackVM.getMetadata().get("cascaded.instance_extrainfo")).contains("pcibridge:2");
        return configBridge || prodExistAndPhNotExist;
    }

    private static class SystemCapabilityCallable
    implements Callable<List<SystemCapability>> {
        private INovaManager novaMgr;
        private String regionUuid;
        private String tokenId;

        public SystemCapabilityCallable(INovaManager novaMgr, String regionUuid, String tokenId) {
            this.novaMgr = novaMgr;
            this.regionUuid = regionUuid;
            this.tokenId = tokenId;
        }

        @Override
        public List<SystemCapability> call() {
            return this.novaMgr.getSIAInfoByOsType("guest_os_arm", this.regionUuid, this.tokenId);
        }
    }

    private static class FlavorCallable
    implements Callable<List<VMFlavor>> {
        private INovaManager novaMgr;
        private String regionUuid;
        private String projectUuid;
        private String tokenId;

        public FlavorCallable(INovaManager novaMgr, String regionUuid, String tokenId, String projectUuid) {
            this.novaMgr = novaMgr;
            this.regionUuid = regionUuid;
            this.tokenId = tokenId;
            this.projectUuid = projectUuid;
        }

        @Override
        public List<VMFlavor> call() {
            return this.novaMgr.getVmFlavors(this.regionUuid, this.tokenId, this.projectUuid);
        }
    }

    private static class VisorCallable
    implements Callable<List<HypervisorInfo>> {
        private INovaManager novaMgr;
        private String regionUuid;
        private String projectUuid;
        private String tokenId;

        public VisorCallable(INovaManager novaMgr, String regionUuid, String projectUuid, String tokenId) {
            this.novaMgr = novaMgr;
            this.regionUuid = regionUuid;
            this.projectUuid = projectUuid;
            this.tokenId = tokenId;
        }

        @Override
        public List<HypervisorInfo> call() {
            return this.novaMgr.getAllHypervisorInfo(this.regionUuid, this.projectUuid, this.tokenId);
        }
    }

    private static class ImageCallable
    implements Callable<List<OpenStackImage>> {
        private IImageManager imageMgr;
        private String regionUuid;
        private String tokenId;

        public ImageCallable(IImageManager imageMgr, String regionUuid, String tokenId) {
            this.imageMgr = imageMgr;
            this.regionUuid = regionUuid;
            this.tokenId = tokenId;
        }

        @Override
        public List<OpenStackImage> call() {
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63() && !LegoConfig.getInstance().getBoolean("is.query.images", Boolean.valueOf(true)).booleanValue()) {
                return new ArrayList<OpenStackImage>();
            }
            return this.imageMgr.getImages(this.regionUuid, this.tokenId);
        }
    }

    private static class VolumeCallable
    implements Callable<List<OpenStackVolume>> {
        private IVolumeService volumeService;
        private String regionUuid;
        private String projectUuid;

        public VolumeCallable(IVolumeService volumeService, String regionUuid, String projectUuid) {
            this.volumeService = volumeService;
            this.regionUuid = regionUuid;
            this.projectUuid = projectUuid;
        }

        @Override
        public List<OpenStackVolume> call() {
            return this.volumeService.getVolumesFromOpenstack(this.regionUuid, this.projectUuid);
        }
    }

    private static class VmCallable
    implements Callable<List<OpenStackVM>> {
        private INovaManager novaMgr;
        private String regionUuid;
        private String tokenId;
        private String projectUuid;

        public VmCallable(INovaManager novaMgr, String regionUuid, String tokenId, String projectUuid) {
            this.novaMgr = novaMgr;
            this.regionUuid = regionUuid;
            this.tokenId = tokenId;
            this.projectUuid = projectUuid;
        }

        @Override
        public List<OpenStackVM> call() {
            return this.novaMgr.getVms(this.regionUuid, this.tokenId, this.projectUuid);
        }
    }
}

