/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceQueryImpl;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.task.ServiceInstRecoveryTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncaughtExceptionHandler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class AutoDisasterRecovery
extends Thread {
    private static final Log LOG = LogFactory.getInstance(AutoDisasterRecovery.class);
    private static final int CONCURRENT_NUM = 10;
    private static AutoDisasterRecovery notify = new AutoDisasterRecovery();
    private static ExecutorService threadPool = Executors.newFixedThreadPool(10);
    private ConcurrentLinkedQueue<InstanceInfoBO> sortedQueue = new ConcurrentLinkedQueue();

    private AutoDisasterRecovery() {
    }

    public static AutoDisasterRecovery getInstance() {
        return notify;
    }

    public synchronized void addToSortedStack(List<InstanceInfoBO> sortedList) {
        for (InstanceInfoBO instance : sortedList) {
            boolean matched = this.sortedQueue.stream().anyMatch(item -> Objects.equals(item.getId(), instance.getId()));
            if (matched) continue;
            this.sortedQueue.add(instance);
        }
    }

    public ConcurrentLinkedQueue<InstanceInfoBO> getSortedQueue() {
        return this.sortedQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleareSortedQueue() {
        AutoDisasterRecovery autoDisasterRecovery = this;
        synchronized (autoDisasterRecovery) {
            ArrayList<InstanceInfoBO> faildList = null;
            for (InstanceInfoBO bo : this.sortedQueue) {
                if (!ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_FAILED.getValue().equals(bo.getStatus())) continue;
                if (null == faildList) {
                    faildList = new ArrayList<InstanceInfoBO>();
                }
                faildList.add(bo);
            }
            if (null != faildList) {
                this.sortedQueue.retainAll(faildList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
        Thread.currentThread().setName("AutoDisater Thread");
        Integer startPriority = null;
        ArrayList<CompletableFuture<Map.Entry<InstanceInfoBO, Boolean>>> futures = new ArrayList<CompletableFuture<Map.Entry<InstanceInfoBO, Boolean>>>();
        AtomicBoolean working = new AtomicBoolean();
        while (true) {
            InstanceInfoBO instBo;
            AutoDisasterRecovery autoDisasterRecovery = this;
            synchronized (autoDisasterRecovery) {
                instBo = this.sortedQueue.peek();
            }
            if (instBo == null) {
                if (working.compareAndSet(true, false)) {
                    this.wait(futures);
                    LOG.info((Object)"Priority %s transaction have been processed", new Object[]{String.valueOf(startPriority)});
                    startPriority = null;
                }
                CommonUtil.sleep((long)5000L);
                continue;
            }
            working.compareAndSet(false, true);
            if (!Objects.equals(startPriority, instBo.getStartPriority())) {
                this.wait(futures);
                if (startPriority != null) {
                    LOG.info((Object)"Priority %s transaction have been processed", new Object[]{String.valueOf(startPriority)});
                }
                startPriority = instBo.getStartPriority();
                LOG.info((Object)"Priority %s transaction will be processed", new Object[]{String.valueOf(startPriority)});
            }
            if (!this.checkServiceInst(instBo)) {
                autoDisasterRecovery = this;
                synchronized (autoDisasterRecovery) {
                    this.sortedQueue.poll();
                }
            }
            this.autoDisasterRecovery(instBo, futures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoDisasterRecovery(InstanceInfoBO instBo, List<CompletableFuture<Map.Entry<InstanceInfoBO, Boolean>>> futures) {
        Future<?> future;
        LOG.info((Object)"AutoDisasterRecovery task is begin: %s", new Object[]{instBo.getName()});
        ServiceInstRecoveryTask task = new ServiceInstRecoveryTask(instBo);
        if (!ServiceInstanceHelper.getInstance().getLock(instBo.getId())) {
            LOG.error((Object)"AutoDisasterRecovery task get lock failed.  Instance name:%s, id:%s", new Object[]{instBo.getName(), instBo.getId()});
            return;
        }
        try {
            ServiceInstanceHelper.getInstance().changeStatus(instBo.getId(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_RUNNING);
            AutoDisasterRecovery autoDisasterRecovery = this;
            synchronized (autoDisasterRecovery) {
                this.sortedQueue.remove();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Change status error: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            ServiceInstanceHelper.getInstance().releaseLock(instBo.getId());
            return;
        }
        JSONObject detail = this.getInstanceAbstractInfo(instBo);
        try {
            future = threadPool.submit(task);
            futures.add(task.getFuture());
            LOG.info((Object)"Submit recovery task success. detail: %s", new Object[]{detail});
        }
        catch (RejectedExecutionException e) {
            future = null;
            LOG.error((Object)"Submit recovery task error. detail: %s, error: %s", new Object[]{detail, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        if (future == null) {
            LOG.error((Object)"Future is null");
        }
    }

    private JSONObject getInstanceAbstractInfo(InstanceInfoBO instBo) {
        return JSONObject.fromObject((Object)instBo, Arrays.asList("id", "name", "startPriority", "recoverPlanId"));
    }

    private void wait(List<CompletableFuture<Map.Entry<InstanceInfoBO, Boolean>>> futures) {
        for (CompletableFuture<Map.Entry<InstanceInfoBO, Boolean>> future : futures) {
            try {
                Map.Entry<InstanceInfoBO, Boolean> detail = future.get();
                JSONObject json = this.getInstanceAbstractInfo(detail.getKey());
                Boolean status = detail.getValue();
                if (status != null) {
                    LOG.info((Object)"Recovery task %s. %s", new Object[]{detail.getValue() != false ? "success" : "failed", json});
                    continue;
                }
                LOG.info((Object)"Instance %s is not recovery", new Object[]{json});
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error((Object)"Get future result failed", (Throwable)e);
            }
        }
        futures.clear();
    }

    private boolean checkServiceInst(InstanceInfoBO instBo) {
        String instanceId = instBo.getId();
        ServiceInstance serviceInstance = AbstractServiceInstanceQueryImpl.queryServiceInstance(instanceId);
        if (!serviceInstance.getStatus().equals(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue()) && !serviceInstance.getStatus().equals(ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_FAILED.getValue())) {
            LOG.debug((Object)"Instance is not normal or not err-failover,cant failover,instance status:%s,instance name:%s", new Object[]{serviceInstance.getStatus(), serviceInstance.getName()});
            return false;
        }
        try {
            ServiceInstance instance = new ServiceInstance();
            instance.setProtectGroupId(instBo.getProtectGroupId());
            instance.setName(instBo.getName());
            instance.setType(instBo.getType());
            instance.setStatus(instBo.getStatus());
            instance.setProtectType(instBo.getProtectType());
            ServiceInstanceHelper.getInstance().checkServiceInstPoInfo(instance);
            ServiceInstanceHelper.getInstance().checkServiceInstAutoRecovery(instance);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Check checkServiceInstPoInfo error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            ServiceInstanceHelper.getInstance().releaseLock(instBo.getId());
            AlarmReporter.sendNoRepeatAlarm((long)52625470L, (String)instBo.getProtectGroupId(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{instBo.getId(), instBo.getName()});
            return false;
        }
        AlarmReporter.restoreAlarm((long)52625470L, (String[])new String[]{instBo.getId()});
        return true;
    }
}

