/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.TimerTask;

public class CheckLicenseTimeoutTask
extends TimerTask {
    private static final Log LOG = LogFactory.getInstance(CheckLicenseTimeoutTask.class);

    @Override
    public void run() {
        try {
            FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
            if (VerifyUtil.isEmpty((Object)openstack)) {
                LOG.error((Object)"Openstack is empty.");
                return;
            }
            ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
            if (!licenseControl.isLicenseLegal()) {
                LOG.error((Object)"License 90 day trial period has expired.");
                AlarmReporter.sendNoRepeatAlarm((long)52625481L, null, (String)FaultEnum.AlarmResourceType.UNDEFINED.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{"FLAG_SYSTEM_PROBATION_TIMEOUT_ALARM"});
            } else {
                AlarmReporter.restoreAlarm((long)52625481L, (String[])new String[]{"FLAG_SYSTEM_PROBATION_TIMEOUT_ALARM"});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Start CheckLicenseTimeoutTask fail. {}", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }
}

