/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICeiloMeterManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.msg.MeterInfo;
import com.huawei.ism.drm.openstack.serviceinstance.MeterServiceImpl;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EvsMeterServiceImpl
extends MeterServiceImpl {
    private static final Log LOG = LogFactory.getInstance(EvsMeterServiceImpl.class);

    @Override
    protected void reportProjectInfo(String regionId, Map<String, List<ServiceInstance>> projectMap, String openstackUuid, Map<String, ProtectGroup> pgMap) {
        ICeiloMeterManager celio = ManagerFactory.getInstance().getMeterManager(openstackUuid);
        for (String proId : projectMap.keySet()) {
            HashMap<String, List<MeterInfo>> meterInfoMap = new HashMap<String, List<MeterInfo>>();
            for (ServiceInstance instanceDBInfo : projectMap.get(proId)) {
                ProtectGroup pg = pgMap.get(instanceDBInfo.getProtectGroupId());
                Map<String, Float> instances = this.buildInstanceInfo(pg);
                this.updateMeterInfoMap(meterInfoMap, instances, instanceDBInfo.getId(), instanceDBInfo.getName(), proId);
            }
            boolean isRegister = this.checkRegister(regionId);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(OpenStackBasicUtil.getObjectUuid(openstackUuid, regionId), OpenStackBasicUtil.getObjectUuid(openstackUuid, proId));
            for (String meterName : meterInfoMap.keySet()) {
                try {
                    AsyncTaskResponse response = celio.reportMeterInfo((List)meterInfoMap.get(meterName), meterName, regionId, tokenId);
                    this.handleRequestResult(response.isSuccess(), isRegister);
                }
                catch (LegoCheckedException e) {
                    this.handleRequestResult(false, isRegister);
                }
            }
        }
    }

    private Map<String, Float> buildInstanceInfo(ProtectGroup pg) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            LOG.debug((Object)"The protectGroup is not exist.");
            return Collections.emptyMap();
        }
        Map<String, Object> meterInfoMap = this.calculateMeterInfos(pg);
        float volumesSize = Float.parseFloat(String.valueOf(meterInfoMap.get("csha.vol.size")));
        HashMap<String, Float> instances = new HashMap<String, Float>();
        instances.put("csdr.instance.num", Float.valueOf(1.0f));
        instances.put("csdr.vol.size", Float.valueOf(volumesSize));
        return instances;
    }
}

