/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaVolumeStatisticBo;
import com.huawei.ism.drm.openstack.sdk.bo.ResourceLocation;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceQueryImpl;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.openstack.tools.QuotaBuildUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CollectionUtils;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Service(name="com.huawei.ism.drm.openstack.sdk.service.EvsQuotaServiceImpl", desc="")
public class EvsQuotaServiceImpl
extends BaseService {
    private static final Log LOGGER = LogFactory.getInstance(EvsQuotaServiceImpl.class);

    public List<QuotaResourcesBo> calculateCreateInstanceQuota(String projectId, ProtectGroup pg) {
        if (VerifyUtil.isEmpty((String)projectId) || pg == null) {
            LOGGER.error((Object)"Param is null, calculateCreateInstanceQuota failed.");
            throw new LegoCheckedException(1073947393L);
        }
        String type = (String)pg.getProps().get("serviceInstanceType");
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        List<String> volIds = pg.getPolist().stream().map(protectObject -> OpenStackBasicUtil.getIdFromUuid(protectObject.getMoUuid())).collect(Collectors.toList());
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager cinderManager = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        Map<String, OpenStackVolume> volMap = cinderManager.queryOpenStackVolumes(regionUuid, projUuid, volIds);
        List<QuotaResourcesBo> instanceQuota = this.countAddEvsSourceQuota(pg.getPolist(), volMap, type, true, pg);
        return this.addEvsVolQuota(pg, instanceQuota);
    }

    private List<QuotaResourcesBo> countAddEvsSourceQuota(Set<ProtectObject> protectObjectSet, Map<String, OpenStackVolume> volMap, String type, boolean isCreateIns, ProtectGroup pg) {
        HashMap<String, QuotaVolumeStatisticBo> quotaVolumeStatisticBoMap = new HashMap<String, QuotaVolumeStatisticBo>();
        for (ProtectObject po : protectObjectSet) {
            if (po.getProtectGroup() == null) {
                po.setProtectGroup(pg);
            }
            JSONArray vols = JSONArray.fromObject(po.getProps().get("volumeConfig"));
            for (Object vol : vols) {
                JSONObject volInfo = JSONObject.fromObject(vol);
                String volId = OpenStackCommonUtil.getIdFromUuid(volInfo.getString("volumeId", null));
                String drVolumeType = volInfo.getString("drVolumeType", null);
                QuotaBuildUtil.updateQuotaVolumeStatisticBoMap(quotaVolumeStatisticBoMap, volMap, volId, drVolumeType, "");
            }
        }
        return QuotaBuildUtil.convertStatisticBoMapToQuotaList(quotaVolumeStatisticBoMap, type, isCreateIns);
    }

    private List<QuotaResourcesBo> addEvsVolQuota(ProtectGroup protectGroup, List<QuotaResourcesBo> instanceQuota) {
        Set poList = protectGroup.getPolist();
        List volIds = poList.stream().map(protectObject -> OpenStackBasicUtil.getIdFromUuid(protectObject.getMoUuid())).collect(Collectors.toList());
        String regionUuid = protectGroup.getProperty("regionId");
        String projectUuid = protectGroup.getProperty("projectId");
        Map volumeInfoMap = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).queryVolumeInfosByUuid(regionUuid, projectUuid, volIds);
        String drRegionUuid = protectGroup.getProperty("drRegionId");
        for (ProtectObject protectObject2 : poList) {
            String drVolumeId = protectObject2.getProperty("drVolumeId");
            if (!VerifyUtil.isEmpty((String)drVolumeId)) continue;
            String volumeId = OpenStackBasicUtil.getIdFromUuid(protectObject2.getMoUuid());
            VolumeInfo volumeInfo = (VolumeInfo)volumeInfoMap.get(volumeId);
            if (volumeInfo == null) {
                LOGGER.error((Object)"The prod volume is not exist, volumeId: %s.", new Object[]{volumeId});
                throw new LegoCheckedException(2117645L);
            }
            QuotaVolumeStatisticBo statisticBo = this.buildStaticBo(protectObject2, drRegionUuid, volumeInfo.getSize());
            instanceQuota.add(this.buildQuotaResourcesBo(statisticBo, "gigabytes", volumeInfo.getSize()));
            instanceQuota.add(this.buildQuotaResourcesBo(statisticBo, "volumes", 1.0f));
        }
        return instanceQuota;
    }

    private QuotaVolumeStatisticBo buildStaticBo(ProtectObject po, String regionId, int volSize) {
        QuotaVolumeStatisticBo quotaResource = new QuotaVolumeStatisticBo();
        JSONArray volConfigs = JSONArray.fromObject((Object)po.getProperty("volumeConfig"));
        if (volConfigs.isEmpty() || volConfigs.get(0) == null) {
            LOGGER.error((Object)"The protect object is missing volume config data, poId: %s.", new Object[]{po.getUuid()});
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject volConfig = volConfigs.getJSONObject(0);
        quotaResource.setVolumeType(volConfig.getString("volumeType"));
        quotaResource.setDrVolumeType(volConfig.getString("drVolumeType"));
        quotaResource.setRegionId(regionId);
        quotaResource.setVolumesSize((float)volSize);
        quotaResource.setVolumesNumber(1.0f);
        return quotaResource;
    }

    public Optional<String> calculateDeleteInstanceQuota(String instanceId) {
        VerifyUtil.checkObject((Object)instanceId);
        try {
            ServiceInstance instance = AbstractServiceInstanceQueryImpl.queryServiceInstance(instanceId);
            VerifyUtil.checkObject((Object)instance);
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
            JSONArray quotaArray = this.calculateDeletePosQuota(pg, pg.getPolist(), true);
            LOGGER.info((Object)"Delete instance quota message: %s.", new Object[]{quotaArray.toString()});
            return Optional.of(quotaArray.toString());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Calculate Delete Instance fail, instanceId = %s, errorMsg: %s.", new Object[]{instanceId, ExceptionUtil.getErrorMessage((Throwable)e)});
            return Optional.empty();
        }
    }

    public JSONArray calculateDeletePosQuota(ProtectGroup pg, Set<ProtectObject> deletePoList, boolean isDeletePg) {
        VerifyUtil.checkObject((Object)pg);
        List<QuotaResourcesBo> quotaList = new ArrayList<QuotaResourcesBo>();
        List<Object> evsQuotaList = new ArrayList<QuotaResourcesBo>();
        if (!VerifyUtil.isEmpty(deletePoList)) {
            String regionUuid = pg.getProperty("regionId");
            String projectUuid = pg.getProperty("projectId");
            List deleteIds = deletePoList.stream().map(ProtectObject::getMoUuid).map(OpenStackBasicUtil::getIdFromUuid).collect(Collectors.toList());
            Map<String, OpenStackVolume> volumeMap = ManagerFactory.getInstance().getCinderManager(OpenStackCommonUtil.getOpenstack().getUuid()).queryOpenStackVolumes(regionUuid, projectUuid, new ArrayList<String>(deleteIds));
            String type = pg.getProperty("serviceInstanceType");
            quotaList = QuotaBuildUtil.countDelSourceQuota(deletePoList, volumeMap, type, isDeletePg);
            Set<ProtectObject> deleteVolumePoList = deletePoList.stream().filter(po -> Boolean.parseBoolean(po.getProperty("SHOULD_DELETE_DR_VOLUME"))).collect(Collectors.toSet());
            if (VerifyUtil.isEmpty(deleteVolumePoList)) {
                LOGGER.debug((Object)"No DR volume can be deleted.");
                evsQuotaList = Collections.emptyList();
            } else if (deleteVolumePoList.size() == deletePoList.size()) {
                LOGGER.debug((Object)"All DR volumes in protected objects cannot be deleted.");
                evsQuotaList = quotaList;
            } else {
                LOGGER.debug((Object)"Some DR volumes in protected objects cannot be deleted.");
                evsQuotaList = QuotaBuildUtil.countDelSourceQuota(deleteVolumePoList, volumeMap, type, isDeletePg);
            }
        }
        JSONArray quotaArray = new JSONArray();
        ResourceLocation prodResourceLocation = this.getProdResourceLocationFromPg(pg);
        ResourceLocation drResourceLocation = this.getDrResourceLocationFromPg(pg);
        String type = pg.getProperty("serviceInstanceType");
        quotaArray.addAll((Collection)this.constructQuotaResult(type, prodResourceLocation, drResourceLocation, quotaList));
        quotaArray.addAll((Collection)QuotaBuildUtil.constructEvsQuota(drResourceLocation, evsQuotaList, false));
        return quotaArray;
    }

    private QuotaResourcesBo buildQuotaResourcesBo(QuotaVolumeStatisticBo statisticBo, String type, float quota) {
        QuotaResourcesBo quotaResourcesBo = new QuotaResourcesBo();
        quotaResourcesBo.setStatisticBo(statisticBo);
        quotaResourcesBo.setType(type);
        quotaResourcesBo.setQuota(quota);
        return quotaResourcesBo;
    }

    private Set<ProtectObject> getDeleteVolumePoList(ProtectGroup pg) {
        if (!Boolean.parseBoolean(pg.getProperty("SHOULD_DELETE_DR_VOLUME"))) {
            return Collections.emptySet();
        }
        return pg.getPolist().stream().filter(po -> Boolean.parseBoolean(po.getProperty("SHOULD_DELETE_DR_VOLUME"))).collect(Collectors.toSet());
    }

    private Map<String, OpenStackVolume> getAllProdVolumes(ProtectGroup pg) {
        ICinderManager cinderManager = ManagerFactory.getInstance().getCinderManager(OpenStackCommonUtil.getOpenstack().getUuid());
        List<String> volIds = pg.getPolist().stream().map(protectObject -> OpenStackBasicUtil.getIdFromUuid(protectObject.getMoUuid())).collect(Collectors.toList());
        String regionUuid = pg.getProperty("regionId");
        String projectUuid = pg.getProperty("projectId");
        return cinderManager.queryOpenStackVolumes(regionUuid, projectUuid, volIds);
    }

    private ResourceLocation getProdResourceLocationFromPg(ProtectGroup pg) {
        String regionUuid = pg.getProperty("regionId");
        String projectUuid = pg.getProperty("projectId");
        String az = pg.getProperty("zoneName");
        return new ResourceLocation(regionUuid, projectUuid, az);
    }

    private ResourceLocation getDrResourceLocationFromPg(ProtectGroup pg) {
        String drRegionUuid = pg.getProperty("drRegionId");
        String drProjectUuid = pg.getProperty("drProjectId");
        String drAz = pg.getProperty("drZoneName");
        return new ResourceLocation(drRegionUuid, drProjectUuid, drAz);
    }

    private JSONArray constructQuotaResult(String type, ResourceLocation resource, ResourceLocation drResource, List<QuotaResourcesBo> list) {
        JSONArray quotas = new JSONArray();
        ServiceInstaceEnumDefine.ServiceInstanceTypeE instanceType = ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)type);
        if (instanceType == null) {
            return quotas;
        }
        JSONArray quotaResourceList = new JSONArray();
        String prefix = instanceType.getFrontValue() + ".";
        for (QuotaResourcesBo bo : list) {
            JSONObject quotaResource = new JSONObject();
            String resourceType = bo.getType();
            if (resourceType == null || !resourceType.startsWith(prefix)) continue;
            quotaResource.put((Object)"resource", (Object)bo.getType());
            quotaResource.put((Object)"used", (Object)Float.valueOf(0.0f - bo.getQuota()));
            quotaResourceList.add((Object)quotaResource);
        }
        JSONArray usageList = QuotaBuildUtil.buildUsagesList(quotaResourceList, ServiceInstaceEnumDefine.ServiceInstanceTypeE.getServiceIdFromServiceType((String)type), null);
        quotas.add((Object)QuotaBuildUtil.buildQuotaJson(resource, usageList));
        quotas.add((Object)QuotaBuildUtil.buildQuotaJson(drResource, usageList));
        return quotas;
    }

    public List<QuotaResourcesBo> calculateAddVolumesQuota(String instanceId, Set<VolumeBO> addVolumes) {
        ServiceInstance instance = this.getServiceInstance(instanceId, addVolumes);
        String projectId = instance.getProjectId();
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String regionUuid = (String)pg.getProps().get("regionId");
        String openstackUuid = OpenStackCommonUtil.getOpenstack().getUuid();
        String projUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
        ICinderManager cinderManager = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        List volIds = CollectionUtils.mapToList(addVolumes, VolumeBO::getVolumeId);
        Map<String, OpenStackVolume> volMap = cinderManager.queryOpenStackVolumes(regionUuid, projUuid, volIds);
        String type = (String)pg.getProps().get("serviceInstanceType");
        HashMap<String, QuotaVolumeStatisticBo> quotaVolumeStatisticBoMap = new HashMap<String, QuotaVolumeStatisticBo>();
        for (VolumeBO volumeInfo : addVolumes) {
            String volumeUuid = volumeInfo.getVolumeId();
            String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
            QuotaBuildUtil.updateQuotaVolumeStatisticBoMap(quotaVolumeStatisticBoMap, volMap, volumeId, volumeInfo.getDrVolumeType(), null);
        }
        List<QuotaResourcesBo> quotaList = QuotaBuildUtil.convertStatisticBoMapToQuotaList(quotaVolumeStatisticBoMap, type, false);
        quotaList.addAll(this.calculateAddVolumesEvsQuota(volMap, addVolumes));
        return quotaList;
    }

    private List<QuotaResourcesBo> calculateAddVolumesEvsQuota(Map<String, OpenStackVolume> volMap, Set<VolumeBO> addVolumes) {
        ArrayList<QuotaResourcesBo> quotaList = new ArrayList<QuotaResourcesBo>();
        for (VolumeBO protectedVolume : addVolumes) {
            String drVolumeUuid = protectedVolume.getDrVolumeId();
            if (!VerifyUtil.isEmpty((String)drVolumeUuid)) {
                LOGGER.debug((Object)"The DR volume(%s) is not automatically created, the EVS quota does not need to be collected.", new Object[]{drVolumeUuid});
                continue;
            }
            OpenStackVolume prodVolume = volMap.get(protectedVolume.getVolumeId());
            if (prodVolume == null) {
                LOGGER.error((Object)"The prod volume is not exist, volumeId: %s.", new Object[]{prodVolume});
                throw new LegoCheckedException(2117645L);
            }
            QuotaVolumeStatisticBo statisticBo = new QuotaVolumeStatisticBo();
            statisticBo.setVolumeType(protectedVolume.getVolumeType());
            statisticBo.setDrVolumeType(protectedVolume.getDrVolumeType());
            statisticBo.setRegionId(prodVolume.getRegionUuid());
            statisticBo.setVolumesSize((float)prodVolume.getSize().intValue());
            statisticBo.setVolumesNumber(1.0f);
            quotaList.add(this.buildQuotaResourcesBo(statisticBo, "gigabytes", prodVolume.getSize().intValue()));
            quotaList.add(this.buildQuotaResourcesBo(statisticBo, "volumes", 1.0f));
        }
        return quotaList;
    }

    private ServiceInstance getServiceInstance(String instanceId, Set<VolumeBO> addVolumes) {
        if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty(addVolumes)) {
            LOGGER.error((Object)"Param is null , calculateQuota failed");
            throw new LegoCheckedException(1073947393L);
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (VerifyUtil.isEmpty((Object)instance)) {
            LOGGER.error((Object)"Instance is null , calculateQuota failed, instance id: %s.", new Object[]{instanceId});
            throw new LegoCheckedException(1073947393L);
        }
        return instance;
    }
}

