/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.ServiceInstanceBackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.bo.CheckVolumesProtectableRequest;
import com.huawei.ism.drm.openstack.sdk.bo.CheckVolumesProtectableResult;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.QueryVolumeRequestBO;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.ResourceLocation;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeErrorItem;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.model.SameDevInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumePageInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeProtectableInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeProtectablePageInfo;
import com.huawei.ism.drm.openstack.sdk.service.IEvsServiceInstanceService;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.EvsQuotaServiceImpl;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceServiceImpl;
import com.huawei.ism.drm.openstack.serviceinstance.checker.VolumeProtectableChecker;
import com.huawei.ism.drm.openstack.serviceinstance.task.CreateVolumeInstanceTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.EvDeleteVolumesBackTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.EvsAddVolumesBackTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.EvsDeleteInstanceTask;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CollectionUtils;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.BeanUtils;

@Service(name="com.huawei.ism.drm.openstack.sdk.service.IEvsServiceInstanceService", desc="", interfaceClass=IEvsServiceInstanceService.class)
public class EvsServiceInstanceServiceImpl
extends ServiceInstanceServiceImpl
implements IEvsServiceInstanceService {
    private static final Log logger = LogFactory.getInstance(EvsServiceInstanceServiceImpl.class);
    private static final String PG_MAX_VOLUME_CONFIG = "pg.volume.max";
    private CinderManager cinderManager = new CinderManager();

    public VolumeProtectablePageInfo queryProtectableVolumes(QueryVolumeRequestBO queryBo) {
        VolumePageInfo volumePageInfo = this.queryVolumePage(queryBo);
        VolumeProtectableChecker checker = this.buildVolumeChecker(queryBo, null);
        ArrayList<VolumeProtectableInfo> volumeProtectables = new ArrayList<VolumeProtectableInfo>();
        for (VolumeInfo volume : volumePageInfo.getVolumes()) {
            VolumeProtectableInfo protectableInfo = new VolumeProtectableInfo();
            BeanUtils.copyProperties((Object)volume, (Object)protectableInfo);
            List<VolumeErrorItem> volumeErrors = checker.checkSingleVolume(volume, false);
            if (!VerifyUtil.isEmpty(volumeErrors)) {
                VolumeErrorItem volumeError = volumeErrors.get(0);
                logger.debug((Object)"Check single volume fail, error code: %s.", new Object[]{String.valueOf(volumeError.getErrorCode())});
                protectableInfo.setErrorCode(volumeError.getErrorCode());
                protectableInfo.setErrorParams(volumeError.getErrorParams());
            }
            volumeProtectables.add(protectableInfo);
        }
        String openStackUuid = this.getOpenstack().getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, queryBo.getRegionId());
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, queryBo.getProjectId());
        this.addStorageSnToVolume(volumeProtectables, regionUuid, projectUuid);
        VolumeProtectablePageInfo protectablePageInfo = new VolumeProtectablePageInfo();
        protectablePageInfo.setTotalCount(volumePageInfo.getTotalCount());
        protectablePageInfo.setVolumes(volumeProtectables);
        return protectablePageInfo;
    }

    private VolumePageInfo queryVolumePage(QueryVolumeRequestBO queryBo) {
        String filterId = queryBo.getFilterId();
        String openStackUuid = this.getOpenstack().getUuid();
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, queryBo.getProjectId());
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, queryBo.getRegionId());
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        if (!VerifyUtil.isEmpty((String)filterId)) {
            logger.debug((Object)"The filterId is empty, query volume page by id.");
            return this.pageQueryVolumeById(queryBo);
        }
        logger.debug((Object)"The filterId is not empty, query volume page by condition.");
        return this.pageQueryVolumesByCondition(regionUuid, tokenId, projectUuid, queryBo);
    }

    private void addStorageSnToVolume(List<VolumeProtectableInfo> volumeProtectables, String regionUuid, String projectUuid) {
        if (volumeProtectables.isEmpty()) {
            logger.debug((Object)"The volumeProtectables is empty, no need to add storageSn info.");
            return;
        }
        Set volumeTypes = volumeProtectables.stream().map(VolumeProtectableInfo::getVolumeType).collect(Collectors.toSet());
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        Map openVolumeTypeMap = volumeService.getVolumeTypesByName(volumeTypes, regionUuid, projectUuid).stream().collect(Collectors.toMap(ManagedObject::getName, Function.identity()));
        for (VolumeProtectableInfo volumeProtectable : volumeProtectables) {
            JSONObject driverData = JSONObject.fromObject((Object)volumeProtectable.getReplicaDriverData());
            String sn = driverData.getString("sn", driverData.getString("ESN", null));
            if (!VerifyUtil.isEmpty((String)sn)) {
                volumeProtectable.setStorageSn(sn);
                continue;
            }
            OpenStackVolumeType openStackVolumeType = (OpenStackVolumeType)openVolumeTypeMap.get(volumeProtectable.getVolumeType());
            if (openStackVolumeType == null || VerifyUtil.isEmpty((Collection)openStackVolumeType.getStorageSn())) continue;
            volumeProtectable.setStorageSn((String)openStackVolumeType.getStorageSn().iterator().next());
        }
    }

    private VolumePageInfo pageQueryVolumeById(QueryVolumeRequestBO queryBo) {
        boolean isAzMatched;
        VolumeInfo volume = this.queryVolumeByVolumeId(queryBo.getRegionId(), queryBo.getProjectId(), queryBo.getFilterId());
        VolumePageInfo pageInfo = new VolumePageInfo();
        pageInfo.setTotalCount(Integer.valueOf(0));
        if (volume == null || queryBo.getOffset() > 0) {
            return pageInfo;
        }
        String filterName = queryBo.getFilterName();
        boolean isNameMatched = VerifyUtil.isEmpty((String)filterName) || volume.getName().contains(filterName);
        String availableZone = queryBo.getAvailableZone();
        boolean bl = isAzMatched = VerifyUtil.isEmpty((String)availableZone) || availableZone.equals(volume.getAvailabilityZone());
        if (isNameMatched && isAzMatched) {
            pageInfo.setTotalCount(Integer.valueOf(1));
            pageInfo.setVolumes(Collections.singletonList(volume));
        }
        return pageInfo;
    }

    private VolumeInfo queryVolumeByVolumeId(String regionId, String projectId, String volumeId) {
        String openStackUuid = this.getOpenstack().getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, regionId);
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, projectId);
        return ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).queryVolumeInfoByUuid(regionUuid, projectUuid, volumeId);
    }

    private VolumePageInfo pageQueryVolumesByCondition(String regionUuid, String tokenId, String projectUuid, QueryVolumeRequestBO queryBo) {
        String filterName;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Integer limit = queryBo.getLimit();
        paramMap.put("limit", String.valueOf(limit));
        Integer offset = queryBo.getOffset();
        paramMap.put("offset", String.valueOf(offset));
        String availableZone = queryBo.getAvailableZone();
        if (!VerifyUtil.isEmpty((String)availableZone)) {
            paramMap.put("availability_zone", availableZone);
        }
        if (!VerifyUtil.isEmpty((String)(filterName = queryBo.getFilterName()))) {
            paramMap.put("name", filterName);
        }
        return this.cinderManager.queryVolumePage(regionUuid, tokenId, projectUuid, paramMap);
    }

    public VolumeProtectablePageInfo queryDrProtectableVolumes(QueryVolumeRequestBO prodQueryBo, QueryVolumeRequestBO drQueryBo) {
        String regionId = prodQueryBo.getRegionId();
        VolumeProtectableChecker checker = this.buildVolumeChecker(prodQueryBo, drQueryBo);
        VolumeInfo prodVolume = this.queryVolumeByVolumeId(regionId, prodQueryBo.getProjectId(), prodQueryBo.getFilterId());
        List<VolumeErrorItem> prodVolumeErrors = checker.checkSingleVolume(prodVolume, false);
        if (prodVolume == null || !VerifyUtil.isEmpty(prodVolumeErrors)) {
            logger.error((Object)"The prodVolume is not protable, prodVolumeId: %s, errorCode: %s.", new Object[]{prodQueryBo.getFilterId(), prodVolumeErrors.get(0).getErrorCode()});
            throw new LegoCheckedException(1073947393L);
        }
        VolumePageInfo drVolumePageInfo = this.queryVolumePage(drQueryBo);
        ArrayList<VolumeProtectableInfo> volumeProtectables = new ArrayList<VolumeProtectableInfo>();
        for (VolumeInfo drVolume : drVolumePageInfo.getVolumes()) {
            VolumeProtectableInfo volumeProtectable = new VolumeProtectableInfo();
            BeanUtils.copyProperties((Object)drVolume, (Object)volumeProtectable);
            List<VolumeErrorItem> drVolumeErrors = checker.checkVolumePair(prodVolume, drVolume, ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION);
            if (!VerifyUtil.isEmpty(drVolumeErrors)) {
                VolumeErrorItem volumeError = drVolumeErrors.get(0);
                logger.debug((Object)"Check volume pair fail, error code: %s.", new Object[]{String.valueOf(volumeError.getErrorCode())});
                volumeProtectable.setErrorCode(volumeError.getErrorCode());
                volumeProtectable.setErrorParams(volumeError.getErrorParams());
            }
            volumeProtectables.add(volumeProtectable);
        }
        String openStackUuid = this.getOpenstack().getUuid();
        String drRegionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, drQueryBo.getRegionId());
        String drProjectUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, drQueryBo.getProjectId());
        this.addStorageSnToVolume(volumeProtectables, drRegionUuid, drProjectUuid);
        VolumeProtectablePageInfo pageInfo = new VolumeProtectablePageInfo();
        pageInfo.setVolumes(volumeProtectables);
        pageInfo.setTotalCount(drVolumePageInfo.getTotalCount());
        return pageInfo;
    }

    private VolumeProtectableChecker buildVolumeChecker(QueryVolumeRequestBO prodQueryBo, QueryVolumeRequestBO drQueryBo) {
        ResourceLocation prodResourceLocation = this.convertQueryBoToResourceLocation(prodQueryBo);
        ResourceLocation drResourceLocation = null;
        if (drQueryBo != null) {
            drResourceLocation = this.convertQueryBoToResourceLocation(drQueryBo);
        }
        return new VolumeProtectableChecker(ServiceInstaceEnumDefine.ObjectType.EVS, prodResourceLocation, drResourceLocation);
    }

    private ResourceLocation convertQueryBoToResourceLocation(QueryVolumeRequestBO queryBo) {
        String openStackUuid = this.getOpenstack().getUuid();
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, queryBo.getProjectId());
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, queryBo.getRegionId());
        String az = queryBo.getAvailableZone();
        return new ResourceLocation(regionUuid, projectUuid, az);
    }

    @Override
    public List<QuotaResourcesBo> checkCreateInstanceParamAndCalQuota(ProtectGroup pg, String projectId, ExtendParamInfo extendParam) {
        EvsQuotaServiceImpl quotaService = (EvsQuotaServiceImpl)((Object)ServiceLocator.getInstance().getService(EvsQuotaServiceImpl.class));
        return OpenstackCache.run(() -> {
            this.createServiceInstance(pg, extendParam);
            this.updateVolumeConfig(pg);
            return quotaService.calculateCreateInstanceQuota(projectId, pg);
        });
    }

    private void updateVolumeConfig(ProtectGroup pg) {
        String upgradeType = pg.getProps().getOrDefault("AFTER_UPGRADE_TYPE", "");
        String azName = (String)pg.getProps().get("zoneName");
        String drAzName = (String)pg.getProps().get("drZoneName");
        String regionUuid = (String)pg.getProps().get("regionId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String azIdentity = OpenStackVolTypeMapping.getAzIdentity((String)OpenStackCommonUtil.getIdFromUuid(regionUuid), (String)azName, (String)OpenStackCommonUtil.getIdFromUuid(drRegionUuid), (String)drAzName);
        String openstackUuid = OpenStackCommonUtil.getOpenstack().getUuid();
        List volTypeList = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getVolTypeMappingsFromDB(openstackUuid);
        EvsServiceInstanceServiceImpl.getProtectGroupDrVolType(upgradeType, regionUuid, pg.getPolist(), azIdentity, volTypeList, pg);
    }

    public int getPgMaxVolume() {
        return OpenStackCommonUtil.getPgMaxVolume();
    }

    public CheckVolumesProtectableResult checkVolumesProtectable(String projectId, CheckVolumesProtectableRequest request) {
        ArrayList<VolumeErrorItem> errorList = new ArrayList<VolumeErrorItem>();
        if (!this.checkAzMapping(request)) {
            errorList.add(new VolumeErrorItem(Long.valueOf(1073947498L)));
            return new CheckVolumesProtectableResult(errorList);
        }
        Map<VolumeInfo, VolumeInfo> volumePairs = this.buildVolumePairs(projectId, request, errorList);
        String openStackUuid = this.getOpenstack().getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, request.getRegionName());
        String drRegionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, request.getRemoteRegionName());
        ProtectGroup pg = this.convertRequestToPg(request, projectId);
        VolumeProtectableChecker checker = VolumeProtectableChecker.buildVolumeCheckerFromPg(ServiceInstaceEnumDefine.ObjectType.EVS, pg);
        checker.checkProdVolumeFromOneDevs(regionUuid, volumePairs.keySet());
        Set<String> volumeTypes = this.getAutoCreateDrVolTypes(pg, volumePairs);
        checker.getSameDevInfoByVolumes(drRegionUuid, volumePairs.values(), volumeTypes);
        errorList.addAll(checker.checkAllVolumePairs(volumePairs, ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION));
        return new CheckVolumesProtectableResult(errorList);
    }

    private Set<String> getAutoCreateDrVolTypes(ProtectGroup pg, Map<VolumeInfo, VolumeInfo> volumePairs) {
        HashSet srcVolTypes = new HashSet();
        volumePairs.forEach((volumeInfo, drVolumeInfo) -> {
            if (drVolumeInfo == null) {
                srcVolTypes.add(volumeInfo.getVolumeType());
            }
        });
        if (srcVolTypes.isEmpty()) {
            return Collections.emptySet();
        }
        List<OpenStackVolTypeMapping> volTypeList = this.queryVolTypeMapping(pg);
        return CollectionUtils.mapToSet(srcVolTypes, srcVolType -> EvsServiceInstanceServiceImpl.findDrVolType(srcVolType, volTypeList, pg));
    }

    private ProtectGroup convertRequestToPg(CheckVolumesProtectableRequest request, String projectId) {
        ProtectGroup pg = new ProtectGroup();
        String openStackUuid = this.getOpenstack().getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, request.getRegionName());
        pg.setProperty("regionId", (Object)regionUuid);
        String drRegionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, request.getRemoteRegionName());
        pg.setProperty("drRegionId", (Object)drRegionUuid);
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, projectId);
        pg.setProperty("projectId", (Object)projectUuid);
        String drProjectUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, request.getRemoteProjectId());
        pg.setProperty("drProjectId", (Object)drProjectUuid);
        pg.setProperty("zoneName", (Object)request.getAvailableZone());
        pg.setProperty("drZoneName", (Object)request.getRemoteAvailableZone());
        PolicyTemplate template = new PolicyTemplate();
        template.setType(56);
        pg.setTemplate(template);
        return pg;
    }

    public List<QuotaResourcesBo> checkAddVolumeParamAndCalQuota(String projectId, String instanceId, Set<VolumeBO> addVolumes, ExtendParamInfo extendParam) {
        EvsQuotaServiceImpl evsQuotaService = (EvsQuotaServiceImpl)((Object)ServiceLocator.getInstance().getService(EvsQuotaServiceImpl.class));
        return OpenstackCache.run(() -> {
            this.addVolumes(projectId, instanceId, addVolumes, extendParam);
            return evsQuotaService.calculateAddVolumesQuota(instanceId, addVolumes);
        });
    }

    public String addVolumes(String projectId, String instanceId, Set<VolumeBO> addVolumes, ExtendParamInfo extendParam) {
        ServiceInstance instance = this.checkInstance(projectId, instanceId);
        IProtectGroupService groupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = groupService.getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        OpenstackCache.preloadVolume(protectGroup);
        this.checkAddVolumesProtectable(protectGroup, addVolumes);
        if (extendParam != null && extendParam.isCheck()) {
            return null;
        }
        Set<ProtectObject> addPoList = this.buildAddPoList(protectGroup, addVolumes);
        EvsAddVolumesBackTask task = new EvsAddVolumesBackTask(projectId, ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), instanceId, protectGroup, addPoList);
        task.setEvsQuota(Optional.ofNullable(extendParam).map(ExtendParamInfo::getEvsQuota).orElse(null));
        String regionUuid = protectGroup.getProperty("regionId");
        OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, protectGroup.getName(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), projectId, regionUuid);
        this.updateTaskInfo(ServiceInstaceEnumDefine.ServiceInstanceOperateType.ADD_VOLUMES, extendParam, task, inst, instance);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    public void deleteVolumeCheck(String projectId, String instanceId, Set<String> deleteVolumes) {
        ServiceInstance instance = this.checkInstance(projectId, instanceId);
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        this.checkDeleteVolumes(pg, deleteVolumes);
    }

    public String deleteVolumes(String projectId, String instanceId, Set<String> deleteVolumes, ExtendParamInfo extendParam) {
        this.deleteVolumeCheck(projectId, instanceId, deleteVolumes);
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String serviceType = pg.getProperty("serviceInstanceType");
        EvDeleteVolumesBackTask deleteTask = new EvDeleteVolumesBackTask(projectId, serviceType, instance.getId(), pg, deleteVolumes);
        OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, pg.getName(), serviceType, projectId, (String)pg.getProps().get("regionId"));
        this.updateTaskInfo(ServiceInstaceEnumDefine.ServiceInstanceOperateType.DEL_VOLUMES, extendParam, deleteTask, inst, instance);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)deleteTask);
        return String.valueOf(taskId);
    }

    private void checkDeleteVolumes(ProtectGroup pg, Set<String> deleteVolumes) {
        Set poList = pg.getPolist();
        Set volumeIdsInPg = CollectionUtils.mapToSet((Collection)poList, ProtectObject::getMoUuid);
        String openStackUuid = OpenStackCommonUtil.getOpenstack().getUuid();
        for (String deleteVolumeId : deleteVolumes) {
            if (volumeIdsInPg.contains(OpenStackCommonUtil.getObjectUuid(openStackUuid, deleteVolumeId))) continue;
            logger.error((Object)"The volume(%s) can not find in protect group.", new Object[]{deleteVolumeId});
            throw new LegoCheckedException(1073947393L);
        }
        if (deleteVolumes.size() >= poList.size()) {
            logger.error((Object)"Can not delete all protect object in protect group.");
            throw new LegoCheckedException(1073948166L);
        }
    }

    private Set<ProtectObject> buildAddPoList(ProtectGroup pg, Set<VolumeBO> addVolumes) {
        Map<String, VolumeInfo> volumeInfoMap = this.queryVolumeInfoMap(pg, addVolumes);
        boolean shouldCreateDrVolume = addVolumes.stream().map(VolumeBO::getDrVolumeId).anyMatch(VerifyUtil::isEmpty);
        ArrayList<OpenStackVolTypeMapping> volTypeList = shouldCreateDrVolume ? this.queryVolTypeMapping(pg) : new ArrayList();
        HashSet<ProtectObject> poList = new HashSet<ProtectObject>();
        for (VolumeBO volume : addVolumes) {
            String drVolumeType;
            ProtectObject po = new ProtectObject();
            po.setUuid(UUIDGenerator.getUUID());
            String volumeId = volume.getVolumeId();
            po.setMoUuid(OpenStackBasicUtil.getObjectUuid(this.getOpenstack().getUuid(), volumeId));
            po.setPoType(22);
            VolumeInfo srcVolume = volumeInfoMap.get(volumeId);
            po.setName(srcVolume.getName());
            po.setProperty("volumeType", (Object)srcVolume.getVolumeType());
            String drVolumeId = volume.getDrVolumeId();
            boolean isNewDrVolume = VerifyUtil.isEmpty((String)drVolumeId);
            if (isNewDrVolume) {
                drVolumeType = EvsServiceInstanceServiceImpl.findDrVolType(srcVolume.getVolumeType(), volTypeList, pg);
            } else {
                drVolumeType = Optional.ofNullable(volumeInfoMap.get(drVolumeId)).map(VolumeInfo::getVolumeType).orElse("");
                po.setProperty("drVolumeId", (Object)drVolumeId);
            }
            po.setProperty("isNewDrVolume", (Object)String.valueOf(isNewDrVolume));
            po.setProperty("drVolumeType", (Object)drVolumeType);
            po.setProperty("volumeConfig", (Object)this.buildVolConfig(po, drVolumeId));
            poList.add(po);
        }
        return poList;
    }

    private String buildVolConfig(ProtectObject po, String drVolumeId) {
        JSONObject json = new JSONObject();
        json.put((Object)"volumeId", (Object)po.getMoUuid());
        json.put((Object)"drVolumeId", (Object)drVolumeId);
        json.put((Object)"volumeType", (Object)po.getProperty("volumeType"));
        json.put((Object)"drVolumeType", (Object)po.getProperty("drVolumeType"));
        json.put((Object)"isNewDrVolume", (Object)po.getProperty("isNewDrVolume"));
        JSONArray array = new JSONArray();
        array.add((Object)json);
        return array.toString();
    }

    private List<OpenStackVolTypeMapping> queryVolTypeMapping(ProtectGroup pg) {
        String regionId = OpenStackCommonUtil.getIdFromUuid(pg.getProperty("regionId"));
        String az = pg.getProperty("zoneName");
        String primaryRegionAz = OpenStackVolTypeMapping.getMappingAzId((String)regionId, (String)az);
        String drRegionId = OpenStackCommonUtil.getIdFromUuid(pg.getProperty("drRegionId"));
        String drAz = pg.getProperty("drZoneName");
        String secondRegionAz = OpenStackVolTypeMapping.getMappingAzId((String)drRegionId, (String)drAz);
        return ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getResourceMappingByRegionAz(ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue(), primaryRegionAz, secondRegionAz);
    }

    private void checkAddVolumesProtectable(ProtectGroup protectGroup, Set<VolumeBO> addVolumes) {
        Map<VolumeInfo, VolumeInfo> pairsMap = this.buildAllVolumePairsFromPg(protectGroup);
        int volumeSize = pairsMap.size() + addVolumes.size();
        VolumeProtectableChecker.checkProtectGroupVolumeCount(volumeSize).ifPresent(errorItem -> {
            logger.error((Object)"The number of volumes exceeds the limit, volume size = %s.", new Object[]{String.valueOf(volumeSize)});
            throw new LegoCheckedException(errorItem.getErrorCode().longValue(), errorItem.getErrorParams().toArray(new String[0]));
        });
        VolumeProtectableChecker volumeChecker = VolumeProtectableChecker.buildVolumeCheckerFromPg(ServiceInstaceEnumDefine.ObjectType.EVS, protectGroup);
        Map<VolumeInfo, VolumeInfo> addPairs = this.buildAddVolumePairs(protectGroup, addVolumes);
        this.checkAndThrowError(volumeChecker.checkAllVolumePairs(addPairs, ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION));
        HashSet<VolumeInfo> prodVolumes = new HashSet<VolumeInfo>();
        prodVolumes.addAll(pairsMap.keySet());
        prodVolumes.addAll(addPairs.keySet());
        String regionUuid = protectGroup.getProperty("regionId");
        volumeChecker.checkProdVolumeFromOneDevs(regionUuid, prodVolumes);
        HashSet<VolumeInfo> drVolumes = new HashSet<VolumeInfo>();
        drVolumes.addAll(addPairs.values());
        drVolumes.addAll(pairsMap.values());
        Set<String> drVolumeTypes = addVolumes.stream().filter(volume -> VerifyUtil.isEmpty((String)volume.getDrVolumeId())).map(VolumeBO::getDrVolumeType).collect(Collectors.toSet());
        String drRegionUuid = protectGroup.getProperty("drRegionId");
        SameDevInfo sameDev = volumeChecker.getSameDevInfoByVolumes(drRegionUuid, drVolumes, drVolumeTypes);
        protectGroup.setProperty("same_devices", (Object)JSONObject.fromObject((Object)sameDev));
    }

    private void checkAndThrowError(List<VolumeErrorItem> errorList) {
        if (VerifyUtil.isEmpty(errorList)) {
            return;
        }
        VolumeErrorItem error = errorList.get(0);
        logger.error((Object)"The error list is not empty, throw exception: %s.", new Object[]{String.valueOf(error.getErrorCode())});
        throw new LegoCheckedException(error.getErrorCode().longValue(), error.getErrorParams().toArray(new String[0]));
    }

    private Map<VolumeInfo, VolumeInfo> buildAddVolumePairs(ProtectGroup pg, Set<VolumeBO> volumes) {
        Map<String, VolumeInfo> volumeInfoMap = this.queryVolumeInfoMap(pg, volumes);
        HashMap<VolumeInfo, VolumeInfo> pairsMap = new HashMap<VolumeInfo, VolumeInfo>();
        for (VolumeBO volume : volumes) {
            String volumeId = volume.getVolumeId();
            VolumeInfo prodVolume = volumeInfoMap.get(volumeId);
            if (prodVolume == null) {
                logger.error((Object)"The prod volume is not exist, volumeId = %s.", new Object[]{volumeId});
                throw new LegoCheckedException(2117645L);
            }
            String drVolumeUuid = volume.getDrVolumeId();
            if (VerifyUtil.isEmpty((String)drVolumeUuid)) {
                logger.debug((Object)"The dr volume ID can be empty. In this case, the EVS disk is automatically created.");
                pairsMap.put(prodVolume, null);
                continue;
            }
            VolumeInfo drVolume = volumeInfoMap.get(drVolumeUuid);
            if (drVolume == null) {
                logger.error((Object)"The dr volume is not exist, volumeId = %s.", new Object[]{drVolumeUuid});
                throw new LegoCheckedException(2117645L);
            }
            pairsMap.put(prodVolume, drVolume);
        }
        this.updateProtectedVolumeType(pg, volumes, volumeInfoMap);
        return pairsMap;
    }

    private void updateProtectedVolumeType(ProtectGroup pg, Set<VolumeBO> volumes, Map<String, VolumeInfo> volumeInfoMap) {
        boolean shouldCreateDrVolume = volumes.stream().map(VolumeBO::getDrVolumeId).anyMatch(VerifyUtil::isEmpty);
        ArrayList<OpenStackVolTypeMapping> volTypeList = shouldCreateDrVolume ? this.queryVolTypeMapping(pg) : new ArrayList();
        for (VolumeBO volume : volumes) {
            String volumeType = volumeInfoMap.get(volume.getVolumeId()).getVolumeType();
            if (VerifyUtil.isEmpty((String)volumeType)) {
                logger.error((Object)"The prod volumeType is not exist, volumeId = %s.", new Object[]{volume.getVolumeId()});
                throw new LegoCheckedException(1073947393L);
            }
            volume.setVolumeType(volumeType);
            String drVolumeId = volume.getDrVolumeId();
            if (VerifyUtil.isEmpty((String)drVolumeId)) {
                volume.setDrVolumeType(EvsServiceInstanceServiceImpl.findDrVolType(volumeType, volTypeList, pg));
                continue;
            }
            volume.setDrVolumeType(volumeInfoMap.get(drVolumeId).getVolumeType());
        }
    }

    private Map<String, VolumeInfo> queryVolumeInfoMap(ProtectGroup pg, Set<VolumeBO> volumes) {
        HashMap<String, VolumeInfo> volMap = new HashMap<String, VolumeInfo>();
        String projectUuid = pg.getProperty("projectId");
        String regionUuid = pg.getProperty("regionId");
        List addVolIds = CollectionUtils.mapToList(volumes, VolumeBO::getVolumeId);
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        volMap.putAll(volumeService.queryVolumeInfosByUuid(regionUuid, projectUuid, addVolIds));
        List addDrVolIds = CollectionUtils.mapToList(volumes, VolumeBO::getDrVolumeId);
        addDrVolIds.removeIf(VerifyUtil::isEmpty);
        if (!VerifyUtil.isEmpty((Collection)addDrVolIds)) {
            String drRegionUuid = pg.getProperty("drRegionId");
            String drProjectUuid = pg.getProperty("drProjectId");
            volMap.putAll(volumeService.queryVolumeInfosByUuid(drRegionUuid, drProjectUuid, addDrVolIds));
        }
        return volMap;
    }

    private boolean checkAzMapping(CheckVolumesProtectableRequest request) {
        List azMappings = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getAZMappingsByObjectType(ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue());
        String prodRegionAz = this.getRegionAzIdentity(request.getRegionName(), request.getAvailableZone());
        String drRegionAz = this.getRegionAzIdentity(request.getRemoteRegionName(), request.getRemoteAvailableZone());
        for (OpenStackAvailabilityZoneMapping azMapping : azMappings) {
            boolean isReverseMappingExist;
            String localRegionAz = this.getRegionAzIdentity(azMapping.getPrimaryRegionId(), azMapping.getPrimaryAzId());
            String remoteRegionAz = this.getRegionAzIdentity(azMapping.getSecondRegionId(), azMapping.getSecondAzId());
            boolean isMappingExist = prodRegionAz.equals(localRegionAz) && drRegionAz.equals(remoteRegionAz);
            boolean bl = isReverseMappingExist = prodRegionAz.equals(remoteRegionAz) && drRegionAz.equals(localRegionAz);
            if (!isMappingExist && !isReverseMappingExist) continue;
            logger.info((Object)"The AZ mapping exists.");
            return true;
        }
        logger.info((Object)"The AZ mapping not exists.");
        return false;
    }

    private String getRegionAzIdentity(String region, String az) {
        return String.join((CharSequence)"_@_", region, az);
    }

    private Map<VolumeInfo, VolumeInfo> buildVolumePairs(String projectId, CheckVolumesProtectableRequest request, List<VolumeErrorItem> errorList) {
        String openStackUuid = this.getOpenstack().getUuid();
        ArrayList<String> prodVolumes = new ArrayList<String>();
        ArrayList<String> drVolumes = new ArrayList<String>();
        for (VolumeBO volumeBo : request.getVolumes()) {
            prodVolumes.add(volumeBo.getVolumeId());
            Optional.ofNullable(volumeBo.getDrVolumeId()).ifPresent(drVolumes::add);
        }
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, request.getRegionName());
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, projectId);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        Map<String, VolumeInfo> volumeInfoMap = this.cinderManager.queryVolumes(regionUuid, tokenId, projectUuid, prodVolumes);
        String drProjectUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, request.getRemoteProjectId());
        String drRegionUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, request.getRemoteRegionName());
        String drTokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjectUuid);
        Map<String, VolumeInfo> drVolumeInfoMap = this.cinderManager.queryVolumes(drRegionUuid, drTokenId, drProjectUuid, drVolumes);
        HashMap<VolumeInfo, VolumeInfo> volumePairs = new HashMap<VolumeInfo, VolumeInfo>();
        for (VolumeBO volumeBo : request.getVolumes()) {
            String drVolumeId;
            String volumeId = volumeBo.getVolumeId();
            VolumeInfo prodVolume = volumeInfoMap.get(volumeId);
            if (prodVolume == null) {
                logger.warn((Object)"The prodVolume is not exist, volumeId: %s.", new Object[]{volumeId});
                errorList.add(new VolumeErrorItem(Long.valueOf(2117645L)).addVolumeId(volumeId));
            }
            if (!VerifyUtil.isEmpty((String)(drVolumeId = volumeBo.getDrVolumeId())) && !drVolumeInfoMap.containsKey(drVolumeId)) {
                logger.warn((Object)"The drVolume is not exist, volumeId: %s.", new Object[]{drVolumeId});
                errorList.add(new VolumeErrorItem(Long.valueOf(2117645L)).addVolumeId(drVolumeId));
                continue;
            }
            VolumeInfo drVolume = Optional.ofNullable(drVolumeId).map(drVolumeInfoMap::get).orElse(null);
            volumePairs.put(prodVolume, drVolume);
        }
        return volumePairs;
    }

    @Override
    public String createServiceInstance(ProtectGroup pg, ExtendParamInfo extendParam) {
        this.refactorPg(pg);
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        this.updateProdVolType(pg, regionUuid, projectUuid);
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        this.updateProtectGroupDrVolType(serviceType, pg.getPolist(), this.getAzIdentity(pg, serviceType), regionUuid, pg);
        OpenstackCache.preloadVolume(pg);
        this.checkCreateInstanceParam(pg);
        if (extendParam != null && extendParam.isCheck()) {
            return null;
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        CreateVolumeInstanceTask task = new CreateVolumeInstanceTask(projectId, serviceType, pg, this.getServiceInstanceReplicationSyncTask());
        task.setEvsQuota(Optional.ofNullable(extendParam).map(ExtendParamInfo::getEvsQuota).orElse(null));
        OrderInstanceInfo inst = this.createOrderInstanceInfo(null, pg.getName(), serviceType, projectId, regionUuid);
        this.updateTaskInfo(ServiceInstaceEnumDefine.ServiceInstanceOperateType.ADD_INSTANCE, extendParam, task, inst, null);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    private void updateProdVolType(ProtectGroup pg, String regionUuid, String projectUuid) {
        Map volumeConfigMap = pg.getPolist().stream().collect(Collectors.toMap(Function.identity(), po -> JSONArray.fromObject((Object)po.getProperty("volumeConfig"))));
        List volumeIds = volumeConfigMap.values().stream().flatMap(volumeConfigs -> IntStream.range(0, volumeConfigs.size()).mapToObj(arg_0 -> ((JSONArray)volumeConfigs).getJSONObject(arg_0))).map(volumeConfig -> volumeConfig.getString("volumeId")).filter(volumeId -> !VerifyUtil.isEmpty((String)volumeId)).distinct().map(OpenStackBasicUtil::getIdFromUuid).collect(Collectors.toList());
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        Map volumeInfoMap = volumeService.queryVolumeInfosByUuid(regionUuid, projectUuid, volumeIds);
        volumeConfigMap.forEach((po, volumeConfigs) -> {
            IntStream.range(0, volumeConfigs.size()).mapToObj(arg_0 -> ((JSONArray)volumeConfigs).getJSONObject(arg_0)).forEach(volumeConfig -> {
                String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeConfig.getString("volumeId"));
                VolumeInfo volumeInfo = (VolumeInfo)volumeInfoMap.get(volumeId);
                if (volumeInfo == null) {
                    logger.warn((Object)"Volume with id %s is not exists.", new Object[]{volumeId});
                    throw new LegoCheckedException(2117645L);
                }
                if (VerifyUtil.isEmpty((String)volumeInfo.getVolumeType())) {
                    logger.warn((Object)"Volume type of volume %s is empty.", new Object[]{volumeId});
                    throw new LegoCheckedException(2117645L);
                }
                volumeConfig.put((Object)"volumeType", (Object)volumeInfo.getVolumeType());
            });
            po.setProperty("volumeConfig", volumeConfigs);
        });
    }

    @Override
    public void checkCreateInstanceParam(ProtectGroup pg) {
        this.checkInstanceNameIsRepeat(pg);
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String drRegionUuid = pg.getProperty("drRegionId");
        String drProjectUuid = pg.getProperty("drProjectId");
        String az = pg.getProperty("zoneName");
        String drAz = pg.getProperty("drZoneName");
        VolumeProtectableChecker checker = new VolumeProtectableChecker(ServiceInstaceEnumDefine.ObjectType.EVS, new ResourceLocation(regionUuid, projectUuid, az), new ResourceLocation(drRegionUuid, drProjectUuid, drAz));
        this.checkPgVolumesProtable(checker, pg);
    }

    @Override
    public String deleteServiceInstance(String projectId, String instanceId, ExtendParamInfo extendParam) {
        if (VerifyUtil.isEmpty((String)instanceId)) {
            logger.error((Object)"Instance id is empty.");
            throw new LegoCheckedException(1073947393L, "instance id is empty.");
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        this.checkInstanceProjectId(projectId, instance);
        ServiceInstanceHelper.checkInstanceStatusSupportDelete(instance);
        if (extendParam != null && extendParam.isCheck()) {
            return null;
        }
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String serviceType = pg.getProperty("serviceInstanceType");
        EvsDeleteInstanceTask deleteTask = new EvsDeleteInstanceTask(projectId, serviceType, instance.getId(), instance.getName());
        OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, pg.getName(), serviceType, projectId, (String)pg.getProps().get("regionId"));
        this.updateTaskInfo(ServiceInstaceEnumDefine.ServiceInstanceOperateType.DEL_INSTANCE, extendParam, deleteTask, inst, instance);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)deleteTask);
        return String.valueOf(taskId);
    }

    @Override
    protected void updateTaskInfo(ServiceInstaceEnumDefine.ServiceInstanceOperateType operateType, ExtendParamInfo extendParam, AbstractBackTask task, OrderInstanceInfo inst, ServiceInstance instance) {
        super.updateTaskInfo(operateType, extendParam, task, inst, instance);
        Map taskParam = task.getExtendParam();
        if (!VerifyUtil.isMultiEmpty((Object[])new Object[]{taskParam, extendParam})) {
            taskParam.put("SHOULD_DELETE_DR_VOLUME", extendParam.isDeleteVolume());
        }
    }

    private void checkPoVolumeTypeReal(String regionUuid, String projectUuid, Map<String, String> volumeTypeMap) {
        if (volumeTypeMap.isEmpty()) {
            return;
        }
        if (!this.isRealVolumesType(regionUuid, projectUuid, volumeTypeMap)) {
            logger.error((Object)"Volume types are not really.");
            throw new LegoCheckedException(1073948116L);
        }
    }

    private void checkPgVolumesProtable(VolumeProtectableChecker checker, ProtectGroup pg) {
        Map<VolumeInfo, VolumeInfo> volumePairsMap = this.buildAllVolumePairsFromPg(pg);
        String regionUuid = pg.getProperty("regionId");
        checker.checkProdVolumeFromOneDevs(regionUuid, volumePairsMap.keySet());
        String drRegionUuid = pg.getProperty("drRegionId");
        SameDevInfo drSameDevs = checker.getSameDevInfoByVolumes(drRegionUuid, volumePairsMap.values(), this.getDrVolumeTypes(pg.getPolist()));
        pg.setProperty("same_devices", (Object)JSONObject.fromObject((Object)drSameDevs));
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        List<VolumeErrorItem> errorList = checker.checkAllVolumePairs(volumePairsMap, ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)serviceType));
        if (!errorList.isEmpty()) {
            VolumeErrorItem error = errorList.get(0);
            throw new LegoCheckedException(error.getErrorCode().longValue(), error.getErrorParams().toArray(new String[0]));
        }
    }

    private Set<String> getDrVolumeTypes(Set<ProtectObject> poList) {
        HashSet<String> volumeTypes = new HashSet<String>();
        if (VerifyUtil.isEmpty(poList)) {
            return volumeTypes;
        }
        for (ProtectObject po : poList) {
            JSONArray volConfigs = JSONArray.fromObject((Object)po.getProperty("volumeConfig"));
            JSONObject volConfig = volConfigs.getJSONObject(0);
            String drVolumeId = volConfig.getString("drVolumeId", null);
            if (!VerifyUtil.isEmpty((String)drVolumeId)) continue;
            String volumeType = volConfig.getString("drVolumeType");
            volumeTypes.add(volumeType);
        }
        return volumeTypes;
    }

    private Map<VolumeInfo, VolumeInfo> buildAllVolumePairsFromPg(ProtectGroup pg) {
        boolean isDrVolumesMissing;
        String projectUuid;
        String regionUuid;
        ArrayList<String> volumeIds = new ArrayList<String>();
        ArrayList<String> drVolumeIds = new ArrayList<String>();
        HashMap<String, String> volumeIdPairMap = new HashMap<String, String>();
        for (ProtectObject protectObject : pg.getPolist()) {
            String volumeId = OpenStackCommonUtil.getIdFromUuid(protectObject.getMoUuid());
            volumeIds.add(volumeId);
            String drVolumeUuid = this.getDrVolIdFromPo(protectObject).orElse(null);
            if (VerifyUtil.isEmpty((String)drVolumeUuid)) {
                volumeIdPairMap.put(volumeId, null);
                continue;
            }
            String drVolumeId = OpenStackCommonUtil.getIdFromUuid(drVolumeUuid);
            drVolumeIds.add(drVolumeId);
            volumeIdPairMap.put(volumeId, drVolumeId);
        }
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        Map volumeInfoMap = volumeService.queryVolumeInfosByUuid(regionUuid = (String)pg.getProps().get("regionId"), projectUuid = (String)pg.getProps().get("projectId"), volumeIds);
        boolean isVolumesMissing = volumeInfoMap.size() < volumeIds.size();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjectUuid = (String)pg.getProps().get("drProjectId");
        Map drVolumeInfoMap = volumeService.queryVolumeInfosByUuid(drRegionUuid, drProjectUuid, drVolumeIds);
        boolean bl = isDrVolumesMissing = drVolumeInfoMap.size() < drVolumeIds.size();
        if (isVolumesMissing || isDrVolumesMissing) {
            logger.error((Object)"The volumes are not all exist.");
            throw new LegoCheckedException(2117645L);
        }
        HashMap<VolumeInfo, VolumeInfo> resultMap = new HashMap<VolumeInfo, VolumeInfo>();
        for (String volumeId : volumeIdPairMap.keySet()) {
            VolumeInfo volume = (VolumeInfo)volumeInfoMap.get(volumeId);
            VolumeInfo drVolume = Optional.ofNullable(volumeIdPairMap.get(volumeId)).map(drVolumeInfoMap::get).orElse(null);
            resultMap.put(volume, drVolume);
        }
        return resultMap;
    }

    private Optional<String> getDrVolIdFromPo(ProtectObject po) {
        PoReplicaInfo replica = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
        if (replica != null) {
            return replica.getPairInfos().stream().map(PoReplicaPairInfo::getDrVolumeUuid).findAny();
        }
        String drVolId = po.getProperty("drVolumeId");
        if (!VerifyUtil.isEmpty((String)drVolId)) {
            return Optional.of(drVolId);
        }
        return Optional.empty();
    }

    private Map<String, String> getDrTypeInfoMap(Set<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> typeInfoMap = new HashMap<String, String>();
        for (ProtectObject po : poList) {
            String volConfigStr = (String)po.getProps().get("volumeConfig");
            JSONArray array = JSONArray.fromObject((Object)volConfigStr);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = array.getJSONObject(i);
                if (!json.containsKey((Object)"drVolumeId") || !json.containsKey((Object)"drVolumeType")) continue;
                String openstackUuid = OpenStackCommonUtil.getOpenstack().getUuid();
                String volumeId = OpenStackCommonUtil.getObjectUuid(openstackUuid, json.getString("drVolumeId"));
                String volumeType = json.getString("drVolumeType");
                typeInfoMap.put(volumeId, volumeType);
            }
        }
        return typeInfoMap;
    }
}

