/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.ServiceInstanceBackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.galax.sdk.model.HypermetroDomain;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsManilaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.bo.AzMapBo;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PageForVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.ShareBO;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.bo.VerifyServerResultBO;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.ISfsServiceInstanceService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceServiceImpl;
import com.huawei.ism.drm.openstack.serviceinstance.task.ServiceInstanceReplicationSyncTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.SfsCreateInstanceTask;
import com.huawei.ism.drm.openstack.serviceinstance.task.sfs.SfsDeleteInstanceTask;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.task.FixedRecoveryThreadPool;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

@Service(name="com.huawei.ism.drm.openstack.sdk.service.ISfsServiceInstanceService", desc="", interfaceClass=ISfsServiceInstanceService.class)
public class SfsServiceInstanceServiceImpl
extends ServiceInstanceServiceImpl
implements ISfsServiceInstanceService {
    private static final Log LOG = LogFactory.getInstance(SfsServiceInstanceServiceImpl.class);
    private static final ISfsManilaManager SFS_MANILA_MANAGER = ManagerFactory.getInstance().getSfsManilaManager();
    private static final ISfsFilemeterManager FILEMETER_MANAGER = ManagerFactory.getInstance().getSfsFilemeterManager();
    private ServiceInstanceReplicationSyncTask serviceInstanceReplicationSyncTask;

    @Override
    protected PageForVmInfo buildVmList(ServiceInstance instanceInDB, int marker, int limit) {
        if (ServiceInstaceEnumDefine.ObjectType.SFS.getValue().equals(instanceInDB.getObjectType())) {
            return this.buildShareInfo(instanceInDB);
        }
        return super.buildVmList(instanceInDB, marker, limit);
    }

    private PageForVmInfo buildShareInfo(ServiceInstance instanceInDB) {
        PageForVmInfo pageServers = new PageForVmInfo();
        if (VerifyUtil.isEmpty((Object)instanceInDB) || VerifyUtil.isEmpty((String)instanceInDB.getProtectGroupId())) {
            return pageServers;
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(instanceInDB.getProtectGroupId(), true);
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            return pageServers;
        }
        ArrayList<ShareBO> shareBOList = new ArrayList<ShareBO>();
        for (ProtectObject po : pg.getPolist()) {
            ShareBO shareBO = new ShareBO();
            String pdShareString = po.getProperty("pd_share");
            Share pdShare = (Share)JSONObject.toBean((String)pdShareString, Share.class);
            if (VerifyUtil.isEmpty((Object)pdShare)) continue;
            shareBO.setName(pdShare.getName());
            shareBO.setShareId(pdShare.getId());
            shareBO.setShareProto(pdShare.getShareProto());
            shareBO.setObjectType(ServiceInstaceEnumDefine.ObjectType.SFS.getValue());
            shareBO.setSize(pdShare.getSize());
            String drShareString = po.getProperty("dr_share");
            Share drShare = (Share)JSONObject.toBean((String)drShareString, Share.class);
            if (VerifyUtil.isEmpty((Object)drShare)) continue;
            shareBO.setRemoteName(drShare.getName());
            shareBO.setRemoteShareId(drShare.getId());
            shareBOList.add(shareBO);
        }
        pageServers.setShareBOList(shareBOList);
        return pageServers;
    }

    @Override
    public ServiceInstanceReplicationSyncTask getServiceInstanceReplicationSyncTask() {
        return this.serviceInstanceReplicationSyncTask;
    }

    @Override
    public void setServiceInstanceReplicationSyncTask(ServiceInstanceReplicationSyncTask serviceInstanceReplicationSyncTask) {
        this.serviceInstanceReplicationSyncTask = serviceInstanceReplicationSyncTask;
    }

    @Override
    public String deleteServiceInstance(String projectId, String instanceId, ExtendParamInfo extendParam) {
        if (VerifyUtil.isEmpty((String)instanceId)) {
            LOG.error((Object)"Instance_id is empty.");
            throw new LegoCheckedException(1073947393L, "instance_id is empty.");
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        this.checkInstanceProjectId(projectId, instance);
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        this.checkSharePairStatus(instance, pg);
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        Map newProps = pg.getProps();
        newProps.put("before_delete_instance_status", instance.getStatus());
        ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(pg.getUuid(), newProps);
        if (extendParam != null && extendParam.isCheck()) {
            return null;
        }
        SfsDeleteInstanceTask task = new SfsDeleteInstanceTask(projectId, serviceType, instance.getId(), instance.getName());
        OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, pg.getName(), serviceType, projectId, (String)pg.getProps().get("regionId"));
        this.updateTaskInfo(ServiceInstaceEnumDefine.ServiceInstanceOperateType.DEL_INSTANCE, extendParam, task, inst, instance);
        return String.valueOf(ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task));
    }

    private void checkSharePairStatus(ServiceInstance instance, ProtectGroup pg) {
        String sharePairStaus = OpenStackCommonUtil.querySharePairRunningStatus(pg);
        if (OpenstackEnumDefine.SharePairRunningStatus.SYNCHRONIZING.getValue().equals(sharePairStaus)) {
            LOG.error((Object)"Instance name %s, instance id=%s status is not allow delete, pair status: %s.", new Object[]{instance.getName(), instance.getId(), sharePairStaus});
            throw new LegoCheckedException(1073948693L, String.format(Locale.ENGLISH, "Delete instance(%s) error, its pair status is %s.", instance.getName(), sharePairStaus));
        }
    }

    public VerifyServerResultBO verifyShare(Map<String, String> paramMap) {
        String projectId = paramMap.get("projectId");
        String srcRegion = paramMap.get("regionName");
        String remoteProjectId = paramMap.get("drProjectId");
        String pdAz = paramMap.get("zoneName");
        String drAz = paramMap.get("drZoneName");
        String drRegion = paramMap.get("drRegionName");
        String pdShareJson = paramMap.get("pd_share");
        String openstackUuid = this.getOpenstack().getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, srcRegion);
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
        String drProjectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, remoteProjectId);
        String drRegionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, drRegion);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjectUuid);
        JSONArray jsonArray = JSONArray.fromObject((Object)pdShareJson);
        List shareList = JSONArray.toCollection((JSONArray)jsonArray, Share.class);
        UrlBaseParams pdUrlBaseParams = new UrlBaseParams(projectUuid, regionUuid, tokenId);
        UrlBaseParams drUrlBaseParams = new UrlBaseParams(drProjectUuid, drRegionUuid, drTokenId);
        VerifyServerResultBO verifyResult = new VerifyServerResultBO();
        HashSet<VerifyServerResultBO.ResultItem> resultItems = new HashSet<VerifyServerResultBO.ResultItem>();
        this.checkShareAz(pdAz, drAz, resultItems);
        for (Share share : shareList) {
            Share pdShare = SFS_MANILA_MANAGER.queryShareById(pdUrlBaseParams, OpenStackCommonUtil.getIdFromUuid(share.getId()));
            Optional<VerifyServerResultBO> verifyResultOptional = this.checkShareStatus(resultItems, pdShare);
            if (verifyResultOptional.isPresent()) {
                return verifyResultOptional.get();
            }
            HypermetroDomain hypermetroDomain = this.getHypermetroDomain(pdUrlBaseParams, verifyResult, resultItems, pdShare);
            List<OpenStackVolTypeMapping> shareTypeMapping = OpenStackCommonUtil.getShardTyepMapping(regionUuid, drRegionUuid, pdAz, drAz, pdShare.getShareType());
            if (shareTypeMapping.isEmpty()) {
                LOG.error((Object)"File service level mapping error");
                this.buildVerifyResult(verifyResult, resultItems, pdShare);
            }
            this.checkHypermetroDomain(drUrlBaseParams, pdShare, hypermetroDomain, shareTypeMapping);
        }
        return verifyResult;
    }

    private void checkHypermetroDomain(UrlBaseParams drUrlBaseParams, Share pdShare, HypermetroDomain hypermetroDomain, List<OpenStackVolTypeMapping> shareTypeMapping) {
        for (OpenStackVolTypeMapping mapping : shareTypeMapping) {
            String drShareType = mapping.getPrimaryVolType().equals(pdShare.getShareType()) ? mapping.getSecondVolType() : mapping.getPrimaryVolType();
            HypermetroDomain checkHD = FILEMETER_MANAGER.queryHypermetroDomain(drUrlBaseParams, drShareType);
            if (!hypermetroDomain.getId().equals(checkHD.getId())) continue;
            LOG.info((Object)"HyperMetro domain verification succeeded.");
            break;
        }
    }

    private void buildVerifyResult(VerifyServerResultBO verifyResult, Set<VerifyServerResultBO.ResultItem> resultItems, Share pdShare) {
        VerifyServerResultBO.ResultItem resultItem = new VerifyServerResultBO.ResultItem();
        resultItem.setErrCode(String.valueOf(1073949755L));
        resultItem.setErrParams(new String[]{pdShare.getShareType(), ""});
        resultItems.add(resultItem);
        verifyResult.setCheckResult(resultItems);
    }

    private Optional<VerifyServerResultBO> checkShareStatus(Set<VerifyServerResultBO.ResultItem> resultItems, Share pdShare) {
        if (VerifyUtil.isEmpty((Object)pdShare) || !OpenstackEnumDefine.ShareStatus.AVAILABLE.getValue().equals(pdShare.getStatus())) {
            VerifyServerResultBO verifyResult = new VerifyServerResultBO();
            LOG.error((Object)"The share(%s,share name=%s) status error,status:%s.", new Object[]{pdShare.getId(), pdShare.getName(), pdShare.getStatus()});
            VerifyServerResultBO.ResultItem resultItem = new VerifyServerResultBO.ResultItem();
            resultItem.setErrCode(String.valueOf(1073947393L));
            resultItems.add(resultItem);
            verifyResult.setCheckResult(resultItems);
            return Optional.of(verifyResult);
        }
        return Optional.empty();
    }

    private HypermetroDomain getHypermetroDomain(UrlBaseParams pdUrlBaseParams, VerifyServerResultBO verifyResult, Set<VerifyServerResultBO.ResultItem> resultItems, Share pdShare) {
        HypermetroDomain hypermetroDomain = FILEMETER_MANAGER.queryHypermetroDomain(pdUrlBaseParams, pdShare.getShareType());
        if (!OpenstackEnumDefine.HypermetroDomainStatus.NORMAL.getKey().equals(hypermetroDomain.getRunningStatus())) {
            LOG.error((Object)"Failed to create an instance because the HyperMetro domain status is %s.", new Object[]{hypermetroDomain.getRunningStatus()});
            VerifyServerResultBO.ResultItem resultItem = new VerifyServerResultBO.ResultItem();
            resultItem.setErrCode(String.valueOf(1073949742L));
            resultItem.setErrParams(new String[]{hypermetroDomain.getName()});
            resultItems.add(resultItem);
            verifyResult.setCheckResult(resultItems);
        }
        return hypermetroDomain;
    }

    private void checkShareAz(String pdAz, String drAz, Set<VerifyServerResultBO.ResultItem> resultItems) {
        IOpenstackResourceService openstackResourceService = (IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class);
        List mappings = openstackResourceService.getAZMappingsByObjectType(ServiceInstaceEnumDefine.ObjectType.SFS.getValue());
        for (OpenStackAvailabilityZoneMapping mapping : mappings) {
            if (mapping.getPrimaryAzId().equals(pdAz) && mapping.getSecondAzId().equals(drAz)) {
                LOG.info((Object)"The AZ mapping exists.");
                return;
            }
            if (!mapping.getPrimaryAzId().equals(drAz) || !mapping.getSecondAzId().equals(pdAz)) continue;
            LOG.info((Object)"The AZ mapping exists.");
            return;
        }
        LOG.info((Object)"The AZ mapping not exists.");
        VerifyServerResultBO.ResultItem resultItem = new VerifyServerResultBO.ResultItem();
        resultItem.setErrCode(String.valueOf(1073948121L));
        resultItems.add(resultItem);
    }

    public List<Share> queryAvailableShares(String projectId, AzMapBo azMap) {
        String openstackUuid = this.getOpenstack().getUuid();
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        UrlBaseParams urlBaseParams = new UrlBaseParams(projectId, azMap.getRegion(), tokenId);
        List<Object> allShare = ManagerFactory.getInstance().getSfsManilaManager().queryAllShares(urlBaseParams);
        allShare = allShare.stream().filter(share -> StringUtils.equals((CharSequence)azMap.getAvailableZone(), (CharSequence)share.getAvailabilityZone())).collect(Collectors.toList());
        return this.filterAvailableShares(allShare, urlBaseParams, azMap);
    }

    private boolean checkHypermetroDomain(HypermetroDomain hypermetroDomain) {
        if (VerifyUtil.isEmpty((Object)hypermetroDomain)) {
            LOG.error((Object)"The hypermetroDomain is null, check failed.");
            return false;
        }
        if (!OpenstackEnumDefine.HypermetroDomainRole.PRIMARY.getValue().equals(hypermetroDomain.getConfigRole())) {
            LOG.error((Object)"The hypermetroDomain(%s) is standby, check failed.", new Object[]{hypermetroDomain.getName()});
            return false;
        }
        if (!OpenstackEnumDefine.HypermetroDomainWorkMode.SYNC_MODE.getValue().equals(hypermetroDomain.getWorkMode())) {
            LOG.error((Object)"The working mode of the HyperMetro domain(%s) is not syncMode, check failed.", new Object[]{hypermetroDomain.getName()});
            return false;
        }
        if (!"false".equalsIgnoreCase(hypermetroDomain.getIsShareAuthenticationSync())) {
            LOG.error((Object)"The shareAuthenticationSync of the HyperMetro domain(%s) is not false, check failed.", new Object[]{hypermetroDomain.getName()});
            return false;
        }
        return true;
    }

    private List<Share> filterAvailableShares(List<Share> shares, UrlBaseParams urlBaseParams, AzMapBo azMap) {
        ConcurrentHashMap shareTypeSuccess = new ConcurrentHashMap();
        return shares.stream().map(share -> {
            Future future = FixedRecoveryThreadPool.submit(() -> this.checkShareProtectable(urlBaseParams, azMap, shareTypeSuccess, (Share)share));
            return Pair.of((Object)share, (Object)future);
        }).filter(datas -> {
            boolean checkResult = false;
            try {
                checkResult = (Boolean)((Future)datas.getValue()).get(30L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                LOG.error((Object)"Waiting check result of share(%s) error:%s.", new Object[]{((Share)datas.getKey()).getName(), ExceptionUtil.getErrorMessage((Throwable)exception)});
            }
            return checkResult;
        }).map(Pair::getKey).collect(Collectors.toList());
    }

    private boolean checkShareProtectable(UrlBaseParams urlBaseParams, AzMapBo azMap, Map<String, Boolean> shareTypeSuccess, Share share) {
        if (!OpenstackEnumDefine.ShareStatus.AVAILABLE.getValue().equals(share.getStatus())) {
            LOG.info((Object)"The share(%s,share name=%s) status error,status:%s.", new Object[]{share.getId(), share.getName(), share.getStatus()});
            return false;
        }
        if (this.checkShareExist(share)) {
            LOG.info((Object)"The share(%s,share name=%s) has been used.", new Object[]{share.getId(), share.getName()});
            return false;
        }
        List<OpenStackVolTypeMapping> shardTyepMapping = OpenStackCommonUtil.getShardTyepMapping(azMap.getRegion(), azMap.getRemoteRegion(), azMap.getAvailableZone(), azMap.getRemoteAvailableZone(), share.getShareType());
        if (VerifyUtil.isEmpty(shardTyepMapping)) {
            LOG.info((Object)"The shareType(%s) does not have a matching shardTyepMapping.", new Object[]{share.getShareType()});
            return false;
        }
        if (!shareTypeSuccess.containsKey(share.getShareType())) {
            HypermetroDomain hypermetroDomain = null;
            try {
                hypermetroDomain = FILEMETER_MANAGER.queryHypermetroDomain(urlBaseParams, share.getShareType());
            }
            catch (LegoCheckedException exception) {
                LOG.error((Object)"Query hypermetroDomain by shareType(%s) failed.", new Object[]{share.getShareType(), exception});
            }
            shareTypeSuccess.put(share.getShareType(), this.checkHypermetroDomain(hypermetroDomain));
        }
        if (!shareTypeSuccess.getOrDefault(share.getShareType(), true).booleanValue()) {
            LOG.info((Object)"The current HyperMetro domain pair is the standby end.");
            return false;
        }
        return true;
    }

    private boolean checkShareExist(Share share) {
        String openstackUuid = this.getOpenstack().getUuid();
        if (!VerifyUtil.isEmpty((String)share.getMetadata().getHypermetroTags()) && (share.getMetadata().getHypermetroTags().contains("__type_dr") || share.getMetadata().getHypermetroTags().contains("__type_pd"))) {
            LOG.info((Object)"The share(%s,share name=%s) has a DR tag.", new Object[]{share.getId(), share.getName(), share.getStatus()});
            return true;
        }
        if (!this.checkPoExists(Collections.singleton(OpenStackCommonUtil.getObjectUuid(openstackUuid, share.getId())))) {
            LOG.info((Object)"The share(%s,share name=%s) is already protected.", new Object[]{share.getId(), share.getName()});
            return true;
        }
        if (this.isSingleVmExistRollBackTask(OpenStackCommonUtil.getObjectUuid(openstackUuid, share.getId()))) {
            LOG.info((Object)"The share(%s,share name=%s) has rollBack task.", new Object[]{share.getId(), share.getName()});
            return true;
        }
        return false;
    }

    @Override
    public String createServiceInstance(ProtectGroup pg, ExtendParamInfo extendParam) {
        this.refactorPg(pg);
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        if (extendParam != null && extendParam.isCheck()) {
            return OpenstackCache.run(() -> {
                this.checkCreateInstanceParam(pg);
                return null;
            });
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        SfsCreateInstanceTask task = new SfsCreateInstanceTask(projectId, serviceType, pg, this.serviceInstanceReplicationSyncTask);
        OrderInstanceInfo inst = this.createOrderInstanceInfo(null, pg.getName(), serviceType, projectId, regionUuid);
        this.updateTaskInfo(ServiceInstaceEnumDefine.ServiceInstanceOperateType.ADD_INSTANCE, extendParam, task, inst, null);
        return String.valueOf(ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task));
    }

    @Override
    public void checkCreateInstanceParam(ProtectGroup pg) {
        String projUuid = pg.getProperty("projectId");
        String drProjUuid = pg.getProperty("drProjectId");
        String regionUuid = pg.getProperty("regionId");
        String drRegionUuid = pg.getProperty("drRegionId");
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        UrlBaseParams pdUrlBaseParams = new UrlBaseParams(projUuid, regionUuid, tokenId);
        UrlBaseParams drUrlBaseParams = new UrlBaseParams(drProjUuid, drRegionUuid, drTokenId);
        for (ProtectObject po : pg.getPolist()) {
            Share pdShare = SFS_MANILA_MANAGER.queryShareById(pdUrlBaseParams, OpenStackCommonUtil.getIdFromUuid(po.getMoUuid()));
            HypermetroDomain hypermetroDomain = FILEMETER_MANAGER.queryHypermetroDomain(pdUrlBaseParams, pdShare.getShareType());
            if (!OpenstackEnumDefine.HypermetroDomainStatus.NORMAL.getKey().equals(hypermetroDomain.getRunningStatus())) {
                LOG.error((Object)"Failed to create an instance because the HyperMetro domain status is %s.", new Object[]{hypermetroDomain.getRunningStatus()});
                throw new LegoCheckedException(1073949742L, new String[]{hypermetroDomain.getName()});
            }
            String drShareTypeName = this.getShareTypeName(pg, pdShare);
            HypermetroDomain checkHD = FILEMETER_MANAGER.queryHypermetroDomain(drUrlBaseParams, drShareTypeName);
            if (!hypermetroDomain.getId().equals(checkHD.getId())) {
                LOG.error((Object)"File service level mapping error");
                throw new LegoCheckedException(1073949755L, new String[]{pdShare.getShareType(), drShareTypeName});
            }
            po.setProperty("pd_share", (Object)JSONObject.fromObject((Object)pdShare).toString());
            po.setProperty("pg_hypermetro_domain", (Object)JSONObject.fromObject((Object)hypermetroDomain).toString());
        }
    }

    private String getShareTypeName(ProtectGroup pg, Share share) {
        String zoneName = (String)pg.getProps().get("zoneName");
        String drZoneName = (String)pg.getProps().get("drZoneName");
        String regionUuid = (String)pg.getProps().get("regionId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String pdAz = OpenStackVolTypeMapping.getMappingAzId((String)OpenStackCommonUtil.getIdFromUuid(regionUuid), (String)zoneName);
        String drAzName = OpenStackVolTypeMapping.getMappingAzId((String)OpenStackCommonUtil.getIdFromUuid(drRegionUuid), (String)drZoneName);
        Optional<String> optional = this.getShareTypeName(share.getShareType(), pdAz, drAzName);
        if (optional.isPresent()) {
            return optional.get();
        }
        LOG.error((Object)"The service level mapping is missing.");
        throw new LegoCheckedException(1073949755L, new String[]{share.getShareType(), ""});
    }

    private Optional<String> getShareTypeName(String pdShareTypeName, String pdAzName, String drAzName) {
        String openStackUuid = OpenStackCommonUtil.getOpenstack().getUuid();
        List shareTypeList = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getResourceMapping(openStackUuid, ServiceInstaceEnumDefine.ObjectType.SFS.getValue());
        for (OpenStackVolTypeMapping shareType : shareTypeList) {
            if (shareType.getPrimaryAzId().equals(pdAzName) && shareType.getPrimaryVolType().equals(pdShareTypeName) && shareType.getSecondAzId().equals(drAzName)) {
                return Optional.of(shareType.getSecondVolType());
            }
            if (!shareType.getSecondAzId().equals(pdAzName) || !shareType.getSecondVolType().equals(pdShareTypeName) || !shareType.getPrimaryAzId().equals(drAzName)) continue;
            return Optional.of(shareType.getPrimaryVolType());
        }
        return Optional.empty();
    }
}

