/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class UpdateVolTypeMappingTask
extends TimerTask {
    private static final Log LOG = LogFactory.getInstance(UpdateVolTypeMappingTask.class);
    private final Timer timer;

    public UpdateVolTypeMappingTask(Timer timer) {
        this.timer = timer;
    }

    @Override
    public void run() {
        String openStackUuid;
        LOG.info((Object)"Execute UpdateVolTypeMappingTask.");
        FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
        if (openstack == null) {
            LOG.error((Object)"Openstack is null, do nothing this time.");
            return;
        }
        IOpenstackResourceService openstackResourceService = (IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class);
        List volMappingList = openstackResourceService.getVolTypeMappingsFromDB(openStackUuid = openstack.getUuid());
        if (this.checkIfNeedUpdate(volMappingList)) {
            ArrayList<OpenStackAvailabilityZoneMapping> azMappingList = openstackResourceService.getAvailabilityZoneMappingsFromDB(openStackUuid);
            if (azMappingList == null) {
                azMappingList = new ArrayList<OpenStackAvailabilityZoneMapping>();
            }
            this.updateDBConfig(openstackResourceService, openStackUuid, volMappingList, azMappingList);
        }
        LOG.info((Object)"Execute updateVolTypeMappingTask done.");
        this.timer.cancel();
        this.timer.purge();
        LOG.info((Object)"Exit updateVolTypeMappingTask done.");
    }

    private void updateDBConfig(IOpenstackResourceService openstackResourceService, String openStackUuid, List<OpenStackVolTypeMapping> volMappingList, List<OpenStackAvailabilityZoneMapping> azMappingList) {
        ArrayList<OpenStackVolTypeMapping> insertMappingList = new ArrayList<OpenStackVolTypeMapping>();
        ArrayList<OpenStackVolTypeMapping> updateMappingList = new ArrayList<OpenStackVolTypeMapping>();
        this.updateVolTypePriority(volMappingList);
        for (OpenStackVolTypeMapping volMapping : volMappingList) {
            boolean isUpdateOnce = false;
            for (OpenStackAvailabilityZoneMapping azMapping : azMappingList) {
                OpenStackVolTypeMapping newVolMapping;
                if (this.buildVolTypeMapping(volMapping, azMapping, newVolMapping = new OpenStackVolTypeMapping())) continue;
                if (isUpdateOnce) {
                    newVolMapping.setUuid(openStackUuid + ":" + this.getRandom());
                    insertMappingList.add(newVolMapping);
                    continue;
                }
                newVolMapping.setUuid(volMapping.getUuid());
                newVolMapping.setMoId(volMapping.getMoId());
                updateMappingList.add(newVolMapping);
                isUpdateOnce = true;
            }
        }
        if (!VerifyUtil.isEmpty(insertMappingList)) {
            openstackResourceService.saveVolTypeMappingInDB(insertMappingList);
        }
        if (!VerifyUtil.isEmpty(updateMappingList)) {
            openstackResourceService.updateVolTypeMappingInDB(updateMappingList);
        }
        LOG.info((Object)"UpdateDBConfig done: insert %s, update: %s.", new Object[]{insertMappingList.size(), updateMappingList.size()});
    }

    private boolean buildVolTypeMapping(OpenStackVolTypeMapping volMapping, OpenStackAvailabilityZoneMapping azMapping, OpenStackVolTypeMapping newVolMapping) {
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(azMapping.getType()) && volMapping.getType().equals(ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue())) {
            newVolMapping.setPrimaryAzId(OpenStackVolTypeMapping.getMappingAzId((String)azMapping.getPrimaryRegionId(), (String)azMapping.getPrimaryAzId()));
            newVolMapping.setSecondAzId(OpenStackVolTypeMapping.getMappingAzId((String)azMapping.getPrimaryRegionId(), (String)azMapping.getPrimaryAzId()));
            newVolMapping.setPrimaryVolType(volMapping.getPrimaryVolType());
            newVolMapping.setSecondVolType(volMapping.getSecondVolType());
            newVolMapping.setType(volMapping.getType());
            newVolMapping.setPriority(volMapping.getPriority());
        } else {
            if (!this.isMatch(volMapping, azMapping)) {
                return true;
            }
            this.buildVolMaping(volMapping, azMapping, newVolMapping);
        }
        return false;
    }

    private void updateVolTypePriority(List<OpenStackVolTypeMapping> volMappingList) {
        AtomicInteger ii = new AtomicInteger(1);
        volMappingList.stream().filter(vol -> vol.getType().equals(ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue())).forEach(vol -> {
            vol.setPriority(ii.get());
            ii.getAndIncrement();
        });
        AtomicInteger jj = new AtomicInteger(1);
        volMappingList.stream().filter(vol -> vol.getType().equals(ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getFrontValue())).forEach(vol -> {
            vol.setPriority(jj.get());
            jj.getAndIncrement();
        });
    }

    private void buildVolMaping(OpenStackVolTypeMapping volMapping, OpenStackAvailabilityZoneMapping azMapping, OpenStackVolTypeMapping newVolMapping) {
        newVolMapping.setPrimaryAzId(OpenStackVolTypeMapping.getMappingAzId((String)azMapping.getPrimaryRegionId(), (String)volMapping.getPrimaryAzId()));
        newVolMapping.setSecondAzId(OpenStackVolTypeMapping.getMappingAzId((String)azMapping.getSecondRegionId(), (String)volMapping.getSecondAzId()));
        newVolMapping.setPrimaryVolType(volMapping.getPrimaryVolType());
        newVolMapping.setSecondVolType(volMapping.getSecondVolType());
        newVolMapping.setPriority(volMapping.getPriority());
        newVolMapping.setType(volMapping.getType());
    }

    private boolean isMatch(OpenStackVolTypeMapping volMapping, OpenStackAvailabilityZoneMapping azMapping) {
        if (VerifyUtil.isEmpty((String)volMapping.getType()) || VerifyUtil.isEmpty((String)volMapping.getPrimaryAzId()) || VerifyUtil.isEmpty((String)volMapping.getSecondAzId())) {
            return false;
        }
        return volMapping.getType().equals(azMapping.getType()) && volMapping.getPrimaryAzId().equals(azMapping.getPrimaryAzId()) && volMapping.getSecondAzId().equals(azMapping.getSecondAzId());
    }

    private boolean checkIfNeedUpdate(List<OpenStackVolTypeMapping> volMappingList) {
        if (VerifyUtil.isEmpty(volMappingList)) {
            return false;
        }
        for (OpenStackVolTypeMapping volTypeMapping : volMappingList) {
            if (!this.checkAzIdUpdate(volTypeMapping) && !this.checkVhaVolType(volTypeMapping)) continue;
            return true;
        }
        return false;
    }

    private boolean checkVhaVolType(OpenStackVolTypeMapping volTypeMapping) {
        return ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(volTypeMapping.getType()) && (VerifyUtil.isEmpty((String)volTypeMapping.getPrimaryAzId()) || VerifyUtil.isEmpty((String)volTypeMapping.getSecondAzId()));
    }

    private boolean checkAzIdUpdate(OpenStackVolTypeMapping volTypeMapping) {
        return !ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(volTypeMapping.getType()) && !VerifyUtil.isEmpty((String)volTypeMapping.getPrimaryAzId()) && !VerifyUtil.isEmpty((String)volTypeMapping.getSecondAzId()) && (!volTypeMapping.getPrimaryAzId().contains("_@_") || !volTypeMapping.getSecondAzId().contains("_@_"));
    }

    private String getRandom() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() == 1) {
                hv = "0" + hv;
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }
}

