/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.checker;

import com.google.common.cache.Cache;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.protection.service.UpdateProtectedVolumeBackTask;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstChecker;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class EvsServiceInstanceChecker
implements IServiceInstChecker {
    private static final Log LOG = LogFactory.getInstance(EvsServiceInstanceChecker.class);

    public void check(CheckContext context) {
        if (!this.checkValid(context)) {
            return;
        }
        this.checkVolumeExistUpdateName(context);
        this.checkCgId(context);
        this.checkCgReplicaStatusAndUpdate(context);
        this.checkAndUpdateProtectObject(context, context.getPg());
        this.checkAndUpdateProtectGroup(context);
    }

    private boolean checkValid(CheckContext context) {
        if (context.getInstanceInst() == null || context.getPg() == null) {
            LOG.warn((Object)"ProtectGroup is null or serviceInstance is null.");
            return false;
        }
        if (context.getPg().getPoType() != 22 || !ServiceInstaceEnumDefine.ObjectType.EVS.getValue().equals(context.getPg().getObjectType())) {
            LOG.warn((Object)"ProtectGroup(%s) is not EVS disk pg.", new Object[]{context.getPg().getUuid()});
            return false;
        }
        if (!ServiceInstaceEnumDefine.ObjectType.EVS.getValue().equals(context.getInstanceInst().getObjectType())) {
            LOG.warn((Object)"ServiceInstance(%s) is null or not EVS disk instance.", new Object[]{context.getInstanceInst().getUuid()});
            return false;
        }
        Set poList = context.getPg().getPolist();
        if (VerifyUtil.isEmpty((Collection)poList)) {
            LOG.error((Object)"ProtectGroup(%s) has no any protectObject.", new Object[]{context.getPg().getUuid()});
            throw new LegoCheckedException(2117645L);
        }
        return true;
    }

    private void checkAndUpdateProtectObject(CheckContext context, ProtectGroup protectGroup) {
        Set abnormalPoUuidSet = context.getAbnormalPoUuidSet();
        for (ProtectObject po : protectGroup.getPolist()) {
            if (abnormalPoUuidSet.contains(po.getUuid())) {
                po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
                continue;
            }
            po.setPoStatus(ProtectObjectStatusEnum.VALID.getValue());
        }
    }

    private void checkAndUpdateProtectGroup(CheckContext context) {
        if (VerifyUtil.isEmpty((Collection)context.getAbnormalPoUuidSet()) && VerifyUtil.isEmpty((Collection)context.getCgStatusErrorIds())) {
            context.getPg().setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
        } else {
            context.getPg().setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
        }
    }

    private void checkVolumeExistUpdateName(CheckContext context) {
        ProtectGroup protectGroup = context.getPg();
        UrlBaseParams prodUrlBaseParams = this.initProdUrlBaseParams(protectGroup);
        UrlBaseParams drUrlBaseParams = this.initDrUrlBaseParams(protectGroup);
        Set abnormalPoUuidSet = context.getAbnormalPoUuidSet();
        HashMap<String, String> prodAndDrVolumeId = new HashMap<String, String>();
        this.getProdAndDrVolumeId(prodAndDrVolumeId, protectGroup, abnormalPoUuidSet);
        HashMap<String, OpenStackVolume> allVolumeMap = new HashMap<String, OpenStackVolume>();
        this.queryVolumes(protectGroup, allVolumeMap, prodUrlBaseParams, new ArrayList<String>(prodAndDrVolumeId.keySet()));
        this.queryVolumes(protectGroup, allVolumeMap, drUrlBaseParams, new ArrayList<String>(prodAndDrVolumeId.values()));
        for (ProtectObject po : protectGroup.getPolist()) {
            if (abnormalPoUuidSet.contains(po.getUuid())) continue;
            if (!this.checkProdVolumeExistAndUpdateName(prodUrlBaseParams.getRegionUuid(), allVolumeMap, abnormalPoUuidSet, po)) {
                LOG.error((Object)"The prod volume id of the ProtectObject(%s) in the ProtectGroup(%s) is not found.", new Object[]{po.getUuid(), protectGroup.getUuid()});
                continue;
            }
            this.checkDrVolumeExistAndUpdateName(drUrlBaseParams.getRegionUuid(), allVolumeMap, abnormalPoUuidSet, po);
        }
    }

    private void getProdAndDrVolumeId(HashMap<String, String> prodAndDrVolumeId, ProtectGroup protectGroup, Set<String> abnormalPoUuidSet) {
        for (ProtectObject po : protectGroup.getPolist()) {
            PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
            if (poReplicaInfo == null || VerifyUtil.isEmpty((Collection)poReplicaInfo.getPairInfos())) {
                abnormalPoUuidSet.add(po.getUuid());
                LOG.error((Object)"The PoReplicaInfo of the ProtectObject(%s) is not configured.", new Object[]{po.getUuid()});
                continue;
            }
            String drVolumeUuid = ((PoReplicaPairInfo)poReplicaInfo.getPairInfos().iterator().next()).getDrVolumeUuid();
            prodAndDrVolumeId.put(OpenStackCommonUtil.getIdFromUuid(po.getMoUuid()), OpenStackCommonUtil.getIdFromUuid(drVolumeUuid));
        }
    }

    private void checkDrVolumeExistAndUpdateName(String regionUuid, HashMap<String, OpenStackVolume> allVolumeMap, Set<String> abnormalPoUuidSet, ProtectObject po) {
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
        PoReplicaPairInfo poReplicaPairInfo = (PoReplicaPairInfo)poReplicaInfo.getPairInfos().iterator().next();
        String drVolumeKey = regionUuid + poReplicaPairInfo.getDrVolumeUuid();
        if (!allVolumeMap.containsKey(drVolumeKey)) {
            abnormalPoUuidSet.add(po.getUuid());
            LOG.error((Object)"The dr volume id in the ProtectObject(%s) is not found.", new Object[]{po.getUuid()});
            return;
        }
        poReplicaPairInfo.setDrVolumeName(allVolumeMap.get(drVolumeKey).getName());
        po.setProperty("replicationInfo", (Object)poReplicaInfo);
    }

    private boolean checkProdVolumeExistAndUpdateName(String regionUuid, HashMap<String, OpenStackVolume> allVolumeMap, Set<String> abnormalPoUuidSet, ProtectObject po) {
        String prodVolumeKey = regionUuid + po.getMoUuid();
        if (!allVolumeMap.containsKey(prodVolumeKey)) {
            abnormalPoUuidSet.add(po.getUuid());
            return false;
        }
        po.setName(allVolumeMap.get(prodVolumeKey).getName());
        return true;
    }

    private void queryVolumes(ProtectGroup pg, HashMap<String, OpenStackVolume> allVolumeMap, UrlBaseParams urlBaseParams, List<String> volumeIds) {
        String regionUuid = urlBaseParams.getRegionUuid();
        String projUuid = urlBaseParams.getProjectUuid();
        String tokenId = urlBaseParams.getTokenId();
        if (!this.checkIsManualRefresh(pg)) {
            this.queryAllVolumesByRegionIdAndProjectId(allVolumeMap, regionUuid, projUuid, tokenId);
        } else {
            this.queryVolumesByVolumeId(allVolumeMap, volumeIds, regionUuid, projUuid);
        }
    }

    private void queryVolumesByVolumeId(HashMap<String, OpenStackVolume> allVolumeMap, List<String> volumeIds, String regionUuid, String projUuid) {
        CinderManager cinderMgr = new CinderManager();
        Map<String, OpenStackVolume> volumeMap = cinderMgr.queryOpenStackVolumes(regionUuid, projUuid, volumeIds);
        for (Map.Entry<String, OpenStackVolume> entry : volumeMap.entrySet()) {
            allVolumeMap.put(regionUuid + entry.getValue().getUuid(), entry.getValue());
        }
    }

    private void queryAllVolumesByRegionIdAndProjectId(HashMap<String, OpenStackVolume> allVolumeMap, String regionUuid, String projUuid, String tokenId) {
        try {
            CinderManager cinderMgr = new CinderManager();
            Cache<String, Object> cache = OpenstackCache.getCacheMap().get((Object)OpenstackCache.CacheType.OPENSTACK_VOLUME_LIST);
            List volumes = (List)cache.get((Object)(regionUuid + projUuid), () -> {
                List<OpenStackVolume> queryVolumes = cinderMgr.queryAllOpenStackVolumes(regionUuid, tokenId, projUuid);
                if (!VerifyUtil.isEmpty(queryVolumes)) {
                    cache.put((Object)(regionUuid + projUuid), queryVolumes);
                }
                return queryVolumes;
            });
            for (OpenStackVolume volume : volumes) {
                allVolumeMap.put(regionUuid + volume.getUuid(), volume);
            }
        }
        catch (ExecutionException e) {
            LOG.error((Object)"Failed to get volume infos to cache:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Failed to get volume infos to cache");
        }
    }

    private UrlBaseParams initProdUrlBaseParams(ProtectGroup pg) {
        String projUuid = (String)pg.getProps().get("projectId");
        String regionUuid = (String)pg.getProps().get("regionId");
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        return new UrlBaseParams(projUuid, regionUuid, tokenId);
    }

    private UrlBaseParams initDrUrlBaseParams(ProtectGroup pg) {
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        return new UrlBaseParams(drProjUuid, drRegionUuid, drTokenId);
    }

    private void checkCgReplicaStatusAndUpdate(CheckContext context) {
        String replicaStatus = this.queryReplicaStatus(context);
        this.checkReplicaStatusAndUpdate(context.getPg(), context, replicaStatus);
    }

    private void checkReplicaStatusAndUpdate(ProtectGroup pg, CheckContext context, String replicaStatus) {
        if (!OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(replicaStatus) && !OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue().equals(replicaStatus)) {
            context.getCgStatusErrorIds().add(pg.getProps().get("replicaCgUuid"));
            LOG.error((Object)"The replica status(%s) of the ProtectGroup(%s) not active or copying.", new Object[]{replicaStatus, pg.getUuid()});
        }
        pg.getProps().put("replicaCgRepStatus", replicaStatus);
    }

    private String queryReplicaStatus(CheckContext context) {
        ProtectGroup pg = context.getPg();
        String optCGUuid = (String)pg.getProps().get("replicaCgUuid");
        UrlBaseParams prodUrlBaseParams = this.initProdUrlBaseParams(pg);
        Optional<VolumeReplicationCgInfo> cgInfoOptional = this.queryCgInfo(pg.getPoProviderSN(), prodUrlBaseParams, (String)pg.getProps().get("replicaCgUuid"));
        if (!cgInfoOptional.isPresent()) {
            LOG.error((Object)"The prod cgUuid(%s) in the ProtectGroup(%s) not exist or cgInfo cannot be found.", new Object[]{optCGUuid, pg.getUuid()});
            return OpenstackEnumDefine.ReplicationRepStatusE.ERROR.getValue();
        }
        VolumeReplicationCgInfo cgInfo = cgInfoOptional.get();
        if (!OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(cgInfo.getStatus())) {
            LOG.error((Object)"The cgInfo(%s) in the ProtectGroup(%s), status error: %s", new Object[]{cgInfo.getId(), pg.getUuid(), cgInfo.getStatus()});
            return OpenstackEnumDefine.ReplicationRepStatusE.ERROR.getValue();
        }
        return this.queryDRReplicaStatus(cgInfo.getReplicationStatus(), pg);
    }

    private Optional<VolumeReplicationCgInfo> queryCgInfo(String poProviderSN, UrlBaseParams prodUrlBaseParams, String cgUuid) {
        if (VerifyUtil.isEmpty((String)cgUuid)) {
            LOG.error((Object)"Pg have no cgUuid: %s", new Object[]{cgUuid});
            return Optional.empty();
        }
        IDrExtendManager drExtendManager = ManagerFactory.getInstance().getDrExtendManager(poProviderSN);
        VolumeReplicationCgInfo cgInfo = drExtendManager.queryRealtimeVolumeReplicationCG(prodUrlBaseParams.getRegionUuid(), prodUrlBaseParams.getTokenId(), prodUrlBaseParams.getProjectUuid(), cgUuid, new int[0]);
        return Optional.ofNullable(cgInfo);
    }

    private String queryDRReplicaStatus(String primaryReplicaStatus, ProtectGroup pg) {
        if (!OpenstackEnumDefine.ReplicationRepStatusE.UNKNOWN.getValue().equals(primaryReplicaStatus)) {
            return primaryReplicaStatus;
        }
        String optDrCGUuid = (String)pg.getProps().get("drReplicaCgUuid");
        UrlBaseParams drUrlBaseParams = this.initDrUrlBaseParams(pg);
        Optional<VolumeReplicationCgInfo> cgInfoOptional = this.queryCgInfo(pg.getPoProviderSN(), drUrlBaseParams, optDrCGUuid);
        if (!cgInfoOptional.isPresent()) {
            LOG.error((Object)"The dr cgUuid(%s) in the ProtectGroup(%s) not exist or cgInfo cannot be found.", new Object[]{optDrCGUuid, pg.getUuid()});
            return OpenstackEnumDefine.ReplicationRepStatusE.ERROR.getValue();
        }
        return cgInfoOptional.get().getReplicationStatus();
    }

    private void checkCgId(CheckContext context) {
        ProtectGroup pg = context.getPg();
        String replicaModel = UpdateProtectedVolumeBackTask.getReplicaModel(pg.getTemplate().getType());
        if (VerifyUtil.isEmpty((String)replicaModel)) {
            return;
        }
        String cgUuid = (String)pg.getProps().get("replicaCgUuid");
        if (VerifyUtil.isEmpty((String)cgUuid)) {
            LOG.error((Object)"Pg(%s) have no cgUuid.", new Object[]{pg.getName()});
            return;
        }
        String cgId = OpenStackCommonUtil.getIdFromUuid(cgUuid);
        Set abnormalPoUuidSet = context.getAbnormalPoUuidSet();
        Map<String, VolumeReplicationInfo> replicationInfoMap = this.getVolumeReplicationInfoMap(pg, replicaModel);
        this.checkVolumeNotInCg(pg, cgId, abnormalPoUuidSet, replicationInfoMap);
    }

    private Map<String, VolumeReplicationInfo> getVolumeReplicationInfoMap(ProtectGroup pg, String replicaModel) {
        List replicationInfos;
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        IDrExtendManager drExtendManager = ManagerFactory.getInstance().getDrExtendManager(pg.getPoProviderSN());
        if (!this.checkIsManualRefresh(pg)) {
            try {
                Cache<String, Object> cache = OpenstackCache.getCacheMap().get((Object)OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST);
                replicationInfos = (List)cache.get((Object)(regionUuid + projUuid), () -> {
                    List<VolumeReplicationInfo> replicationInfos0 = drExtendManager.getVolumeReplications(regionUuid, tokenId, projUuid, null, false);
                    if (replicationInfos0 != null) {
                        cache.put((Object)(regionUuid + projUuid), replicationInfos0);
                    }
                    return replicationInfos0;
                });
            }
            catch (ExecutionException e) {
                LOG.error((Object)"Failed to get replication infos to cache:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Failed to get replication infos to cache");
            }
        } else {
            replicationInfos = drExtendManager.getVolumeReplications(regionUuid, tokenId, projUuid, null, false);
        }
        HashMap<String, VolumeReplicationInfo> replicationInfoMap = new HashMap<String, VolumeReplicationInfo>();
        for (VolumeReplicationInfo volumeReplicationInfo : replicationInfos) {
            if (!replicaModel.equals(volumeReplicationInfo.getReplicaModel())) continue;
            replicationInfoMap.put(volumeReplicationInfo.getVolumeId(), volumeReplicationInfo);
        }
        return replicationInfoMap;
    }

    private boolean checkIsManualRefresh(ProtectGroup pg) {
        String isManualRefresh = pg.getProperty("isManualRefresh");
        return VerifyUtil.isEmpty((String)isManualRefresh) || String.valueOf(1).equals(isManualRefresh);
    }

    private void checkVolumeNotInCg(ProtectGroup pg, String cgId, Set<String> abnormalPoUuidSet, Map<String, VolumeReplicationInfo> replicationInfoMap) {
        for (ProtectObject po : pg.getPolist()) {
            if (abnormalPoUuidSet.contains(po.getUuid())) continue;
            String volumeId = OpenStackCommonUtil.getIdFromUuid(po.getMoUuid());
            VolumeReplicationInfo volumeReplicationInfo = replicationInfoMap.get(volumeId);
            if (VerifyUtil.isEmpty((Object)volumeReplicationInfo)) {
                abnormalPoUuidSet.add(po.getUuid());
                LOG.error((Object)"The replication information of po(%s) in the ProtectGroup(%s) is not found.", new Object[]{po.getUuid(), pg.getUuid()});
                continue;
            }
            if (cgId.equals(volumeReplicationInfo.getReplicationcgId())) continue;
            abnormalPoUuidSet.add(po.getUuid());
            LOG.error((Object)"The cgId of the po(%s) in the ProtectGroup(%s) is inconsistent with that found in.", new Object[]{po.getUuid(), pg.getUuid()});
        }
    }
}

