/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.checker;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsManilaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.bo.FileSystem;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.SharePair;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstChecker;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.compress.utils.Sets;

public class ShareChecker
implements IServiceInstChecker {
    private static final Log LOG = LogFactory.getInstance(ShareChecker.class);
    private static final ISfsManilaManager SFS_MANILA_MANAGER = ManagerFactory.getInstance().getSfsManilaManager();
    private static final ISfsFilemeterManager FILEMETER_MANAGER = ManagerFactory.getInstance().getSfsFilemeterManager();
    private static final Set<String> SHAREPAIR_ABNORMAL_RUNNING_STATUS_SET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{OpenstackEnumDefine.SharePairRunningStatus.UNKNOWN.getValue(), OpenstackEnumDefine.SharePairRunningStatus.INVALID.getValue(), OpenstackEnumDefine.SharePairRunningStatus.PAUSE.getValue(), OpenstackEnumDefine.SharePairRunningStatus.DELETEING.getValue()}));
    private static final Set<String> SHAREPAIR_ABNORMAL_HEALTH_STATUS_SET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{OpenstackEnumDefine.SharePairHealthStatus.UNKNOWN.getValue(), OpenstackEnumDefine.SharePairHealthStatus.FAULTY.getValue()}));
    private static final Set<String> SHAREPAIR_ABNORMAL_LINK_STATUS_SET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{OpenstackEnumDefine.SharePairLinkStatus.DISCONNECTED.getValue()}));

    public void check(CheckContext context) {
        if (context.getPg().getPoType() != 17 || !ServiceInstaceEnumDefine.ObjectType.SFS.getValue().equals(context.getPg().getObjectType())) {
            LOG.warn((Object)"ProtectGroup(%s) is not SFS pg.", new Object[]{context.getPg().getUuid()});
            return;
        }
        if (context.getInstanceInst() == null || !ServiceInstaceEnumDefine.ObjectType.SFS.getValue().equals(context.getInstanceInst().getObjectType())) {
            LOG.warn((Object)"ServiceInstance of ProtectGroup(%s) is null or not SFS instance.", new Object[]{context.getPg().getUuid()});
            return;
        }
        Set poList = context.getPg().getPolist();
        if (VerifyUtil.isEmpty((Collection)poList)) {
            LOG.error((Object)"ProtectGroup(%s) has no any protectObject.", new Object[]{context.getPg().getUuid()});
            throw new LegoCheckedException(2117645L);
        }
        for (ProtectObject po : poList) {
            Share pdShare = (Share)JSONObject.toBean((String)po.getProperty("pd_share"), Share.class);
            Share drShare = (Share)JSONObject.toBean((String)po.getProperty("dr_share"), Share.class);
            SharePair sharePair = (SharePair)JSONObject.toBean((String)po.getProperty("share_pair"), SharePair.class);
            if (pdShare == null || drShare == null || sharePair == null) {
                LOG.error((Object)"PdShare or DrShare from protectObject(%s) of protectGroup(%s) is null.", new Object[]{po.getUuid(), context.getPg().getUuid()});
                continue;
            }
            UrlBaseParams pdUrlBaseParams = this.initPdUrlBaseParams(context.getPg());
            UrlBaseParams drUrlBaseParams = this.initDrUrlBaseParams(context.getPg());
            this.checkAndUpdateFileSystem(context, po, pdUrlBaseParams, pdShare.getId(), "local_file_system");
            this.checkAndUpdateFileSystem(context, po, drUrlBaseParams, drShare.getId(), "remote_file_system");
            this.checkAndUpdateShare(context, po, pdUrlBaseParams, pdShare.getId(), "pd_share");
            this.checkAndUpdateShare(context, po, drUrlBaseParams, drShare.getId(), "dr_share");
            this.checkAndUpdateSharePair(context, po, pdUrlBaseParams, sharePair.getSharePairId());
            this.checkAndUpdateProtectObject(context, po);
            this.checkAndUpdateProtectGroup(context);
        }
    }

    private UrlBaseParams initPdUrlBaseParams(ProtectGroup pg) {
        String projUuid = (String)pg.getProps().get("projectId");
        String regionUuid = (String)pg.getProps().get("regionId");
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        return new UrlBaseParams(projUuid, regionUuid, tokenId);
    }

    private UrlBaseParams initDrUrlBaseParams(ProtectGroup pg) {
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        return new UrlBaseParams(drProjUuid, drRegionUuid, drTokenId);
    }

    private void checkAndUpdateFileSystem(CheckContext context, ProtectObject po, UrlBaseParams baseParams, String shareId, String poKey) {
        if (context.getAbnormalPoUuidSet().contains(po.getUuid())) {
            return;
        }
        FileSystem remoteFileSystem = FILEMETER_MANAGER.getPdFileSystemByShareId(baseParams, shareId);
        if (remoteFileSystem == null) {
            LOG.error((Object)"Query FileSystem by fileMeterManager from po(%s) of pg(%s) is null, shareId(%s).", new Object[]{po.getUuid(), context.getPg().getUuid(), shareId});
            context.getAbnormalPoUuidSet().add(po.getUuid());
        }
        po.setProperty(poKey, (Object)JSONObject.fromObject((Object)remoteFileSystem).toString());
    }

    private void checkAndUpdateShare(CheckContext context, ProtectObject po, UrlBaseParams baseParams, String shareId, String poKey) {
        if (context.getAbnormalPoUuidSet().contains(po.getUuid())) {
            return;
        }
        Share remoteShare = SFS_MANILA_MANAGER.queryShareById(baseParams, shareId);
        if (remoteShare == null) {
            LOG.error((Object)"Query Share by sfsManilaManager of pg(%s) is null, shareId(%s).", new Object[]{context.getPg().getUuid(), shareId});
            return;
        }
        po.setProperty(poKey, (Object)JSONObject.fromObject((Object)remoteShare).toString());
    }

    private void checkAndUpdateSharePair(CheckContext context, ProtectObject po, UrlBaseParams baseParams, String localSharePairId) {
        if (context.getAbnormalPoUuidSet().contains(po.getUuid())) {
            return;
        }
        SharePair remoteSharePair = FILEMETER_MANAGER.querySharePairById(baseParams, localSharePairId);
        if (remoteSharePair == null) {
            LOG.error((Object)"Query SharePair by fileMeterManager from po(%s) of pg(%s) is null, sharePairId(%s).", new Object[]{po.getUuid(), context.getPg().getUuid(), localSharePairId});
            context.getAbnormalPoUuidSet().add(po.getUuid());
            return;
        }
        po.setProperty("share_pair", (Object)JSONObject.fromObject((Object)remoteSharePair).toString());
        if (this.isShairPairStatusAbnormal(remoteSharePair)) {
            context.getAbnormalPoUuidSet().add(po.getUuid());
        }
    }

    private boolean isShairPairStatusAbnormal(SharePair remoteSharePair) {
        if (VerifyUtil.isEmpty((String)remoteSharePair.getRunningStatus())) {
            return true;
        }
        if (VerifyUtil.isEmpty((String)remoteSharePair.getHealthStatus())) {
            return true;
        }
        if (VerifyUtil.isEmpty((String)remoteSharePair.getLinkStatus())) {
            return true;
        }
        return SHAREPAIR_ABNORMAL_RUNNING_STATUS_SET.contains(remoteSharePair.getRunningStatus()) || SHAREPAIR_ABNORMAL_HEALTH_STATUS_SET.contains(remoteSharePair.getHealthStatus()) || SHAREPAIR_ABNORMAL_LINK_STATUS_SET.contains(remoteSharePair.getLinkStatus());
    }

    private void checkAndUpdateProtectObject(CheckContext context, ProtectObject po) {
        if (context.getAbnormalPoUuidSet().contains(po.getUuid())) {
            po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
        } else {
            po.setPoStatus(ProtectObjectStatusEnum.VALID.getValue());
        }
    }

    private void checkAndUpdateProtectGroup(CheckContext context) {
        if (context.getAbnormalPoUuidSet().isEmpty()) {
            context.getPg().setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
        } else {
            context.getPg().setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
        }
    }
}

