/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.checker;

import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackConsts;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolAttachment;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstChecker;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class VmVolumCheckChecker
implements IServiceInstChecker {
    private static final Log LOG = LogFactory.getInstance(VmVolumCheckChecker.class);

    public void check(CheckContext context) {
        LOG.debug((Object)"Check vm volume.");
        ProtectGroup pg = context.getPg();
        try {
            Set unSupportedVmUuids = context.getUnSupportedPoUuids();
            Set volDelVmUuids = context.getVolDelVmUuids();
            Set volAddVmUuids = context.getVolAddVmUuids();
            this.updateProtectGroupVolum(context, pg, unSupportedVmUuids, volDelVmUuids, volAddVmUuids);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Failed to update protectobject in Group(" + pg.getName() + ") by consistence rules." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update protectobject in Group(" + pg.getName() + ") by unexpected exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            ExceptionUtil.rethrowException((Exception)e, (String)"fail to refresh pg", (long)0x300001L, (String[])new String[0]);
        }
    }

    private void updateProtectGroupVolum(CheckContext context, ProtectGroup protectGroup, Set<String> unSupportedPoUuids, Set<String> volDelVmUuids, Set<String> volAddVmUuids) {
        HashSet<String> protectedVolUuids = new HashSet<String>();
        String[] uuids = this.getVmUuids(protectGroup.getPolist());
        Map<String, List<OpenStackVolume>> vmAndVolInfo = this.getVmAndVolInfoMap(protectGroup, uuids, protectedVolUuids);
        if (VerifyUtil.isEmpty(vmAndVolInfo)) {
            LOG.error((Object)"VmList in region(%s) is empty,", new Object[]{protectGroup.getProps().get("regionName")});
            return;
        }
        Map<String, PoReplicaPairInfo> protectedVolReplica = this.getUesdProtectedVolAndReplication(protectGroup, protectedVolUuids);
        Map<String, PoReplicaPairInfo> hyperAndRemoteReplicaMap = this.getProtectedVolAndReplication(protectGroup, protectedVolReplica);
        this.updateVolumeMetadata(context, vmAndVolInfo, protectedVolReplica);
        for (ProtectObject po : protectGroup.getPolist()) {
            if ("true".equals(po.getProps().get("TOBEDELETED")) || "true".equals(po.getProps().get("OBJ_DELETE_ERROR"))) continue;
            String moUuid = po.getMoUuid();
            if (!vmAndVolInfo.keySet().contains(moUuid)) {
                LOG.error((Object)("VM don't use any volume:" + po.getName()));
                po.setPoStatus(ProtectObjectStatusEnum.UNSUPPORTED.getValue());
                this.updatePoProps(po, new ArrayList<OpenStackVolume>(), protectedVolReplica, volDelVmUuids, volAddVmUuids, hyperAndRemoteReplicaMap);
                unSupportedPoUuids.add(moUuid);
                continue;
            }
            List<OpenStackVolume> vmUsedVols = vmAndVolInfo.get(moUuid);
            this.updatePoProps(po, vmUsedVols, protectedVolReplica, volDelVmUuids, volAddVmUuids, hyperAndRemoteReplicaMap);
            if (volAddVmUuids.contains(po.getMoUuid())) continue;
            po.setPoStatus(ProtectObjectStatusEnum.VALID.getValue());
        }
    }

    private Map<String, PoReplicaPairInfo> getProtectedVolAndReplication(ProtectGroup protectGroup, Map<String, PoReplicaPairInfo> protectedVolReplica) {
        HashMap<String, PoReplicaPairInfo> result = new HashMap<String, PoReplicaPairInfo>();
        if (34 != protectGroup.getTemplate().getType() && 37 != protectGroup.getTemplate().getType()) {
            return result;
        }
        HashSet<String> hyperUuidSet = new HashSet<String>();
        for (ProtectObject po : protectGroup.getPolist()) {
            PoReplicaInfo hyperPoReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
            for (PoReplicaPairInfo pairInfo : hyperPoReplicaInfo.getPairInfos()) {
                if (!protectedVolReplica.keySet().contains(pairInfo.getVolumeUuid()) || !OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) && !OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus().equals(pairInfo.getVolumeStatus())) continue;
                result.put(pairInfo.getVolumeUuid(), pairInfo);
                hyperUuidSet.add(pairInfo.getDrVolumeUuid());
            }
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            PoReplicaInfo remotePoReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
            for (PoReplicaPairInfo pairInfo : remotePoReplicaInfo.getPairInfos()) {
                if (!hyperUuidSet.contains(pairInfo.getVolumeUuid())) continue;
                result.put(pairInfo.getVolumeUuid(), pairInfo);
            }
        }
        return result;
    }

    private void updatePoProps(ProtectObject po, List<OpenStackVolume> volumeSet, Map<String, PoReplicaPairInfo> protectedVolReplica, Set<String> volDelVmUuids, Set<String> voladdVmUuids, Map<String, PoReplicaPairInfo> hyperAndRemoteReplicaMap) {
        String poReplicaInfoStr = (String)po.getProps().get("replicationInfo");
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaInfoStr, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            LOG.error((Object)("PoReplicaInfo json to bean failed:poReplicaInfoStr=" + poReplicaInfoStr));
            return;
        }
        ArrayList<PoReplicaPairInfo> delPairs = new ArrayList<PoReplicaPairInfo>();
        this.getBeenRemovedVols(po, volumeSet, protectedVolReplica, volDelVmUuids, poReplicaInfo, delPairs);
        this.deleteHypermetorReplicationInfo(po, delPairs);
        this.deleteRemoteReplicationInfo(po, delPairs);
        poReplicaInfo.getPairInfos().removeAll(delPairs);
        this.delStorageInfo(po, delPairs);
        for (OpenStackVolume volume : volumeSet) {
            boolean isAddVol = true;
            PoReplicaPairInfo addPairInfo = null;
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                LOG.debug((Object)"PairInfovolumuuid:%s", new Object[]{pairInfo.getVolumeUuid()});
                if (!volume.getUuid().equals(pairInfo.getVolumeUuid())) continue;
                if (OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) || OpenstackEnumDefine.VolProtectStatusE.CONFIGING.getStatus().equals(pairInfo.getVolumeStatus())) {
                    addPairInfo = pairInfo;
                    isAddVol = true;
                    break;
                }
                if (OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus().equals(pairInfo.getVolumeStatus())) {
                    pairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
                }
                isAddVol = false;
                break;
            }
            if (!isAddVol) continue;
            this.updatePairInfoOfAddedVolume(po, protectedVolReplica, voladdVmUuids, poReplicaInfo, volume, addPairInfo);
            this.updatePairInfoOfAddedVolume(po, protectedVolReplica, volume, hyperAndRemoteReplicaMap);
        }
        po.getProps().put("replicationInfo", JsonUtil.beanToJson(poReplicaInfo));
        this.refreshVolCfg(po, poReplicaInfo);
        this.refreshDrHyperType(po);
    }

    private void deleteHypermetorReplicationInfo(ProtectObject po, List<PoReplicaPairInfo> delPairs) {
        PoReplicaInfo poHypermetorReplicationInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
        if (!VerifyUtil.isEmpty((Object)poHypermetorReplicationInfo)) {
            List poHypermetorReplicaPairList = poHypermetorReplicationInfo.getPairInfos();
            for (PoReplicaPairInfo poReplicaPairInfo : delPairs) {
                Iterator iterator = poHypermetorReplicaPairList.iterator();
                while (iterator.hasNext()) {
                    PoReplicaPairInfo pairInfo = (PoReplicaPairInfo)iterator.next();
                    if (!pairInfo.getVolumeUuid().equals(poReplicaPairInfo.getVolumeUuid())) continue;
                    iterator.remove();
                }
            }
            po.getProps().put("hypermetor_replicationInfo", JsonUtil.beanToJson(poHypermetorReplicationInfo));
        }
    }

    private void deleteRemoteReplicationInfo(ProtectObject po, List<PoReplicaPairInfo> delPairs) {
        PoReplicaInfo poRemoteReplicationInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
        if (!VerifyUtil.isEmpty((Object)poRemoteReplicationInfo)) {
            List poRemoteReplicaPairList = poRemoteReplicationInfo.getPairInfos();
            for (PoReplicaPairInfo poReplicaPairInfo : delPairs) {
                Iterator iterator = poRemoteReplicaPairList.iterator();
                while (iterator.hasNext()) {
                    PoReplicaPairInfo pairInfo = (PoReplicaPairInfo)iterator.next();
                    if (!pairInfo.getDrVolumeUuid().equals(poReplicaPairInfo.getDrVolumeUuid())) continue;
                    iterator.remove();
                }
            }
            po.getProps().put("remote_replicationInfo", JsonUtil.beanToJson(poRemoteReplicationInfo));
        }
    }

    private void delStorageInfo(ProtectObject po, List<PoReplicaPairInfo> delPairs) {
        Set delVolUuidSet = delPairs.stream().map(pairInfo -> pairInfo.getVolumeUuid()).filter(volUuid -> !VerifyUtil.isEmpty((String)volUuid)).collect(Collectors.toSet());
        po.getUsedStorageResourceSet().removeIf(storageInfo -> delVolUuidSet.contains(storageInfo.getResourceId()));
    }

    private void updatePairInfoOfAddedVolume(ProtectObject po, Map<String, PoReplicaPairInfo> protectedVolReplica, OpenStackVolume volume, Map<String, PoReplicaPairInfo> hyperAndRemoteReplicaMap) {
        if (protectedVolReplica.keySet().contains(volume.getUuid()) && !VerifyUtil.isEmpty((String)po.getProperty("hypermetor_replicationInfo"))) {
            String hyperVolUuid = null;
            PoReplicaInfo hyperPoReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
            PoReplicaPairInfo addPairInfo = null;
            for (PoReplicaPairInfo pairInfo : hyperPoReplicaInfo.getPairInfos()) {
                if (!volume.getUuid().equals(pairInfo.getVolumeUuid())) continue;
                addPairInfo = pairInfo;
            }
            if (addPairInfo == null) {
                addPairInfo = new PoReplicaPairInfo();
                hyperPoReplicaInfo.getPairInfos().add(addPairInfo);
            }
            addPairInfo.setVolumeName(volume.getName());
            addPairInfo.setVolumeType(volume.getVolType());
            addPairInfo.setVolumeUuid(volume.getUuid());
            addPairInfo.setSize(volume.getSize().intValue());
            addPairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus());
            if (hyperAndRemoteReplicaMap.keySet().contains(volume.getUuid())) {
                addPairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
                PoReplicaPairInfo temp = hyperAndRemoteReplicaMap.get(volume.getUuid());
                addPairInfo.setReplicaUuid(temp.getReplicaUuid());
                addPairInfo.setDrVolumeUuid(temp.getDrVolumeUuid());
                addPairInfo.setDrVolumeType(temp.getDrVolumeType());
                addPairInfo.setDrReplicaUuid(temp.getDrReplicaUuid());
                hyperVolUuid = temp.getDrVolumeUuid();
            }
            LOG.info((Object)"Refresh po:%s add hyperPair:%s", new Object[]{po.getName(), JsonUtil.beanToJson(addPairInfo)});
            po.getProps().put("hypermetor_replicationInfo", JsonUtil.beanToJson(hyperPoReplicaInfo));
            if (!VerifyUtil.isEmpty(hyperVolUuid)) {
                PoReplicaInfo remotePoReplicaInfo = this.getHyperVolume(po, hyperAndRemoteReplicaMap, hyperVolUuid);
                po.getProps().put("remote_replicationInfo", JsonUtil.beanToJson(remotePoReplicaInfo));
            }
        }
    }

    private PoReplicaInfo getHyperVolume(ProtectObject po, Map<String, PoReplicaPairInfo> hyperAndRemoteReplicaMap, String hyperVolUuid) {
        PoReplicaInfo remotePoReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
        ProtectGroup pg = po.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        ArrayList<String> volUuids = new ArrayList<String>();
        volUuids.add(hyperVolUuid);
        List volumeList = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).queryVolumesByUuid(regionUuid, projUuid, volUuids, false);
        if (!VerifyUtil.isEmpty((Collection)volumeList)) {
            OpenStackVolume hyperVolume = (OpenStackVolume)volumeList.get(0);
            PoReplicaPairInfo remotePairInfo = null;
            for (PoReplicaPairInfo pairInfo : remotePoReplicaInfo.getPairInfos()) {
                if (!hyperVolume.getUuid().equals(pairInfo.getVolumeUuid()) || !hyperAndRemoteReplicaMap.keySet().contains(hyperVolume.getUuid())) continue;
                remotePairInfo = pairInfo;
            }
            if (remotePairInfo == null) {
                remotePairInfo = new PoReplicaPairInfo();
                remotePoReplicaInfo.getPairInfos().add(remotePairInfo);
            }
            remotePairInfo.setVolumeName(hyperVolume.getName());
            remotePairInfo.setVolumeType(hyperVolume.getVolType());
            remotePairInfo.setVolumeUuid(hyperVolume.getUuid());
            remotePairInfo.setSize(hyperVolume.getSize().intValue());
            remotePairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus());
            if (hyperAndRemoteReplicaMap.keySet().contains(hyperVolume.getUuid())) {
                remotePairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
                PoReplicaPairInfo temp = hyperAndRemoteReplicaMap.get(hyperVolume.getUuid());
                remotePairInfo.setReplicaUuid(temp.getReplicaUuid());
                remotePairInfo.setDrVolumeUuid(temp.getDrVolumeUuid());
                remotePairInfo.setDrVolumeType(temp.getDrVolumeType());
                remotePairInfo.setDrReplicaUuid(temp.getDrReplicaUuid());
            }
            LOG.info((Object)"Refresh po:%s add remotePair:%s", new Object[]{po.getName(), JsonUtil.beanToJson(remotePairInfo)});
        }
        return remotePoReplicaInfo;
    }

    private void refreshDrHyperType(ProtectObject po) {
        String poHyperReplicaInfoStr = (String)po.getProps().get("hypermetor_replicationInfo");
        if (!VerifyUtil.isEmpty((String)poHyperReplicaInfoStr)) {
            Map<String, String> srcUuidToDrHyperTypeMap;
            PoReplicaInfo poHyperReplicaInfo = JsonUtil.jsonToBean(poHyperReplicaInfoStr, PoReplicaInfo.class);
            if (!OpenStackCommonUtil.isCsdrVhaMode(po.getProtectGroup())) {
                srcUuidToDrHyperTypeMap = this.getSrcUuidToDrHyperTypeMap(poHyperReplicaInfo);
            } else {
                PoReplicaInfo poRemoteReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
                srcUuidToDrHyperTypeMap = this.getSrcUuidToDrHyperTypeMap(poRemoteReplicaInfo);
            }
            JSONArray volArray = JSONArray.fromObject(po.getProps().get("volumeConfig"));
            int size = volArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = volArray.getJSONObject(i);
                String volUuid = jsonObject.getString("volumeId");
                String volId = OpenStackCommonUtil.getIdFromUuid(volUuid);
                if (!srcUuidToDrHyperTypeMap.containsKey(volId)) continue;
                jsonObject.put((Object)"drHyperVolumeType", (Object)srcUuidToDrHyperTypeMap.get(volId));
            }
            po.getProps().put("volumeConfig", volArray.toString());
        }
    }

    private Map<String, String> getSrcUuidToDrHyperTypeMap(PoReplicaInfo poHyperReplicaInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (poHyperReplicaInfo == null || VerifyUtil.isEmpty((Collection)poHyperReplicaInfo.getPairInfos())) {
            return result;
        }
        for (PoReplicaPairInfo pairInfo : poHyperReplicaInfo.getPairInfos()) {
            result.put(OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid()), pairInfo.getDrVolumeType());
        }
        return result;
    }

    private void updatePairInfoOfAddedVolume(ProtectObject po, Map<String, PoReplicaPairInfo> protectedVolReplica, Set<String> voladdVmUuids, PoReplicaInfo poReplicaInfo, OpenStackVolume volume, PoReplicaPairInfo addPairInfo) {
        LOG.debug((Object)"NewPair:%s", new Object[]{volume.getUuid()});
        if (null == addPairInfo) {
            addPairInfo = new PoReplicaPairInfo();
            poReplicaInfo.getPairInfos().add(addPairInfo);
        }
        addPairInfo.setVolumeName(volume.getName());
        addPairInfo.setVolumeType(volume.getVolType());
        addPairInfo.setVolumeUuid(volume.getUuid());
        addPairInfo.setSize(volume.getSize().intValue());
        addPairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus());
        if (protectedVolReplica.keySet().contains(volume.getUuid())) {
            addPairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
            PoReplicaPairInfo temp = protectedVolReplica.get(volume.getUuid());
            addPairInfo.setReplicaUuid(temp.getReplicaUuid());
            addPairInfo.setDrVolumeUuid(temp.getDrVolumeUuid());
            addPairInfo.setDrVolumeType(temp.getDrVolumeType());
            addPairInfo.setDrReplicaUuid(temp.getDrReplicaUuid());
            this.updateStorageInfo(po, volume);
            ProtectGroup pg = po.getProtectGroup();
            if (OpenstackConsts.OPENSTACK_NEEDREATTACH_TYPES.contains(pg.getTemplate().getType()) && !OpenStackCommonUtil.isCsdrCshaMode(pg)) {
                this.reAttachVol(po, volume);
            }
        } else {
            voladdVmUuids.add(po.getMoUuid());
            String vmType = (String)po.getProps().get("vm_type");
            if (VerifyUtil.isEmpty((String)((String)po.getProps().get("vm_type"))) || !"BMS".equals(vmType)) {
                po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
            }
        }
    }

    private void reAttachVol(ProtectObject po, OpenStackVolume volume) {
        ProtectGroup pg = po.getProtectGroup();
        String volumeUuid = volume.getUuid();
        String vmUuid = po.getMoUuid();
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        String projUuid = pg.getProperty("projectId");
        String regionUuid = pg.getProperty("regionId");
        if (!volumeService.isAttachVM(regionUuid, projUuid, vmUuid, volumeUuid)) {
            return;
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        IVirtualMachineService vmService = (IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
        VolumeInfo volumeInfo = CinderManager.convertToVolumeInfo(volume);
        ReconnectVolumeInfo reconnVolumeInfo = new ReconnectVolumeInfo();
        reconnVolumeInfo.setVolumeId(volumeInfo.getId());
        reconnVolumeInfo.setIsHyperMetro(Boolean.valueOf(true));
        vmService.runWithAttachVolSemaphore(volumeInfo.getStorageSn(), vm.getHostId(), 1800L, () -> {
            novaMgr.reattachVolume(new ReattchParam(regionUuid, projUuid, tokenId), vmUuid, reconnVolumeInfo);
            return null;
        });
    }

    private void refreshVolCfg(ProtectObject po, PoReplicaInfo poReplicaInfo) {
        JSONArray array = new JSONArray();
        if (null != poReplicaInfo && !poReplicaInfo.getPairInfos().isEmpty()) {
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                JSONObject json = new JSONObject();
                json.put((Object)"volumeId", (Object)pairInfo.getVolumeUuid());
                json.put((Object)"drVolumeType", (Object)pairInfo.getDrVolumeType());
                json.put((Object)"volumeType", (Object)pairInfo.getVolumeType());
                array.add((Object)json);
            }
        }
        po.getProps().put("volumeConfig", array.toString());
    }

    private void updateStorageInfo(ProtectObject po, OpenStackVolume volume) {
        volume.generateAttachmentInfo();
        String deviceName = "";
        for (Object attachment : volume.getAttachments()) {
            if (!po.getMoUuid().equals(attachment.getVmUuid())) continue;
            deviceName = attachment.getDevice();
            break;
        }
        Set infos = po.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo info : infos) {
            if (!volume.getUuid().equals(info.getResourceId())) continue;
            info.setDeviceName(deviceName);
            info.setResourceName(volume.getName());
            return;
        }
        ProtectObjectStorageInfo storage = new ProtectObjectStorageInfo();
        storage.setId(UUIDGenerator.getUUID());
        storage.setResourceName(volume.getName());
        storage.setLunWWN(volume.getUuid());
        storage.setResourceId(volume.getUuid());
        storage.setResourceProviderSN(OpenStackCommonUtil.getOpenstackUuidFromStr(volume.getUuid()));
        storage.setDeviceName(deviceName);
        po.addHostStorageResourceInfo(storage);
    }

    private String[] getVmUuids(Collection<ProtectObject> pos) {
        String[] uuids = new String[pos.size()];
        int index = 0;
        for (ProtectObject po : pos) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                LOG.error((Object)"Uuid is empty", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            LOG.debug((Object)"Pouuid:%s", new Object[]{po.getMoUuid()});
            uuids[index++] = po.getMoUuid();
        }
        return uuids;
    }

    private Map<String, List<OpenStackVolume>> getVmAndVolInfoMap(ProtectGroup pg, String[] uuids, Set<String> protectedVolUuids) {
        HashMap<String, List<OpenStackVolume>> vmAndVolInfo = new HashMap<String, List<OpenStackVolume>>();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String strIsManual = pg.getProperty("isManualRefresh");
        boolean isAutoFresh = !VerifyUtil.isEmpty((String)strIsManual) && String.valueOf(0).equals(strIsManual);
        List volList = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).getVolumesByVm(regionUuid, projUuid, isAutoFresh, uuids);
        for (OpenStackVolume vol : volList) {
            LOG.debug((Object)"VolList:%s ", new Object[]{vol.getUuid()});
            protectedVolUuids.add(vol.getUuid());
            vol.generateAttachmentInfo();
            for (OpenStackVolAttachment attachment : vol.getAttachments()) {
                if (!vmAndVolInfo.containsKey(attachment.getVmUuid())) {
                    ArrayList volInfos = new ArrayList();
                    vmAndVolInfo.put(attachment.getVmUuid(), volInfos);
                }
                ((List)vmAndVolInfo.get(attachment.getVmUuid())).add(vol);
                LOG.debug((Object)"Put info: %s, %s", new Object[]{attachment.getVmUuid(), vol.getUuid()});
            }
        }
        return vmAndVolInfo;
    }

    private Map<String, PoReplicaPairInfo> getUesdProtectedVolAndReplication(ProtectGroup protectGroup, Set<String> protectedVolUuids) {
        HashMap<String, PoReplicaPairInfo> protectedVolReplica = new HashMap<String, PoReplicaPairInfo>();
        for (ProtectObject po : protectGroup.getPolist()) {
            String poReplicaInfoStr = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaInfoStr, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                LOG.error((Object)"Convert to poReplicaInfo return null.");
                throw new LegoCheckedException(0x300001L);
            }
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if (!protectedVolUuids.contains(pairInfo.getVolumeUuid()) || protectedVolReplica.keySet().contains(pairInfo.getVolumeUuid()) || !OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) && !OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus().equals(pairInfo.getVolumeStatus())) continue;
                protectedVolReplica.put(pairInfo.getVolumeUuid(), pairInfo);
            }
        }
        return protectedVolReplica;
    }

    private void updateVolumeMetadata(CheckContext context, Map<String, List<OpenStackVolume>> map, Map<String, PoReplicaPairInfo> protectedVolReplica) {
        ServiceInstance serviceInstance = context.getInstanceInst();
        if (null == serviceInstance) {
            return;
        }
        String instanceType = serviceInstance.getType();
        ProtectGroup pg = context.getPg();
        if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63() || ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(instanceType)) {
            return;
        }
        for (Map.Entry<String, PoReplicaPairInfo> entry : protectedVolReplica.entrySet()) {
            String volumeUuid = entry.getKey();
            OpenStackVolume volume = this.find(map, volumeUuid);
            if (VerifyUtil.isEmpty((Object)volume)) {
                LOG.error((Object)("Can not find volume:" + volumeUuid));
                continue;
            }
            this.updateMetadata(pg, volume);
        }
    }

    private OpenStackVolume find(Map<String, List<OpenStackVolume>> map, String volumeUuid) {
        if (VerifyUtil.isEmpty(map) || VerifyUtil.isEmpty((String)volumeUuid)) {
            return null;
        }
        for (Map.Entry<String, List<OpenStackVolume>> entry : map.entrySet()) {
            for (OpenStackVolume openStackVolume : entry.getValue()) {
                if (!volumeUuid.equals(openStackVolume.getUuid())) continue;
                return openStackVolume;
            }
        }
        return null;
    }

    private void updateMetadata(ProtectGroup pg, OpenStackVolume volume) {
        try {
            if (null != volume.getMetadata() && volume.getMetadata().containsKey("occupied_volume")) {
                return;
            }
            String regionUuid = (String)pg.getProps().get("regionId");
            String projUuid = (String)pg.getProps().get("projectId");
            IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            HashMap<String, String> metadataMap = new HashMap<String, String>();
            metadataMap.put("occupied_volume", "false");
            volumeService.updateVolumeMetadata(OpenStackCommonUtil.getIdFromUuid(volume.getUuid()), metadataMap, regionUuid, projUuid);
        }
        catch (Exception e) {
            LOG.error((Object)("UpdateVolumeMetadata error." + volume.getUuid()), (Throwable)e);
        }
    }

    private void getBeenRemovedVols(ProtectObject po, List<OpenStackVolume> volumeSet, Map<String, PoReplicaPairInfo> protectedVolReplica, Set<String> volDelVmUuids, PoReplicaInfo poReplicaInfo, List<PoReplicaPairInfo> delPairs) {
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            LOG.debug((Object)"PairInfo:%s", new Object[]{pairInfo.getVolumeStatus()});
            boolean isVolRemove = true;
            for (OpenStackVolume vol : volumeSet) {
                if (!vol.getUuid().equals(pairInfo.getVolumeUuid()) || OpenstackEnumDefine.VolProtectStatusE.RELEASING.getStatus().equals(pairInfo.getVolumeStatus()) || OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus().equals(pairInfo.getVolumeStatus())) continue;
                isVolRemove = false;
                break;
            }
            if (!isVolRemove) continue;
            if (OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) || protectedVolReplica.keySet().contains(pairInfo.getVolumeUuid())) {
                delPairs.add(pairInfo);
                continue;
            }
            if (OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) {
                pairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus());
                volDelVmUuids.add(po.getMoUuid());
                continue;
            }
            if (!OpenstackEnumDefine.VolProtectStatusE.RELEASING.getStatus().equals(pairInfo.getVolumeStatus()) && !OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus().equals(pairInfo.getVolumeStatus())) continue;
            volDelVmUuids.add(po.getMoUuid());
        }
    }
}

