/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.checker;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ResourceLocation;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeErrorItem;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStoragePoolRemoteDevInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStorageResourcePool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.model.SameDevInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class VolumeProtectableChecker {
    private static final Log LOGGER = LogFactory.getInstance(VolumeProtectableChecker.class);
    private static final Set<String> PROTECTABLE_STATUS = ImmutableSet.of((Object)OpenstackEnumDefine.VolumeStatusE.INUSE.getType(), (Object)OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType());
    private static final Set<String> DR_PROTECTABLE_STATUS = Collections.singleton(OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType());
    private static final ImmutableSet<ServiceInstaceEnumDefine.ServiceInstanceTypeE> HYPER_METRO_SERVICE_TYPES = ImmutableSet.of((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO, (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA);
    private String regionUuid;
    private String projectUuid;
    private String az;
    private String drRegionUuid;
    private String drProjectUuid;
    private String drAz;
    private ServiceInstaceEnumDefine.ObjectType objectType;
    private boolean isNeedInitDrInfo = false;
    private Map<String, OpenStackVolumeType> openStackVolumeTypeMap = new HashMap<String, OpenStackVolumeType>();
    private Map<String, OpenStackStorageResourcePool> devSnPoolMap = new HashMap<String, OpenStackStorageResourcePool>();
    private Map<String, Set<String>> volumeTypeMapping = new HashMap<String, Set<String>>();

    public VolumeProtectableChecker(ServiceInstaceEnumDefine.ObjectType objectType, ResourceLocation prodResourceLocation, ResourceLocation drResourceLocation) {
        VerifyUtil.checkObjs((Object[])new Object[]{objectType, prodResourceLocation});
        this.regionUuid = prodResourceLocation.getRegionUuid();
        this.projectUuid = prodResourceLocation.getProjectUuid();
        this.az = prodResourceLocation.getAz();
        VerifyUtil.checkObjs((Object[])new Object[]{this.regionUuid, this.projectUuid, this.az});
        if (drResourceLocation != null) {
            this.drRegionUuid = drResourceLocation.getRegionUuid();
            this.drProjectUuid = drResourceLocation.getProjectUuid();
            this.drAz = drResourceLocation.getAz();
            VerifyUtil.checkObjs((Object[])new Object[]{this.drRegionUuid, this.drProjectUuid, this.drAz});
            this.isNeedInitDrInfo = true;
        }
        this.objectType = objectType;
        this.initVolumeTypeMapping();
        this.initOpenStackVolumeTypeMap();
        this.initVolumeTypePoolMap();
    }

    public static VolumeProtectableChecker buildVolumeCheckerFromPg(ServiceInstaceEnumDefine.ObjectType objectType, ProtectGroup protectGroup) {
        VerifyUtil.checkObjs((Object[])new Object[]{protectGroup});
        String projectId = protectGroup.getProperty("projectId");
        String regionId = protectGroup.getProperty("regionId");
        String azName = protectGroup.getProperty("zoneName");
        ResourceLocation location = new ResourceLocation(regionId, projectId, azName);
        String drRegionId = protectGroup.getProperty("drRegionId");
        String drAzName = protectGroup.getProperty("drZoneName");
        String drProjectId = protectGroup.getProperty("projectId");
        ResourceLocation drLocation = null;
        if (!VerifyUtil.isMultiEmpty((Object[])new Object[]{drRegionId, drAzName, drProjectId})) {
            drLocation = new ResourceLocation(drRegionId, drProjectId, drAzName);
        }
        return new VolumeProtectableChecker(objectType, location, drLocation);
    }

    private void initVolumeTypeMapping() {
        String secondAzId = null;
        if (this.isNeedInitDrInfo) {
            secondAzId = OpenStackVolTypeMapping.getMappingAzId((String)OpenStackCommonUtil.getIdFromUuid(this.drRegionUuid), (String)this.drAz);
        }
        String objStr = this.objectType == ServiceInstaceEnumDefine.ObjectType.EVS ? ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue() : this.objectType.getValue();
        String primaryAzId = OpenStackVolTypeMapping.getMappingAzId((String)OpenStackCommonUtil.getIdFromUuid(this.regionUuid), (String)this.az);
        List openStackVolTypeMappings = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getResourceMappingByRegionAz(objStr, primaryAzId, secondAzId);
        openStackVolTypeMappings.removeIf(Objects::isNull);
        for (OpenStackVolTypeMapping mapping : openStackVolTypeMappings) {
            String primaryVolType = mapping.getPrimaryVolType();
            String secondVolType = mapping.getSecondVolType();
            boolean isReverse = primaryAzId.equals(mapping.getSecondAzId());
            String srcVolType = isReverse ? secondVolType : primaryVolType;
            String drVolType = isReverse ? primaryVolType : secondVolType;
            this.volumeTypeMapping.computeIfAbsent(srcVolType, key -> new HashSet()).add(drVolType);
        }
    }

    private void initOpenStackVolumeTypeMap() {
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        HashSet volumeTypes = new HashSet();
        this.volumeTypeMapping.forEach((key, values) -> {
            volumeTypes.add(key);
            volumeTypes.addAll(values);
        });
        ArrayList openStackVolumeTypes = new ArrayList();
        openStackVolumeTypes.addAll(volumeService.getVolumeTypesByName(volumeTypes, this.regionUuid, this.projectUuid));
        if (this.isNeedInitDrInfo) {
            openStackVolumeTypes.addAll(volumeService.getVolumeTypesByName(volumeTypes, this.drRegionUuid, this.drProjectUuid));
        }
        this.openStackVolumeTypeMap = openStackVolumeTypes.stream().collect(Collectors.toMap(item -> this.getVolTypeIdentity(item.getRegionUuid(), item.getName()), Function.identity(), ObjectUtils::defaultIfNull));
    }

    private String getVolTypeIdentity(String regionUuid, String volumeType) {
        return StringUtils.joinWith((String)"_@_", (Object[])new Object[]{regionUuid, volumeType});
    }

    private void initVolumeTypePoolMap() {
        List poolList = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).getStorageResourcePools(OpenStackCommonUtil.getOpenstack().getUuid(), this.regionUuid, this.projectUuid);
        if (this.isNeedInitDrInfo) {
            List drPoolList = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).getStorageResourcePools(OpenStackCommonUtil.getOpenstack().getUuid(), this.drRegionUuid, this.drProjectUuid);
            poolList.addAll(drPoolList);
        }
        poolList.forEach(OpenStackStorageResourcePool::generateRemoteDevInfo);
        this.devSnPoolMap = poolList.stream().collect(Collectors.toMap(OpenStackStorageResourcePool::getLocalDevSn, Function.identity(), ObjectUtils::defaultIfNull));
    }

    public List<VolumeErrorItem> checkSingleVolume(VolumeInfo volumeInfo, boolean isDrVolume) {
        ArrayList<VolumeErrorItem> errorList = new ArrayList<VolumeErrorItem>();
        if (volumeInfo == null) {
            LOGGER.debug((Object)"The volume is not exist.");
            errorList.add(new VolumeErrorItem(Long.valueOf(2117645L)));
            return errorList;
        }
        VolumeProtectableChecker.checkVolumeStatus(volumeInfo, isDrVolume).ifPresent(errorList::add);
        VolumeProtectableChecker.checkVolumeEncrypted(volumeInfo).ifPresent(errorList::add);
        VolumeProtectableChecker.checkVolumeOccupied(volumeInfo).ifPresent(errorList::add);
        return errorList;
    }

    public List<VolumeErrorItem> checkVolumePair(VolumeInfo prodVolume, VolumeInfo drVolume, ServiceInstaceEnumDefine.ServiceInstanceTypeE serviceType) {
        VerifyUtil.checkObjs((Object[])new Object[]{this.drRegionUuid, this.drAz, this.drProjectUuid});
        ArrayList<VolumeErrorItem> errorList = new ArrayList<VolumeErrorItem>();
        if (this.objectType == ServiceInstaceEnumDefine.ObjectType.EVS && drVolume == null) {
            LOGGER.debug((Object)"The drVolume can be null, when objectType is EVS.");
            return this.checkSingleVolume(prodVolume, false);
        }
        errorList.addAll(this.checkSingleVolume(prodVolume, false));
        errorList.addAll(this.checkSingleVolume(drVolume, true));
        VolumeProtectableChecker.checkVolumeSameCapacity(prodVolume, drVolume).ifPresent(errorList::add);
        VolumeProtectableChecker.checkVolumeSameDiskProperties(prodVolume, drVolume).ifPresent(errorList::add);
        VolumeProtectableChecker.checkVolumeTypeMapping(prodVolume, drVolume, this.volumeTypeMapping).ifPresent(errorList::add);
        this.checkVolumePoolsConnection(prodVolume, drVolume, serviceType).ifPresent(errorList::add);
        return errorList;
    }

    public List<VolumeErrorItem> checkAllVolumePairs(Map<VolumeInfo, VolumeInfo> volumeMapping, ServiceInstaceEnumDefine.ServiceInstanceTypeE serviceType) {
        VerifyUtil.checkObjs((Object[])new Object[]{this.drRegionUuid, this.drAz, this.drProjectUuid, volumeMapping});
        ArrayList<VolumeErrorItem> errorList = new ArrayList<VolumeErrorItem>();
        Optional<VolumeErrorItem> errorOptional = VolumeProtectableChecker.checkProtectGroupVolumeCount(volumeMapping.size());
        if (errorOptional.isPresent()) {
            errorList.add(errorOptional.get());
            return errorList;
        }
        volumeMapping.forEach((prodVolume, drVolume) -> errorList.addAll(this.checkVolumePair((VolumeInfo)prodVolume, (VolumeInfo)drVolume, serviceType)));
        return errorList;
    }

    public static Optional<VolumeErrorItem> checkProtectGroupVolumeCount(int volSize) {
        int pgMaxVolume = OpenStackCommonUtil.getPgMaxVolume();
        if (volSize > pgMaxVolume) {
            LOGGER.debug((Object)"The number of volumes exceeds the limit.");
            VolumeErrorItem volumeError = new VolumeErrorItem(Long.valueOf(1073947497L));
            volumeError.addErrorParam(String.valueOf(pgMaxVolume));
            return Optional.of(volumeError);
        }
        return Optional.empty();
    }

    public void checkProdVolumeFromOneDevs(String regionUuid, Collection<VolumeInfo> volumes) {
        this.getSameDevInfoByVolumes(regionUuid, volumes, null);
    }

    public SameDevInfo getSameDevInfoByVolumes(String regionUuid, Collection<VolumeInfo> volumes, Collection<String> volumeTypes) {
        Set existVolumes = volumes.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> sameDevSet = new HashSet<String>();
        for (Object volume : existVolumes) {
            if (VerifyUtil.isEmpty((String)volume.getStorageSn())) {
                LOGGER.debug((Object)"The volumes are not from the same device, devSnSet is empty.");
                throw new LegoCheckedException(1073948413L);
            }
            sameDevSet = this.getSameDevSet(sameDevSet, Collections.singleton(volume.getStorageSn()));
        }
        String priorityType = null;
        if (!VerifyUtil.isEmpty(volumeTypes)) {
            for (String volumeType : volumeTypes) {
                String volTypeIdentity = this.getVolTypeIdentity(regionUuid, volumeType);
                OpenStackVolumeType openStackVolumeType = this.openStackVolumeTypeMap.get(volTypeIdentity);
                if (openStackVolumeType == null || VerifyUtil.isEmpty((Collection)openStackVolumeType.getStorageSn())) {
                    LOGGER.error((Object)"The volume type(%s) is not invalid", new Object[]{volumeType});
                    throw new LegoCheckedException(1073949726L);
                }
                Set storageSn = openStackVolumeType.getStorageSn();
                priorityType = (sameDevSet = this.getSameDevSet(sameDevSet, storageSn)) == storageSn ? volumeType : priorityType;
            }
        }
        SameDevInfo sameDevInfo = new SameDevInfo();
        if (!VerifyUtil.isEmpty(existVolumes)) {
            sameDevInfo.setVolumeId(((VolumeInfo)existVolumes.iterator().next()).getId());
            return sameDevInfo;
        }
        sameDevInfo.setVolumeType(priorityType);
        return sameDevInfo;
    }

    private Set<String> getSameDevSet(Set<String> tmpSameDevs, Set<String> devSnSet) {
        if (VerifyUtil.isEmpty(tmpSameDevs)) {
            return devSnSet;
        }
        if (tmpSameDevs.size() > devSnSet.size() && tmpSameDevs.containsAll(devSnSet)) {
            return devSnSet;
        }
        if (!devSnSet.containsAll(tmpSameDevs)) {
            LOGGER.debug((Object)"The volumes are not from the same device.");
            throw new LegoCheckedException(1073948413L);
        }
        return tmpSameDevs;
    }

    public static Optional<VolumeErrorItem> checkVolumeTypeMapping(VolumeInfo prodVolume, VolumeInfo drVolume, Map<String, Set<String>> volumeTypeMapping) {
        VerifyUtil.checkObjs((Object[])new Object[]{prodVolume, drVolume, volumeTypeMapping});
        String prodVolumeType = prodVolume.getVolumeType();
        String drVolumeType = drVolume.getVolumeType();
        Set<String> volumeTypes = volumeTypeMapping.get(prodVolumeType);
        if (VerifyUtil.isMultiEmpty((Object[])new Object[]{prodVolumeType, drVolumeType}) || VerifyUtil.isEmpty(volumeTypes) || !volumeTypes.contains(drVolumeType)) {
            LOGGER.debug((Object)"The prodVolume type: %s does not match the drVolume type: %s.", new Object[]{prodVolumeType, drVolumeType});
            VolumeErrorItem errorItem = new VolumeErrorItem(Long.valueOf(1073947492L)).addErrorParam(prodVolumeType).addErrorParam(drVolumeType).addVolumeId(drVolume.getId()).addVolumeId(prodVolume.getId());
            return Optional.of(errorItem);
        }
        return Optional.empty();
    }

    public static Optional<VolumeErrorItem> checkVolumeSameCapacity(VolumeInfo prodVolume, VolumeInfo drVolume) {
        VerifyUtil.checkObjs((Object[])new Object[]{prodVolume, drVolume});
        int prodVolumeSize = prodVolume.getSize();
        int drVolumeSize = drVolume.getSize();
        if (prodVolumeSize != drVolumeSize) {
            LOGGER.debug((Object)"The prodVolume and drVolume have different capacities.");
            VolumeErrorItem volumeErrorItem = new VolumeErrorItem(Long.valueOf(1073947491L)).addErrorParam(String.valueOf(prodVolumeSize)).addErrorParam(String.valueOf(drVolumeSize)).addVolumeId(drVolume.getId()).addVolumeId(prodVolume.getId());
            return Optional.of(volumeErrorItem);
        }
        return Optional.empty();
    }

    public static Optional<VolumeErrorItem> checkVolumeSameDiskProperties(VolumeInfo prodVolume, VolumeInfo drVolume) {
        boolean isImageSame;
        VerifyUtil.checkObjs((Object[])new Object[]{prodVolume, drVolume});
        boolean isBootableSame = prodVolume.isBootable() == drVolume.isBootable();
        boolean bl = isImageSame = VerifyUtil.isEmpty((Map)prodVolume.getVolumeImageMetadata()) == VerifyUtil.isEmpty((Map)drVolume.getVolumeImageMetadata());
        if (!isBootableSame || !isImageSame) {
            String prodVolumeId = prodVolume.getId();
            String drVolumeId = drVolume.getId();
            LOGGER.debug((Object)"Disk properties (Data disk/System disk) of production volume %s and DR volume %s are not the same.", new Object[]{prodVolumeId, drVolumeId});
            return Optional.of(new VolumeErrorItem(Long.valueOf(1073947500L)).addVolumeId(prodVolumeId).addVolumeId(drVolumeId));
        }
        return Optional.empty();
    }

    public static Optional<VolumeErrorItem> checkVolumeOccupied(VolumeInfo volumeInfo) {
        VerifyUtil.checkObject((Object)volumeInfo);
        Map metadata = volumeInfo.getMetadata();
        if (metadata != null && metadata.containsKey("occupied_volume")) {
            String volumeId = volumeInfo.getId();
            LOGGER.debug((Object)"The volume %s has been occupied.", new Object[]{volumeId});
            return Optional.of(new VolumeErrorItem(Long.valueOf(1073947493L)).addVolumeId(volumeId));
        }
        return Optional.empty();
    }

    public static Optional<VolumeErrorItem> checkVolumeStatus(VolumeInfo volumeInfo, boolean isDrVolume) {
        VerifyUtil.checkObject((Object)volumeInfo);
        String status = volumeInfo.getStatus();
        Set<String> protectableStatus = isDrVolume ? DR_PROTECTABLE_STATUS : PROTECTABLE_STATUS;
        boolean isSoftDelete = VolumeProtectableChecker.isSoftDelete(volumeInfo);
        if (isSoftDelete || !protectableStatus.contains(status)) {
            String volumeId = volumeInfo.getId();
            LOGGER.debug((Object)"The volume %s in %s state cannot be protected.", new Object[]{volumeId, status});
            VolumeErrorItem volumeError = new VolumeErrorItem(Long.valueOf(1073947494L)).addErrorParam(status).addVolumeId(volumeId);
            return Optional.of(volumeError);
        }
        return Optional.empty();
    }

    private static boolean isSoftDelete(VolumeInfo volumeInfo) {
        Map metadata = volumeInfo.getMetadata();
        LOGGER.debug((Object)"Volume(%s)'s metadata is %s.", new Object[]{volumeInfo.getId(), metadata});
        return !VerifyUtil.isEmpty((Map)metadata) && Boolean.parseBoolean((String)metadata.get("soft_deleted"));
    }

    public static Optional<VolumeErrorItem> checkVolumeEncrypted(VolumeInfo volumeInfo) {
        VerifyUtil.checkObject((Object)volumeInfo);
        Map encryptionInfo = volumeInfo.getEncryptionInfo();
        if (!VerifyUtil.isEmpty((Map)encryptionInfo) && !VerifyUtil.isAllEmpty(encryptionInfo.values())) {
            String volumeId = volumeInfo.getId();
            LOGGER.debug((Object)"The volume %s is encrypted.", new Object[]{volumeId});
            return Optional.of(new VolumeErrorItem(Long.valueOf(1073947499L)).addVolumeId(volumeId));
        }
        return Optional.empty();
    }

    public Optional<VolumeErrorItem> checkVolumePoolsConnection(VolumeInfo prodVolume, VolumeInfo drVolume, ServiceInstaceEnumDefine.ServiceInstanceTypeE serviceType) {
        VerifyUtil.checkObjs((Object[])new Object[]{prodVolume, drVolume});
        Set<OpenStackStorageResourcePool> prodPools = this.getPoolByVolume(prodVolume, false);
        Set<OpenStackStorageResourcePool> drPools = this.getPoolByVolume(drVolume, true);
        if (prodPools.stream().anyMatch(Objects::isNull)) {
            String prodVolumeId = prodVolume.getId();
            LOGGER.debug((Object)"The resource pool is not exist, volumeId: %s.", new Object[]{prodVolumeId});
            VolumeErrorItem volumeError = new VolumeErrorItem(Long.valueOf(1073947496L)).addVolumeId(prodVolumeId);
            return Optional.of(volumeError);
        }
        if (drPools.stream().anyMatch(Objects::isNull)) {
            String drVolumeId = drVolume.getId();
            LOGGER.debug((Object)"The resource pool is not exist, volumeId: %s.", new Object[]{drVolumeId});
            VolumeErrorItem volumeError = new VolumeErrorItem(Long.valueOf(1073947496L)).addVolumeId(drVolumeId);
            return Optional.of(volumeError);
        }
        for (OpenStackStorageResourcePool prodPool : prodPools) {
            for (OpenStackStorageResourcePool drPool : drPools) {
                if (this.checkResourcePoolConnection(serviceType, prodPool, drPool)) continue;
                VolumeErrorItem volumeError = new VolumeErrorItem(Long.valueOf(1073948114L)).addVolumeId(drVolume.getId()).addVolumeId(prodVolume.getId());
                return Optional.of(volumeError);
            }
        }
        return Optional.empty();
    }

    private boolean checkResourcePoolConnection(ServiceInstaceEnumDefine.ServiceInstanceTypeE serviceType, OpenStackStorageResourcePool srcPool, OpenStackStorageResourcePool drPool) {
        HashSet<String> prodRemoteDevSns = new HashSet<String>();
        HashSet<String> drRemoteDevSns = new HashSet<String>();
        if (HYPER_METRO_SERVICE_TYPES.contains((Object)serviceType)) {
            prodRemoteDevSns.addAll(this.getDevSnSetFromDevInfos(srcPool.getRemoteHyperMetroDevs()));
            drRemoteDevSns.addAll(this.getDevSnSetFromDevInfos(drPool.getRemoteHyperMetroDevs()));
        } else {
            prodRemoteDevSns.addAll(this.getDevSnSetFromDevInfos(srcPool.getRemoteDevs()));
            drRemoteDevSns.addAll(this.getDevSnSetFromDevInfos(drPool.getRemoteDevs()));
        }
        return prodRemoteDevSns.contains(drPool.getLocalDevSn()) && drRemoteDevSns.contains(srcPool.getLocalDevSn());
    }

    private Set<OpenStackStorageResourcePool> getPoolByVolume(VolumeInfo volume, boolean isDr) {
        ArrayList<String> storageSns = new ArrayList<String>();
        if (!VerifyUtil.isEmpty((String)volume.getStorageSn())) {
            storageSns.add(volume.getStorageSn());
        } else {
            String regionId = isDr ? this.drRegionUuid : this.regionUuid;
            String volTypeIdentity = this.getVolTypeIdentity(regionId, volume.getVolumeType());
            OpenStackVolumeType openStackVolumeType = this.openStackVolumeTypeMap.get(volTypeIdentity);
            if (openStackVolumeType != null && !VerifyUtil.isEmpty((Collection)openStackVolumeType.getStorageSn())) {
                storageSns.addAll(openStackVolumeType.getStorageSn());
            }
        }
        return storageSns.stream().map(this.devSnPoolMap::get).collect(Collectors.toSet());
    }

    private Set<String> getDevSnSetFromDevInfos(List<OpenStackStoragePoolRemoteDevInfo> devInfos) {
        if (devInfos.isEmpty()) {
            return Collections.emptySet();
        }
        return devInfos.stream().map(OpenStackStoragePoolRemoteDevInfo::getDevSn).collect(Collectors.toSet());
    }
}

