/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.fault;

import com.huawei.ism.drm.openstack.sdk.bo.OcAlarmBO;
import com.huawei.ism.drm.openstack.serviceinstance.fault.OcResponseHandler;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.IOcAccessService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.IOcParamListener;
import com.huawei.lego.cbb.i18n.sdk.I18nMgr;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.nem.fault.sdk.model.AlarmDetail;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public class OcFaultMsgHandler
implements SystemStatusChangedListener,
IOcParamListener,
IFaultHandler {
    private static final int QUEUE_SIZE = 10240;
    private static final Log LOG = LogFactory.getInstance(OcFaultMsgHandler.class);
    private static final int ALARMLIST_MAXSIZE = 100;
    private static final int NUMBER_FORMARTSECOND = 1000;
    private static final int PAUSE_TIME = 10000;
    private static final String SERVICE_TYPE = "eReplication";
    private static final String SERVICE_TYPE_PATTERN_CH = "\u4e91\u670d\u52a1=%s\uff0c ";
    private static final String SERVICE_TYPE_PATTERN_EN = "CloudService=%s, ";
    private static final String ALARM_GROUP_ID = "278460409";
    private static final String ALARM_GROUP_NAME = "eReplication";
    private static final long SLEEP_TIME_FOR_RETRY = 60000L;
    private static final int MAX_RETRY_TIME = 120;
    private static final List<String> OC_ALARM_ID_LIST = Arrays.asList("0x3230014", "0x323001F", "0x3230024", "0x3230025", "0x3230028", "0x000803220005", "0x323002C", "0x323002D", "0x323002E", "0x323002F", "0x3230030", "0x3230031", "0x3230032", "0x3230033", "0x3230034", "0x3230035", "0x3230036", "0x3230037", "0x3230038", "0x3230039", "0x323003A", "0x323003B", "0x000803220004", "0x323003C", "0x323003D", "0x323003E", "0x323003F", "0x3230040", "0x3230041", "0x3230042", "0x3230043", "0x3230047", "0x3230046", "0x3230049", "0x3230053", "0x3230048", "0x323005C", "0x323005D", "0x3230064", "0x3230067", "0x3230065", "0x3230068", "0x3230069", "0x3230071", "0x3230070", "0x3230074", "0x3230086");
    private static final List<String> REPORT_OC_TO_EVENT_ALARM_ID_LIST = Arrays.asList("0x3230028", "0x3230039", "0x3230032");
    private static Map<Integer, Integer> eventTypeMap = new HashMap<Integer, Integer>();
    private CloudConfig accessInfo;
    private String ocToken;
    private I18nMgr i18nMgr;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ConcurrentLinkedQueue<LegoAlarm> alarmQue = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange() {
        Class<OcFaultMsgHandler> clazz = OcFaultMsgHandler.class;
        synchronized (OcFaultMsgHandler.class) {
            if (this.accessInfo == null) {
                this.doscheduler();
            }
            this.accessInfo = ((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).getCloudConfigBy("oc");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void notify(LegoAlarm legoAlarm, AlarmDetail detail) {
        if (this.alarmQue.size() >= 10240) {
            LOG.error((Object)"add to alarmQue error");
            return;
        }
        if (OC_ALARM_ID_LIST.contains(legoAlarm.getAlarmId())) {
            this.alarmQue.add(legoAlarm);
        }
    }

    public I18nMgr getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMgr i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    public void sendAlarm() {
        LegoAlarm alarm;
        if (this.alarmQue.isEmpty() || VerifyUtil.isEmpty((Object)this.accessInfo)) {
            LOG.debug((Object)"AlarmQue is empty ");
            return;
        }
        try {
            if (VerifyUtil.isEmpty((String)this.ocToken)) {
                this.setOcToken();
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Get ocToken fail, cannot send alarm to oc.", (Throwable)e);
            return;
        }
        ArrayList<LegoAlarm> alarmList = new ArrayList<LegoAlarm>();
        while (alarmList.size() <= 100 && (alarm = this.alarmQue.poll()) != null) {
            alarmList.add(alarm);
        }
        this.sendForReduceDepth(alarmList);
    }

    private void sendForReduceDepth(List<LegoAlarm> alarmList) {
        try {
            this.reportAlarm(alarmList);
        }
        catch (Exception e) {
            LOG.error((Object)("send alarm to oc failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160784212003L);
        }
    }

    private void reportAlarm(List<LegoAlarm> alarmList) {
        String domain = (String)this.accessInfo.getProps().get("oc_domain");
        String port = (String)this.accessInfo.getProps().get("oc_port");
        int portInt = NumberUtil.convertToInteger((Object)port);
        RestClient client = new RestClient(domain, portInt, "", "", (IResponseHandler)new OcResponseHandler(), new String[0]);
        LOG.info((Object)"Start report ocFault . domain= %s, port=%s, alarm size = %s", new Object[]{domain, port, alarmList.size()});
        String hostIp = LegoConfig.getInstance().getKeyValue("floatIp");
        if (VerifyUtil.isEmpty((String)hostIp)) {
            hostIp = LegoConfig.getInstance().getKeyValue("ip");
        }
        if (!AddressUtil.isValidIP((String)hostIp)) {
            LOG.error((Object)"hostIp is not valid, send alarm failed.");
            return;
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"alarmRecords", (Object)JSONArray.fromObject(this.alarmTransform(alarmList)).toString());
        int idx = 0;
        while (true) {
            List<Header> headers = this.getHeaderList(hostIp);
            try {
                client.put("/rest/csfault/v1/alarms", jsonObj.toString(), null, headers);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 1073947691L) {
                    LOG.error((Object)"Report alarm fail. Reason: authentication fail.");
                    this.setOcToken();
                } else if (e.getErrorCode() == 1073947395L) {
                    if (0 == idx % 3) {
                        LOG.error((Object)"Report alarm fail. Reason: sever is unavailable now. retry time is %s.", new Object[]{String.valueOf(idx)});
                    }
                    CommonUtil.sleep((long)60000L);
                } else {
                    LOG.error((Object)("Send alarm failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160767696896L);
                    if (idx >= 120) {
                        LOG.error((Object)"Send alarm failed, retry times over limit.");
                        break;
                    }
                    CommonUtil.sleep((long)60000L);
                }
                ++idx;
                continue;
            }
            break;
        }
    }

    private List<Header> getHeaderList(String hostIp) {
        ArrayList<Header> headers = new ArrayList<Header>();
        BasicHeader hostDomain = new BasicHeader("service-host", (Object)hostIp);
        BasicHeader strToken = new BasicHeader("X-Auth-Token", (Object)this.ocToken);
        BasicHeader conType = new BasicHeader("Content-type", (Object)"application/json;charset=UTF-8");
        BasicHeader acceptType = new BasicHeader("Accept", (Object)"application/json;charset=UTF-8");
        headers.add((Header)hostDomain);
        headers.add((Header)strToken);
        headers.add((Header)conType);
        headers.add((Header)acceptType);
        return headers;
    }

    public List<OcAlarmBO> alarmTransform(List<LegoAlarm> alarmList) {
        ArrayList<OcAlarmBO> ocAlarmBOs = new ArrayList<OcAlarmBO>();
        for (int i = 0; i < alarmList.size(); ++i) {
            OcAlarmBO ocAlarmBO = new OcAlarmBO();
            LegoAlarm legoAlarm = alarmList.get(i);
            ocAlarmBO.setAlarmId(legoAlarm.getAlarmId());
            ocAlarmBO.setAlarmName(this.i18nMgr.getString(legoAlarm.getAlarmName(), Locale.CHINA) + "##" + this.i18nMgr.getString(legoAlarm.getAlarmName(), Locale.ENGLISH));
            ocAlarmBO.setSeverity(5 - legoAlarm.getAlarmLevel().getValue());
            ocAlarmBO.setOriginSystem("eReplication");
            ocAlarmBO.setOriginSystemType("eReplication");
            ocAlarmBO.setMoi(this.getOCFaultLocationInfo("eReplication", legoAlarm, Locale.CHINA) + "##" + this.getOCFaultLocationInfo("eReplication", legoAlarm, Locale.ENGLISH));
            ocAlarmBO.setMoc("eReplication");
            ocAlarmBO.setSubCsn((int)legoAlarm.getAlarmSequence());
            ocAlarmBO.setNativeMeDn(legoAlarm.getMoUuid());
            ocAlarmBO.setMeName("eReplication");
            ocAlarmBO.setMeCategory("eReplication");
            ocAlarmBO.setMeType("eReplication");
            ocAlarmBO.setAlarmGroupId(ALARM_GROUP_ID);
            ocAlarmBO.setAlarmGroupName("eReplication");
            ocAlarmBO.setOccurUtc(legoAlarm.getAlarmTime() / 1000L);
            int eventType = eventTypeMap.get(legoAlarm.getAlarmType());
            if (!VerifyUtil.isEmpty((Object)eventType)) {
                ocAlarmBO.setEventType(eventType);
            } else {
                ocAlarmBO.setEventType(legoAlarm.getAlarmType());
            }
            ocAlarmBO.setMatchKey(legoAlarm.getEntity());
            ocAlarmBO.setClearCategory(1);
            int clearTime = (int)(legoAlarm.getClearTime() / 1000L);
            ocAlarmBO.setClearUtc((long)clearTime);
            ocAlarmBO.setCleared(legoAlarm.getClearStatus().getValue());
            this.setCategory(ocAlarmBO, legoAlarm);
            if (REPORT_OC_TO_EVENT_ALARM_ID_LIST.contains(legoAlarm.getAlarmId()) && FaultEnum.ClearState.CLEARED.getValue() == legoAlarm.getClearStatus().getValue()) continue;
            ocAlarmBO.setClearUser(legoAlarm.getClearUser());
            ocAlarmBO.setAdditionalInformation(this.i18nMgr.getString(legoAlarm.getLocation(), Locale.CHINA, this.getOCParseParamForContainErrorID(legoAlarm, Locale.CHINA)) + "##" + this.i18nMgr.getString(legoAlarm.getLocation(), Locale.ENGLISH, this.getOCParseParamForContainErrorID(legoAlarm, Locale.ENGLISH)));
            LOG.debug((Object)"AlarmRecords : %s", new Object[]{ocAlarmBO.getMatchKey()});
            ocAlarmBOs.add(ocAlarmBO);
        }
        return ocAlarmBOs;
    }

    private void setCategory(OcAlarmBO ocAlarmBO, LegoAlarm legoAlarm) {
        ocAlarmBO.setCategory(1);
        if (FaultEnum.ClearState.CLEARED.getValue() == legoAlarm.getClearStatus().getValue()) {
            ocAlarmBO.setCategory(2);
        }
        if (REPORT_OC_TO_EVENT_ALARM_ID_LIST.contains(legoAlarm.getAlarmId())) {
            ocAlarmBO.setCategory(3);
        }
    }

    private void setOcToken() {
        String ip = LegoConfig.getInstance().getKeyValue("floatIp");
        if (VerifyUtil.isEmpty((String)ip)) {
            ip = LegoConfig.getInstance().getKeyValue("ip");
        }
        if (!VerifyUtil.isEmpty((Object)this.accessInfo)) {
            try {
                CloudConfig cloudConfig = this.accessInfo.clone();
                String pwdEncrpte = (String)this.accessInfo.getProps().get("oc_password");
                String pwdDecrpte = WccEncryptor.decrypt((String)pwdEncrpte);
                cloudConfig.getProps().put("oc_password", pwdDecrpte);
                this.ocToken = ((IOcAccessService)ServiceLocator.getInstance().getService(IOcAccessService.class)).getOcToken(cloudConfig, ip, Boolean.TRUE.booleanValue());
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Object)"Clone error: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() != Status.STATUS_STARTED) return;
        Class<OcFaultMsgHandler> clazz = OcFaultMsgHandler.class;
        synchronized (OcFaultMsgHandler.class) {
            this.accessInfo = ((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).getCloudConfigBy("oc");
            if (this.accessInfo == null) return;
            this.doscheduler();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void doscheduler() {
        this.scheduler.scheduleAtFixedRate(this::sendAlarm, 0L, 10000L, TimeUnit.MILLISECONDS);
    }

    public String getOCFaultLocationInfo(String serviceType, LegoAlarm legoAlarm, Locale locale) {
        StringBuffer moi = new StringBuffer();
        if (Locale.ENGLISH.equals(locale)) {
            moi.append(String.format(Locale.ROOT, SERVICE_TYPE_PATTERN_EN, serviceType));
        } else {
            moi.append(String.format(Locale.ROOT, SERVICE_TYPE_PATTERN_CH, serviceType));
        }
        String key = legoAlarm.getAlarmId() + ".alarm.moi";
        String moiDetail = this.i18nMgr.getString(key, locale, legoAlarm.getAlarmParam());
        if (VerifyUtil.isEmpty((String)moiDetail) || key.equalsIgnoreCase(moiDetail)) {
            return moi.substring(0, moi.length() - 2);
        }
        return moi.append(moiDetail).toString();
    }

    private String[] getOCParseParamForContainErrorID(LegoAlarm legoAlarm, Locale local) {
        if ("0x3230047".equals(legoAlarm.getAlarmId())) {
            return this.i18nMgr.getParseParamForContainErrorID(legoAlarm, local);
        }
        return legoAlarm.getAlarmParam();
    }

    public boolean isReportOc(String alarmId) {
        return OC_ALARM_ID_LIST.contains(alarmId);
    }

    static {
        eventTypeMap.put(1, 1);
        eventTypeMap.put(2, 5);
        eventTypeMap.put(3, 2);
        eventTypeMap.put(4, 4);
        eventTypeMap.put(5, 3);
        eventTypeMap.put(6, 9);
    }
}

