/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.fault;

import com.google.common.collect.ImmutableMap;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.DelReplicationTask;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.CloudAvailableZone;
import com.huawei.ism.drm.openstack.sdk.msg.CloudInfra;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.model.InstanceOrder;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.lego.cbb.cloudservice.sdk.util.MultiCloudUtil;
import com.huawei.lego.cbb.i18n.sdk.I18nMgr;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(name="com.huawei.ism.drm.openstack.sdk.service.IScOperationService", desc="", interfaceClass=IScOperationService.class)
public class ScOperationServiceImp
implements IScOperationService {
    private static final Log LOG = LogFactory.getInstance(ScOperationServiceImp.class);
    private static final String ACTION_UPDATE = "update";
    private static final String ACTION_DELETE = "delete";
    private static final String REPROT_ORDER_URL = "/rest/subscription/v3.0/subscriptions/";
    private static final String REPORT_QUOTA_SEPARATELY_URL = "/v2/quotamg/services/{service_name}/quotas/used";
    private static final int MAX_LENGTH = 1000;
    private static final LegoMoGenerator LEGOMOGENERATOR = new LegoMoGenerator();
    private I18nMgr i18nMgr;

    public I18nMgr getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMgr i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    public void reportOrderResult(String status, List<OrderInstanceInfo> instances, String quotas, Map<String, Object> extendParam) {
        String subscriptionId = Optional.ofNullable(extendParam).map(param -> param.get("subscription_id")).map(String::valueOf).orElse("");
        if (VerifyUtil.isEmpty((String)status) || VerifyUtil.isEmpty(instances) || VerifyUtil.isEmpty((String)subscriptionId)) {
            LOG.error((Object)("Report Order Result is null, status: " + status + " instances: " + instances + " subscriptionId: " + subscriptionId));
            return;
        }
        ScOperationServiceImp.deleteOrder(subscriptionId);
        JSONObject result = this.createOrderResult(status, instances, quotas, extendParam);
        String tokenId = null;
        String projectId = null;
        try {
            FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
            String openstackUuid = openstack.getUuid();
            projectId = ((OrderInstanceInfo)CommonUtil.getFirstElement(instances)).getProjectId();
            projectId = this.convertProjectIdToCenter(projectId);
            tokenId = TokenUtil.getInstance().getTokenId(openstackUuid + ":" + projectId);
        }
        catch (LegoCheckedException t) {
            LOG.error((Object)"Get openstackUuid or tokenId fail", (Throwable)t);
        }
        try {
            String url = REPROT_ORDER_URL + subscriptionId + "/result";
            this.sendOrderResult(tokenId, result.toString(), url);
        }
        catch (LegoCheckedException t) {
            LOG.error((Object)"Report Order Result fail", (Throwable)t);
            InstanceOrder order = new InstanceOrder();
            order.setSubscriptionId(subscriptionId);
            order.setOrderResult(result.toString());
            order.setProjectId(projectId);
            order.setStatus(status);
            order.setRetryTimes(1);
            this.changeInstanceOrder(order, ACTION_UPDATE);
        }
    }

    private String convertProjectIdToCenter(String projectId) {
        if (MultiCloudUtil.isSupportMultiCloud()) {
            projectId = MultiCloudUtil.convertToCenter((String)projectId);
        }
        return projectId;
    }

    private static void deleteOrder(String subscriptionId) {
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getMoDao().getHibernateTemplate();
        try {
            InstanceOrder order = new InstanceOrder();
            order.setSubscriptionId(subscriptionId);
            hibernateTemplate.delete((Object)order);
        }
        catch (DataAccessException e) {
            LOG.error((Object)"Failed to delete Instance Order.", (Throwable)e, 90160758786896L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void retrySendOrderResult() {
        List<InstanceOrder> list = this.getInstanceOrders();
        if (list.size() == 0) {
            LOG.info((Object)"No failed report InstanceOrder");
            return;
        }
        FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
        String uuid = openstack.getUuid();
        for (InstanceOrder order : list) {
            int times = order.getRetryTimes() + 1;
            if (VerifyUtil.isEmpty((String)order.getProjectId())) {
                LOG.info((Object)"The param projectId is empty, subscriptionId: %s", new Object[]{order.getSubscriptionId()});
                continue;
            }
            String projectId = this.convertProjectIdToCenter(order.getProjectId());
            String tokenId = TokenUtil.getInstance().getTokenId(uuid + ":" + projectId);
            if (ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.EXECUTING.getValue().equals(order.getStatus())) {
                this.dealExecutingOrder(order, times);
                continue;
            }
            this.reportOrderResultAndAlarm(order, times, tokenId, false);
        }
    }

    private List<InstanceOrder> getInstanceOrders() {
        List list;
        try {
            String hql = "from InstanceOrder";
            list = CommonDAOLocator.getBaseDao().find(hql, new Object[0]);
        }
        catch (DataAccessException e) {
            LOG.error((Object)"Failed to query InstanceOrder.", (Throwable)e, 90160758786896L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return list;
    }

    private void dealExecutingOrder(InstanceOrder order, int times) {
        LOG.debug((Object)"Order status is executing, times: %s", new Object[]{String.valueOf(times)});
        if (times < 24) {
            order.setRetryTimes(times);
        } else {
            order.setStatus(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue());
            order.setRetryTimes(0);
        }
        this.changeInstanceOrder(order, ACTION_UPDATE);
    }

    private boolean isReportQuotaSeparately(InstanceOrder order) {
        if (VerifyUtil.isEmpty((String)order.getExtendParam())) {
            LOG.info((Object)"The extendParam is empty, subscriptionId: %s", new Object[]{order.getSubscriptionId()});
            return false;
        }
        JSONObject extendParam = JSONObject.fromObject((Object)order.getExtendParam());
        if (!"false".equals(extendParam.getString("order_result_callback", null))) {
            return false;
        }
        return extendParam.getBoolean("should_report_quota_separately");
    }

    private void reportOrderResultAndAlarm(InstanceOrder order, int times, String tokenId, boolean isFirst) {
        String subscriptionId = order.getSubscriptionId();
        try {
            if (this.isReportQuotaSeparately(order)) {
                this.sendReportQuotaRequest(order, tokenId);
            } else {
                this.sendOrderResult(tokenId, order.getOrderResult(), REPROT_ORDER_URL + subscriptionId + "/result");
            }
            if (!isFirst) {
                this.changeInstanceOrder(order, ACTION_DELETE);
            }
            AlarmReporter.restoreAlarm((long)52625479L, (String[])new String[]{subscriptionId});
        }
        catch (LegoCheckedException t) {
            LOG.error((Object)"Retry report orderResult fail, the subscriptionId is %s, error msg=%s", new Object[]{subscriptionId, ExceptionUtil.getErrorMessage((Throwable)t)});
            if (times >= 24) {
                AlarmReporter.sendAlarm((long)52625479L, (String)subscriptionId, (String)FaultEnum.AlarmResourceType.UNDEFINED.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])this.getAlarmLocationParam(subscriptionId));
            }
            order.setRetryTimes(times);
            this.changeInstanceOrder(order, ACTION_UPDATE);
        }
    }

    public void recordingOrder(Map<String, Object> extendParam) {
        if ("false".equals(extendParam.getOrDefault("order_result_callback", null))) {
            LOG.info((Object)"Call recordingOrder order result callback is false.");
            return;
        }
        if (!extendParam.containsKey("order_instinfo") || !extendParam.containsKey("subscription_id")) {
            LOG.error((Object)("Order Result param is empty, extendParam: " + extendParam));
            return;
        }
        OrderInstanceInfo order = (OrderInstanceInfo)extendParam.get("order_instinfo");
        order.setResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue());
        ArrayList<OrderInstanceInfo> instances = new ArrayList<OrderInstanceInfo>();
        instances.add(order);
        JSONObject result = this.createOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), instances, null, extendParam);
        InstanceOrder instanceOrder = new InstanceOrder();
        instanceOrder.setSubscriptionId(extendParam.get("subscription_id").toString());
        instanceOrder.setOrderResult(result.toString());
        instanceOrder.setProjectId(order.getProjectId());
        instanceOrder.setStatus(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.EXECUTING.getValue());
        instanceOrder.setRetryTimes(0);
        try {
            this.changeInstanceOrder(instanceOrder, ACTION_UPDATE);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Recording Order fail : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private JSONObject createOrderResult(String status, List<OrderInstanceInfo> instances, String quotas, Map<String, Object> extendParam) {
        JSONObject result = new JSONObject();
        result.put((Object)"status", (Object)status);
        Locale znLocal = new Locale("zh", "CN");
        Locale enLocal = new Locale("en");
        JSONArray instanceList = new JSONArray();
        for (OrderInstanceInfo inst : instances) {
            Map<String, String> instance = this.getInstance(znLocal, enLocal, inst);
            instanceList.add(instance);
            if (extendParam.containsKey("PG_NOT_DELETE_VOLUMES")) {
                this.reportEvsVolume(instanceList, inst, extendParam);
                continue;
            }
            this.reportVolume(instanceList, inst);
        }
        result.put((Object)"instances", (Object)instanceList);
        if (null != quotas) {
            result.put((Object)"extend_quotas", (Object)JSONArray.fromObject((Object)quotas));
        }
        return result;
    }

    private Map<String, String> getInstance(Locale znLocal, Locale enLocal, OrderInstanceInfo inst) {
        HashMap<String, String> instance = new HashMap<String, String>();
        instance.put("result", inst.getResult());
        instance.put("instance_id", inst.getInstanceId());
        instance.put("instance_name", inst.getInstanceName());
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(inst.getInstanceType()) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(inst.getInstanceType())) {
            instance.put("instance_type", ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getFrontValue());
        } else {
            instance.put("instance_type", ServiceInstaceEnumDefine.ServiceInstanceTypeE.getServiceIdFromServiceType((String)inst.getInstanceType()));
        }
        if (!VerifyUtil.isEmpty((String)inst.getProductId())) {
            instance.put("product_id", inst.getProductId());
        }
        instance.put("region_id", inst.getRegionId());
        instance.put("project_id", inst.getProjectId());
        if (!VerifyUtil.isEmpty((String)inst.getErrorCode())) {
            String messageZn;
            instance.put("error_code", inst.getErrorCode());
            String messageEn = this.i18nMgr.getString(inst.getErrorCode(), enLocal, inst.getParam());
            if (messageEn.length() > 1000) {
                messageEn = messageEn.substring(0, 1000);
            }
            if ((messageZn = this.i18nMgr.getString(inst.getErrorCode(), znLocal, inst.getParam())).length() > 1000) {
                messageZn = messageZn.substring(0, 1000);
            }
            JSONObject errorInfo = new JSONObject();
            errorInfo.put((Object)"zh_CN", (Object)messageZn);
            errorInfo.put((Object)"en_US", (Object)messageEn);
            instance.put("message", errorInfo.toString());
        }
        return instance;
    }

    private void reportVolume(JSONArray instanceList, OrderInstanceInfo inst) {
        List beforeDrVolList = inst.getBeforeDrVolList();
        String beforeStutas = inst.getBeforeStutas();
        ServiceInstaceEnumDefine.ServiceInstanceOperateType operateType = inst.getOperateType();
        if (ServiceInstaceEnumDefine.ServiceInstanceOperateType.DEL_INSTANCE.equals((Object)operateType) && DelReplicationTask.NO_ALLOWDELETE_STATUS.contains(beforeStutas)) {
            LOG.info((Object)"Delete instance:%s when status is unnormal, no need report volume info.", new Object[]{inst.getInstanceId()});
            return;
        }
        beforeDrVolList = beforeDrVolList == null ? new ArrayList() : beforeDrVolList;
        List<OpenStackVolume> currentDrVolList = OpenStackCommonUtil.findAllDrVolumes(inst.getInstanceId());
        List<OpenStackVolume> reportVolume = this.getReportVolume(beforeDrVolList, currentDrVolList);
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        for (OpenStackVolume volume : reportVolume) {
            HashMap<String, String> volumeMap = new HashMap<String, String>();
            volumeMap.put("result", inst.getResult());
            volumeMap.put("region_id", OpenStackCommonUtil.getIdFromUuid(volume.getRegionUuid()));
            volumeMap.put("project_id", OpenStackCommonUtil.getIdFromUuid(volume.getProjUuid()));
            volumeMap.put("instance_id", OpenStackCommonUtil.getIdFromUuid(volume.getUuid()));
            volumeMap.put("instance_name", volume.getName());
            volumeMap.put("instance_type", quotaService.getEVSServiceId());
            instanceList.add(volumeMap);
        }
    }

    private void reportEvsVolume(JSONArray instanceList, OrderInstanceInfo inst, Map<String, Object> extendParam) {
        if (ServiceInstaceEnumDefine.ServiceInstanceOperateType.DEL_INSTANCE.equals((Object)inst.getOperateType()) && DelReplicationTask.NO_ALLOWDELETE_STATUS.contains(inst.getBeforeStutas())) {
            LOG.info((Object)"Delete instance:%s when status is unnormal, no need report volume info.", new Object[]{inst.getInstanceId()});
            return;
        }
        ArrayList<OpenStackVolume> beforeDrVolList = VerifyUtil.isEmpty((Collection)inst.getBeforeDrVolList()) ? new ArrayList() : inst.getBeforeDrVolList();
        String drRegionId = String.valueOf(extendParam.get("drRegionId"));
        Object volumeObjs = extendParam.get("PG_NOT_DELETE_VOLUMES");
        if (!(volumeObjs instanceof List)) {
            return;
        }
        List<OpenStackVolume> currentDrVolList = this.convertToOpenStackVolume((List)volumeObjs, drRegionId);
        List<OpenStackVolume> reportVolumes = this.getReportVolume(beforeDrVolList, currentDrVolList);
        String evsServiceId = LegoConfig.getInstance().getKeyValue("evs_service_id", "evs");
        for (OpenStackVolume volume : reportVolumes) {
            HashMap<String, String> volumeMap = new HashMap<String, String>();
            volumeMap.put("result", inst.getResult());
            volumeMap.put("region_id", OpenStackCommonUtil.getIdFromUuid(volume.getRegionUuid()));
            volumeMap.put("project_id", OpenStackCommonUtil.getIdFromUuid(volume.getProjUuid()));
            volumeMap.put("instance_id", OpenStackCommonUtil.getIdFromUuid(volume.getUuid()));
            volumeMap.put("instance_name", volume.getName());
            volumeMap.put("instance_type", evsServiceId);
            instanceList.add(volumeMap);
        }
    }

    private List<OpenStackVolume> convertToOpenStackVolume(List volumeList, String regionId) {
        if (VerifyUtil.isEmpty((Collection)volumeList)) {
            return Collections.emptyList();
        }
        ArrayList<OpenStackVolume> openStackVolumes = new ArrayList<OpenStackVolume>();
        for (Object volumeObj : volumeList) {
            if (!(volumeObj instanceof VolumeInfo)) continue;
            VolumeInfo volumeInfo = (VolumeInfo)volumeObj;
            OpenStackVolume openStackVolume = new OpenStackVolume();
            openStackVolume.setRegionUuid(regionId);
            openStackVolume.setProjUuid(volumeInfo.getProjectId());
            openStackVolume.setUuid(volumeInfo.getId());
            openStackVolumes.add(openStackVolume);
        }
        return openStackVolumes;
    }

    private List<OpenStackVolume> getReportVolume(List<OpenStackVolume> beforeDrVolList, List<OpenStackVolume> currentDrVolList) {
        ArrayList<OpenStackVolume> reportVolume = new ArrayList<OpenStackVolume>();
        if (currentDrVolList.size() >= beforeDrVolList.size()) {
            String dupKey;
            HashSet<String> dupSet = new HashSet<String>();
            for (OpenStackVolume volume : beforeDrVolList) {
                dupKey = OpenStackCommonUtil.getVolumeDupKey(volume);
                dupSet.add(dupKey);
            }
            for (OpenStackVolume volume : currentDrVolList) {
                dupKey = OpenStackCommonUtil.getVolumeDupKey(volume);
                if (dupSet.contains(dupKey)) continue;
                reportVolume.add(volume);
            }
        } else {
            String dupKey;
            HashSet<String> dupSet = new HashSet<String>();
            for (OpenStackVolume volume : currentDrVolList) {
                dupKey = OpenStackCommonUtil.getVolumeDupKey(volume);
                dupSet.add(dupKey);
            }
            for (OpenStackVolume volume : beforeDrVolList) {
                dupKey = OpenStackCommonUtil.getVolumeDupKey(volume);
                if (dupSet.contains(dupKey)) continue;
                reportVolume.add(volume);
            }
        }
        return reportVolume;
    }

    private void changeInstanceOrder(InstanceOrder order, String action) {
        try {
            if (action.equals(ACTION_UPDATE)) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)order);
            } else if (action.equals(ACTION_DELETE)) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)order);
            }
        }
        catch (DataAccessException e) {
            LOG.error((Object)"Failed to change Instance Order.", (Throwable)e, 90160758786896L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void updateProjectQuotas(String regionId, String projectId, String quotas) {
        if (VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)quotas)) {
            LOG.error((Object)("Param is null, regionId: " + regionId + " projectId: " + projectId + " quotas: " + quotas));
            return;
        }
        try {
            FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
            String openstackUuid = openstack.getUuid();
            String tokenId = TokenUtil.getInstance().getTokenId(openstackUuid + ":" + projectId);
            String url = "/rest/vdc/v3.0/quotas/regions/" + regionId;
            this.sendOrderResult(tokenId, quotas, url);
        }
        catch (Exception t) {
            LOG.error((Object)("Update Project Quotas fail:" + ExceptionUtil.getErrorMessage((Throwable)t)));
        }
    }

    protected void sendOrderResult(String tokenId, String message, String url) {
        if (VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)message) || VerifyUtil.isEmpty((String)url)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        CloudConfig accessInfo = this.getCloudConfig();
        if (VerifyUtil.isEmpty((Object)accessInfo)) {
            LOG.error((Object)"AccessInfo is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String domain = (String)accessInfo.getProps().get("manageOne_domain");
        String port = (String)accessInfo.getProps().get("manageOne_port");
        String adderss = "https://" + domain + ":" + port;
        String urlStr = adderss + url;
        LOG.debug((Object)"Put message to SC, urlStr: %s", new Object[]{urlStr});
        ClientUtil.sendPutRequest(urlStr, message, tokenId);
    }

    public List<CloudInfra> queryCloudInfras() {
        HashMap uriVariables;
        if (VerifyUtil.isEmpty((Object)OpenStackCommonUtil.getOpenstack())) {
            return Collections.emptyList();
        }
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        if (VerifyUtil.isEmpty((Object)open)) {
            return Collections.emptyList();
        }
        CloudConfig accessInfo = this.getCloudConfig();
        if (VerifyUtil.isEmpty((Object)accessInfo)) {
            LOG.error((Object)"AccessInfo is empty");
            return Collections.emptyList();
        }
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String domain = (String)accessInfo.getProps().get("manageOne_domain");
        String port = (String)accessInfo.getProps().get("manageOne_port");
        String adderss = "https://" + domain + ":" + port;
        String urlStr = adderss + "/rest/serviceaccess/v3.0/cloud-infras";
        String respStr = ClientUtil.sendGetRequest(urlStr, uriVariables = new HashMap(), tokenId, new int[0]);
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to get cloudInfras.response string is empty");
            return Collections.emptyList();
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"records")) {
            JSONArray jsonArray = json.getJSONArray("records");
            return JSONArray.toCollection((JSONArray)jsonArray, CloudInfra.class);
        }
        LOG.error((Object)"Failed to get records,request");
        return Collections.emptyList();
    }

    public List<CloudAvailableZone> queryAvailableZones(String cloudInfraId) {
        if (VerifyUtil.isEmpty((Object)OpenStackCommonUtil.getOpenstack())) {
            return Collections.emptyList();
        }
        CloudConfig accessInfo = this.getCloudConfig();
        if (VerifyUtil.isEmpty((Object)accessInfo)) {
            LOG.error((Object)"AccessInfo is empty");
            return Collections.emptyList();
        }
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String domain = (String)accessInfo.getProps().get("manageOne_domain");
        String port = (String)accessInfo.getProps().get("manageOne_port");
        String adderss = "https://" + domain + ":" + port;
        String urlStr = adderss + "/rest/serviceaccess/v3.0/available-zones?cloud_infra_id={cloud_infra_id}";
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("cloud_infra_id", cloudInfraId);
        String respStr = ClientUtil.sendGetRequest(urlStr, uriVariables, tokenId, new int[0]);
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to get availableZones.response string is empty");
            return Collections.emptyList();
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"records")) {
            JSONArray jsonArray = json.getJSONArray("records");
            return JSONArray.toCollection((JSONArray)jsonArray, CloudAvailableZone.class);
        }
        LOG.error((Object)"Failed to get records,request");
        return Collections.emptyList();
    }

    private String[] getAlarmLocationParam(String subscriptionId) {
        CloudConfig accessInfo = this.getCloudConfig();
        return new String[]{subscriptionId, VerifyUtil.isEmpty((Object)accessInfo) ? "" : (String)accessInfo.getProps().get("manageOne_domain"), VerifyUtil.isEmpty((Object)accessInfo) ? "" : (String)accessInfo.getProps().get("manageOne_port"), LEGOMOGENERATOR.getInstallServerIp()};
    }

    public void reportQuotaSeparately(InstanceOrder todoReportQuota, String tokenId) {
        if (VerifyUtil.isEmpty((Object)todoReportQuota)) {
            LOG.error((Object)"The param todoReportQuota is empty");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkObjs((Object[])new Object[]{todoReportQuota.getOrderResult(), todoReportQuota.getSubscriptionId(), todoReportQuota.getExtendParam(), todoReportQuota.getProjectId()});
        this.reportOrderResultAndAlarm(todoReportQuota, 0, tokenId, true);
    }

    private void sendReportQuotaRequest(InstanceOrder todoReportQuota, String tokenId) {
        CloudConfig accessInfo = this.getCloudConfig();
        if (VerifyUtil.isEmpty((Object)accessInfo)) {
            LOG.error((Object)"AccessInfo is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String requestBodyJson = todoReportQuota.getOrderResult();
        JSONObject requestBody = JSONObject.fromObject((Object)requestBodyJson);
        String domain = (String)accessInfo.getProps().get("manageOne_domain");
        String port = (String)accessInfo.getProps().get("manageOne_port");
        String address = "https://" + domain + ":" + port;
        String url = REPORT_QUOTA_SEPARATELY_URL.replace("{service_name}", requestBody.getString("service_name"));
        String urlStr = address + url;
        LOG.debug((Object)"Put message to SC Separately, urlStr: %s", new Object[]{urlStr});
        ClientUtil.sendPutRequest(urlStr, requestBodyJson, tokenId, (Map<String, String>)ImmutableMap.of((Object)"X-Client-Token", (Object)todoReportQuota.getSubscriptionId()));
    }

    private CloudConfig getCloudConfig() {
        return ((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).getCloudConfigBy("manageOne");
    }
}

