/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.listener;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.serviceinstance.AutoDeleteMeterRecords;
import com.huawei.ism.drm.openstack.serviceinstance.AutoReportInstanceOrderInfo;
import com.huawei.ism.drm.openstack.serviceinstance.AutoReportMetersInfo;
import com.huawei.ism.drm.openstack.serviceinstance.CheckArbitrationStatus;
import com.huawei.ism.drm.openstack.serviceinstance.CheckIntanceConfig;
import com.huawei.ism.drm.openstack.serviceinstance.CheckLicenseTimeoutTask;
import com.huawei.ism.drm.openstack.serviceinstance.SDRRegisterHelper;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.UpdateVolTypeMappingTask;
import com.huawei.ism.drm.openstack.system.unitepassword.task.IAMregistask;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ServiceInstanceInitializer
implements SystemStatusChangedListener {
    private static final Log LOG = LogFactory.getInstance(ServiceInstanceInitializer.class);
    private static final Long DEFAULT_INTERVAL = 43200000L;
    private static final Long DEFAULT_DELAY = 600000L;

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            LOG.info((Object)"The status started, begin check instance");
            Timer timer = new Timer(true);
            CheckIntanceConfig task = new CheckIntanceConfig();
            timer.schedule((TimerTask)task, DEFAULT_DELAY, (long)DEFAULT_INTERVAL);
            Timer meterTimer = new Timer(true);
            AutoReportMetersInfo reportMeterInfo = new AutoReportMetersInfo();
            meterTimer.schedule((TimerTask)reportMeterInfo, 600000L, 3600000L);
            this.deleteMeterRecords();
            Timer orderTimer = new Timer(true);
            AutoReportInstanceOrderInfo reportOrderInfo = new AutoReportInstanceOrderInfo();
            orderTimer.schedule((TimerTask)reportOrderInfo, 1800000L, 3600000L);
            Timer checkTimer = new Timer(true);
            CheckArbitrationStatus checkArbTask = new CheckArbitrationStatus();
            checkTimer.schedule((TimerTask)checkArbTask, 0L, 10000L);
            Timer licenseCheckTimer = new Timer(true);
            CheckLicenseTimeoutTask checkLicenseTimeoutTask = new CheckLicenseTimeoutTask();
            licenseCheckTimer.schedule((TimerTask)checkLicenseTimeoutTask, 3600000L, 86400000L);
            Timer updateVolTypeMappingTimer = new Timer(true);
            UpdateVolTypeMappingTask updateVolTypeMappingTask = new UpdateVolTypeMappingTask(updateVolTypeMappingTimer);
            updateVolTypeMappingTimer.schedule((TimerTask)updateVolTypeMappingTask, 60000L, 300000L);
            this.changeInstanceStatus();
            this.checkInstanceMeterRecords();
            SDRRegisterHelper.getInstance().registerSDR();
            Timer iamTimer = new Timer(true);
            IAMregistask iamregistask = new IAMregistask();
            iamTimer.schedule((TimerTask)iamregistask, 1800000L, DEFAULT_INTERVAL * 2L);
        }
    }

    private void deleteMeterRecords() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 2);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date date = calendar.getTime();
        if (date.before(new Date())) {
            Calendar startDT = Calendar.getInstance();
            startDT.setTime(date);
            startDT.add(5, 1);
            date = startDT.getTime();
        }
        Timer meterRecordTimer = new Timer(true);
        AutoDeleteMeterRecords deleteMeterRecords = new AutoDeleteMeterRecords();
        meterRecordTimer.schedule((TimerTask)deleteMeterRecords, date, 86400000L);
    }

    private void checkInstanceMeterRecords() {
        IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
        meterService.checkInstanceMeterRecords();
    }

    private void changeInstanceStatus() {
        LOG.info((Object)"enter change instance status1");
        try {
            List serviceInsList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ServiceInstance", new Object[0]);
            if (VerifyUtil.isEmpty((Collection)serviceInsList)) {
                LOG.info((Object)"No serviceinstance to change status");
                return;
            }
            IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
            for (ServiceInstance instance : serviceInsList) {
                String status = instance.getStatus();
                ServiceInstaceEnumDefine.ServiceInstanceStatusE statusEnum = ServiceInstaceEnumDefine.ServiceInstanceStatusE.getType((String)status);
                if (null == statusEnum) {
                    LOG.info((Object)"The status is invalid:%s", new Object[]{status});
                    continue;
                }
                String planId = instance.getRecoveryPlanId();
                RecoveryPlan plan = planService.getRecoveryPlan(planId);
                ServiceInstaceEnumDefine.ServiceInstanceStatusE targetStatusEnum = this.getTargetStatus(plan, statusEnum);
                if (targetStatusEnum.equals((Object)statusEnum)) continue;
                LOG.info((Object)"Change instance status from %s to %s", new Object[]{statusEnum, targetStatusEnum});
                ServiceInstanceHelper.getInstance().changeStatus(instance.getId(), targetStatusEnum);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Change serviceinstace status failed," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private ServiceInstaceEnumDefine.ServiceInstanceStatusE getTargetStatus(RecoveryPlan plan, ServiceInstaceEnumDefine.ServiceInstanceStatusE currentStatus) {
        ServiceInstaceEnumDefine.ServiceInstanceStatusE targetStatusEnum = currentStatus;
        switch (currentStatus) {
            case TESTING: {
                targetStatusEnum = this.getStatusForTest(plan);
                break;
            }
            case HOT_MIGRATION_RUNNING: {
                targetStatusEnum = this.getStatusForHotMigration(plan);
                break;
            }
            case PLANED_MIGRATION_RUNNING: {
                targetStatusEnum = this.getStatusForPlanMigration(plan);
                break;
            }
            case DISASTER_RECOVERY_RUNNING: {
                targetStatusEnum = this.getStatusForDisasterRecovery(plan);
                break;
            }
            case REPROTECT_RUNNING: {
                targetStatusEnum = this.getStatusForReprotect(plan);
                break;
            }
            case LOCKED: {
                targetStatusEnum = ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL;
                break;
            }
            case DELETING: {
                targetStatusEnum = ServiceInstaceEnumDefine.ServiceInstanceStatusE.ERR_DELETE;
                break;
            }
            default: {
                LOG.info((Object)"Will not change status, currentStatus=%s", new Object[]{currentStatus});
            }
        }
        return targetStatusEnum;
    }

    private ServiceInstaceEnumDefine.ServiceInstanceStatusE getStatusForReprotect(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL;
        }
        return ServiceInstaceEnumDefine.ServiceInstanceStatusE.REPROTECT_FAILED;
    }

    private ServiceInstaceEnumDefine.ServiceInstanceStatusE getStatusForDisasterRecovery(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_COMPLETED;
        }
        return ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_FAILED;
    }

    private ServiceInstaceEnumDefine.ServiceInstanceStatusE getStatusForPlanMigration(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL;
        }
        return ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_FAILED;
    }

    private ServiceInstaceEnumDefine.ServiceInstanceStatusE getStatusForHotMigration(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL;
        }
        return ServiceInstaceEnumDefine.ServiceInstanceStatusE.HOT_MIGRATION_FAILED;
    }

    private ServiceInstaceEnumDefine.ServiceInstanceStatusE getStatusForTest(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.ServiceInstanceStatusE.TESTED;
        }
        return ServiceInstaceEnumDefine.ServiceInstanceStatusE.ERR_TEST;
    }
}

