/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlanUtil;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.service.IEvsServiceInstanceService;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService;
import com.huawei.ism.drm.openstack.serviceinstance.task.ServiceInstanceReplicationSyncTask;
import com.huawei.ism.drm.openstack.tools.OpenStackCheckPhVolumeUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

public class CreateVolumeInstanceTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(CreateVolumeInstanceTask.class);
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final List<String> HAVE_RECOVERY_PLAN_INSTANCE_TYPE_LIST = Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
    private ProtectGroup pg;
    private String proId;
    private ServiceInstanceReplicationSyncTask serviceInstanceReplicationSyncTask;
    private JSONObject evsQuota;

    public CreateVolumeInstanceTask(String proId, String type, ProtectGroup pg, ServiceInstanceReplicationSyncTask serviceInstanceReplicationSyncTask) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)pg.getName(), (String)"ism.drm.instance.create", (String)proId, (String)type, (String)"", null), 2147483, true);
        this.pg = pg;
        this.proId = proId;
        this.serviceInstanceReplicationSyncTask = serviceInstanceReplicationSyncTask;
    }

    protected void doWork() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
            this.setEvsQuotaToExtendParam(this.evsQuota, "quotas", "order_quotas");
            this.setEvsQuotaToExtendParam(this.evsQuota, "original_quotas", "original_quotas");
        }
        IServiceInstanceService instService = (IServiceInstanceService)ServiceLocator.getInstance().getService(IEvsServiceInstanceService.class);
        instService.checkCreateInstanceParam(this.pg);
        String regionId = this.pg.getProperty("regionId");
        String drRegionId = this.pg.getProperty("drRegionId");
        OpenStackCheckPhVolumeUtil.checkPhVolumesAndRun(regionId, drRegionId, this.pg.getPolist(), this::work);
    }

    private void work() {
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        String result = quotaService.checkCreateInstanceOutOfQuota(this.proId, this.pg);
        if (!VerifyUtil.isEmpty((String)result)) {
            String[] para = result.split(":");
            LOG.error((Object)"Create instance out of quota:pgName=%s", new Object[]{this.pg.getName()});
            throw new LegoCheckedException(1073948125L, para, "Create instance failed.");
        }
        String instanceUuid = UUIDGenerator.getUUID();
        this.pg.getProps().put("SERVICEINSTANCE_UUID", instanceUuid);
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        long createPgTaskId = pgService.createProtectGroup(this.pg, false);
        if (!OpenStackCommonUtil.monitorCreateInstanceTaskResult(createPgTaskId)) {
            LOG.error((Object)"Create protectgroup failed:pgName=%s", new Object[]{this.pg.getName()});
            throw new LegoCheckedException(1073948104L, "Create instance failed.");
        }
        String type = (String)this.pg.getProps().get("serviceInstanceType");
        String planId = null;
        if (HAVE_RECOVERY_PLAN_INSTANCE_TYPE_LIST.contains(type)) {
            planId = RecoveryPlanUtil.createRecoveryPlan((ProtectGroup)this.pg, (String)this.pg.getObjectType());
            LOG.debug((Object)"Create recovery plan successfully, planId=%s", new Object[]{planId});
        }
        ServiceInstance instance = this.constructorServiceInstance(instanceUuid, type, planId, this.pg.getObjectType());
        this.saveServiceInstanceAndReportMeter(instance);
        this.serviceInstanceReplicationSyncTask.add(instanceUuid);
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            if (this.getExtendParam().get("order_instinfo") instanceof OrderInstanceInfo) {
                OrderInstanceInfo order = (OrderInstanceInfo)this.getExtendParam().get("order_instinfo");
                order.setInstanceId(instance.getId());
            }
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
        }
    }

    private ServiceInstance constructorServiceInstance(String instanceUuid, String type, String planId, String objectType) {
        ServiceInstance instance = new ServiceInstance();
        instance.setDescription(this.pg.getDescription());
        instance.setName(this.pg.getName());
        instance.setOwnerId(this.pg.getOwnerId());
        instance.setStatus(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue());
        String projectUuid = (String)this.pg.getProps().get("projectId");
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        instance.setProjectId(projectId);
        instance.setProtectGroupId(this.pg.getUuid());
        instance.setRecoveryPlanId(planId);
        instance.setUuid(instanceUuid);
        instance.setCreateTime(Long.valueOf(new Date().getTime()));
        instance.setObjectType(objectType);
        instance.setStartPriority(3);
        instance.setType(type);
        instance.setProtectType(type);
        return instance;
    }

    private void saveServiceInstanceAndReportMeter(ServiceInstance instance) {
        try {
            LOG.debug((Object)"Start save ServiceInstance.ServiceInstanceName=%s, ServiceInstanceID=%s,protectGroupID=%s", new Object[]{instance.getName(), instance.getId(), instance.getProtectGroupId()});
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)instance);
            String regionUuid = (String)this.pg.getProps().get("regionId");
            String drRegionUuid = (String)this.pg.getProps().get("drRegionId");
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            Map meterInfos = meterService.calculateMeterInfos(this.pg);
            meterInfos.put("change_type", "inst_create");
            meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
            meterService.reportChangedMeterInfo(regionUuid, instance, openstackUuid, meterInfos);
            meterService.reportChangedMeterInfo(drRegionUuid, instance, openstackUuid, meterInfos);
            LOG.debug((Object)"End save ServiceInstance.ServiceInstanceName=%s, ServiceInstanceID=%s,protectGroupID=%s", new Object[]{instance.getName(), instance.getId(), instance.getProtectGroupId()});
        }
        catch (LegoCheckedException | NullPointerException | DataAccessException e) {
            LOG.error((Object)"Create instance error. error msg=%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948104L, "Create instance error.", e);
        }
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            if (this.getExtendParam().get("order_instinfo") instanceof OrderInstanceInfo) {
                OrderInstanceInfo order = (OrderInstanceInfo)this.getExtendParam().get("order_instinfo");
                order.setInstanceId((String)this.pg.getProps().get("SERVICEINSTANCE_UUID"));
            }
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }

    public void setEvsQuota(JSONObject evsQuota) {
        this.evsQuota = evsQuota;
    }
}

