/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.OpenstackPgRefreshServiceImpl;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackConsts;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DelVolumesFromVmBackTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(DelVolumesFromVmBackTask.class);
    private static final int DEFAULT_TIMEOUT = 7200;
    private String instanceId;
    private ProtectObject po;
    private String serverId;
    private ProtectGroup pg;
    private String serviceType;
    private Set<ProtectedVolumeInfo> willDelVolumes;
    private PoReplicaInfo normalReplicaInfo;
    private PoReplicaInfo standbyReplicaInfo;
    private PoReplicaInfo hyperMetroReplicaInfo;
    private Map<String, PoReplicaPairInfo> normalPairInfoMapping;
    private Map<String, PoReplicaPairInfo> standbyPairInfoMapping;
    private Map<String, PoReplicaPairInfo> hyperMetroPairInfoMapping;
    private IVolumeService volumeService;
    private IProtectGroupRefreshService pgRefreshService;
    private String openstackUuid;
    private String regionUuid;
    private String drRegionUuid;
    private String projUuid;
    private String drProjUuid;

    public DelVolumesFromVmBackTask(String proId, String type, String instanceId, ProtectGroup pg, String serverId, Set<ProtectedVolumeInfo> delVolumes) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)pg.getName(), (String)"ism.drm.instance.del.volumes.fromvm", (String)proId, (String)type, (String)"", (String[])new String[]{pg.getName()}), 7200, true);
        this.instanceId = instanceId;
        this.pg = pg;
        this.serverId = serverId;
        this.willDelVolumes = delVolumes;
        this.volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        this.pgRefreshService = new OpenstackPgRefreshServiceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        this.handleHighThan63();
        if (!ServiceInstanceHelper.getInstance().getLock(this.instanceId)) {
            throw new LegoCheckedException(1073948693L);
        }
        try {
            ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.LOCKED);
            boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(this.pg.getUuid());
            if (!lockFlag) {
                LOG.error((Object)("The pg is locked: " + this.pg.getUuid()), 90160758786893L);
                throw new LegoCheckedException(102401L);
            }
            this.pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(this.pg.getUuid(), false);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            Map meterInfos = meterService.calculateMeterInfos(this.pg);
            meterInfos.put("change_type", "inst_update");
            meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
            this.initParam();
            this.checkVolSnapshots();
            this.reconnectVolumes();
            this.delReplica();
            this.updatePgReplica();
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.pg);
            ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)this.instanceId));
            meterService.reportChangedMeterInfo(this.regionUuid, instance, this.openstackUuid, meterInfos);
            meterService.reportChangedMeterInfo(this.drRegionUuid, instance, this.openstackUuid, meterInfos);
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Delete volume protect failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"delete volume protect failed", (long)0x300001L, (String[])new String[0], (Log)LOG);
        }
        finally {
            this.clearAlarm();
        }
    }

    private void clearAlarm() {
        ProtectionJobUtil.getInstance().releaseLockPg(this.pg.getUuid());
        this.refreshPg();
        ServiceInstanceHelper.getInstance().releaseLock(this.instanceId);
        try {
            ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL);
        }
        catch (Exception e) {
            LOG.error((Object)("Set instance(" + this.instanceId + ") normal error."), (Throwable)e);
        }
    }

    private void updatePgReplica() {
        if (34 == this.pg.getTemplate().getType() || 37 == this.pg.getTemplate().getType()) {
            this.po.getProps().put("hypermetor_replicationInfo", JsonUtil.beanToJson(this.hyperMetroReplicaInfo));
            if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(this.pg.getProperty("replicaCgRepStatus"))) {
                this.po.getProps().put("replicationInfo", JsonUtil.beanToJson(this.standbyReplicaInfo));
                this.po.getProps().put("remote_replicationInfo", JsonUtil.beanToJson(this.normalReplicaInfo));
            } else {
                this.po.getProps().put("replicationInfo", JsonUtil.beanToJson(this.normalReplicaInfo));
                this.po.getProps().put("remote_replicationInfo", JsonUtil.beanToJson(this.standbyReplicaInfo));
            }
        } else {
            this.po.getProps().put("replicationInfo", JsonUtil.beanToJson(this.normalReplicaInfo));
        }
    }

    private void handleHighThan63() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
            IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
            String quotas = quotaService.calculateDeleteVolumeQuota(this.instanceId, this.willDelVolumes);
            Map param = this.getExtendParam();
            param.put("order_quotas", quotas);
            this.setExtendParam(param);
        }
    }

    private void refreshPg() {
        try {
            if (!VerifyUtil.isEmpty((Object)this.pgRefreshService)) {
                this.pgRefreshService.refreshProtectGroup(this.pg);
            }
        }
        catch (Exception e) {
            LOG.error((Object)(this.pg.getName() + "refresh failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void delShareVolVmReplica(String delVolUuid) {
        for (ProtectObject protectObject : this.pg.getPolist()) {
            if (this.po.equals((Object)protectObject)) continue;
            String replicaInfoStr = (String)protectObject.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
            if (null != poReplicaInfo) {
                this.removeUsedStorageResourceByVmType(delVolUuid, poReplicaInfo, protectObject);
                HashSet<String> delVolumeStatus = new HashSet<String>();
                delVolumeStatus.add(OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus());
                if (OpenStackCommonUtil.isBareMetalServer(OpenStackCommonUtil.getServerById(this.projUuid, this.regionUuid, this.serverId))) {
                    delVolumeStatus.add(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
                }
                List poReplicaPairInfoList = poReplicaInfo.getPairInfos();
                Iterator iterator = poReplicaPairInfoList.iterator();
                while (iterator.hasNext()) {
                    PoReplicaPairInfo poReplicaPairInfo = (PoReplicaPairInfo)iterator.next();
                    if (!delVolUuid.equals(poReplicaPairInfo.getVolumeUuid()) || !delVolumeStatus.contains(poReplicaPairInfo.getVolumeStatus())) continue;
                    iterator.remove();
                    this.removeUsedStorageResource(poReplicaPairInfo.getVolumeUuid(), protectObject);
                }
            }
            protectObject.getProps().put("replicationInfo", JsonUtil.beanToJson(poReplicaInfo));
        }
    }

    private void delReplica() {
        boolean ring;
        String ringUUID = this.getRingUUID();
        boolean bl = ring = ringUUID != null;
        if (ring) {
            this.volumeService.closeRing(this.regionUuid, this.drProjUuid, ringUUID, false);
        }
        for (ProtectedVolumeInfo delVolumeInfo : this.willDelVolumes) {
            String volumeUuid = delVolumeInfo.getVolumeId();
            Set<String> masters = this.getVolumeUuidsByMaster(this.normalPairInfoMapping, this.standbyPairInfoMapping, volumeUuid);
            PoReplicaPairInfo normalPair = this.getReplicaByVolumeUuid(this.normalPairInfoMapping, masters);
            PoReplicaPairInfo standbyPair = this.getReplicaByVolumeUuid(this.standbyPairInfoMapping, masters);
            PoReplicaPairInfo hyperMetroPair = null;
            if (masters.size() > 1) {
                hyperMetroPair = this.getReplicaByVolumeUuid(this.hyperMetroPairInfoMapping, masters);
            } else if (null != normalPair && null != standbyPair) {
                Set<String> slaves = Stream.of(normalPair.getDrVolumeUuid(), standbyPair.getDrVolumeUuid()).filter(slave -> !VerifyUtil.isEmpty((String)slave)).map(slave -> {
                    if (!slave.contains(":")) {
                        return OpenStackCommonUtil.getObjectUuid(this.openstackUuid, slave);
                    }
                    return slave;
                }).collect(Collectors.toSet());
                hyperMetroPair = this.getReplicaByVolumeUuid(this.hyperMetroPairInfoMapping, slaves);
            }
            this.deleteReplicaInfo(normalPair, standbyPair, hyperMetroPair);
            this.deleteVolumeInfo(volumeUuid, normalPair, standbyPair, hyperMetroPair);
            this.removePairInfo(volumeUuid, normalPair, standbyPair, hyperMetroPair);
        }
        if (ring) {
            this.volumeService.openRing(this.regionUuid, this.drProjUuid, ringUUID);
        }
    }

    private void deleteReplicaInfo(PoReplicaPairInfo normalPair, PoReplicaPairInfo standbyPair, PoReplicaPairInfo hyperMetroPair) {
        this.delReplicationReplica(this.standbyReplicaInfo, standbyPair);
        this.delReplicationReplica(this.normalReplicaInfo, normalPair);
        this.delReplicationReplica(this.hyperMetroReplicaInfo, hyperMetroPair);
    }

    private void deleteVolumeInfo(String volumeUuid, PoReplicaPairInfo normalPair, PoReplicaPairInfo standbyPair, PoReplicaPairInfo hyperMetroPair) {
        Stream.of(normalPair, standbyPair).filter(Objects::nonNull).map(PoReplicaPairInfo::getDrVolumeUuid).distinct().forEach(this.delVolume(this.drRegionUuid, this.drProjUuid));
        if (!VerifyUtil.isEmpty((Object)this.hyperMetroReplicaInfo)) {
            Optional.ofNullable(hyperMetroPair).map(PoReplicaPairInfo::getDrVolumeUuid).ifPresent(this.delVolume(this.hyperMetroReplicaInfo.getRegionUuid(), this.hyperMetroReplicaInfo.getProjUuid()));
        }
        this.deleteOccupiedVolumeMetadata(this.regionUuid, this.projUuid, volumeUuid, true);
        this.delShareVolVmReplica(volumeUuid);
        if (34 == this.pg.getTemplate().getType() || 37 == this.pg.getTemplate().getType()) {
            this.delShareVolumeReplicationInfo(standbyPair, "remote_replicationInfo");
            this.delShareVolumeReplicationInfo(hyperMetroPair, "hypermetor_replicationInfo");
        }
    }

    private void removePairInfo(String volumeUuid, PoReplicaPairInfo normalPair, PoReplicaPairInfo standbyPair, PoReplicaPairInfo hyperMetroPair) {
        this.removePairInfo(this.normalReplicaInfo, normalPair);
        this.removePairInfo(this.standbyReplicaInfo, standbyPair);
        this.removePairInfo(this.hyperMetroReplicaInfo, hyperMetroPair);
        this.removeUsedStorageResource(volumeUuid, this.po);
        this.removePoVolConfig(volumeUuid, this.po);
    }

    private void delShareVolumeReplicationInfo(PoReplicaPairInfo poReplicaPairInfo, String replicationKey) {
        for (ProtectObject protectObject : this.pg.getPolist()) {
            if (this.po.equals((Object)protectObject)) continue;
            PoReplicaInfo poReplicaInfo = (PoReplicaInfo)protectObject.getProperty(replicationKey, PoReplicaInfo.class);
            if (!VerifyUtil.isEmpty((Object)poReplicaInfo)) {
                List poReplicaPairInfos = poReplicaInfo.getPairInfos();
                Iterator iterator = poReplicaPairInfos.iterator();
                while (iterator.hasNext()) {
                    PoReplicaPairInfo pairInfo = (PoReplicaPairInfo)iterator.next();
                    if (null == poReplicaPairInfo) {
                        LOG.error((Object)"PoReplicaPairInfo is null");
                        throw new LegoCheckedException(0x300001L);
                    }
                    if (!pairInfo.getVolumeUuid().equals(poReplicaPairInfo.getVolumeUuid())) continue;
                    iterator.remove();
                    this.removeUsedStorageResource(pairInfo.getVolumeUuid(), protectObject);
                }
            }
            protectObject.getProps().put(replicationKey, JsonUtil.beanToJson(poReplicaInfo));
        }
    }

    private void removePoVolConfig(String volumeUuid, ProtectObject protectObject) {
        JSONArray volArray = JSONArray.fromObject((Object)protectObject.getProperty("volumeConfig"));
        Iterator itr = volArray.iterator();
        while (itr.hasNext()) {
            JSONObject vol = (JSONObject)itr.next();
            String volId = OpenStackCommonUtil.getIdFromUuid(vol.getString("volumeId"));
            if (!Objects.equals(volId, OpenStackCommonUtil.getIdFromUuid(volumeUuid))) continue;
            itr.remove();
        }
        this.po.setProperty("volumeConfig", (Object)volArray.toString());
    }

    private PoReplicaPairInfo getReplicaByVolumeUuid(Map<String, PoReplicaPairInfo> pairs, Set<String> uuids) {
        if (!VerifyUtil.isEmpty(pairs)) {
            return uuids.stream().filter(pairs::containsKey).findFirst().map(pairs::get).orElse(null);
        }
        return null;
    }

    private Set<String> getVolumeUuidsByMaster(Map<String, PoReplicaPairInfo> normalPairInfoMap, Map<String, PoReplicaPairInfo> standbyPairInfoMap, String volumeUuid) {
        HashSet<String> uuids = new HashSet<String>();
        uuids.add(volumeUuid);
        if (!VerifyUtil.isEmpty(normalPairInfoMap) && normalPairInfoMap.containsKey(volumeUuid)) {
            PoReplicaPairInfo pairInfo = normalPairInfoMap.get(volumeUuid);
            if (!VerifyUtil.isEmpty(standbyPairInfoMap)) {
                Set<String> slaveuuid;
                String drOpenstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.drRegionUuid);
                String drVolumeUuid = pairInfo.getDrVolumeUuid();
                if (!drVolumeUuid.contains(drOpenstackUuid)) {
                    drVolumeUuid = OpenStackCommonUtil.getObjectUuid(drOpenstackUuid, drVolumeUuid);
                }
                if (!VerifyUtil.isEmpty(slaveuuid = this.getVolumeUuidsBySlave(standbyPairInfoMap.values().stream(), drVolumeUuid))) {
                    uuids.addAll(slaveuuid.stream().map(slave -> slave.contains(drOpenstackUuid) ? slave : OpenStackCommonUtil.getObjectUuid(drOpenstackUuid, slave)).collect(Collectors.toSet()));
                }
            }
        } else if (!VerifyUtil.isEmpty(standbyPairInfoMap) && standbyPairInfoMap.containsKey(volumeUuid)) {
            PoReplicaPairInfo pairInfo = standbyPairInfoMap.get(volumeUuid);
            if (!VerifyUtil.isEmpty(normalPairInfoMap)) {
                Set<String> slaveuuid;
                String drVolumeUuid = pairInfo.getDrVolumeUuid();
                if (!drVolumeUuid.contains(this.openstackUuid)) {
                    drVolumeUuid = OpenStackCommonUtil.getObjectUuid(this.openstackUuid, drVolumeUuid);
                }
                if (!VerifyUtil.isEmpty(slaveuuid = this.getVolumeUuidsBySlave(normalPairInfoMap.values().stream(), drVolumeUuid))) {
                    uuids.addAll(slaveuuid.stream().map(slave -> slave.contains(this.openstackUuid) ? slave : OpenStackCommonUtil.getObjectUuid(this.openstackUuid, slave)).collect(Collectors.toSet()));
                }
            }
        } else {
            throw new LegoCheckedException(1073947393L);
        }
        return uuids;
    }

    private Set<String> getVolumeUuidsBySlave(Stream<PoReplicaPairInfo> pairs, String volumeUuid) {
        if (null == volumeUuid) {
            return Collections.emptySet();
        }
        Set otherUUids = pairs.filter(pair -> volumeUuid.contains(pair.getDrVolumeUuid())).map(PoReplicaPairInfo::getVolumeUuid).collect(Collectors.toSet());
        return VerifyUtil.isEmpty(otherUUids) ? Collections.emptySet() : otherUUids;
    }

    private void removePairInfo(PoReplicaInfo replica, PoReplicaPairInfo pair) {
        if (null == replica) {
            return;
        }
        List pairs = replica.getPairInfos();
        if (null != pairs && null != pair) {
            pairs.remove(pair);
        }
    }

    private Consumer<String> delVolume(String region, String project) {
        return volumeUUID -> {
            this.deleteOccupiedVolumeMetadata(region, project, (String)volumeUUID, false);
            this.volumeService.delVolume(volumeUUID, region, project);
        };
    }

    private void deleteOccupiedVolumeMetadata(String region, String project, String volumeUUID, boolean isMasterVolume) {
        String volumeId;
        CinderManager mgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(region, project);
        VolumeInfo volumeInfo = mgr.queryVolume(region, tokenId, project, volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUUID));
        if (null != volumeInfo) {
            if (isMasterVolume && OpenstackEnumDefine.VolumeStatusE.ATTACHING.getType().equals(volumeInfo.getStatus())) {
                this.volumeService.unreserveVolume(OpenStackCommonUtil.getIdFromUuid(volumeUUID), this.regionUuid, this.projUuid);
            }
            this.volumeService.deleteVolMetadatas(region, project, OpenStackCommonUtil.getIdFromUuid(volumeUUID), "occupied_volume");
        }
    }

    private String getRingUUID() {
        return (String)this.po.getProtectGroup().getProps().get("prodRingID");
    }

    private void delReplicationReplica(PoReplicaInfo handlerReplicaInfo, PoReplicaPairInfo pairInfo) {
        if (null == pairInfo) {
            return;
        }
        HashSet<String> removeSrcRepUuids = new HashSet<String>();
        HashSet<String> removeDrRepUuids = new HashSet<String>();
        removeSrcRepUuids.add(pairInfo.getReplicaUuid());
        removeDrRepUuids.add(pairInfo.getDrReplicaUuid());
        this.volumeService.updateVolumeReplicationCG(handlerReplicaInfo.getRegionUuid(), handlerReplicaInfo.getProjUuid(), handlerReplicaInfo.getCgUuid(), null, removeSrcRepUuids);
        this.volumeService.updateVolumeReplicationCG(handlerReplicaInfo.getDrRegionUuid(), handlerReplicaInfo.getDrProjUuid(), handlerReplicaInfo.getDrCgUuid(), null, removeDrRepUuids);
        this.volumeService.delVolReplica(handlerReplicaInfo.getRegionUuid(), handlerReplicaInfo.getProjUuid(), pairInfo.getReplicaUuid(), false, false);
        this.volumeService.delVolReplica(handlerReplicaInfo.getDrRegionUuid(), handlerReplicaInfo.getDrProjUuid(), pairInfo.getDrReplicaUuid(), false, false);
    }

    private void reconnectVolumes() {
        if (!OpenstackConsts.OPENSTACK_NEEDREATTACH_TYPES.contains(this.pg.getTemplate().getType())) {
            LOG.info((Object)"This serviceInstanse type is not hypermetro, instance_id is %s", new Object[]{this.instanceId});
            return;
        }
        String storageSn = this.willDelVolumes.stream().map(ProtectedVolumeInfo::getVolumeId).map(volumeUuid -> this.volumeService.queryVolumeInfoByUuid(this.regionUuid, this.projUuid, volumeUuid)).filter(Objects::nonNull).map(VolumeInfo::getStorageSn).filter(sn -> !VerifyUtil.isEmpty((String)sn)).findAny().orElse(null);
        IVirtualMachineService vmService = (IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(this.openstackUuid);
        String vmUuid = OpenStackCommonUtil.getObjectUuid(this.openstackUuid, this.serverId);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(this.regionUuid, this.projUuid);
        OpenStackVM vm = novaMgr.getVm(this.regionUuid, tokenId, this.projUuid, vmUuid, new int[0]);
        String hostId = vm.getHostId();
        for (ProtectedVolumeInfo protectedVolume : this.willDelVolumes) {
            String volumeUuid2 = protectedVolume.getVolumeId();
            String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid2);
            if (this.volumeService.isAttachVM(this.regionUuid, this.projUuid, vmUuid, volumeId)) {
                ReconnectVolumeInfo reconnVolumeInfo = new ReconnectVolumeInfo();
                reconnVolumeInfo.setVolumeId(volumeId);
                reconnVolumeInfo.setIsHyperMetro(Boolean.valueOf(false));
                vmService.runWithAttachVolSemaphore(storageSn, hostId, 1800L, () -> {
                    novaMgr.reattachVolume(new ReattchParam(this.regionUuid, this.projUuid, tokenId), vmUuid, reconnVolumeInfo);
                    return null;
                });
            }
            this.reconnectSharedVolume(novaMgr, tokenId, volumeUuid2, storageSn, hostId);
        }
    }

    private void reconnectSharedVolume(INovaManager novaMgr, String tokenId, String volumeUuid, String storageSn, String hostId) {
        IVirtualMachineService vmService = (IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class);
        for (ProtectObject protectObject : this.pg.getPolist()) {
            if (this.po.equals((Object)protectObject)) continue;
            HashSet<String> delVolumeStatus = new HashSet<String>();
            delVolumeStatus.add(OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus());
            boolean isMetalServer = OpenStackCommonUtil.isBareMetalServer(OpenStackCommonUtil.getServerById(this.projUuid, this.regionUuid, OpenStackCommonUtil.getIdFromUuid(this.po.getMoUuid())));
            if (!isMetalServer) continue;
            delVolumeStatus.add(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
            boolean needReconnect = this.needReconnect(protectObject, volumeUuid, delVolumeStatus);
            if (!needReconnect) continue;
            ReconnectVolumeInfo reconnVolumeInfo = new ReconnectVolumeInfo();
            reconnVolumeInfo.setVolumeId(OpenStackCommonUtil.getIdFromUuid(volumeUuid));
            reconnVolumeInfo.setIsHyperMetro(Boolean.valueOf(false));
            vmService.runWithAttachVolSemaphore(storageSn, hostId, 1800L, () -> {
                novaMgr.reattachVolume(new ReattchParam(this.regionUuid, this.projUuid, tokenId), protectObject.getMoUuid(), reconnVolumeInfo);
                return null;
            });
        }
    }

    private boolean needReconnect(ProtectObject protectObject, String volumeUuid, Set<String> delVolumeStatus) {
        boolean needReconnect = false;
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)protectObject.getProperty("replicationInfo", PoReplicaInfo.class);
        if (null != poReplicaInfo) {
            List poReplicaPairInfoList = poReplicaInfo.getPairInfos();
            for (PoReplicaPairInfo poReplicaPairInfo : poReplicaPairInfoList) {
                if (!volumeUuid.equals(poReplicaPairInfo.getVolumeUuid()) || !delVolumeStatus.contains(poReplicaPairInfo.getVolumeStatus()) || !this.volumeService.isAttachVM(this.regionUuid, this.projUuid, protectObject.getMoUuid(), OpenStackCommonUtil.getIdFromUuid(volumeUuid))) continue;
                needReconnect = true;
                break;
            }
        }
        return needReconnect;
    }

    private void removeUsedStorageResource(String volumeUuid, ProtectObject protectObject) {
        Iterator itr = protectObject.getUsedStorageResourceSet().iterator();
        while (itr.hasNext()) {
            if (!volumeUuid.equals(((ProtectObjectStorageInfo)itr.next()).getResourceId())) continue;
            itr.remove();
            break;
        }
    }

    private void initParam() {
        this.po = this.getPoByServerId();
        this.initReplicaInfo();
    }

    private void initReplicaInfo() {
        this.normalReplicaInfo = this.getPoReplicaInfo("replicationInfo", true);
        if (this.pg.getTemplate().getType() == 34 || this.pg.getTemplate().getType() == 37) {
            this.standbyReplicaInfo = this.getPoReplicaInfo("remote_replicationInfo", false);
            if (null != this.standbyReplicaInfo) {
                HashMap replicationReplicasMapping = new HashMap();
                Stream.of(this.normalReplicaInfo, this.standbyReplicaInfo).forEach(replica -> replicationReplicasMapping.put(replica, this.queryReplicaStatus((PoReplicaInfo)replica)));
                if (Collections.singleton(OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue()).containsAll(replicationReplicasMapping.values())) {
                    LOG.error((Object)("Both pair(s) under standby status. po: " + this.po.getMoUuid()));
                    throw new LegoCheckedException(1073947393L);
                }
                if (replicationReplicasMapping.values().contains(OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue())) {
                    this.normalReplicaInfo = replicationReplicasMapping.entrySet().stream().filter(e -> !OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(e.getValue())).map(Map.Entry::getKey).findAny().orElse(null);
                    this.standbyReplicaInfo = replicationReplicasMapping.entrySet().stream().filter(e -> OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(e.getValue())).map(Map.Entry::getKey).findAny().orElse(null);
                }
                this.standbyPairInfoMapping = this.getPoReplicaPairInfoMap(this.standbyReplicaInfo);
            }
            this.hyperMetroReplicaInfo = this.getPoReplicaInfo("hypermetor_replicationInfo", false);
            this.hyperMetroPairInfoMapping = this.getPoReplicaPairInfoMap(this.hyperMetroReplicaInfo);
        }
        this.normalPairInfoMapping = this.getPoReplicaPairInfoMap(this.normalReplicaInfo);
        if (this.normalReplicaInfo == null) {
            LOG.error((Object)"NormalReplicaInfo is null");
            throw new LegoCheckedException(2117645L);
        }
        this.regionUuid = this.normalReplicaInfo.getRegionUuid();
        this.drRegionUuid = this.normalReplicaInfo.getDrRegionUuid();
        this.projUuid = this.normalReplicaInfo.getProjUuid();
        this.drProjUuid = this.normalReplicaInfo.getDrProjUuid();
        this.openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid);
    }

    private String queryReplicaStatus(PoReplicaInfo replica) {
        String status = this.queryReplicaStatus(replica, false);
        if (OpenstackEnumDefine.ReplicationRepStatusE.UNKNOWN.getValue().equals(status)) {
            status = this.queryReplicaStatus(replica, true);
        }
        return status;
    }

    private String queryReplicaStatus(PoReplicaInfo replica, boolean master) {
        String cg;
        String region;
        String project;
        DrExtendManager mgr = new DrExtendManager();
        if (master) {
            project = replica.getProjUuid();
            region = replica.getRegionUuid();
            cg = replica.getCgUuid();
        } else {
            project = replica.getDrProjUuid();
            region = replica.getDrRegionUuid();
            cg = replica.getDrCgUuid();
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(region, project);
        VolumeReplicationCgInfo consistentGroup = mgr.queryVolumeReplicationCG(region, tokenId, project, cg);
        return consistentGroup.getReplicationStatus();
    }

    private PoReplicaInfo getPoReplicaInfo(String type, boolean strict) {
        String replicaStr = (String)this.po.getProps().get(type);
        if (VerifyUtil.isEmpty((String)replicaStr)) {
            if (strict) {
                LOG.error((Object)"Convert string to bean failed, repliaStr is null or empty");
                throw new LegoCheckedException(1073947393L);
            }
            return null;
        }
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class);
        if (null == replicaInfo && strict) {
            LOG.error((Object)("Convert string to bean failed:repliaStr=" + replicaStr));
            throw new LegoCheckedException(1073947393L);
        }
        return replicaInfo;
    }

    private Map<String, PoReplicaPairInfo> getPoReplicaPairInfoMap(PoReplicaInfo replicaInfo) {
        if (null == replicaInfo) {
            return Collections.emptyMap();
        }
        HashMap<String, PoReplicaPairInfo> map = new HashMap<String, PoReplicaPairInfo>();
        String reOpenStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(replicaInfo.getRegionUuid());
        for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
            if (pairInfo.getVolumeUuid().contains(reOpenStackUuid)) {
                map.put(pairInfo.getVolumeUuid(), pairInfo);
                continue;
            }
            map.put(OpenStackCommonUtil.getObjectUuid(reOpenStackUuid, pairInfo.getVolumeUuid()), pairInfo);
        }
        return map;
    }

    private ProtectObject getPoByServerId() {
        for (ProtectObject tempPo : this.pg.getPolist()) {
            if (!tempPo.getMoUuid().contains(this.serverId)) continue;
            return tempPo;
        }
        LOG.error((Object)("Cant find po by serverId:serverId=" + this.serverId));
        throw new LegoCheckedException(1073947393L);
    }

    private void checkVolSnapshots() {
        ArrayList<String> volumesId = new ArrayList<String>();
        for (ProtectedVolumeInfo delVolumeInfo : this.willDelVolumes) {
            String volumeUuid = delVolumeInfo.getVolumeId();
            PoReplicaPairInfo pairInfo = this.normalPairInfoMapping.get(volumeUuid);
            if (null == pairInfo) {
                LOG.error((Object)("Can not find pairInfo by volumeUuid,uuid=" + volumeUuid));
                continue;
            }
            String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid());
            LOG.debug((Object)"Remotevol id is: %s", new Object[]{volId});
            volumesId.add(volId);
        }
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        volService.checkVolumesExitSnapshots(this.drRegionUuid, this.drProjUuid, volumesId);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }

    private void removeUsedStorageResourceByVmType(String delVolUuid, PoReplicaInfo poReplicaInfo, ProtectObject protectObject) {
        List poReplicaPairInfoList = poReplicaInfo.getPairInfos();
        Iterator iterator = poReplicaPairInfoList.iterator();
        while (iterator.hasNext()) {
            PoReplicaPairInfo poReplicaPairInfo = (PoReplicaPairInfo)iterator.next();
            if (!delVolUuid.equals(poReplicaPairInfo.getVolumeUuid())) continue;
            if (OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus().equals(poReplicaPairInfo.getVolumeStatus())) {
                iterator.remove();
                this.removeUsedStorageResource(poReplicaPairInfo.getVolumeUuid(), protectObject);
                continue;
            }
            if (!"BMS".equals(protectObject.getProps().get("vm_type"))) continue;
            iterator.remove();
            this.removeUsedStorageResource(poReplicaPairInfo.getVolumeUuid(), protectObject);
        }
    }
}

