/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.observer.ProtectGroupOperateObserver;
import com.huawei.ism.drm.openstack.protection.service.ReattachVolumeTask;
import com.huawei.ism.drm.openstack.protection.template.provider.OpenStackPolicyTemplateProvider;
import com.huawei.ism.drm.openstack.sdk.bo.ConsistentGroupReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.openstack.tools.model.DelTagParam;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class DowngradeInstanceTask
extends AbstractBackTask {
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final Log LOG = LogFactory.getInstance(DowngradeInstanceTask.class);
    private String instanceId;
    private String instanceName;
    private String regionUuid;
    private String drRegionUuid;
    private String openstackUuid;
    private String reservedInsType;
    private IVolumeService volumeService;
    private IProtectionTaskService protectionTaskService;

    public DowngradeInstanceTask(String proId, String type, String instanceId, String instanceName, String reservedInsType) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)instanceName, (String)"ism.drm.instance.downgrade", (String)proId, (String)type, (String)"", null), 2147483, true);
        this.instanceId = instanceId;
        this.instanceName = instanceName;
        this.reservedInsType = reservedInsType;
        this.volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        this.protectionTaskService = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        this.handleHighThan63();
        if (!ServiceInstanceHelper.getInstance().getLock(this.instanceId)) {
            LOG.error((Object)("Not get this instance lock,instanceId:" + this.instanceId));
            throw new LegoCheckedException(1073948693L);
        }
        boolean deleteCompleted = false;
        try {
            ServiceInstance instance = ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.MAINTAIN);
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            ProtectGroup pg = pgService.getProtectGroupByID(instance.getProtectGroupId(), false);
            this.checkVolSnapshots(pg);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            Map meterInfos = meterService.calculateMeterInfos(pg);
            meterInfos.put("meter_pg", pgService.getProtectGroupBasicInfo(instance.getProtectGroupId(), true));
            meterInfos.put("change_type", "inst_downgrade");
            meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
            this.deleteResource(instance, pg, meterInfos);
            HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
            template.execute(session -> this.saveProtectGroupAndServiceInstance(instance, pg, session));
            this.notifyObserver(pg);
            deleteCompleted = true;
            LOG.info((Object)"ReservedInsType: %s", new Object[]{this.reservedInsType});
            this.regionUuid = pg.getProperty("regionId");
            this.drRegionUuid = pg.getProperty("drRegionId");
            this.openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid);
            meterService.reportChangedMeterInfo(this.regionUuid, instance, this.openstackUuid, meterInfos);
            meterService.reportChangedMeterInfo(this.drRegionUuid, instance, this.openstackUuid, meterInfos);
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
            }
        }
        finally {
            ServiceInstanceHelper.getInstance().releaseLock(this.instanceId);
            if (deleteCompleted) {
                this.changeStatus(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL);
            } else {
                this.changeStatus(ServiceInstaceEnumDefine.ServiceInstanceStatusE.ERR_MODIFY_TYPE);
            }
        }
    }

    private void notifyObserver(ProtectGroup pg) {
        MessageEvent event = new MessageEvent();
        event.setMessageType(22);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(pg);
        HashMap messageMap = new HashMap();
        event.setMessageMap(messageMap);
        event.setObjectList(objectList);
        CreateProtectGroupRefineService service = CreateProtectGroupRefineService.getInstance();
        service.notifyObserverList(event, "after");
    }

    private void deleteResource(ServiceInstance instance, ProtectGroup pg, Map<String, Object> meterInfos) {
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getFrontValue().equals(this.reservedInsType)) {
            this.deleteVhaResources(pg);
            this.updateAsCsdrInstanceConfig(pg, instance.getRecoveryPlanId());
            instance.setProtectType(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
            meterInfos.put("up_downgrade_chage", ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getFrontValue());
        } else if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getFrontValue().equals(this.reservedInsType)) {
            this.deleteCsdrResources(pg, instance);
            meterInfos.put("up_downgrade_chage", ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getFrontValue());
        }
    }

    private void handleHighThan63() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
            IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
            String quotas = quotaService.calculateDowngradeInstanceQuota(this.instanceId, this.reservedInsType);
            Map param = this.getExtendParam();
            param.put("order_quotas", quotas);
            this.setExtendParam(param);
        }
    }

    private void changeStatus(ServiceInstaceEnumDefine.ServiceInstanceStatusE status) {
        try {
            ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, status);
        }
        catch (Exception e) {
            LOG.error((Object)"Set instance(%s) %s error. %s", new Object[]{this.instanceName, status, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private boolean saveProtectGroupAndServiceInstance(ServiceInstance instance, ProtectGroup pg, Session session) {
        session.saveOrUpdate((Object)pg.getTemplate());
        session.saveOrUpdate((Object)pg);
        session.update((Object)instance);
        return true;
    }

    private void deleteCsdrResources(ProtectGroup protectGroup, ServiceInstance instance) {
        List<ConsistentGroupReplicaInfo> replicas = OpenStackCommonUtil.getReplicas(protectGroup);
        OpenStackCommonUtil.closeRing(this.volumeService, replicas);
        OpenStackCommonUtil.deleteRing(this.volumeService, replicas);
        Map<String, List<String>> actualStatusMapping = OpenStackCommonUtil.getRealStatusSideMapping(protectGroup);
        Map<String, List<ConsistentGroupReplicaInfo>> replicaSideMapping = OpenStackCommonUtil.castSideMappingToReplicaMapping(protectGroup, actualStatusMapping, replicas);
        this.deleteCsdrReplicas(protectGroup, replicaSideMapping, OpenstackEnumDefine.ReplicationRepStatusE.UNKNOWN.getValue());
        this.deleteCsdrReplicas(protectGroup, replicaSideMapping, "standbyside");
        this.deleteCsdrReplicas(protectGroup, replicaSideMapping, "activeside");
        List delPhVmTask = ProtectGroupOperateObserver.getDelPhVmTaskList(protectGroup.getPolist(), protectGroup);
        OpenStackCommonUtil.executeTask(delPhVmTask, ExecutionService.ExecuteType.FAILED_ABORT, true);
        this.removeRecoveryPlan(instance.getRecoveryPlanId());
        this.updateAsVhaProtectGroupConfig(protectGroup);
        this.updateAsVhaInstanceConfig(instance);
        this.protectionTaskService.deleteTaskAndJob(protectGroup.getUuid());
    }

    private void updateAsVhaProtectGroupConfig(ProtectGroup protectGroup) {
        protectGroup.getPolist().forEach(this::updateAsVhaProtectObjectConfig);
        Map props = protectGroup.getProps();
        props.put("serviceInstanceType", ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue());
        props.put("drProjectId", props.get("projectId"));
        props.put("drRegionId", props.get("regionId"));
        props.put("drZoneName", props.get("zoneName"));
        props.put("drRegionName", props.get("regionName"));
        props.put("remoteStorageDevSn", props.get("remoteDRHyperMetorStorageDevSn"));
        props.put("replicaCgUuid", props.get("hyperProCgUuid"));
        props.put("drReplicaCgUuid", props.get("hyperProdrCgUuid"));
        OpenStackCommonUtil.cleanRingProps(protectGroup, "DrStarReplicationSideMapping", "hyperDRRingID", "drHyperReplicaCgRepStatus", "drRemoteReplicaCgRepStatus", "replicaCgRepStatus", "before_delete_instance_status");
        protectGroup.getPolist().forEach(this::updateAsVhAProtectObjectConfig);
        PolicyTemplate template = protectGroup.getTemplate();
        template.setType(29);
        template.setReplicationType(template.getType());
        OpenStackPolicyTemplateProvider.initHyperMetroPolicyTemplate(template);
    }

    private void updateAsVhaProtectObjectConfig(ProtectObject protectObject) {
        JSONArray volumes = (JSONArray)protectObject.getProperty("volumeConfig", JSONArray.class);
        if (volumes == null) {
            return;
        }
        volumes.filter(JSONObject.class).forEach(this::updateAsVhaProtectObjectConfig);
        protectObject.setProperty("volumeConfig", (Object)volumes);
    }

    private void updateAsVhaProtectObjectConfig(JSONObject volume) {
        volume.set((Object)"drVolumeType", volume.get("drHyperVolumeType")).remove((Object)"drHyperVolumeType");
    }

    private void updateAsVhAProtectObjectConfig(ProtectObject protectObject) {
        Map props = protectObject.getProps();
        props.put("replicationInfo", props.get("hypermetor_replicationInfo"));
        OpenStackCommonUtil.cleanProps((Map<String, String>)props, "hypermetor_replicationInfo", "remote_replicationInfo");
    }

    private void updateAsVhaInstanceConfig(ServiceInstance instance) {
        instance.setType(ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue());
        instance.setProtectType(ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue());
        instance.setRecoveryPlanId(null);
    }

    private void deleteCsdrReplicas(ProtectGroup protectGroup, Map<String, List<ConsistentGroupReplicaInfo>> statusMapping, String side) {
        List<ConsistentGroupReplicaInfo> replicas = statusMapping.get(side);
        if (replicas != null) {
            replicas.forEach(replica -> this.deleteCsdrReplica(protectGroup, (ConsistentGroupReplicaInfo)replica, side));
        }
    }

    private void deleteCsdrReplica(ProtectGroup protectGroup, ConsistentGroupReplicaInfo replica, String side) {
        OpenStackCommonUtil.deleteCg(this.volumeService, replica.getProjUuid(), replica.getRegionUuid(), replica.getCgUuid(), Boolean.TRUE.toString());
        OpenStackCommonUtil.deleteCg(this.volumeService, replica.getDrProjUuid(), replica.getDrRegionUuid(), replica.getDrCgUuid(), Boolean.TRUE.toString());
        this.deleteCsdrReplicaPairs(protectGroup, replica.getSide(), side);
    }

    private void removeRecoveryPlan(String recoveryPlanId) {
        IRecoveryPlanService service = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = service.getRecoveryPlan(recoveryPlanId);
        if (recoveryPlan != null) {
            service.removeRecoveryPlan(recoveryPlanId);
        }
    }

    private void deleteCsdrReplicaPairs(ProtectGroup protectGroup, String ruleSide, String realSide) {
        DelTagParam delTagParam = new DelTagParam();
        delTagParam.setDelPrdVm(false);
        delTagParam.setDelPrdVol(false);
        delTagParam.setDelPhVm(true);
        delTagParam.setDelPhVol(true);
        List standbyTaskList = OpenStackCommonUtil.getDelReplicaTaskList(this.volumeService, protectGroup.getPolist(), protectGroup, ruleSide, realSide, delTagParam);
        OpenStackCommonUtil.executeTask(standbyTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
    }

    private void checkVolSnapshots(ProtectGroup pg) {
        ArrayList<String> volumesId = new ArrayList<String>();
        for (ProtectObject po : pg.getPolist()) {
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null == poReplicaInfo || poReplicaInfo.getPairInfos().isEmpty()) continue;
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid());
                LOG.debug((Object)"Remotevol id is: %s,producerVolid: %s", new Object[]{volId, OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid())});
                volumesId.add(volId);
            }
        }
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        volService.checkVolumesExitSnapshots((String)pg.getProps().get("drRegionId"), (String)pg.getProps().get("drProjectId"), volumesId);
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }

    private void deleteVhaResources(ProtectGroup protectGroup) {
        this.volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        String projId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        String drProjId = (String)protectGroup.getProps().get("drProjectId");
        String drRegionId = (String)protectGroup.getProps().get("drRegionId");
        String cgId = (String)protectGroup.getProps().get("replicaCgUuid");
        String drCgId = (String)protectGroup.getProps().get("drReplicaCgUuid");
        String splitFlag = (String)protectGroup.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        String tokenId = TokenUtil.getInstance().getTokenId(projId);
        DrExtendManager mgr = new DrExtendManager();
        List<Callable<PoReplicaInfo>> reattachTasks = this.getCallableList(protectGroup);
        OpenStackCommonUtil.closeAndDeleteRing(protectGroup, this.volumeService);
        VolumeReplicationCgInfo cg = mgr.queryVolumeReplicationCG(regionId, tokenId, projId, cgId);
        String standbyCG = null;
        String standbyDRCG = null;
        String hyperMetorCG = (String)protectGroup.getProps().get("hyperProCgUuid");
        String hyperMetorDRCG = (String)protectGroup.getProps().get("hyperProdrCgUuid");
        if (null != cg && OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(cg.getReplicationStatus())) {
            standbyCG = cgId;
            standbyDRCG = drCgId;
        } else {
            standbyCG = (String)protectGroup.getProps().get("hyperProRemoteCgUuid");
            standbyDRCG = (String)protectGroup.getProps().get("hyperProRemotedrCgUuid");
        }
        VolumeReplicationCgInfo standbyVolumeCG = mgr.queryVolumeReplicationCG(regionId, tokenId, projId, standbyCG);
        if (null == standbyVolumeCG || standbyVolumeCG.isMasterFlag()) {
            OpenStackCommonUtil.deleteCg(this.volumeService, projId, regionId, standbyCG, splitFlag);
            OpenStackCommonUtil.deleteCg(this.volumeService, drProjId, drRegionId, standbyDRCG, splitFlag);
        } else {
            OpenStackCommonUtil.deleteCg(this.volumeService, drProjId, drRegionId, standbyDRCG, splitFlag);
            OpenStackCommonUtil.deleteCg(this.volumeService, projId, regionId, standbyCG, splitFlag);
        }
        VolumeReplicationCgInfo activeVolumeHyperMetorCG = mgr.queryVolumeReplicationCG(regionId, tokenId, projId, hyperMetorCG);
        if (null == activeVolumeHyperMetorCG || activeVolumeHyperMetorCG.isMasterFlag()) {
            OpenStackCommonUtil.deleteCg(this.volumeService, projId, regionId, hyperMetorCG, splitFlag);
            OpenStackCommonUtil.deleteCg(this.volumeService, projId, regionId, hyperMetorDRCG, splitFlag);
        } else {
            OpenStackCommonUtil.deleteCg(this.volumeService, projId, regionId, hyperMetorDRCG, splitFlag);
            OpenStackCommonUtil.deleteCg(this.volumeService, projId, regionId, hyperMetorCG, splitFlag);
        }
        this.deleteTask(protectGroup, projId, regionId, tokenId, reattachTasks);
    }

    private void deleteTask(ProtectGroup protectGroup, String projId, String regionId, String tokenId, List<Callable<PoReplicaInfo>> reattachTasks) {
        String deleteSide = OpenStackBasicUtil.getStandbyReplication(protectGroup, projId, regionId, tokenId);
        String standbySide = this.getStandbySide(deleteSide);
        DelTagParam delTagParamStandBy = new DelTagParam(false, false, false, false);
        List standbyTaskList = OpenStackCommonUtil.getDelReplicaTaskList(this.volumeService, protectGroup.getPolist(), protectGroup, standbySide, "standbyside", delTagParamStandBy);
        OpenStackCommonUtil.executeTask(standbyTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
        LOG.info((Object)"Delete standby side  replication success.");
        DelTagParam delTagParamHyper = new DelTagParam(false, false, false, true);
        this.executeTask(protectGroup, reattachTasks, delTagParamHyper);
    }

    private void executeTask(ProtectGroup protectGroup, List<Callable<PoReplicaInfo>> reattachTasks, DelTagParam delTagParamHyper) {
        List hyperMetorTaskList = OpenStackCommonUtil.getDelReplicaTaskList(this.volumeService, protectGroup.getPolist(), protectGroup, "hypermetorside", "hypermetorside", delTagParamHyper);
        OpenStackCommonUtil.executeTask(hyperMetorTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
        LOG.info((Object)"Delete hypermetor side replication success.");
        reattachTasks.stream().forEach(obj -> {
            if (obj instanceof ReattachVolumeTask) {
                ((ReattachVolumeTask)obj).setAfterHyperMetroDel(true);
            }
        });
        OpenStackCommonUtil.executeTask(reattachTasks, ExecutionService.ExecuteType.FAILED_CONTINUE, false);
        OpenStackCommonUtil.cleanRingProps(protectGroup, new String[0]);
    }

    private String getStandbySide(String deleteSide) {
        String standbySide = null;
        standbySide = "activeside".equals(deleteSide) ? "standbyside" : "activeside";
        return standbySide;
    }

    private List<Callable<PoReplicaInfo>> getCallableList(ProtectGroup protectGroup) {
        LOG.info((Object)"Downgrade instance, do reconnect volumes. pg: %s", new Object[]{protectGroup.getName()});
        ArrayList<Callable<PoReplicaInfo>> reattachTasks = new ArrayList<Callable<PoReplicaInfo>>();
        for (ProtectObject po : protectGroup.getPolist()) {
            ReattachVolumeTask task = this.getReattachVolumeTask(po);
            if (task == null) continue;
            reattachTasks.add(task);
        }
        OpenStackCommonUtil.executeTask(reattachTasks, ExecutionService.ExecuteType.FAILED_CONTINUE, false);
        return reattachTasks;
    }

    private ReattachVolumeTask getReattachVolumeTask(ProtectObject po) {
        String replicationInfo = (String)po.getProps().get("hypermetor_replicationInfo");
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            LOG.error((Object)("Json to bean error:replicaInfoStr=" + replicationInfo));
            return null;
        }
        LOG.info((Object)"Reattach volume, replicaInfoStr: %s", new Object[]{replicationInfo});
        ReattachVolumeTask task = new ReattachVolumeTask(poReplicaInfo);
        return task;
    }

    private void updateAsCsdrInstanceConfig(ProtectGroup protectGroup, String planId) {
        PolicyTemplate template = protectGroup.getTemplate();
        template.setType(22);
        OpenStackPolicyTemplateProvider.initAsyncReplicationPolicyTemplate(template);
        Map props = protectGroup.getProps();
        props.put("serviceInstanceType", ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
        protectGroup.getPolist().forEach(this::updateAsCsdrProtectObjectConfig);
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId, true, true);
        if (null == recoveryPlan) {
            LOG.error((Object)"RecoveryPlan is null");
            throw new LegoCheckedException(201L);
        }
        HashSet<ProtectGroup> protectGroups = new HashSet<ProtectGroup>();
        protectGroups.add(protectGroup);
        recoveryPlan.setProtectGroups(protectGroups);
        IRecoveryManager recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
        RecoveryProcessDefinition rpDefinition = recoveryManager.createRecoveryProcessDefinition(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
        Set processes = recoveryPlan.getRecoveryProcesses();
        HashSet<RecoveryProcessDefinition> processesNew = new HashSet<RecoveryProcessDefinition>();
        processesNew.add(rpDefinition);
        for (RecoveryProcessDefinition process : processes) {
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == process.getProcType()) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)process);
                continue;
            }
            process.setProtectionType(template.getType());
            processesNew.add(process);
        }
        recoveryPlan.setRecoveryProcesses(processesNew);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
    }

    private void updateAsCsdrProtectObjectConfig(ProtectObject protectObject) {
        Map props = protectObject.getProps();
        OpenStackCommonUtil.cleanProps((Map<String, String>)props, "hypermetor_replicationInfo", "remote_replicationInfo");
    }
}

