/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.license.EvsVolumeLicenseControlImpl;
import com.huawei.ism.drm.openstack.protection.service.DelReplicationTask;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.EvsMeterServiceImpl;
import com.huawei.ism.drm.openstack.serviceinstance.EvsQuotaServiceImpl;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CollectionUtils;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class EvDeleteVolumesBackTask
extends AbstractBackTask {
    private static final int DEFAULT_TIMEOUT = 7200;
    private static final Log LOGGER = LogFactory.getInstance(EvDeleteVolumesBackTask.class);
    private static final Set<String> VOLUME_STATUS_ALLOWED_DELETE = ImmutableSet.of((Object)OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType(), (Object)OpenstackEnumDefine.VolumeStatusE.ERROR.getType(), (Object)OpenstackEnumDefine.VolumeStatusE.ERRORDELETING.getType(), (Object)OpenstackEnumDefine.VolumeStatusE.ERRORRESTORING.getType());
    private String regionUuid;
    private String drRegionUuid;
    private Set<String> deleteIds;
    private Set<ProtectObject> deletePos;
    private String instanceId;
    private ProtectGroup pg;
    private String proId;
    private JSONObject evsQuota;
    private IVolumeService volumeService;

    public EvDeleteVolumesBackTask(String proId, String type, String instanceId, ProtectGroup pg, Set<String> deleteIds) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)pg.getName(), (String)"ism.drm.instance.volume.delete", (String)proId, (String)type, (String)"", (String[])new String[]{pg.getName()}), 7200, true);
        this.instanceId = instanceId;
        this.pg = pg;
        this.proId = proId;
        this.deleteIds = deleteIds;
        this.regionUuid = pg.getProperty("regionId");
        this.drRegionUuid = pg.getProperty("drRegionId");
        this.volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
    }

    protected void doWork() {
        ((IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class)).recordingOrder(this.getExtendParam());
        EvsVolumeLicenseControlImpl licenseControl = EvsVolumeLicenseControlImpl.getInstance();
        try {
            this.lockServiceInstance();
            this.lockProtectGroup();
            this.reloadPgInfo();
            Map<String, Object> meterInfo = ((EvsMeterServiceImpl)ServiceLocator.getInstance().getService(EvsMeterServiceImpl.class)).calculateMeterInfos(this.pg);
            licenseControl.updatePgVolumeMap(this.pg, this.deletePos);
            licenseControl.releaseLicense(this.pg);
            this.markDeleteVolume();
            this.calculateDeletePoQuota();
            this.delReplica();
            this.updatePgInfo();
            this.reportMeter(meterInfo);
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
        }
        finally {
            licenseControl.finishLicense(this.pg.getUuid());
            this.doWorkFinally();
        }
    }

    private void reloadPgInfo() {
        this.pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(this.pg.getUuid(), true);
        this.deletePos = this.pg.getPolist().stream().filter(po -> this.deleteIds.contains(OpenStackCommonUtil.getIdFromUuid(po.getMoUuid()))).collect(Collectors.toSet());
    }

    private void markDeleteVolume() {
        boolean isDeleteVolume = Boolean.parseBoolean(((Object)this.getExtendParam().getOrDefault("SHOULD_DELETE_DR_VOLUME", false)).toString());
        Map drVolumeMap = new HashMap();
        if (isDeleteVolume) {
            String drProjUuid = (String)this.pg.getProps().get("drProjectId");
            List deleteDrVolumeIds = CollectionUtils.mapToList((Collection)this.pg.getPolist(), this::getDrVolumeIdFromPo);
            drVolumeMap = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).queryVolumeInfosByUuid(this.drRegionUuid, drProjUuid, deleteDrVolumeIds);
        }
        ArrayList<VolumeInfo> notDeleteVolumes = new ArrayList<VolumeInfo>();
        for (ProtectObject po : this.pg.getPolist()) {
            String lastDeleteFlag;
            boolean isPoDeleteVolume;
            VolumeInfo drVolume = (VolumeInfo)drVolumeMap.get(this.getDrVolumeIdFromPo(po));
            if (!this.deletePos.contains(po)) {
                LOGGER.debug((Object)"The po(%s) does not need to be delete.", new Object[]{po.getName()});
                notDeleteVolumes.add(drVolume);
                continue;
            }
            boolean bl = isPoDeleteVolume = isDeleteVolume && this.checkPoSupportDeleteDrVolume(po, drVolume);
            if (!isPoDeleteVolume) {
                notDeleteVolumes.add(drVolume);
            }
            if (!VerifyUtil.isEmpty((String)(lastDeleteFlag = po.getProperty("SHOULD_DELETE_DR_VOLUME"))) && Boolean.parseBoolean(lastDeleteFlag) == isPoDeleteVolume) continue;
            LOGGER.info((Object)"The delete flag of po(%s) need to be updated.", new Object[]{po.getName()});
            po.setProperty("SHOULD_DELETE_DR_VOLUME", (Object)String.valueOf(isPoDeleteVolume));
        }
        this.getExtendParam().put("PG_NOT_DELETE_VOLUMES", notDeleteVolumes);
        this.getExtendParam().put("drRegionId", this.drRegionUuid);
        this.pg.getReplicaList().forEach(replica -> replica.setPg(this.pg));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.pg);
    }

    private String getDrVolumeIdFromPo(ProtectObject po) {
        PoReplicaInfo replicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
        PoReplicaPairInfo pairInfo = Optional.ofNullable(replicaInfo).map(PoReplicaInfo::getPairInfos).map(list -> (PoReplicaPairInfo)list.get(0)).orElseThrow(() -> {
            LOGGER.error((Object)"The pair info in po(%s) not found.", new Object[]{po.getName()});
            return new LegoCheckedException(2117645L);
        });
        return OpenStackBasicUtil.getIdFromUuid(pairInfo.getDrVolumeUuid());
    }

    private boolean checkPoSupportDeleteDrVolume(ProtectObject po, VolumeInfo volume) {
        String poName = po.getName();
        if (volume == null) {
            LOGGER.info((Object)"The dr volume of po(%s) is not exist.", new Object[]{poName});
            return false;
        }
        int poStatus = po.getPoStatus();
        if (poStatus == ProtectObjectStatusEnum.INVALID.getValue()) {
            LOGGER.info((Object)"The po(%s) status is not valid, keep last delete mark.", new Object[]{poName});
            return false;
        }
        if (poStatus == ProtectObjectStatusEnum.ERROR_DELETE.getValue()) {
            LOGGER.info((Object)"The po(%s) status is not valid, keep last delete mark.", new Object[]{poName});
            return Boolean.parseBoolean(po.getProperty("SHOULD_DELETE_DR_VOLUME"));
        }
        String status = volume.getStatus();
        if (!VOLUME_STATUS_ALLOWED_DELETE.contains(status)) {
            LOGGER.info((Object)"The dr volume is not allowed to delete when it is mounted to the vm, volumeId: %s, status: %s.", new Object[]{volume.getId(), status});
            return false;
        }
        if (!VerifyUtil.isEmpty((Collection)volume.getAttachments())) {
            LOGGER.info((Object)"The dr volume is not allowed to delete when it is mounted to the vm, volumeId: %s.", new Object[]{volume.getId()});
            return false;
        }
        return true;
    }

    private void delReplica() {
        ArrayList deleteReplicaTasks = new ArrayList();
        HashSet<String> deleteReplicaIds = new HashSet<String>();
        HashSet<String> deleteDrReplicaIds = new HashSet<String>();
        for (ProtectObject po : this.deletePos) {
            String replicaInfoStr = po.getProperty("replicationInfo");
            PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
            if (replicaInfo == null) {
                LOGGER.error((Object)"Json to bean error, replicaInfoStr: %s, protectGroup name: %s, protectObject name: %s.", new Object[]{replicaInfoStr, this.pg.getName(), po.getName()});
                continue;
            }
            if (VerifyUtil.isEmpty((Collection)replicaInfo.getPairInfos())) {
                LOGGER.error((Object)"Pair info of protectObject is empty, protectGroup name: %s, protectObject name: %s.", new Object[]{replicaInfoStr, this.pg.getName(), po.getName()});
                continue;
            }
            PoReplicaPairInfo pairInfo = (PoReplicaPairInfo)replicaInfo.getPairInfos().get(0);
            boolean shouldDeleteDrVolume = Boolean.parseBoolean(po.getProps().getOrDefault("SHOULD_DELETE_DR_VOLUME", Boolean.FALSE.toString()));
            DelReplicationTask task = DelReplicationTask.builder(this.volumeService, this.pg, pairInfo).shouldDeleteDrVolume(shouldDeleteDrVolume).build();
            deleteReplicaTasks.add(task);
            deleteReplicaIds.add(pairInfo.getReplicaUuid());
            deleteDrReplicaIds.add(pairInfo.getDrReplicaUuid());
        }
        String projectUuid = OpenStackCommonUtil.getObjectUuid(OpenStackCommonUtil.getOpenstack().getUuid(), this.proId);
        if (!VerifyUtil.isEmpty(deleteReplicaIds)) {
            String cgId = this.pg.getProperty("replicaCgUuid");
            this.volumeService.updateVolumeReplicationCG(this.regionUuid, projectUuid, cgId, null, deleteReplicaIds);
        }
        if (!VerifyUtil.isEmpty(deleteDrReplicaIds)) {
            String drCgId = this.pg.getProperty("drReplicaCgUuid");
            this.volumeService.updateVolumeReplicationCG(this.drRegionUuid, projectUuid, drCgId, null, deleteDrReplicaIds);
        }
        OpenStackCommonUtil.executeTask(deleteReplicaTasks, ExecutionService.ExecuteType.FAILED_ABORT, true);
    }

    private void updatePgInfo() {
        this.pg.getPolist().removeIf(po -> this.deleteIds.contains(OpenStackCommonUtil.getIdFromUuid(po.getMoUuid())));
        this.pg.getReplicaList().forEach(replica -> replica.setPg(this.pg));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.pg);
    }

    private void doWorkFinally() {
        ProtectionJobUtil.getInstance().releaseLockPg(this.pg.getUuid());
        ServiceInstanceHelper.getInstance().releaseLock(this.instanceId);
        try {
            ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL);
        }
        catch (LegoCheckedException exception) {
            LOGGER.error((Object)"Set instance(%s) normal error.", new Object[]{this.instanceId});
        }
    }

    private void calculateDeletePoQuota() {
        this.setEvsQuotaToExtendParam(this.evsQuota, "quotas", "order_quotas");
        this.setEvsQuotaToExtendParam(this.evsQuota, "original_quotas", "original_quotas");
        Set<ProtectObject> deletePoList = this.pg.getPolist().stream().filter(po -> this.deleteIds.contains(OpenStackCommonUtil.getIdFromUuid(po.getMoUuid()))).collect(Collectors.toSet());
        JSONArray quotaArray = null;
        try {
            EvsQuotaServiceImpl quotaService = (EvsQuotaServiceImpl)((Object)ServiceLocator.getInstance().getService(EvsQuotaServiceImpl.class));
            quotaArray = quotaService.calculateDeletePosQuota(this.pg, deletePoList, false);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Calculate Delete protect objects fail.instanceId = %s.", new Object[]{this.instanceId});
        }
        catch (Exception e) {
            LOGGER.error((Object)"Calculate Delete protect objects fail, instanceId = %s.", new Object[]{this.instanceId});
        }
        String quotaStr = quotaArray == null || quotaArray.isEmpty() ? null : quotaArray.toString();
        this.getExtendParam().put("order_quotas", quotaStr);
        this.getExtendParam().put("original_quotas", quotaStr);
    }

    private void reportMeter(Map<String, Object> meterInfo) {
        meterInfo.put("change_type", "inst_update");
        meterInfo.put("meter_report_time", TimeUtil.getCurrentDate());
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)this.instanceId));
        String openstackUuid = OpenStackCommonUtil.getOpenstack().getUuid();
        IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(EvsMeterServiceImpl.class);
        meterService.reportChangedMeterInfo(this.regionUuid, instance, openstackUuid, meterInfo);
        meterService.reportChangedMeterInfo(this.drRegionUuid, instance, openstackUuid, meterInfo);
    }

    private void lockServiceInstance() {
        if (!ServiceInstanceHelper.getInstance().getLock(this.instanceId)) {
            LOGGER.error((Object)"Not get this instance lock, instanceId: %s.", new Object[]{this.instanceId});
            throw new LegoCheckedException(1073948693L);
        }
        ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.LOCKED);
    }

    private void lockProtectGroup() {
        boolean isLockSuccess = ProtectionJobUtil.getInstance().getLockPg(this.pg.getUuid());
        if (!isLockSuccess) {
            LOGGER.error((Object)"The pg is locked, pgId: %s.", new Object[]{this.pg.getUuid()});
            throw new LegoCheckedException(102401L);
        }
    }

    protected void processFailure() {
        this.deletePos.forEach(po -> po.setPoStatus(ProtectObjectStatusEnum.ERROR_DELETE.getValue()));
        this.pg.getReplicaList().forEach(replica -> replica.setPg(this.pg));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.pg);
        OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
    }

    public String getRegionUuid() {
        return this.regionUuid;
    }

    public String getDrRegionUuid() {
        return this.drRegionUuid;
    }

    public Set<String> getDeleteIds() {
        return this.deleteIds;
    }

    public Set<ProtectObject> getDeletePos() {
        return this.deletePos;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public String getProId() {
        return this.proId;
    }

    public JSONObject getEvsQuota() {
        return this.evsQuota;
    }

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    public void setRegionUuid(String regionUuid) {
        this.regionUuid = regionUuid;
    }

    public void setDrRegionUuid(String drRegionUuid) {
        this.drRegionUuid = drRegionUuid;
    }

    public void setDeleteIds(Set<String> deleteIds) {
        this.deleteIds = deleteIds;
    }

    public void setDeletePos(Set<ProtectObject> deletePos) {
        this.deletePos = deletePos;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
    }

    public void setProId(String proId) {
        this.proId = proId;
    }

    public void setEvsQuota(JSONObject evsQuota) {
        this.evsQuota = evsQuota;
    }

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }
}

