/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.galax.resource.provider.protectgroup.VolumeProtectObjectProvider;
import com.huawei.ism.drm.openstack.license.EvsVolumeLicenseControlImpl;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.serviceinstance.EvsMeterServiceImpl;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCheckPhVolumeUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CollectionUtils;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class EvsAddVolumesBackTask
extends AbstractBackTask {
    private static final int DEFAULT_TIMEOUT = 7200;
    private static final Log LOG = LogFactory.getInstance(EvsAddVolumesBackTask.class);
    private String regionUuid;
    private String drRegionUuid;
    private Set<ProtectObject> addPoList;
    private String instanceId;
    private ProtectGroup pg;
    private String proId;
    private JSONObject evsQuota;

    public EvsAddVolumesBackTask(String proId, String type, String instanceId, ProtectGroup pg, Set<ProtectObject> addPoList) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)pg.getName(), (String)"ism.drm.instance.volume.add", (String)proId, (String)type, (String)"", (String[])new String[]{pg.getName()}), 7200, true);
        this.instanceId = instanceId;
        this.pg = pg;
        this.proId = proId;
        this.addPoList = addPoList;
        this.regionUuid = (String)pg.getProps().get("regionId");
        this.drRegionUuid = (String)pg.getProps().get("drRegionId");
    }

    protected void doWork() {
        IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
        scOperation.recordingOrder(this.getExtendParam());
        this.setEvsQuotaToExtendParam(this.evsQuota, "quotas", "order_quotas");
        this.setEvsQuotaToExtendParam(this.evsQuota, "original_quotas", "original_quotas");
        OpenStackCheckPhVolumeUtil.checkPhVolumesAndRun(this.regionUuid, this.drRegionUuid, this.addPoList, this::work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        this.checkQuota();
        EvsVolumeLicenseControlImpl licenseControl = EvsVolumeLicenseControlImpl.getInstance();
        try {
            this.lockServiceInstance();
            this.lockProtectGroup();
            String sameDevices = this.pg.getProperty("same_devices");
            this.pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(this.pg.getUuid(), false);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(EvsMeterServiceImpl.class);
            Map meterInfos = meterService.calculateMeterInfos(this.pg);
            meterInfos.put("change_type", "inst_update");
            this.addPoList.forEach(po -> po.setProtectGroup(this.pg));
            this.pg.getPolist().addAll(this.addPoList);
            new VolumeProtectObjectProvider().buildProtectObjects(this.pg);
            licenseControl.deductLicense(this.pg);
            this.pg.setProperty("same_devices", (Object)sameDevices);
            ProtectGroupHelper.getInstance().checkAndBuildReplica(this.pg);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.pg);
            this.reportMeter(meterService, meterInfos);
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Add volume to instance failed.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Add volume to instance failed.", (Throwable)e);
            ExceptionUtil.rethrowException((Throwable)e, (String)"add volumes to instance failed", (long)0x300001L, (String[])new String[0], (Log)LOG);
        }
        finally {
            licenseControl.finishLicense(this.pg.getUuid());
            this.doWorkFinally();
        }
    }

    private void checkQuota() {
        OpenStackCommonUtil.checkPgVolumeCounts(this.pg.getUuid(), this.addPoList.size());
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        String result = quotaService.checkAddVolumesOutOfQuota(this.proId, this.pg, CollectionUtils.mapToSet(this.addPoList, this::convertProtectedVolume));
        if (!VerifyUtil.isEmpty((String)result)) {
            String[] param = result.split(":");
            LOG.error((Object)"Add vols out of quota, pgName = %s.", new Object[]{this.pg.getName()});
            throw new LegoCheckedException(1073948125L, param, "add vols failed.");
        }
    }

    private void reportMeter(IMeterService meterService, Map<String, Object> meterInfos) {
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)this.instanceId));
        meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid);
        meterService.reportChangedMeterInfo(this.regionUuid, instance, openstackUuid, meterInfos);
        meterService.reportChangedMeterInfo(this.drRegionUuid, instance, openstackUuid, meterInfos);
    }

    private ProtectedVolumeInfo convertProtectedVolume(ProtectObject po) {
        ProtectedVolumeInfo protectedVol = new ProtectedVolumeInfo();
        protectedVol.setVolumeId(po.getMoUuid());
        protectedVol.setDrVolumeUuid(po.getProperty("drVolumeType"));
        return protectedVol;
    }

    private void lockServiceInstance() {
        if (!ServiceInstanceHelper.getInstance().getLock(this.instanceId)) {
            LOG.error((Object)"Not get this instance lock, instanceId: %s.", new Object[]{this.instanceId});
            throw new LegoCheckedException(1073948693L);
        }
        ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.LOCKED);
    }

    private void lockProtectGroup() {
        boolean isLockSuccess = ProtectionJobUtil.getInstance().getLockPg(this.pg.getUuid());
        if (!isLockSuccess) {
            LOG.error((Object)"The pg is locked, pgId: %s.", new Object[]{this.pg.getUuid()});
            throw new LegoCheckedException(102401L);
        }
    }

    private void doWorkFinally() {
        ProtectionJobUtil.getInstance().releaseLockPg(this.pg.getUuid());
        ServiceInstanceHelper.getInstance().releaseLock(this.instanceId);
        try {
            ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL);
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"Set instance(%s) normal error.", new Object[]{this.instanceId});
        }
    }

    protected void processFailure() {
        OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
    }

    public String getRegionUuid() {
        return this.regionUuid;
    }

    public String getDrRegionUuid() {
        return this.drRegionUuid;
    }

    public Set<ProtectObject> getAddPoList() {
        return this.addPoList;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public String getProId() {
        return this.proId;
    }

    public JSONObject getEvsQuota() {
        return this.evsQuota;
    }

    public void setRegionUuid(String regionUuid) {
        this.regionUuid = regionUuid;
    }

    public void setDrRegionUuid(String drRegionUuid) {
        this.drRegionUuid = drRegionUuid;
    }

    public void setAddPoList(Set<ProtectObject> addPoList) {
        this.addPoList = addPoList;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
    }

    public void setProId(String proId) {
        this.proId = proId;
    }

    public void setEvsQuota(JSONObject evsQuota) {
        this.evsQuota = evsQuota;
    }
}

