/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.EvsMeterServiceImpl;
import com.huawei.ism.drm.openstack.serviceinstance.EvsQuotaServiceImpl;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.task.base.AbstractDeleteInstanceTask;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class EvsDeleteInstanceTask
extends AbstractDeleteInstanceTask {
    private static final Log LOGGER = LogFactory.getInstance(EvsDeleteInstanceTask.class);
    private static final Set<String> INSTANCE_STATUS_NOT_ALLOWED_DELETE_VOLUME = ImmutableSet.of((Object)ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_FAILED.getValue(), (Object)ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_FAILED.getValue(), (Object)ServiceInstaceEnumDefine.ServiceInstanceStatusE.MAINTAIN.getValue());
    private static final Set<String> VOLUME_STATUS_ALLOWED_DELETE = ImmutableSet.of((Object)OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType(), (Object)OpenstackEnumDefine.VolumeStatusE.ERROR.getType(), (Object)OpenstackEnumDefine.VolumeStatusE.ERRORDELETING.getType(), (Object)OpenstackEnumDefine.VolumeStatusE.ERRORRESTORING.getType());

    public EvsDeleteInstanceTask(String proId, String type, String instanceId, String instanceName) {
        super(proId, type, instanceId, instanceName);
    }

    @Override
    protected void calculateDeleteInstanceQuota(String instanceId) {
        Optional<String> quotasOptional = ((EvsQuotaServiceImpl)((Object)ServiceLocator.getInstance().getService(EvsQuotaServiceImpl.class))).calculateDeleteInstanceQuota(instanceId);
        this.getExtendParam().put("order_quotas", quotasOptional.orElse(null));
        this.getExtendParam().put("original_quotas", quotasOptional.orElse(null));
    }

    @Override
    protected void checkInstanceBeforeDeleteInstance(ServiceInstance serviceInstance) {
        if (serviceInstance == null) {
            LOGGER.error((Object)"Instance is not exist, id: %s.", new Object[]{this.instanceId});
            throw new LegoCheckedException(2117645L);
        }
        this.checkVolSnapshots(serviceInstance);
        ServiceInstanceHelper.checkInstanceStatusSupportDelete(serviceInstance);
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(serviceInstance.getProtectGroupId(), true);
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        List<String> drVolIds = this.getDrVolumeIdsFromPoList(pg.getPolist());
        Map drVolumeMap = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).queryVolumeInfosByUuid(drRegionUuid, drProjUuid, drVolIds);
        boolean isDeleteVolume = this.checkUpdateInstanceDeleteVolume(serviceInstance, pg);
        if (isDeleteVolume) {
            this.checkUpdatePosDeleteVolume(pg, drVolumeMap);
        }
        this.addNotDelVolsToExtendParam(pg.getPolist(), drVolumeMap, drRegionUuid);
    }

    @Override
    protected IMeterService getMeterService() {
        return (IMeterService)ServiceLocator.getInstance().getService(EvsMeterServiceImpl.class);
    }

    private boolean checkUpdateInstanceDeleteVolume(ServiceInstance serviceInstance, ProtectGroup pg) {
        Map extendParam = this.getExtendParam();
        boolean isDeleteVolume = Boolean.parseBoolean(((Object)extendParam.getOrDefault("SHOULD_DELETE_DR_VOLUME", false)).toString());
        if (INSTANCE_STATUS_NOT_ALLOWED_DELETE_VOLUME.contains(serviceInstance.getStatus())) {
            LOGGER.info((Object)"The service instance status(%s) does not support delete volume.", new Object[]{serviceInstance.getStatus()});
            isDeleteVolume = false;
        }
        boolean isLastTaskFailed = ServiceInstaceEnumDefine.ServiceInstanceStatusE.ERR_DELETE.getValue().equals(serviceInstance.getStatus());
        String lastDeleteConfig = pg.getProperty("SHOULD_DELETE_DR_VOLUME");
        if (isLastTaskFailed && !VerifyUtil.isEmpty((String)lastDeleteConfig)) {
            LOGGER.info((Object)"The last delete service instance task failed, inherit the deletion configuration of the last task.");
            return Boolean.parseBoolean(lastDeleteConfig);
        }
        String isDeleteVolumeStr = String.valueOf(isDeleteVolume);
        if (!isDeleteVolumeStr.equals(lastDeleteConfig)) {
            extendParam.put("SHOULD_DELETE_DR_VOLUME", isDeleteVolume);
            pg.setProperty("SHOULD_DELETE_DR_VOLUME", (Object)isDeleteVolumeStr);
            ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(pg.getUuid(), pg.getProps());
        }
        return isDeleteVolume;
    }

    private void checkUpdatePosDeleteVolume(ProtectGroup pg, Map<String, VolumeInfo> volumeInfoMap) {
        Set poList = pg.getPolist();
        if (VerifyUtil.isEmpty((Collection)poList)) {
            return;
        }
        for (ProtectObject po : poList) {
            boolean isDeleteVolume;
            Optional<VolumeInfo> drVolumeOptional = this.getDrVolumeIdFromPo(po).map(volumeInfoMap::get);
            if (drVolumeOptional.isPresent()) {
                isDeleteVolume = this.checkVolumeSupportDelete(drVolumeOptional.get());
            } else {
                LOGGER.info((Object)"The dr volume does not exist or was deleted, poId: %s.", new Object[]{po.getMoUuid()});
                isDeleteVolume = true;
            }
            if (String.valueOf(isDeleteVolume).equals(po.getProperty("SHOULD_DELETE_DR_VOLUME"))) continue;
            po.setProperty("SHOULD_DELETE_DR_VOLUME", (Object)String.valueOf(isDeleteVolume));
        }
        pg.getReplicaList().forEach(replica -> replica.setPg(pg));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)pg);
    }

    private void addNotDelVolsToExtendParam(Set<ProtectObject> poList, Map<String, VolumeInfo> volumeInfoMap, String drRegionUuid) {
        if (VerifyUtil.isEmpty(poList)) {
            return;
        }
        ArrayList notDeleteVols = new ArrayList();
        for (ProtectObject po : poList) {
            if (Boolean.parseBoolean(po.getProperty("SHOULD_DELETE_DR_VOLUME"))) continue;
            Optional<VolumeInfo> drVolumeOptional = this.getDrVolumeIdFromPo(po).map(volumeInfoMap::get);
            drVolumeOptional.ifPresent(notDeleteVols::add);
        }
        this.getExtendParam().put("drRegionId", drRegionUuid);
        this.getExtendParam().put("PG_NOT_DELETE_VOLUMES", notDeleteVols);
    }

    private Optional<String> getDrVolumeIdFromPo(ProtectObject po) {
        PoReplicaInfo replicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
        if (replicaInfo == null || VerifyUtil.isEmpty((Collection)replicaInfo.getPairInfos())) {
            return Optional.empty();
        }
        String drVolumeUuid = Optional.ofNullable(replicaInfo.getPairInfos().get(0)).map(PoReplicaPairInfo::getDrVolumeUuid).orElse("");
        if (VerifyUtil.isEmpty((String)drVolumeUuid)) {
            return Optional.empty();
        }
        return Optional.of(OpenStackBasicUtil.getIdFromUuid(drVolumeUuid));
    }

    private List<String> getDrVolumeIdsFromPoList(Collection<ProtectObject> poList) {
        return poList.stream().map(this::getDrVolumeIdFromPo).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private boolean checkVolumeSupportDelete(VolumeInfo volume) {
        if (!VerifyUtil.isEmpty((Collection)volume.getAttachments())) {
            LOGGER.info((Object)"The dr volume is not allowed to delete when it is mounted to the vm, volumeId: %s.", new Object[]{volume.getId()});
            return false;
        }
        String status = volume.getStatus();
        if (!VOLUME_STATUS_ALLOWED_DELETE.contains(status)) {
            LOGGER.info((Object)"The dr volume is not allowed to delete when it is mounted to the vm, volumeId: %s, status: %s.", new Object[]{volume.getId(), status});
            return false;
        }
        return true;
    }
}

