/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task.sfs;

import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.model.HypermetroDomain;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceQueryImpl;
import com.huawei.ism.drm.openstack.serviceinstance.task.base.AbstractDeleteInstanceTask;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SfsDeleteInstanceTask
extends AbstractDeleteInstanceTask {
    private static final Log LOG = LogFactory.getInstance(SfsDeleteInstanceTask.class);

    public SfsDeleteInstanceTask(String proId, String type, String instanceId, String instanceName) {
        super(proId, type, instanceId, instanceName);
    }

    @Override
    protected void deleteOtherRecoveryPlan(ServiceInstance instance) {
        String pgId = instance.getProtectGroupId();
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(pgId, true);
        HypermetroDomain hypermetroDomain = null;
        for (ProtectObject po : pg.getPolist()) {
            String hypermtroDomainString = po.getProperty("pg_hypermetro_domain");
            hypermetroDomain = (HypermetroDomain)JSONObject.toBean((String)hypermtroDomainString, HypermetroDomain.class);
            if (!VerifyUtil.isEmpty((Object)hypermetroDomain) && !VerifyUtil.isEmpty((String)hypermetroDomain.getId())) continue;
            LOG.error((Object)"HypermetroDomainInfo error");
            return;
        }
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = recoveryPlanService.getRecoveryPlanByDomainId(hypermetroDomain.getId());
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            LOG.info((Object)"No Nas recovery plan is available.");
            return;
        }
        Set protectGroupSet = recoveryPlan.getProtectGroups();
        protectGroupSet.remove(pg);
        if (VerifyUtil.isEmpty((Collection)protectGroupSet)) {
            LOG.info((Object)"Deleting a Nas Recovery Plan(%s)", new Object[]{recoveryPlan.getName()});
            this.deleteRecoveryPlan(recoveryPlan.getPlanId());
            return;
        }
        recoveryPlan.setProtectGroups(protectGroupSet);
        recoveryPlanService.saveOrUpdateRecoveryPlan(recoveryPlan);
    }

    @Override
    protected void calculateDeleteInstanceQuota(String instanceId) {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
            List list = quotaService.calculateDeleteSfsInstanceQuota(this.instanceId);
            JSONArray quotaResourceList = new JSONArray();
            for (QuotaResourcesBo bo : list) {
                JSONObject quotaResource = new JSONObject();
                quotaResource.put((Object)"resource", (Object)bo.getType());
                quotaResource.put((Object)"used", (Object)Float.valueOf(bo.getQuota()));
                quotaResourceList.add((Object)quotaResource);
            }
            ServiceInstance instance = AbstractServiceInstanceQueryImpl.queryServiceInstance(instanceId);
            String pgId = instance.getProtectGroupId();
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            ProtectGroup pg = pgService.getProtectGroupBasicInfo(pgId, true);
            String projectId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("projectId"));
            String regionId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("regionId"));
            String drRegionId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drRegionId"));
            String drProjectId = OpenStackCommonUtil.getIdFromUuid(pg.getProperty("drProjectId"));
            JSONObject usage = new JSONObject();
            usage.put((Object)"resources", (Object)quotaResourceList);
            usage.put((Object)"service_id", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.getServiceIdFromServiceType((String)instance.getType()));
            JSONArray usagesList = new JSONArray();
            usagesList.add((Object)usage);
            JSONArray quotas = new JSONArray();
            JSONObject quota = new JSONObject();
            quota.put((Object)"project_id", (Object)projectId);
            quota.put((Object)"region_id", (Object)regionId);
            quota.put((Object)"usages", (Object)usagesList);
            quotas.add((Object)quota);
            JSONObject drQuota = new JSONObject();
            drQuota.put((Object)"project_id", (Object)drProjectId);
            drQuota.put((Object)"region_id", (Object)drRegionId);
            drQuota.put((Object)"usages", (Object)usagesList);
            quotas.add((Object)drQuota);
            Map param = this.getExtendParam();
            param.put("order_quotas", quotas);
            this.setExtendParam(param);
        }
    }

    @Override
    protected Map<String, Object> calcMeterBeforeUpdate(ServiceInstance instance, IMeterService meterService) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        HashMap<String, Object> meterInfos = new HashMap<String, Object>();
        String regionUuid = (String)pg.getProps().get("regionId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String projUuid = openstackUuid + ":" + instance.getProjectId();
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        UrlBaseParams pdUrlBaseParams = new UrlBaseParams(projUuid, regionUuid, tokenId);
        float deleteSize = 0.0f;
        if (!VerifyUtil.isEmpty((Object)pg)) {
            for (ProtectObject po : pg.getPolist()) {
                Share pdShare = ManagerFactory.getInstance().getSfsManilaManager().queryShareById(pdUrlBaseParams, OpenStackCommonUtil.getIdFromUuid(po.getMoUuid()));
                deleteSize += (float)pdShare.getSize().intValue();
            }
        }
        meterInfos.put("csha.instance.num", String.valueOf(1));
        meterInfos.put("csha.vol.size", String.valueOf(deleteSize));
        meterInfos.put("change_type", "inst_delete");
        meterInfos.put("meter_pg", pg);
        return meterInfos;
    }
}

