/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.cts.service;

import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.ism.drm.system.thirdservice.AbstractOperateLogService;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public class CtsNotifyServiceImpl
extends AbstractOperateLogService
implements SystemStatusChangedListener {
    private static final Log LOG = LogFactory.getInstance(CtsNotifyServiceImpl.class);
    private static final String CHECK_CTS_URL = "/rest/trace/v1/ctscheck";
    private static final String AUTH_KEY = "X-Auth-Token";
    private static final String CONTENT_TYPE_KEY = "Content-type";
    private static final String ACCEPUT_KEY = "Accept";
    private static final String HEADER_FORMAT = "application/json;charset=UTF-8";
    private static final String CTS_URL = "/v1.0/{projectId}/system/trace";
    private String tokenId = null;
    private RestClient restlogClient = null;

    public void notifyLog(SysOptLog log) {
        if (VerifyUtil.isEmpty((Object)log)) {
            LOG.error((Object)"log is empty .");
            throw new LegoCheckedException(1073947393L);
        }
        if (this.restlogClient == null) {
            this.changeOptLogReportedStatus(true, Arrays.asList(log));
            return;
        }
        this.log("[" + this.getSingleLogJson(log) + "]", log.getProjectId());
        this.changeOptLogReportedStatus(true, Arrays.asList(log));
    }

    protected String getSingleLogJson(SysOptLog log) {
        JSONObject logJson = new JSONObject();
        logJson.put((Object)"time", (Object)log.getDate().getTime());
        this.setServiceType(logJson, log);
        String traceName = this.limitTraceNameLen(log);
        logJson.put((Object)"trace_name", (Object)traceName);
        logJson.put((Object)"trace_name_cn", (Object)this.getI18nMgr().getString(log.getOperation(), Locale.SIMPLIFIED_CHINESE));
        logJson.put((Object)"trace_rating", (Object)this.getlogLevelString(log.getLevel()));
        logJson.put((Object)"trace_result", (Object)this.getResult(log.getResult()));
        logJson.put((Object)"source_ip", (Object)log.getTerminalIp());
        logJson.put((Object)"resource_name", (Object)this.getI18nMgr().getString(log.getTarget()).replaceAll("\\[", "").replaceAll("\\]", ""));
        logJson.put((Object)"resource_type", (Object)logJson.getString("service_type", "--"));
        logJson.put((Object)"message", (Object)this.getI18nMgr().getString(log.getDetail(), Locale.ENGLISH, log.getDetailPara()));
        logJson.put((Object)"trace_message_cn", (Object)this.getI18nMgr().getString(log.getDetail(), Locale.SIMPLIFIED_CHINESE, log.getDetailPara()));
        String tokenUser = log.getTokenUser();
        if (!VerifyUtil.isEmpty((String)tokenUser)) {
            String user = "{\"user\":" + log.getTokenUser() + "}";
            String logString = logJson.toString();
            String tempString = logString.substring(0, logString.length() - 1);
            return tempString + ",\"user\":\"" + user.replace("\"", "\\\"") + "\"}";
        }
        logJson.put((Object)"user", (Object)tokenUser);
        return logJson.toString();
    }

    public void notifyLog(List<SysOptLog> logs) {
        if (VerifyUtil.isEmpty(logs)) {
            LOG.error((Object)"logs is empty .");
            throw new LegoCheckedException(1073947393L);
        }
        if (this.restlogClient == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        this.initLog(builder, logs);
        String logsString = builder.toString();
        this.log(logsString, ((SysOptLog)CommonUtil.getFirstElement(logs)).getProjectId());
        this.changeOptLogReportedStatus(true, logs);
    }

    public void refactorServiceConfig() {
        LogNotifyServer server;
        if (this.restlogClient != null) {
            this.restlogClient.closeHttpClient();
        }
        if ((server = this.getLogNotifyServerBy("tenantlog")) != null && server.getIsEnabled()) {
            JSONObject props = JSONObject.fromObject((Object)server.getProtocalProps());
            String ip = props.getString("ip");
            String port = props.getString("port");
            this.restlogClient = new RestClient(ip, NumberUtil.parseInteger((Object)port).intValue(), null, null, (IResponseHandler)new CtsResponseHandler(), new String[0]);
        } else {
            this.restlogClient = null;
        }
    }

    public String getServiceType() {
        return "tenantlog";
    }

    public void checkConnection(String ip, String port, String protocol) {
        String tempTokenId = CtsNotifyServiceImpl.getUnscopeTokenId();
        RestClient tempClient = new RestClient(ip, NumberUtil.parseInteger((Object)port).intValue(), null, null, (IResponseHandler)new CtsResponseHandler(), new String[0]);
        BasicHeader strToken = new BasicHeader(AUTH_KEY, (Object)tempTokenId);
        BasicHeader conType = new BasicHeader(CONTENT_TYPE_KEY, (Object)HEADER_FORMAT);
        BasicHeader acceptType = new BasicHeader(ACCEPUT_KEY, (Object)HEADER_FORMAT);
        ArrayList<BasicHeader> requestHeaders = new ArrayList<BasicHeader>();
        requestHeaders.add(strToken);
        requestHeaders.add(conType);
        requestHeaders.add(acceptType);
        try {
            tempClient.get(CHECK_CTS_URL, null, requestHeaders);
        }
        catch (Exception e) {
            LOG.error((Object)("check CTS health error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073947407L, (Throwable)e);
        }
        finally {
            tempClient.closeHttpClient();
        }
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        LOG.info((Object)"start report talentlog service .");
        this.refactorServiceConfig();
    }

    private void log(String log, String projectId) {
        if (this.restlogClient == null) {
            LOG.error((Object)"report log error , client is null");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("projectId", projectId);
        try {
            this.restlogClient.post(CTS_URL, log, paramMap, this.getHeaders());
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947691L) {
                LOG.info((Object)"author failed , will refresh token and retry .");
                this.tokenId = CtsNotifyServiceImpl.getUnscopeTokenId();
                this.restlogClient.post(CTS_URL, log, paramMap, this.getHeaders());
            }
            LOG.error((Object)"report talent operate log error");
            throw e;
        }
    }

    private List<Header> getHeaders() {
        if (VerifyUtil.isEmpty((String)this.tokenId)) {
            this.tokenId = CtsNotifyServiceImpl.getUnscopeTokenId();
        }
        BasicHeader strToken = new BasicHeader(AUTH_KEY, (Object)this.tokenId);
        BasicHeader conType = new BasicHeader(CONTENT_TYPE_KEY, (Object)HEADER_FORMAT);
        BasicHeader acceptType = new BasicHeader(ACCEPUT_KEY, (Object)HEADER_FORMAT);
        ArrayList<Header> requestHeaders = new ArrayList<Header>();
        requestHeaders.add((Header)strToken);
        requestHeaders.add((Header)conType);
        requestHeaders.add((Header)acceptType);
        return requestHeaders;
    }

    private static String getUnscopeTokenId() {
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        return TokenUtil.getInstance().getTokenId(open, null);
    }

    public boolean isAvailable() {
        if (this.restlogClient == null) {
            return false;
        }
        try {
            this.restlogClient.get(CHECK_CTS_URL, null, this.getHeaders());
            return true;
        }
        catch (LegoCheckedException e) {
            return e.getErrorCode() == 1073947691L;
        }
        catch (Exception e) {
            return false;
        }
    }

    static class CtsResponseHandler
    implements IResponseHandler {
        private static final int UNAUTH_CODE = 401;
        private static final int FORBIDEN_CODE = 403;
        private static final int NOMAL_CODE = 200;

        CtsResponseHandler() {
        }

        public void handleReponse(ServiceResponse response) {
            if (response == null) {
                LOG.error((Object)"Response is empty");
                throw new LegoCheckedException(1073947647L);
            }
            if (401 == response.getStatusCode() || 403 == response.getStatusCode()) {
                LOG.error((Object)"Response status code 401");
                throw new LegoCheckedException(1073947691L);
            }
            if (200 != response.getStatusCode()) {
                LOG.error((Object)("response status code " + response.getStatusCode()));
                throw new LegoCheckedException(-1L);
            }
        }
    }
}

