/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.kms;

import com.huawei.ism.drm.wcc.util.kms.IamAccessMgr;
import com.huawei.ism.drm.wcc.util.kms.KmsAccessMgr;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.Constants;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class KmsRootKeySync
implements SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(KmsRootKeySync.class);
    private static final int PERIOD_TIME = 3600;
    private static final int DELAY_TIME = 60;

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && this.needSyncRootKey()) {
            logger.info((Object)"Sync kms root key to prepared region task start.");
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(this::syncRootKey, 60L, 3600L, TimeUnit.SECONDS);
        }
    }

    private void syncRootKey() {
        try {
            Optional token = IamAccessMgr.getToken();
            if (!token.isPresent()) {
                logger.error((Object)"Sync kms root key failed. Get token failed.");
                return;
            }
            String projectId = IamAccessMgr.getProject((String)((String)token.get()));
            List keyIds = KmsAccessMgr.getRootKeys((String)((String)token.get()), (String)projectId);
            keyIds.forEach(keyId -> this.syncKey2ValidRegion((String)token.get(), projectId, (String)keyId));
            logger.info((Object)"Sync kms root key to prepared region end.");
        }
        catch (Exception e) {
            logger.error((Object)"Sync kms root key failed. Exception: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private void syncKey2ValidRegion(String token, String projectId, String keyId) {
        try {
            List regions = KmsAccessMgr.getSyncRegions((String)token, (String)projectId, (String)keyId);
            for (String regionId : regions) {
                KmsAccessMgr.syncRootKey((String)token, (String)projectId, (String)keyId, (String)regionId);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Sync key:%s failed. Exception:%s", new Object[]{keyId, ExceptionUtil.getErrorMessage((Throwable)exception)});
        }
    }

    private boolean needSyncRootKey() {
        String currentCipher = LegoConfig.getInstance().getKeyValue("cipher.type");
        if (StringUtils.equals((CharSequence)currentCipher, (CharSequence)Constants.CipherType.GENERAL_CIPHER.getValue())) {
            return false;
        }
        String isActiveSite = "false";
        String installPath = PathUtil.getInstallPath();
        String propertyFile = installPath + "/NodeAgent/conf/nodeAgent.properties";
        try (FileInputStream inputStream = new FileInputStream(propertyFile);){
            Properties properties = new Properties();
            properties.load(inputStream);
            isActiveSite = properties.getProperty("is_active_site");
        }
        catch (IOException e) {
            logger.error((Object)"Load nodeAgent.properties failed.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)isActiveSite);
    }
}

