/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.unitepassword;

import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.system.unitepassword.OpenStackUnitePasswordConstants;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Account;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Complexity;
import com.huawei.lego.cbb.user.service.common.SystemInitializeUser;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Map;

public class UnitePasswordCommon {
    private static final Log LOGGER = LogFactory.getInstance(UnitePasswordCommon.class);
    private static final SystemInitializeUser SYSTEMINITIALIZEUSER = new SystemInitializeUser();
    private static final LegoMoGenerator LEGOMOGENERATOR = new LegoMoGenerator();

    public static Account buildSyncAdminAccount(String pwd, int operationType) {
        Account account = new Account();
        String syncUserName = SYSTEMINITIALIZEUSER.getProperty("sys.defalt.syncUserName", "");
        account.setAccountName(syncUserName);
        String regionId = LegoConfig.getNodeConfig().getKeyValue("config.hcs.node.region");
        account.setRegion(regionId);
        account.setIp(LEGOMOGENERATOR.getInstallServerIp());
        account.setAccountType(OpenStackUnitePasswordConstants.ACCOUNTTYPE.MMAPPACCOUNT.getCode());
        account.setUrlValid(OpenStackUnitePasswordConstants.UnitePasswordRegisterUrl.URL_VALID.getUrl());
        account.setAccountDescription("{\"zh-cn\":\"\u673a\u673a\u63a5\u53e3\u5e10\u6237\uff0c\u7528\u4e8e\u53ccRD\u901a\u4fe1\u4e0eHA\u544a\u8b66\u4e0a\u62a5\",\"en-us\":\"Machine-machine interface account used for dual-RD communication and HA alarm reporting\"}");
        account.setPasswd(pwd);
        account.setOldPasswd(pwd);
        account.setPasswdExpires(Long.valueOf(-1L));
        Complexity syncAdminComplexity = new Complexity();
        syncAdminComplexity.setDifok(4);
        syncAdminComplexity.setUcredit(1);
        syncAdminComplexity.setLcredit(1);
        syncAdminComplexity.setDcredit(1);
        syncAdminComplexity.setOcredit(1);
        account.setPasswdComplexity(syncAdminComplexity);
        account.setOperationType(operationType);
        account.setModifyType(OpenStackUnitePasswordConstants.MODIFYTYPE.NOT_SUPPORT.getCode());
        return account;
    }

    public static boolean register(JSONObject accountJSONObject) {
        JSONObject result;
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.er.om.float");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            LOGGER.error((Object)"Unite Password account register failed, server urlStr is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String fullUrl = "https://" + urlStr + "/rest/mounpwdservice/v1/account";
        LOGGER.info((Object)"Unite Password account register fullUrl is : %s", new Object[]{fullUrl});
        String response = ClientUtil.sendPostRequest(fullUrl, accountJSONObject.toString(), tokenId);
        LOGGER.info((Object)"Unite Password account register response: %s", new Object[]{response});
        if (VerifyUtil.isEmpty((String)response)) {
            LOGGER.error((Object)"Unite Password account register response is empty.");
            throw new LegoCheckedException(0x300001L);
        }
        try {
            result = JSONObject.fromObject((Object)response);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Resolve Unite Password account register response  failed.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
        if (!VerifyUtil.isEmpty((Map)result) && result.containsKey((Object)"code")) {
            String resultCode = result.getString("code");
            LOGGER.info((Object)"Unite Password account register response resultCode is : %s", new Object[]{resultCode});
            if ("00000000".equals(resultCode)) {
                return true;
            }
            LOGGER.error((Object)"Unite Password account register failed, The resultData is %s", new Object[]{result.getString("message")});
            return false;
        }
        LOGGER.error((Object)"Unite Password account register failed.");
        return false;
    }
}

