/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.unitepassword.serviceimpl;

import com.huawei.ism.drm.openstack.system.unitepassword.OpenStackUnitePasswordConstants;
import com.huawei.ism.drm.openstack.system.unitepassword.UnitePasswordCommon;
import com.huawei.ism.drm.openstack.system.unitepassword.model.SubComponent;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Account;
import com.huawei.lego.comm.unitepassword.IUnitePasswordSyncAdminMgr;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

@Service(name="unitePasswordSyncAdminMgrImpl", desc="", interfaceClass=IUnitePasswordSyncAdminMgr.class)
public class UnitePasswordSyncAdminMgrImpl
extends BaseService
implements IUnitePasswordSyncAdminMgr {
    private static final Log LOG = LogFactory.getInstance(UnitePasswordSyncAdminMgrImpl.class);

    public void modifySyncAdminPwd(String newPwd) {
        if (StringUtils.isEmpty((CharSequence)newPwd)) {
            LOG.warn((Object)"Modify syncAdmin pwd empty.");
            return;
        }
        JSONObject deleteObject = this.getRegisterObject(newPwd, OpenStackUnitePasswordConstants.OPERATIONTYPE.DELETE.getCode());
        JSONObject addObject = this.getRegisterObject(newPwd, OpenStackUnitePasswordConstants.OPERATIONTYPE.ADD.getCode());
        if (UnitePasswordCommon.register(deleteObject) && UnitePasswordCommon.register(addObject)) {
            LOG.warn((Object)"Modify syncAdmin pwd success.");
            return;
        }
        LOG.error((Object)"Modify syncAdmin pwd to ManageOne failed.");
        throw new LegoCheckedException(-1L, "Update account to ManageOne error");
    }

    private JSONObject getRegisterObject(String pwd, int operationType) {
        Account syncAccount = UnitePasswordCommon.buildSyncAdminAccount(pwd, operationType);
        String componentName = "eReplication";
        SubComponent subComponent = new SubComponent();
        subComponent.setSubComponentName(componentName);
        subComponent.setCreatedAccountList(Collections.singletonList(syncAccount));
        JSONObject accountJSONObject = new JSONObject();
        accountJSONObject.put((Object)"componentName", (Object)componentName);
        accountJSONObject.put((Object)"subComponents", Collections.singletonList(subComponent));
        return accountJSONObject;
    }
}

