/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeInfoBO;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.msg.HyperMetroVolInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.sdk.msg.VolAttachInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolConnectionInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolConnectionInfoData;
import com.huawei.ism.drm.openstack.sdk.msg.VolDataHyTargetLun;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.openstack.tools.OpenstackResourceUtil;
import com.huawei.ism.drm.openstack.tools.model.DelTagParam;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.util.FusionCloudUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OpenStackBasicUtil {
    private static final Log LOG = LogFactory.getInstance(OpenStackBasicUtil.class);

    protected OpenStackBasicUtil() {
    }

    public static String getIdFromUuid(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            return null;
        }
        if (uuid.contains(":")) {
            uuid = uuid.split(":")[1];
        }
        return uuid;
    }

    public static Set<String> getIdFromUuid(Set<String> srcUuids) {
        HashSet<String> idSet = new HashSet<String>();
        if (VerifyUtil.isEmpty(srcUuids)) {
            return idSet;
        }
        for (String uuid : srcUuids) {
            String id = OpenStackBasicUtil.getIdFromUuid(uuid);
            if (VerifyUtil.isEmpty((String)id)) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public static String getOpenstackUuidFromStr(String uuid) {
        String ret = "";
        if (VerifyUtil.isEmpty((String)uuid)) {
            return "";
        }
        if (uuid.contains(":")) {
            ret = uuid.split(":")[0];
        }
        return ret;
    }

    public static int generateHashCode(String ... props) {
        int prime = 31;
        int result = 1;
        for (String prop : props) {
            result = 31 * result + (prop == null ? 0 : prop.hashCode());
        }
        return result;
    }

    public static List<String> getListFromStr(String str, String seperator) {
        String[] strArr;
        if (VerifyUtil.isEmpty((String)str) || VerifyUtil.isEmpty((String)seperator)) {
            return new ArrayList<String>();
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (String temp : strArr = str.split(seperator)) {
            retList.add(temp);
        }
        return retList;
    }

    public static String getStringFromCollection(Collection<String> collection, String seperator) {
        if (VerifyUtil.isEmpty(collection) || VerifyUtil.isEmpty((String)seperator)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : collection) {
            sb.append(str);
            sb.append(seperator);
        }
        if (sb.length() == 0) {
            return "";
        }
        String result = sb.substring(0, sb.length() - 1);
        return result;
    }

    public static String getObjectUuid(String openstatckUuid, String objId) {
        if (VerifyUtil.isEmpty((String)openstatckUuid) || VerifyUtil.isEmpty((String)objId)) {
            throw new LegoCheckedException(1073947393L);
        }
        String prefix = openstatckUuid + ":";
        if (objId.startsWith(prefix)) {
            return objId;
        }
        return prefix + objId;
    }

    public static int getNumFromResource(String key, int defaultValue) {
        if (VerifyUtil.isEmpty((String)key)) {
            throw new LegoCheckedException(1073947393L);
        }
        int num = defaultValue;
        try {
            String numStr = OpenstackResourceUtil.getInstance().getValue(key);
            num = Integer.parseInt(numStr);
        }
        catch (Exception e) {
            LOG.error((Object)("number format failed,key=" + key + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return num;
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeContent = dateFormat.format(date);
        String timeZoneStr = " " + TimeUtil.getDefaultTimeZone((Date)date);
        timeContent = timeContent + timeZoneStr;
        return timeContent;
    }

    public static String getNameBySuff(String name, String suff) {
        String srcName;
        if (VerifyUtil.isEmpty((String)name) || VerifyUtil.isEmpty((String)suff)) {
            LOG.error((Object)"get name by suff error , name or suff empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String targetName = srcName = name + suff;
        try {
            byte[] nameByte = srcName.getBytes("UTF-8");
            int len = nameByte.length - 255;
            if (len > 0) {
                if (len % 2 != 0) {
                    ++len;
                }
                byte[] srcNameByte = name.getBytes("UTF-8");
                targetName = new String(srcNameByte, 0, srcNameByte.length - len, "UTF-8") + suff;
            }
            return targetName;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("can not convert to utf-8 unicode error." + name.length() + ExceptionUtil.getErrorMessage((Throwable)e)));
            if (name.length() > 3) {
                return name.substring(0, name.length() - 3) + suff;
            }
            return srcName;
        }
    }

    public static boolean isCurrentFCVersionHighThan63() {
        return FusionCloudUtil.isCurrentFCVersionHighThanParamVerion((String)"6.3");
    }

    public static OpenStackAvailabilityZoneMapping initOpenStackAvailabilityZoneMapping(String regionId, String remoteRegionId, String remoteAzName) {
        OpenStackAvailabilityZoneMapping zoneMapping = new OpenStackAvailabilityZoneMapping();
        zoneMapping.setPrimaryRegionId(regionId);
        zoneMapping.setSecondRegionId(remoteRegionId);
        zoneMapping.setSecondAzId(remoteAzName);
        zoneMapping.setSecondAz(remoteAzName);
        return zoneMapping;
    }

    public static boolean checkHyperMetroVolPath(VolAttachInfo attachInfo) {
        if (VerifyUtil.isEmpty((Object)attachInfo)) {
            LOG.debug((Object)"VolAttachInfo is null");
            return false;
        }
        HyperMetroVolInfo hyInfo = attachInfo.getHyInfo();
        if (VerifyUtil.isEmpty((Object)hyInfo)) {
            LOG.debug((Object)"HyperMetroVolInfo is null");
            return false;
        }
        if (VerifyUtil.isEmpty((String)hyInfo.getLocalLun())) {
            LOG.debug((Object)"HyperMetroVolInfo LocalLun is null");
            return false;
        }
        if (VerifyUtil.isEmpty((String)hyInfo.getRemoteLun())) {
            LOG.debug((Object)"HyperMetroVolInfo RemoteLun is null");
            return false;
        }
        VolConnectionInfo connectionInfo = attachInfo.getConnectionInfo();
        if (VerifyUtil.isEmpty((Object)connectionInfo)) {
            LOG.debug((Object)"connectionInfo is null");
            return false;
        }
        VolConnectionInfoData data = connectionInfo.getData();
        if (VerifyUtil.isEmpty((Object)data)) {
            LOG.debug((Object)"connectionInfo data is null");
            return false;
        }
        VolDataHyTargetLun hyTargetLun = data.getHyTargetLun();
        if (VerifyUtil.isEmpty((Object)hyTargetLun)) {
            LOG.debug((Object)"hyTargetLun data is null");
            return false;
        }
        if (!Arrays.asList(hyTargetLun.getLocalLunScan(), hyTargetLun.getRemoteLunScan()).stream().allMatch(Boolean.TRUE::equals)) {
            LOG.debug((Object)"local_lun_scan or remote_lun_scan is false");
            return false;
        }
        return true;
    }

    public static PoReplicaInfo getSameVmUUIDPoReplication(PoReplicaInfo sourcePoReplicaInfo, Map<String, PoReplicaInfo> poDRReplicaInfoMap) {
        PoReplicaInfo rollbackHyperMetorepoReplicaInfo = null;
        for (PoReplicaInfo hyqrollbackPoReplicaInfo : poDRReplicaInfoMap.values()) {
            List hyqpairInfoList = hyqrollbackPoReplicaInfo.getPairInfos();
            if (VerifyUtil.isEmpty((Collection)hyqpairInfoList) || !hyqrollbackPoReplicaInfo.getMoUuid().equals(sourcePoReplicaInfo.getMoUuid())) continue;
            rollbackHyperMetorepoReplicaInfo = hyqrollbackPoReplicaInfo;
            break;
        }
        return rollbackHyperMetorepoReplicaInfo;
    }

    public static void cleanProps(Map<String, String> props, String ... keys) {
        OpenStackBasicUtil.cleanProps(props, Arrays.asList(keys).stream());
    }

    public static void cleanProps(Map<String, String> props, Stream<String> keyStream) {
        keyStream.filter(Objects::nonNull).forEach(props::remove);
    }

    public static Map.Entry<Map<String, String>, List<VolumeReplicationCgInfo>> queryVolumeReplicationCG(ProtectGroup protectGroup) {
        String standbyCgIdKey;
        String normalCgIdKey;
        String regionId;
        String projectId;
        DrExtendManager mgr = new DrExtendManager();
        Map props = protectGroup.getProps();
        if (OpenStackBasicUtil.isCsdrVhaMode(protectGroup)) {
            projectId = (String)props.get("projectId");
            regionId = (String)props.get("regionId");
            normalCgIdKey = "replicaCgUuid";
            standbyCgIdKey = "hyperProRemoteCgUuid";
        } else {
            projectId = (String)props.get("drProjectId");
            regionId = (String)props.get("drRegionId");
            normalCgIdKey = "drReplicaCgUuid";
            standbyCgIdKey = "hyperProRemotedrCgUuid";
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionId, projectId);
        String normalCgId = (String)props.get(normalCgIdKey);
        String standbyCgId = (String)props.get(standbyCgIdKey);
        List cgs = Arrays.asList(normalCgId, standbyCgId).stream().filter(Objects::nonNull).map(cg -> mgr.queryVolumeReplicationCG(regionId, tokenId, projectId, (String)cg)).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put(OpenStackBasicUtil.getIdFromUuid(normalCgId), "activeside");
        mapping.put(OpenStackBasicUtil.getIdFromUuid(standbyCgId), "standbyside");
        return new AbstractMap.SimpleEntry<Map<String, String>, List<VolumeReplicationCgInfo>>(mapping, cgs);
    }

    public static boolean isCsdrVhaMode(ProtectGroup protectGroup) {
        String regionUuid;
        if (!protectGroup.hasProperty("originalAvailableRegion")) {
            return false;
        }
        String originalRegionUuid = protectGroup.getProperty("originalAvailableRegion");
        return !Objects.equals(originalRegionUuid, regionUuid = protectGroup.getProperty("regionId"));
    }

    public static boolean isCsdrCshaMode(ProtectGroup protectGroup) {
        return OpenStackBasicUtil.isCsdrVhaMode(protectGroup);
    }

    public static List<OpenStackAvailabilityZoneMapping> getVhaCshaMappingsList(List<OpenStackAvailabilityZoneMapping> mappings, String regionId, ServiceInstaceEnumDefine.ServiceInstanceTypeE instanceType) {
        ArrayList<OpenStackAvailabilityZoneMapping> vhaMappingsList = new ArrayList<OpenStackAvailabilityZoneMapping>();
        if (regionId == null) {
            return vhaMappingsList;
        }
        for (OpenStackAvailabilityZoneMapping mapping : mappings) {
            if (instanceType != ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)mapping.getType()) || !OpenStackBasicUtil.isRelatedAZMappingForVha(mapping, regionId)) continue;
            vhaMappingsList.add(mapping);
        }
        return vhaMappingsList;
    }

    private static boolean isRelatedAZMappingForVha(OpenStackAvailabilityZoneMapping mapping, String regionId) {
        if (mapping == null || regionId == null) {
            return false;
        }
        return regionId.equals(mapping.getPrimaryRegionId());
    }

    public static void buildVolumeExtendHyperMetroInfo(PoReplicaPairInfo pairInfo, ProtectGroup pg, Map<String, String> volNameMap, ProtectObject po, VolumeInfoBO volumeTemp) {
        String replicationHyperMetorInfo = (String)po.getProps().get("hypermetor_replicationInfo");
        PoReplicaInfo poHyperMetroReplicaInfo = JsonUtil.jsonToBean(replicationHyperMetorInfo, PoReplicaInfo.class);
        if (null != poHyperMetroReplicaInfo && !poHyperMetroReplicaInfo.getPairInfos().isEmpty()) {
            for (PoReplicaPairInfo pairHyperMetroInfo : poHyperMetroReplicaInfo.getPairInfos()) {
                if (!pairInfo.getVolumeUuid().equals(pairHyperMetroInfo.getVolumeUuid()) && (!Objects.equals(pairHyperMetroInfo.getVolumeUuid(), pairInfo.getDrVolumeUuid()) || !OpenStackBasicUtil.isCsdrVhaMode(pg))) continue;
                volumeTemp.setReplicationExtendInfoHyperMetro((Object)OpenStackBasicUtil.buildVolumeExtendInfo(pairHyperMetroInfo, pg, volNameMap));
                break;
            }
        }
    }

    public static JSONObject buildVolumeExtendInfo(PoReplicaPairInfo pairInfo, ProtectGroup pg, Map<String, String> volNameMap) {
        JSONObject slaveVolumeObject = new JSONObject();
        String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid());
        slaveVolumeObject.put((Object)"id", (Object)volId);
        slaveVolumeObject.put((Object)"name", (Object)volNameMap.get(volId));
        slaveVolumeObject.put((Object)"vol_type", (Object)pairInfo.getDrVolumeType());
        JSONObject extendInfo = new JSONObject();
        extendInfo.put((Object)"remote_volume", (Object)slaveVolumeObject);
        extendInfo.put((Object)"cg_id", (Object)OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("replicaCgUuid")));
        extendInfo.put((Object)"cg_replication_status", pg.getProps().get("replicaCgRepStatus"));
        extendInfo.put((Object)"replication_id", (Object)OpenStackCommonUtil.getIdFromUuid(pairInfo.getReplicaUuid()));
        return extendInfo;
    }

    public static String getStandbyReplication(ProtectGroup protectGroup, String projUuid, String regionUuid, String tokenId) {
        String deleteSide = "standbyside";
        DrExtendManager drMgr = new DrExtendManager();
        for (ProtectObject po : protectGroup.getPolist()) {
            PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                LOG.error((Object)("get replicationInfo failed, po=" + po.getName()));
                continue;
            }
            boolean breakPo = false;
            for (PoReplicaPairInfo tempPoReplicaPairInfo : poReplicaInfo.getPairInfos()) {
                if (VerifyUtil.isEmpty((String)tempPoReplicaPairInfo.getReplicaUuid())) continue;
                String newReplicationId = OpenStackCommonUtil.getIdFromUuid(tempPoReplicaPairInfo.getReplicaUuid());
                VolumeReplicationInfo repliaInfo = drMgr.queryVolumeReplication(regionUuid, tokenId, projUuid, newReplicationId);
                if (null != repliaInfo) {
                    deleteSide = !OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(repliaInfo.getReplicationStatus()) ? "activeside" : "standbyside";
                    breakPo = true;
                    break;
                }
                LOG.info((Object)"the replica is not exist:replicaId= %s", new Object[]{tempPoReplicaPairInfo.getReplicaUuid()});
            }
            if (!breakPo) continue;
            break;
        }
        return deleteSide;
    }

    public static List<Map<String, Object>> getReverseAZMap(List<OpenStackVolTypeMapping> csdrVolTypesList, OpenStackVolTypeMapping volTypeMapping, OpenStackAvailabilityZoneMapping mapping, OpenStackVolTypeMapping volCsdrTypeMapping, ServiceInstaceEnumDefine.ServiceInstanceTypeE instanceType) {
        ArrayList<Map<String, Object>> fitRingMaps = new ArrayList<Map<String, Object>>();
        for (OpenStackVolTypeMapping volOtherCsdrTypeMapping : csdrVolTypesList) {
            if (volTypeMapping.getSecondVolType() == null || !volTypeMapping.getSecondVolType().equals(volOtherCsdrTypeMapping.getSecondVolType()) || volCsdrTypeMapping.getPrimaryVolType() == null || volOtherCsdrTypeMapping.getPrimaryVolType() == null || !volCsdrTypeMapping.getPrimaryVolType().equals(volOtherCsdrTypeMapping.getPrimaryVolType())) continue;
            Map map = mapping.toMap();
            map.put("primary_region_name", map.get("primary_region"));
            map.put("second_region_name", map.get("second_region"));
            map.put("primary_az_name", map.get("primary_az"));
            map.put("second_az_name", map.get("second_az"));
            map.put("drHyperMetorType", volTypeMapping.getSecondVolType());
            map.put("sourceType", volTypeMapping.getPrimaryVolType());
            map.put("drType", volCsdrTypeMapping.getPrimaryVolType());
            map.put("priority", volCsdrTypeMapping.getPriority());
            if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.equals((Object)instanceType)) {
                OpenStackBasicUtil.putDrSecondInfo(volTypeMapping, map);
            }
            map.remove("primary_region");
            map.remove("second_region");
            map.remove("primary_az");
            map.remove("second_az");
            map.remove("type");
            fitRingMaps.add(map);
        }
        return fitRingMaps;
    }

    protected static void putDrSecondInfo(OpenStackVolTypeMapping volTypeMapping, Map<String, Object> map) {
        String[] secondAzIdArr = volTypeMapping.getSecondAzId().split("_@_");
        if (secondAzIdArr.length != 2) {
            LOG.error((Object)"Invalid OpenStackVolTypeMapping secondAzId:%s", new Object[]{volTypeMapping.getSecondAzId()});
            throw new LegoCheckedException(1073949726L);
        }
        map.put("dr_second_region_id", secondAzIdArr[0]);
        map.put("dr_second_az_id", secondAzIdArr[1]);
    }

    public static void sortVolumeTypeByPriority(List<InstanceVolTypeMapping> drVolTypeList) {
        Collections.sort(drVolTypeList, (countA, countB) -> countA.getPriority() - countB.getPriority());
    }

    public static boolean forceDelete() {
        String forceDelete = LegoConfig.getInstance().getKeyValue("forceDelete");
        return Boolean.toString(true).equals(forceDelete);
    }

    public static void deleteTagFromVm(PoReplicaInfo poReplicationInfo, DelTagParam delTagParam) {
        if (poReplicationInfo == null) {
            LOG.error((Object)"Param error,PoReplicaInfo is null.");
            return;
        }
        String regionUuid = poReplicationInfo.getRegionUuid();
        String projectUuid = poReplicationInfo.getProjUuid();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String drRegionUuid = poReplicationInfo.getDrRegionUuid();
        String drProjectUuid = poReplicationInfo.getDrProjUuid();
        String drTokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjectUuid);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.info((Object)"Some param is null, regionUuid:%s, projectUuid:%s, openstackUuid:%s, drRegionUuid:%s, drProjectUuid:%s", new Object[]{regionUuid, projectUuid, openstackUuid, drRegionUuid, drProjectUuid});
            return;
        }
        if (VerifyUtil.isEmpty((String)drRegionUuid) || VerifyUtil.isEmpty((String)drProjectUuid) || VerifyUtil.isEmpty((String)drTokenId)) {
            LOG.info((Object)"Some param is null, drRegionUuid:%s, drProjectUuid:%s", new Object[]{drRegionUuid, drProjectUuid});
            return;
        }
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        if (delTagParam.isDelPrdVm()) {
            OpenStackBasicUtil.deleteTagFromProductionVM(novaMgr, regionUuid, tokenId, projectUuid, poReplicationInfo);
        }
        if (delTagParam.isDelPhVm()) {
            OpenStackBasicUtil.deleteTagFromPhVM(novaMgr, drRegionUuid, drTokenId, drProjectUuid, poReplicationInfo);
        }
    }

    private static void deleteTagFromProductionVM(INovaManager novaMgr, String reginUuid, String tokenId, String projectUuid, PoReplicaInfo poReplicationInfo) {
        boolean forceDelete = OpenStackBasicUtil.forceDelete();
        OpenStackVM openStackVM = novaMgr.getVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), new int[0]);
        if (!forceDelete || openStackVM != null) {
            novaMgr.deleteTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_pd");
            novaMgr.deleteTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_dr");
            novaMgr.deleteTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_csha");
            novaMgr.deleteDrBackUpTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), openStackVM);
        } else {
            LOG.info((Object)"Do not delete Tag From production Vm,vmuuid=%s, because vm is not extis and forceDelete=%s", new Object[]{poReplicationInfo.getMoUuid(), forceDelete});
        }
    }

    private static void deleteTagFromPhVM(INovaManager novaMgr, String drRreginUuid, String drTokenId, String drProjectUuid, PoReplicaInfo poReplicationInfo) {
        PhVmInfo phVmInfo = poReplicationInfo.getPhVmInfo();
        if (null == phVmInfo || null == phVmInfo.getVmUuid()) {
            return;
        }
        OpenStackVM openStackVM = novaMgr.getVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), new int[0]);
        boolean forceDelete = OpenStackBasicUtil.forceDelete();
        if (!forceDelete || null != openStackVM) {
            novaMgr.deleteTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), "__type_dr");
            novaMgr.deleteTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), "__type_pd");
            novaMgr.deleteTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), "__type_csha");
            novaMgr.deleteDrBackUpTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), openStackVM);
        } else {
            LOG.info((Object)"Do not delete Tag From phVm,vmuuid=%s, because vm is not extis and forceDelete=%s", new Object[]{phVmInfo.getVmUuid(), forceDelete});
        }
    }

    public static String getRecoveryPlanName(RecoveryPlan recoveryPlan) {
        return recoveryPlan != null ? recoveryPlan.getName() : "";
    }

    public static boolean isSwitchNetWork(ProtectGroup pg) {
        if (!PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg)) {
            return false;
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionUuid);
        if (VerifyUtil.isEmpty((Collection)regions)) {
            LOG.debug((Object)"openstack region is not exist. regionUuid is:%s", new Object[]{regions});
            return true;
        }
        return ((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getIsSwitchNetwork();
    }

    public static boolean checkVmNotConfigBridge(OpenStackVM checkVm) {
        String bridge = (String)checkVm.getMetadata().get("cascaded.instance_extrainfo");
        return VerifyUtil.isEmpty((String)bridge) || bridge.contains("pcibridge:0") || !bridge.contains("pcibridge");
    }

    public static String getRequestUrl(String regionUuid, String projectUuid, String typeCompute, String requestUrl) {
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, typeCompute);
        return urlStr + String.format(Locale.ROOT, requestUrl, projectUuid);
    }

    public static void setProtectObjectVmInfo(ProtectGroup pg, List<OpenStackVM> vms) {
        if (!FusionCloudUtil.isCurrentFCVersionHighThanParamVerion((String)"6.5.1")) {
            return;
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        ArrayList<String> uuids = new ArrayList<String>();
        if (pg.getPolist().size() < 101) {
            for (ProtectObject po : pg.getPolist()) {
                if (!"ECS".equals(po.getProps().get("vm_type"))) continue;
                uuids.add(OpenStackCommonUtil.getIdFromUuid(po.getMoUuid()));
            }
        }
        Map<String, String> serverIdToAddress = novaMgr.getVmsAddressMap(regionUuid, projectUuid, uuids);
        HashMap uuidToVmMaps = VerifyUtil.isEmpty(vms) ? new HashMap() : vms.stream().collect(Collectors.toMap(ManagedObject::getUuid, Function.identity()));
        for (ProtectObject po : pg.getPolist()) {
            if (!"ECS".equals(po.getProps().get("vm_type"))) continue;
            po.getProps().put("vm_addressMap", serverIdToAddress.get(po.getMoUuid()));
            List<VMInterface> vmInterfaces = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, po.getMoUuid());
            po.getProps().put("vm_interface", JsonUtil.listToJsonArray(vmInterfaces));
            OpenStackVM vm = (OpenStackVM)uuidToVmMaps.get(po.getMoUuid());
            if (vm == null) {
                vm = novaMgr.getVm(regionUuid, tokenId, projectUuid, po.getMoUuid(), new int[0]);
            }
            if (vm == null) continue;
            po.setProperty("VM_STATUS", (Object)OpenstackEnumDefine.VmStatusE.getStatusByValue((int)vm.getStatus()));
        }
    }

    public static String getSortStr(String[] sortStr) {
        Arrays.sort(sortStr);
        StringBuffer sortBuffer = new StringBuffer();
        int length = sortStr.length;
        for (int i = 0; i < length; ++i) {
            sortBuffer.append(sortStr[i]);
        }
        return sortBuffer.toString();
    }

    public static boolean checkUrlBaseParamsIsNull(UrlBaseParams urlBaseParams) {
        if (VerifyUtil.isEmpty((Object)urlBaseParams) || VerifyUtil.isEmpty((String)urlBaseParams.getProjectUuid()) || VerifyUtil.isEmpty((String)urlBaseParams.getRegionUuid()) || VerifyUtil.isEmpty((String)urlBaseParams.getTokenId())) {
            LOG.error((Object)"UrlBaseParams check false.");
            return true;
        }
        return false;
    }

    public static <T> T checkAndGetInfo(String url, String respStr, String checkKey, Class<T> type) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Received return error.response string is empty.request str=%s.", new Object[]{url});
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (jsonNode == null || !jsonNode.path("itemNotFound").isMissingNode()) {
            LOG.error((Object)"Received return error.jsNode is null.request str=%s,response str=%s.", new Object[]{url, SecurityUtil.desensitization((String)respStr)});
            return null;
        }
        if (jsonNode.path(checkKey).isMissingNode()) {
            LOG.error((Object)"Received return error.response string do not contain share keywords.request str=%s", new Object[]{url, SecurityUtil.desensitization((String)respStr)});
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonToBean(jsonNode.path(checkKey).toString(), type);
    }

    public static <T> List<T> checkAndGetListInfo(String url, String respStr, String checkKey, Class<T> type) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Received return error.response string is empty.request str=%s.", new Object[]{url});
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (jsonNode == null || !jsonNode.path("itemNotFound").isMissingNode()) {
            LOG.error((Object)"Received return error.jsNode is null.request str=%s,response str=%s.", new Object[]{url, SecurityUtil.desensitization((String)respStr)});
            throw new LegoCheckedException(0x300001L);
        }
        if (jsonNode.path(checkKey).isMissingNode()) {
            LOG.error((Object)"Received return error.response string do not contain share keywords.request str=%s", new Object[]{url, SecurityUtil.desensitization((String)respStr)});
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonArrayToList(jsonNode.path(checkKey).toString(), type);
    }
}

