/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.tools;

import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OpenStackCheckPhVmUtil {
    private static final Log LOG = LogFactory.getInstance(OpenStackCheckPhVmUtil.class);
    private static final Set<String> RUNNING_PHVMS = Collections.synchronizedSet(new HashSet());

    public static void checkPhVmsAndRun(Set<ProtectObject> poSet, Runnable run) {
        Set<String> phVmSet = OpenStackCheckPhVmUtil.checkRunningPhVms(poSet);
        try {
            run.run();
        }
        finally {
            OpenStackCheckPhVmUtil.releasePhVms(phVmSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCurrentPhVmsToSet(Set<String> usedVms) {
        if (usedVms == null) {
            return;
        }
        Set<String> set = RUNNING_PHVMS;
        synchronized (set) {
            usedVms.addAll(RUNNING_PHVMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> checkRunningPhVms(Set<ProtectObject> poSet) {
        if (VerifyUtil.isEmpty(poSet)) {
            return Collections.emptySet();
        }
        HashSet<String> phVmSet = new HashSet<String>();
        for (ProtectObject po : poSet) {
            String phVmId = OpenStackCommonUtil.getIdFromUuid(po.getProperty("occupied_vm"));
            String cshaPhVmId = OpenStackCommonUtil.getIdFromUuid(po.getProperty("prod_region_drZoneName"));
            if (!VerifyUtil.isEmpty((String)phVmId)) {
                phVmSet.add(phVmId);
            }
            if (VerifyUtil.isEmpty((String)cshaPhVmId)) continue;
            phVmSet.add(cshaPhVmId);
        }
        if (VerifyUtil.isEmpty(phVmSet)) {
            LOG.debug((Object)"phVmSet is empty.");
            return phVmSet;
        }
        Set<String> set = RUNNING_PHVMS;
        synchronized (set) {
            for (String phVmId : phVmSet) {
                if (!RUNNING_PHVMS.contains(phVmId)) continue;
                LOG.error((Object)"the vm(%s) is not avalible because allready used by other pg. RUNNING_PHVMS:%s", new Object[]{phVmId, RUNNING_PHVMS});
                throw new LegoCheckedException(1073948130L);
            }
            RUNNING_PHVMS.addAll(phVmSet);
        }
        return phVmSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releasePhVms(Set<String> phVmSet) {
        if (VerifyUtil.isEmpty(phVmSet)) {
            return;
        }
        Set<String> set = RUNNING_PHVMS;
        synchronized (set) {
            RUNNING_PHVMS.removeAll(phVmSet);
        }
    }
}

