/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.tools;

import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenStackCheckPhVolumeUtil {
    private static final Log LOG = LogFactory.getInstance(OpenStackCheckPhVolumeUtil.class);
    private static final Set<String> RUNNING_PH_VOLUMES = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPhVolumesAndRun(String regionId, String drRegionId, Set<ProtectObject> pos, Runnable run) {
        Set<String> phVolumeSet = OpenStackCheckPhVolumeUtil.checkRunningPhVolumes(regionId, drRegionId, pos);
        try {
            run.run();
        }
        finally {
            OpenStackCheckPhVolumeUtil.releasePhVolumes(phVolumeSet);
        }
    }

    private static Set<String> checkRunningPhVolumes(String regionId, String drRegionId, Set<ProtectObject> pos) {
        if (VerifyUtil.isMultiEmpty((Object[])new Object[]{regionId, drRegionId}) || VerifyUtil.isEmpty(pos)) {
            return Collections.emptySet();
        }
        HashSet<String> phVolumeSet = new HashSet<String>();
        for (ProtectObject po : pos) {
            if (!VerifyUtil.isEmpty((String)po.getMoUuid())) {
                phVolumeSet.add(CommUtil.combineString((String[])new String[]{regionId, OpenStackCommonUtil.getIdFromUuid(po.getMoUuid())}));
            }
            if (VerifyUtil.isEmpty((String)po.getProperty("drVolumeId"))) continue;
            phVolumeSet.add(CommUtil.combineString((String[])new String[]{drRegionId, OpenStackCommonUtil.getIdFromUuid(po.getProperty("drVolumeId"))}));
        }
        return OpenStackCheckPhVolumeUtil.comparePhVolumeSet(phVolumeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> comparePhVolumeSet(Set<String> phVolumeSet) {
        if (VerifyUtil.isEmpty(phVolumeSet)) {
            LOG.debug((Object)"The phVolumeSet is empty.");
            return phVolumeSet;
        }
        Set<String> set = RUNNING_PH_VOLUMES;
        synchronized (set) {
            for (String phVolumeId : phVolumeSet) {
                if (!RUNNING_PH_VOLUMES.contains(phVolumeId)) continue;
                LOG.error((Object)"The volume(%s) is not available because already used by other pg. RUNNING_PH_VOLUMES:%s", new Object[]{phVolumeId, RUNNING_PH_VOLUMES});
                throw new LegoCheckedException(1073947493L);
            }
            RUNNING_PH_VOLUMES.addAll(phVolumeSet);
        }
        return phVolumeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releasePhVolumes(Set<String> phVolumeSet) {
        if (VerifyUtil.isEmpty(phVolumeSet)) {
            return;
        }
        Set<String> set = RUNNING_PH_VOLUMES;
        synchronized (set) {
            RUNNING_PH_VOLUMES.removeAll(phVolumeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkVolumeInPhVmAndRun(Map<String, String> props, Set<ProtectObject> pos, Runnable run) {
        Set<String> phVolumeSet = OpenStackCheckPhVolumeUtil.checkVolumeInPhVm(props, pos);
        try {
            run.run();
        }
        finally {
            OpenStackCheckPhVolumeUtil.releasePhVolumes(phVolumeSet);
        }
    }

    private static Set<String> checkVolumeInPhVm(Map<String, String> props, Set<ProtectObject> pos) {
        if (VerifyUtil.isEmpty(props) || VerifyUtil.isEmpty(pos)) {
            return Collections.emptySet();
        }
        String regionId = props.get("regionId");
        String drRegionId = props.get("drRegionId");
        String drProjId = props.get("drProjectId");
        HashSet<String> phVolumeSet = new HashSet<String>();
        for (ProtectObject po : pos) {
            Set<String> drVolumeIds;
            Set<String> volumeIds = OpenStackCheckPhVolumeUtil.getVolumeIdInPhVm(regionId, po);
            if (!VerifyUtil.isEmpty(volumeIds)) {
                phVolumeSet.addAll(volumeIds);
            }
            if (VerifyUtil.isEmpty(drVolumeIds = OpenStackCheckPhVolumeUtil.getVolumeIdInDrPhVm(drRegionId, drProjId, po))) continue;
            phVolumeSet.addAll(drVolumeIds);
        }
        return OpenStackCheckPhVolumeUtil.comparePhVolumeSet(phVolumeSet);
    }

    private static Set<String> getVolumeIdInPhVm(String regionId, ProtectObject po) {
        List vmConfigs = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)po.getProperty("volumeConfig")), JSONObject.class);
        if (VerifyUtil.isEmpty((Collection)vmConfigs) || VerifyUtil.isEmpty((String)regionId)) {
            return Collections.emptySet();
        }
        return vmConfigs.stream().map(json -> json.getString("volumeId")).filter(Objects::nonNull).map(volumeId -> CommUtil.combineString((String[])new String[]{regionId, OpenStackCommonUtil.getIdFromUuid(volumeId)})).collect(Collectors.toSet());
    }

    private static Set<String> getVolumeIdInDrPhVm(String drRegionUuid, String drProjUuid, ProtectObject po) {
        String openstackUuid = OpenStackCommonUtil.getOpenstack().getUuid();
        INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String phVmId = OpenStackCommonUtil.getIdFromUuid(po.getProperty("occupied_vm"));
        if (VerifyUtil.isMultiEmpty((Object[])new Object[]{drRegionUuid, drProjUuid, phVmId})) {
            return Collections.emptySet();
        }
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        OpenStackVM vm = novaManager.getVm(drRegionUuid, tokenId, drProjUuid, phVmId, new int[0]);
        if (vm == null || VerifyUtil.isEmpty((String)vm.getVolumeAttached())) {
            return Collections.emptySet();
        }
        return OpenStackCommonUtil.getListFromStr(vm.getVolumeAttached(), ",").stream().map(volumeId -> CommUtil.combineString((String[])new String[]{drRegionUuid, OpenStackCommonUtil.getIdFromUuid(volumeId)})).collect(Collectors.toSet());
    }
}

