/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.tools;

import com.google.common.collect.ImmutableMap;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaVolumeStatisticBo;
import com.huawei.ism.drm.openstack.sdk.bo.ResourceLocation;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;

public class QuotaBuildUtil {
    private static final Log LOG = LogFactory.getInstance(QuotaBuildUtil.class);
    private static Map<ServiceInstaceEnumDefine.ServiceInstanceTypeE, String> volSizeTypeMap = ImmutableMap.builder().put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION, (Object)"csdr.vol.size").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO, (Object)"csha.vol.size").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA, (Object)"vha.vol.size").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION, (Object)"csdr.vol.size").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION, (Object)"csdr.vol.size").build();
    private static Map<ServiceInstaceEnumDefine.ServiceInstanceTypeE, String> volNumTypeMap = ImmutableMap.builder().put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION, (Object)"csdr.vol.num").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO, (Object)"csha.vol.num").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA, (Object)"vha.vol.num").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION, (Object)"csdr.vol.num").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION, (Object)"csdr.vol.num").build();
    private static Map<ServiceInstaceEnumDefine.ServiceInstanceTypeE, String> instNumTypeMap = ImmutableMap.builder().put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION, (Object)"csdr.instance.num").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO, (Object)"csha.instance.num").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA, (Object)"vha.instance.num").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION, (Object)"csdr.instance.num").put((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION, (Object)"csdr.instance.num").build();
    private static Map<ServiceInstaceEnumDefine.ServiceInstanceTypeE, String> vhaVolSizeTypeMap = ImmutableMap.of((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION, (Object)"vha.vol.size", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION, (Object)"csha.vol.size");
    private static Map<ServiceInstaceEnumDefine.ServiceInstanceTypeE, String> vhaVolNumTypeMap = ImmutableMap.of((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION, (Object)"vha.vol.num", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION, (Object)"csha.vol.num");
    private static Map<ServiceInstaceEnumDefine.ServiceInstanceTypeE, String> vhaInstNumTypeMap = ImmutableMap.of((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION, (Object)"vha.instance.num", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION, (Object)"csha.instance.num");

    public static void updateQuotaVolumeStatisticBoMap(Map<String, QuotaVolumeStatisticBo> quotaVolumeStatisticBoMap, Map<String, OpenStackVolume> volMap, String volumeId, String drVolumeType, String drHyperVolumeType) {
        if (VerifyUtil.isEmpty(volMap)) {
            LOG.error((Object)"The volume info map is empty!.");
            throw new LegoCheckedException(1073947393L);
        }
        OpenStackVolume volume = volMap.get(volumeId);
        if (volume == null) {
            LOG.error((Object)"CalculateQuota failed, vol is miss, volumeId: %s.", new Object[]{volumeId});
            throw new LegoCheckedException(1073947393L);
        }
        String volumeType = volume.getVolType();
        QuotaVolumeStatisticBo statisticBo = quotaVolumeStatisticBoMap.getOrDefault(volumeType, new QuotaVolumeStatisticBo(volumeType, drVolumeType, OpenStackCommonUtil.getIdFromUuid(volume.getRegionUuid()), volume.getAz(), drHyperVolumeType));
        statisticBo.setVolumesNumber(statisticBo.getVolumesNumber() + 1.0f);
        statisticBo.setVolumesSize(statisticBo.getVolumesSize() + (float)Optional.ofNullable(volume.getSize()).orElse(0).intValue());
        quotaVolumeStatisticBoMap.put(volumeType, statisticBo);
    }

    public static List<QuotaResourcesBo> convertStatisticBoMapToQuotaList(Map<String, QuotaVolumeStatisticBo> quotaVolumeStatisticBoMap, String type, boolean isCreateIns) {
        if (VerifyUtil.isEmpty(quotaVolumeStatisticBoMap)) {
            return Lists.newArrayList();
        }
        return quotaVolumeStatisticBoMap.values().stream().map(quotaVolumeStatisticBo -> QuotaBuildUtil.createQuotaInfo(type, quotaVolumeStatisticBo, isCreateIns)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<QuotaResourcesBo> createQuotaInfo(String type, QuotaVolumeStatisticBo quotaVolumeStatisticBo, boolean isCreateIns) {
        ArrayList<QuotaResourcesBo> result = new ArrayList<QuotaResourcesBo>();
        ServiceInstaceEnumDefine.ServiceInstanceTypeE instanceTypeE = ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)type);
        if (instanceTypeE != null) {
            result.addAll(QuotaBuildUtil.buildQuotasByInstanceType(instanceTypeE, quotaVolumeStatisticBo, isCreateIns));
            if (instanceTypeE == ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION || instanceTypeE == ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION) {
                result.addAll(QuotaBuildUtil.buildVhaQuotasByInstanceType(instanceTypeE, quotaVolumeStatisticBo, isCreateIns));
            }
        } else {
            LOG.error((Object)"Instance type is error, type: %s.", new Object[]{type});
            throw new LegoCheckedException(1073947393L);
        }
        return result.stream().peek(bo -> bo.setStatisticBo(quotaVolumeStatisticBo)).collect(Collectors.toList());
    }

    private static List<QuotaResourcesBo> buildQuotasByInstanceType(ServiceInstaceEnumDefine.ServiceInstanceTypeE instanceTypeE, QuotaVolumeStatisticBo statisticBo, boolean isCreateIns) {
        QuotaResourcesBo volSize = new QuotaResourcesBo();
        volSize.setQuota(statisticBo.getVolumesSize());
        volSize.setType(volSizeTypeMap.get(instanceTypeE));
        QuotaResourcesBo volNum = new QuotaResourcesBo();
        volNum.setQuota(statisticBo.getVolumesNumber());
        volNum.setType(volNumTypeMap.get(instanceTypeE));
        QuotaResourcesBo instNum = new QuotaResourcesBo();
        instNum.setType(instNumTypeMap.get(instanceTypeE));
        instNum.setQuota(isCreateIns ? 1.0f : 0.0f);
        return Arrays.asList(volSize, volNum, instNum);
    }

    private static List<QuotaResourcesBo> buildVhaQuotasByInstanceType(ServiceInstaceEnumDefine.ServiceInstanceTypeE instanceTypeE, QuotaVolumeStatisticBo statisticBo, boolean isCreateIns) {
        QuotaResourcesBo volVhaSize = new QuotaResourcesBo();
        volVhaSize.setQuota(statisticBo.getVolumesSize());
        Optional.ofNullable(vhaVolSizeTypeMap.get(instanceTypeE)).ifPresent(arg_0 -> ((QuotaResourcesBo)volVhaSize).setType(arg_0));
        QuotaResourcesBo volVhaNum = new QuotaResourcesBo();
        volVhaNum.setQuota(statisticBo.getVolumesNumber());
        Optional.ofNullable(vhaVolNumTypeMap.get(instanceTypeE)).ifPresent(arg_0 -> ((QuotaResourcesBo)volVhaNum).setType(arg_0));
        QuotaResourcesBo instVhaNum = new QuotaResourcesBo();
        Optional.ofNullable(vhaInstNumTypeMap.get(instanceTypeE)).ifPresent(arg_0 -> ((QuotaResourcesBo)instVhaNum).setType(arg_0));
        instVhaNum.setQuota(isCreateIns ? 1.0f : 0.0f);
        return Arrays.asList(volVhaSize, volVhaNum, instVhaNum);
    }

    public static List<QuotaResourcesBo> countDelSourceQuota(Set<ProtectObject> protectObjectSet, Map<String, OpenStackVolume> volMap, String type, boolean isCreateIns) {
        Map<String, PoReplicaPairInfo> volIdMap = OpenStackCommonUtil.getVolIdsOfProtectObjects(protectObjectSet, true);
        Set<PoReplicaPairInfo> hyperPairInfos = QuotaBuildUtil.getPoReplicaPairInfos(protectObjectSet);
        Map<String, QuotaVolumeStatisticBo> quotaVolumeStatisticBoMap = QuotaBuildUtil.getQuotaVolumeStatisticBoMap(volMap, volIdMap, hyperPairInfos);
        return QuotaBuildUtil.convertStatisticBoMapToQuotaList(quotaVolumeStatisticBoMap, type, isCreateIns);
    }

    public static Set<PoReplicaPairInfo> getPoReplicaPairInfos(Set<ProtectObject> protectObjectSet) {
        HashSet<PoReplicaPairInfo> hyperPairInfos = new HashSet<PoReplicaPairInfo>();
        for (ProtectObject po : protectObjectSet) {
            String replicationInfo = (String)po.getProps().get("hypermetor_replicationInfo");
            if (VerifyUtil.isEmpty((String)replicationInfo)) continue;
            hyperPairInfos.addAll(JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class).getPairInfos());
        }
        return hyperPairInfos;
    }

    public static Map<String, QuotaVolumeStatisticBo> getQuotaVolumeStatisticBoMap(Map<String, OpenStackVolume> volMap, Map<String, PoReplicaPairInfo> volIdMap, Set<PoReplicaPairInfo> hyperPairInfos) {
        HashMap<String, QuotaVolumeStatisticBo> quotaVolumeStatisticBoMap = new HashMap<String, QuotaVolumeStatisticBo>();
        for (String volId : volIdMap.keySet()) {
            PoReplicaPairInfo replicaPairInfo = Optional.ofNullable(volIdMap.get(volId)).orElse(new PoReplicaPairInfo());
            String drHyperVolumeType = QuotaBuildUtil.getHyperVolumeType(hyperPairInfos, replicaPairInfo);
            QuotaBuildUtil.updateQuotaVolumeStatisticBoMap(quotaVolumeStatisticBoMap, volMap, volId, replicaPairInfo.getDrVolumeType(), drHyperVolumeType);
        }
        return quotaVolumeStatisticBoMap;
    }

    private static String getHyperVolumeType(Set<PoReplicaPairInfo> hyperPairInfos, PoReplicaPairInfo replicaPairInfo) {
        return hyperPairInfos.stream().filter(hyperPairInfo -> QuotaBuildUtil.isVolHasHyperPair(replicaPairInfo, hyperPairInfo)).findAny().map(PoReplicaPairInfo::getDrVolumeType).orElse("");
    }

    private static boolean isVolHasHyperPair(PoReplicaPairInfo replicaPairInfo, PoReplicaPairInfo hyperPairInfo) {
        boolean isVolHasHyperPair = Objects.equals(replicaPairInfo.getVolumeUuid(), hyperPairInfo.getVolumeUuid());
        isVolHasHyperPair = isVolHasHyperPair || Objects.equals(replicaPairInfo.getVolumeUuid(), hyperPairInfo.getDrVolumeUuid());
        isVolHasHyperPair = isVolHasHyperPair || Objects.equals(replicaPairInfo.getDrVolumeUuid(), hyperPairInfo.getVolumeUuid());
        return isVolHasHyperPair;
    }

    public static JSONArray constructEvsQuota(ResourceLocation drResource, List<QuotaResourcesBo> quotaList, boolean isAddOrMinus) {
        float size = 0.0f;
        float num = 0.0f;
        HashMap<String, Float> volTypeStaticMap = new HashMap<String, Float>();
        for (QuotaResourcesBo bo : quotaList) {
            String drVolumeType = bo.getStatisticBo().getDrVolumeType();
            if (bo.getType().endsWith("vol.size")) {
                Float sizeChange = Float.valueOf(isAddOrMinus ? bo.getQuota() : -bo.getQuota());
                size += sizeChange.floatValue();
                volTypeStaticMap.compute(drVolumeType, (volType, volSize) -> Float.valueOf(volSize == null ? sizeChange.floatValue() : volSize.floatValue() + sizeChange.floatValue()));
            }
            if (!bo.getType().endsWith("vol.num")) continue;
            num += isAddOrMinus ? bo.getQuota() : -bo.getQuota();
        }
        JSONArray quotaResourceList = new JSONArray();
        quotaResourceList.add((Object)QuotaBuildUtil.buildQuotaResource("gigabytes", size));
        quotaResourceList.add((Object)QuotaBuildUtil.buildQuotaResource("volumes", num));
        volTypeStaticMap.forEach((volType, volSize) -> quotaResourceList.add((Object)QuotaBuildUtil.buildQuotaResource(volType, volSize.floatValue())));
        String evsId = LegoConfig.getInstance().getKeyValue("evs_service_id", "evs");
        JSONArray usagesList = QuotaBuildUtil.buildUsagesList(quotaResourceList, evsId, drResource.getAz());
        JSONArray evsQuotaArray = new JSONArray();
        evsQuotaArray.add((Object)QuotaBuildUtil.buildQuotaJson(drResource, usagesList));
        return evsQuotaArray;
    }

    public static JSONObject buildQuotaJson(ResourceLocation resource, JSONArray usageList) {
        JSONObject quota = new JSONObject();
        quota.put((Object)"project_id", (Object)OpenStackCommonUtil.getIdFromUuid(resource.getProjectUuid()));
        quota.put((Object)"region_id", (Object)OpenStackCommonUtil.getIdFromUuid(resource.getRegionUuid()));
        quota.put((Object)"usages", (Object)usageList);
        return quota;
    }

    public static JSONArray buildUsagesList(JSONArray quotaResourceList, String serviceId, String az) {
        JSONObject usage = new JSONObject();
        usage.put((Object)"resources", (Object)quotaResourceList);
        usage.put((Object)"service_id", (Object)serviceId);
        if (!VerifyUtil.isEmpty((String)az)) {
            usage.put((Object)"available_zone", (Object)az);
        }
        JSONArray usagesList = new JSONArray();
        usagesList.add((Object)usage);
        return usagesList;
    }

    private static JSONObject buildQuotaResource(String resource, float used) {
        JSONObject quotaResource = new JSONObject();
        quotaResource.put((Object)"resource", (Object)resource);
        quotaResource.put((Object)"used", (Object)Float.valueOf(used));
        return quotaResource;
    }
}

