CREATE TABLE T_operations (  opt_id bigserial NOT NULL,  opt_name CHARACTER VARYING(255) NOT NULL,  opt_url CHARACTER VARYING(255) DEFAULT NULL,  opt_description CHARACTER VARYING(255) default NULL,  ismaster boolean NOT NULL,  serial_number CHARACTER VARYING(255) NOT NULL,  PRIMARY KEY  (opt_id));
CREATE TABLE T_portalconfig (  id bigserial NOT NULL,  category CHARACTER VARYING(255) NOT NULL,  title CHARACTER VARYING(255) NOT NULL,  url CHARACTER VARYING(1024) NOT NULL, opt_id CHARACTER VARYING(2048) NOT NULL,  PRIMARY KEY  (id));
CREATE SEQUENCE T_ROLE_ROLE_ID_SEQ  INCREMENT 1  MINVALUE 1  MAXVALUE 9223372036854775807  START 100  CACHE 1;
CREATE TABLE T_ROLE(  ROLE_ID BIGINT NOT NULL DEFAULT NEXTVAL('T_ROLE_ROLE_ID_SEQ'::REGCLASS),  CREATORID BIGINT NOT NULL,  CREATTIME CHARACTER VARYING(255) COLLATE PG_CATALOG."default" NOT NULL,  ROLE_NAME CHARACTER VARYING(255) COLLATE PG_CATALOG."default" NOT NULL,  ROLE_DESCRIPTION CHARACTER VARYING(255) COLLATE PG_CATALOG."default" DEFAULT NULL::CHARACTER VARYING,  ISDEFAULT BOOLEAN NOT NULL)WITH (  OIDS=FALSE);
CREATE UNIQUE INDEX T_ROLE_PKEY ON T_ROLE USING BTREE(ROLE_ID);
CREATE TABLE T_topo_img_define (  img_name CHARACTER VARYING(255) NOT NULL,  img_type CHARACTER VARYING(255) default NULL,  img_path CHARACTER VARYING(255) default NULL,  PRIMARY KEY  (img_name));
CREATE TABLE T_operation_r_role ( role_id bigserial NOT NULL,  opt_id bigint NOT NULL,  PRIMARY KEY  (role_id,opt_id), FOREIGN KEY (role_id) REFERENCES T_role (role_id), FOREIGN KEY (opt_id) REFERENCES T_operations (opt_id)) ;
CREATE TABLE T_licenseconsume ( consumeid serial NOT NULL , feature CHARACTER VARYING(256) NOT NULL, res_item CHARACTER VARYING(256)  NOT NULL, total_consume CHARACTER VARYING(255)  NOT NULL, PRIMARY KEY  (consumeid) );
CREATE TABLE T_licenseconsumepolicy ( pid serial NOT NULL, res_main_type CHARACTER VARYING(256) NOT NULL, res_sub_type CHARACTER VARYING(255)  NOT NULL, unitnum int NOT NULL, unitconsume float NOT NULL, consumeid int default NULL, PRIMARY KEY  (pid),FOREIGN KEY (consumeid) REFERENCES T_licenseconsume (consumeid) );
CREATE TABLE T_main_device_type (name CHARACTER VARYING(255) NOT NULL,description CHARACTER VARYING(256)  DEFAULT NULL,PRIMARY KEY (name));
CREATE TABLE T_sub_device_type (name CHARACTER VARYING(255)  NOT NULL,description CHARACTER VARYING(256) DEFAULT NULL,PRIMARY KEY (name)) ;
CREATE TABLE T_device_type_relation (tid bigserial NOT NULL ,parent_type CHARACTER VARYING(255)  DEFAULT NULL,child_type CHARACTER VARYING(255)  DEFAULT NULL,page_url CHARACTER VARYING(255)  DEFAULT NULL,PRIMARY KEY (tid));
CREATE TABLE T_report_business (busId bigserial NOT NULL,busName CHARACTER VARYING(128) default NULL,PRIMARY KEY  (busId));
CREATE TABLE T_report_kpi (kpiId bigserial NOT NULL,kpiName CHARACTER VARYING(128) default NULL,busId bigint default NULL,PRIMARY KEY  (kpiId), FOREIGN KEY (busId) REFERENCES T_report_business (busId)) ;
CREATE TABLE T_report_resource ( resourceId bigserial NOT NULL,resourceName CHARACTER VARYING(128) default NULL,resourceTypeId bigint default NULL,PRIMARY KEY  (resourceId));
CREATE TABLE T_report_resourceType (resourceTypeId bigserial NOT NULL,resourceTypeName CHARACTER VARYING(128) default NULL,busId bigint default NULL, PRIMARY KEY  (resourceTypeId), FOREIGN KEY (busId) REFERENCES T_report_business (busId));
CREATE TABLE T_report_template (tId bigserial  NOT NULL ,tempReportName CHARACTER VARYING(128) default NULL,tempReportDesc CHARACTER VARYING(256) default NULL,busId bigint default NULL,defineType int  default NULL,cycleFlag int default NULL,ireportPluginId CHARACTER VARYING(256) default NULL,resourceType bigint default NULL,url CHARACTER VARYING(256) default NULL, PRIMARY KEY  (tId));
CREATE TABLE T_backConfFile (	filename CHARACTER VARYING(50)  NOT NULL,	context CLOB    NOT NULL);
CREATE TABLE T_managedobject ( moid bigserial NOT NULL ,  discriminator CHARACTER VARYING(255) NOT NULL,  uuid CHARACTER VARYING(255) NOT NULL,  name CHARACTER VARYING(1024) DEFAULT NULL,  is_group boolean DEFAULT NULL,  managed boolean DEFAULT NULL,  status int DEFAULT NULL,  type CHARACTER VARYING(1024)  DEFAULT NULL,  can_receive_event boolean DEFAULT NULL,  description CHARACTER VARYING(3072)  DEFAULT NULL, path CHARACTER VARYING(255)  DEFAULT NULL,  domain_product_id CHARACTER VARYING(255)  DEFAULT NULL,  domain_model_id CHARACTER VARYING(255)  DEFAULT NULL,  recent_update_time date DEFAULT NULL, subnms CHARACTER VARYING(255)  DEFAULT NULL,  top_mo_uuid CHARACTER VARYING(255)  DEFAULT NULL,  is_top_mo boolean DEFAULT NULL,  topo_element_id bigint DEFAULT NULL,  perf_type CHARACTER VARYING(255)  DEFAULT NULL,  timezone_format CHARACTER VARYING(255)  DEFAULT NULL,  parent_id bigint DEFAULT NULL,  PRIMARY KEY (moid),  UNIQUE (uuid), FOREIGN KEY (parent_id) REFERENCES T_managedobject (moid));
CREATE TABLE ti_volume (MOID bigserial NOT NULL,FREECAPACITY DOUBLE PRECISION DEFAULT NULL,ISMAPPED boolean DEFAULT NULL,DISKGROUPID CHARACTER VARYING(255)  DEFAULT NULL,DISKGROUPNAME CHARACTER VARYING(255)  DEFAULT NULL,ISSNAPSHOT boolean DEFAULT NULL,SNAPSHOTTYPE CHARACTER VARYING(255)  DEFAULT NULL, WWN CHARACTER VARYING(255)  DEFAULT NULL, PRIMARY KEY (MOID),FOREIGN KEY (MOID) REFERENCES T_managedobject (moid) ON DELETE CASCADE);
CREATE TABLE ti_policytemplate (  PTID CHARACTER VARYING(255)  NOT NULL,  UUID CHARACTER VARYING(64)  DEFAULT NULL,  NAME CHARACTER VARYING(256)  DEFAULT NULL,  DESCRIPTION CHARACTER VARYING(2048)  DEFAULT NULL,  TYPE integer DEFAULT NULL,  SKETCH CHARACTER VARYING(255)  DEFAULT NULL,  VIEWTEMPLATEURL CHARACTER VARYING(255)  DEFAULT NULL,  EDITTEMPLATEURL CHARACTER VARYING(255)  DEFAULT NULL,  ISSYSTEMDEFINE integer(11) DEFAULT '1',  REPLICATIONTYPE integer(11) DEFAULT '1',  PARENTID CHARACTER VARYING(64)  DEFAULT NULL,  PRIMARY KEY (PTID)) ;
CREATE TABLE ti_protectgroup ( PGID CHARACTER VARYING(255)  NOT NULL,  UUID CHARACTER VARYING(64)  DEFAULT NULL,  PGNAME CHARACTER VARYING(200)  NOT NULL,  PGDESC CHARACTER VARYING(2048)  DEFAULT NULL,  PRODUCTSITEID CHARACTER VARYING(64)  NOT NULL,  PRODUCTSITENAME CHARACTER VARYING(256)  NOT NULL,  PGPROVIDERSN CHARACTER VARYING(255)  DEFAULT NULL,  POTYPE integer(11) NOT NULL,  ISPRIMARY integer(1) DEFAULT '1',  PG_REPLICA_INDEX integer(11) NOT NULL,  LASTEXECTIME bigint DEFAULT NULL,  LAST_EXEC_RESULT integer(11) DEFAULT NULL,  STATUS integer(11) NOT NULL,  PTID CHARACTER VARYING(255)  DEFAULT NULL,  PRIMARY KEY (PGID),  FOREIGN KEY (PTID) REFERENCES ti_policytemplate (PTID)) ;
CREATE TABLE ti_protectgroup_prop (  PGID CHARACTER VARYING(255)  NOT NULL,  PROPVALUE CHARACTER VARYING(1048576)  DEFAULT NULL,  PROPNAME CHARACTER VARYING(255)  NOT NULL,  PRIMARY KEY (PGID,PROPNAME),  CONSTRAINT FK25B7A1E8B053D4B FOREIGN KEY (PGID) REFERENCES TI_PROTECTGROUP (PGID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE) ;
CREATE TABLE ti_protectgrouplog (  HISTORYLOGID bigserial NOT NULL,  INFO CHARACTER VARYING(255)  DEFAULT NULL,  STARTTIME CHARACTER VARYING(255)  DEFAULT NULL,  ENDTIME CHARACTER VARYING(255)  DEFAULT NULL, REPLICAID CHARACTER VARYING(255)  DEFAULT NULL,  RESULT bigint DEFAULT NULL,  FLAG integer(11) DEFAULT NULL,  PGID CHARACTER VARYING(255)  DEFAULT NULL,  PRIMARY KEY (HISTORYLOGID),  CONSTRAINT FK2CCB1A6AB053D4B FOREIGN KEY (PGID) REFERENCES TI_PROTECTGROUP (PGID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE);CREATE INDEX PROTECTGROUP_LOG_PGID_INDX ON ti_protectgrouplog USING BTREE (PGID);
CREATE TABLE ti_protectgrouplogdetail (  DETAILID CHARACTER VARYING(255)  NOT NULL,  TITLE CHARACTER VARYING(255)  DEFAULT NULL,  TITLEPARAMS CHARACTER VARYING(1024)  DEFAULT NULL,  INFO CHARACTER VARYING(255)  DEFAULT NULL,  INFOPARAMS CHARACTER VARYING(1024)  DEFAULT NULL,  STARTTIME CHARACTER VARYING(255)  DEFAULT NULL,  ENDTIME CHARACTER VARYING(255)  DEFAULT NULL,  RESULT bigint DEFAULT NULL,  RELATEDDETAILID CHARACTER VARYING(255)  DEFAULT NULL,  HISTORYLOGID integer(11) DEFAULT NULL,  POSITION integer(11) DEFAULT NULL,  PRIMARY KEY (DETAILID),  CONSTRAINT FK224E3B3B28087FD6 FOREIGN KEY (HISTORYLOGID) REFERENCES TI_PROTECTGROUPLOG (HISTORYLOGID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE,  CONSTRAINT FK224E3B3B28957F13 FOREIGN KEY (RELATEDDETAILID) REFERENCES TI_PROTECTGROUPLOGDETAIL (DETAILID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE) ;
CREATE TABLE ti_protectgroupreplica (  ID CHARACTER VARYING(255)  NOT NULL,  NAME CHARACTER VARYING(255)  NOT NULL,  TIME_STAMP CHARACTER VARYING(255)  DEFAULT NULL,  REPLICATYPE integer(11) NOT NULL,  REPLICASTATUS integer(11) NOT NULL,  REPLICAINDEX integer(11) NOT NULL,  RECSITEID CHARACTER VARYING(255)  NOT NULL,  PROARRAYID CHARACTER VARYING(255)  NOT NULL,  RECARRAYID CHARACTER VARYING(255)  NOT NULL,  PROTECTLOCATION integer(11) DEFAULT NULL,  PGID CHARACTER VARYING(255)  NOT NULL,  PRIMARY KEY (ID),  CONSTRAINT FK708A44DEB053D4B FOREIGN KEY (PGID) REFERENCES TI_PROTECTGROUP (PGID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE) ;
CREATE TABLE ti_protectgroupreplica_prop (  ID CHARACTER VARYING(255)  NOT NULL,  PROPVALUE CHARACTER VARYING(1048576)  DEFAULT NULL,  PROPNAME CHARACTER VARYING(255)  NOT NULL,  PRIMARY KEY (ID,PROPNAME),  CONSTRAINT FKDF837224BC69C53 FOREIGN KEY (ID) REFERENCES TI_PROTECTGROUPREPLICA (ID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE) ;
CREATE TABLE ti_protectobject (  POID CHARACTER VARYING(255)  NOT NULL,  UUID CHARACTER VARYING(64)  DEFAULT NULL,  MOUUID CHARACTER VARYING(255)  DEFAULT NULL,  PONAME CHARACTER VARYING(1024)  NOT NULL,  POTYPE integer(11) NOT NULL,  POSTATUS integer(11) DEFAULT NULL,  PORECOVERYSTATUS integer(11) DEFAULT '-1',  PROVIDERSN CHARACTER VARYING(255)  DEFAULT NULL,  PGID CHARACTER VARYING(255)  NOT NULL,  PRIMARY KEY (POID),  CONSTRAINT FK4FABD284B053D4B FOREIGN KEY (PGID) REFERENCES TI_PROTECTGROUP (PGID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE) ;
CREATE TABLE ti_protectobjectreplica (  ID CHARACTER VARYING(255)  NOT NULL,  POID CHARACTER VARYING(255)  NOT NULL,  PLACEHOLDER_PO_ID CHARACTER VARYING(255)  DEFAULT NULL,  PGREPLICAID CHARACTER VARYING(255)  NOT NULL,  PRIMARY KEY (ID),  CONSTRAINT FK521BE1B45EACD6F4 FOREIGN KEY (PGREPLICAID) REFERENCES TI_PROTECTGROUPREPLICA (ID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE) ;
CREATE TABLE ti_hoststorageresource (  ID CHARACTER VARYING(255)  NOT NULL,  RESID CHARACTER VARYING(255)  NOT NULL,  REPROVIDERSN CHARACTER VARYING(255)  NOT NULL,  MOUNTPOINT CHARACTER VARYING(1024)  DEFAULT NULL,  DISKUUID CHARACTER VARYING(255)  DEFAULT NULL,  APPNAME CHARACTER VARYING(255)  DEFAULT NULL,  APPINSTENCENAME CHARACTER VARYING(255)  DEFAULT NULL,  HOSTNAME CHARACTER VARYING(255)  DEFAULT NULL,  HOSTSN CHARACTER VARYING(255)  DEFAULT NULL,  LBA CHARACTER VARYING(255)  DEFAULT NULL,  DEVNAME CHARACTER VARYING(255)  DEFAULT NULL,  RESTYPE integer(11) NOT NULL,  STORAGETYPE integer(11) DEFAULT '-1',  ASMDISKGROUPNAME CHARACTER VARYING(255)  DEFAULT NULL,  VOLUMEGROUPNAME CHARACTER VARYING(255)  DEFAULT NULL,  UDEVFLAG CHARACTER VARYING(1024)  DEFAULT NULL,  ARCHIVELOG integer(11) DEFAULT '0',  LUNWWN CHARACTER VARYING(512)  DEFAULT NULL,  POID CHARACTER VARYING(255)  NOT NULL,  PRIMARY KEY (ID),  CONSTRAINT FKFC1F30175C3F1C5F FOREIGN KEY (POID) REFERENCES TI_PROTECTOBJECT (POID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE) ;
CREATE TABLE ti_relicastorageinfo (  REPILCASTOR_ID CHARACTER VARYING(255)  NOT NULL,  SRCPROVSN CHARACTER VARYING(1000)  NOT NULL,  SRCDEVID CHARACTER VARYING(1000)  NOT NULL,  PROVSN CHARACTER VARYING(1000)  NOT NULL,  DEVID CHARACTER VARYING(1000)  NOT NULL,  PO_STORAGE_WWN CHARACTER VARYING(512)  DEFAULT NULL,  POREPLICAID CHARACTER VARYING(255)  NOT NULL,  PRIMARY KEY (REPILCASTOR_ID),  CONSTRAINT FKC0C52E5172F8E70E FOREIGN KEY (POREPLICAID) REFERENCES TI_PROTECTOBJECTREPLICA (ID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE) ;
CREATE TABLE ti_po_prop (  POID CHARACTER VARYING(255)  NOT NULL,  PROPVALUE CHARACTER VARYING(40960)  DEFAULT NULL,  PROPNAME CHARACTER VARYING(255)  NOT NULL,  PRIMARY KEY (POID,PROPNAME),  CONSTRAINT FKF57BA5D95C3F1C5F FOREIGN KEY (POID) REFERENCES TI_PROTECTOBJECT (POID) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE);
CREATE SEQUENCE T_LICENSEINFO_PKID_SEQ  INCREMENT 1  MINVALUE 1  MAXVALUE 9223372036854775807  START 1  CACHE 1;
CREATE TABLE T_LICENSEINFO(PKID BIGINT NOT NULL DEFAULT NEXTVAL('T_LICENSEINFO_PKID_SEQ'::REGCLASS), PRODUCT_NAME CHARACTER VARYING(255) ,  PRODUCT_VERSION CHARACTER VARYING(255),  PRODUCT_ESN CHARACTER VARYING(1000),  FEATURE_ATTR CHARACTER VARYING(255),  IN_USE BOOLEAN,  UPLOAD_TIME BIGINT,  LIC_FILE BLOB, PRIMARY KEY  (PKID));
CREATE TABLE TI_RECOVERYPLAN(  PLANID CHARACTER VARYING(255) COLLATE PG_CATALOG."default" NOT NULL,  UUID CHARACTER VARYING(64) COLLATE PG_CATALOG."default",  PLANNAME CHARACTER VARYING(200) COLLATE PG_CATALOG."default",  PLANDESC CHARACTER VARYING(2048) COLLATE PG_CATALOG."default",  PLANSTATUS INTEGER,  PLANPROGRESS INTEGER,  LASTPROCESSORNAME CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  LASTEXECUTETYPE INTEGER,  PLANTYPE INTEGER,  LASTTESTSTATUS INTEGER,  ISSYNCHRONIZED BOOLEAN,  PROCESSSTATUS INTEGER DEFAULT 0, PRIMARY KEY (PLANID));
CREATE TABLE TI_RECOVERYLOG(  LOGID CHARACTER VARYING(255) COLLATE PG_CATALOG."default" NOT NULL,LOGSTATUS INTEGER, LOGTYPE INTEGER, LOGNAME CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  OPERATOR CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  STARTTIME CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  ENDTIME CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  ISSYNCHRONIZED BOOLEAN,  PRODUCTIONSITEID CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  RECOVERYSITEID CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  PLANID CHARACTER VARYING(255) COLLATE PG_CATALOG."default" NOT NULL,  PRIMARY KEY (LOGID), CONSTRAINT FK2C0BE4C54E2732DB FOREIGN KEY (PLANID)      REFERENCES TI_RECOVERYPLAN (PLANID) MATCH SIMPLE      ON UPDATE NO ACTION ON DELETE NO ACTION);
CREATE TABLE TI_RECOVERYPROCESSORDETAIL(  DETAILID CHARACTER VARYING(255) COLLATE PG_CATALOG."default" NOT NULL,  STARTTIME CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  ENDTIME CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  PROCESSNAME CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  PROCESSNAMEPARAMS CHARACTER VARYING(1048576) COLLATE PG_CATALOG."default",  PROCESSDETAIL CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  PROCESSDETAILPARAMS CHARACTER VARYING(8192) COLLATE PG_CATALOG."default",  PROCESSSTATUS INTEGER,  PROCID CHARACTER VARYING(255) COLLATE PG_CATALOG."default" NOT NULL,  LOGID CHARACTER VARYING(255) COLLATE PG_CATALOG."default" NOT NULL,  RELATEDDETAILID CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  PREVIOUSPROCID CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  NEXTPROCID CHARACTER VARYING(255) COLLATE PG_CATALOG."default",  ISSKIPPED BOOLEAN, PRIMARY KEY (DETAILID), CONSTRAINT FK8A853764445EEF35 FOREIGN KEY (LOGID)      REFERENCES TI_RECOVERYLOG (LOGID) MATCH SIMPLE      ON UPDATE NO ACTION ON DELETE CASCADE,  CONSTRAINT FK8A853764DE61C36C FOREIGN KEY (RELATEDDETAILID)      REFERENCES TI_RECOVERYPROCESSORDETAIL (DETAILID) MATCH SIMPLE      ON UPDATE NO ACTION ON DELETE CASCADE);
CREATE INDEX TI_RECOVERYPROCESSORDETAIL_INDEX_RELATEDDETAILID ON TI_RECOVERYPROCESSORDETAIL (RELATEDDETAILID);
CREATE INDEX TI_RECOVERYPROCESSORDETAIL_INDEX_LOGID ON TI_RECOVERYPROCESSORDETAIL(LOGID);
delete from T_operation_r_role where opt_id = 211;
delete from T_operation_r_role where opt_id = 212;
delete from T_operation_r_role where opt_id = 213;
delete from T_operation_r_role where opt_id = 214;
delete from T_operation_r_role where opt_id = 215;
delete from T_operation_r_role where opt_id = 216;
delete from T_operation_r_role where opt_id = 217;
delete from T_operation_r_role where opt_id = 218;
delete from T_operation_r_role where opt_id = 219;
delete from T_operations where opt_id = 211;
delete from T_operations where opt_id = 212;
delete from T_operations where opt_id = 213;
delete from T_operations where opt_id = 214;
delete from T_operations where opt_id = 215;
delete from T_operations where opt_id = 216;
delete from T_operations where opt_id = 217;
delete from T_operations where opt_id = 218;
delete from T_operations where opt_id = 219;
delete from T_role where role_id in (1,2,3); 
insert into T_role values(1,'11','20100203','administrator','admin role',1);
insert into T_role values(2,'11','20100203','operator','operator role',1);
insert into T_role values(3,'11','20100203','auditor','auditor role',1);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(211, 'lego.sys.callhome', '', '', 0, '8000-1100');
insert into T_operation_r_role (role_id, opt_id) values (1, 211);
insert into T_operation_r_role (role_id, opt_id) values (2, 211);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(212, 'lego.sys.callhomeInfo', '/nem/bureau/showCallhome.do', '', 0, '8000-1100-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 212);
insert into T_operation_r_role (role_id, opt_id) values (2, 212);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(218, 'lego.sys.cloudservice.scan', '', '', 1, '8000-1100-10-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 218);
insert into T_operation_r_role (role_id, opt_id) values (2, 218);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(213, 'lego.lab.cloudservice.baseinfo.modify', '', '', 0, '8000-1100-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 213);
insert into T_operation_r_role (role_id, opt_id) values (2, 213);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(214, 'lego.lab.cloudservice.notify.add', '', '', 0, '8000-1100-10-6');
insert into T_operation_r_role (role_id, opt_id) values (1, 214);
insert into T_operation_r_role (role_id, opt_id) values (2, 214);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(215, 'lego.lab.cloudservice.notify.del', '', '', 0, '8000-1100-10-7');
insert into T_operation_r_role (role_id, opt_id) values (1, 215);
insert into T_operation_r_role (role_id, opt_id) values (2, 215);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(216, 'lego.sys.bureau', '/nem/bureau/showBureau.do', '', 0, '8000-1100-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 216);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(219, 'lego.sys.bureau.scan', '', '', 1, '8000-1100-20-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 219);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(217, 'lego.sys.bureauEdit', '', '', 0, '8000-1100-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 217);
delete from T_operation_r_role where role_id = 1 and opt_id = 3;
delete from T_operation_r_role where role_id = 2 and opt_id = 3;
delete from T_operation_r_role where role_id = 1 and opt_id = 4;
delete from T_operation_r_role where role_id = 2 and opt_id = 4;
delete from T_operation_r_role where role_id = 1 and opt_id = 11;
delete from T_operation_r_role where role_id = 2 and opt_id = 11;
delete from T_operation_r_role where role_id = 1 and opt_id = 14;
delete from T_operation_r_role where role_id = 2 and opt_id = 14;
delete from T_operation_r_role where role_id = 1 and opt_id = 12;
delete from T_operation_r_role where role_id = 1 and opt_id = 13;
delete from T_operation_r_role where role_id = 2 and opt_id = 13;
delete from T_operation_r_role where role_id = 1 and opt_id = 15;
delete from T_operation_r_role where role_id = 2 and opt_id = 15;
delete from T_operation_r_role where role_id = 1 and opt_id = 16;
delete from T_operation_r_role where role_id = 2 and opt_id = 16;
delete from T_operation_r_role where role_id = 1 and opt_id = 20;
delete from T_operation_r_role where role_id = 2 and opt_id = 20;
delete from T_operation_r_role where role_id = 1 and opt_id = 17;
delete from T_operation_r_role where role_id = 2 and opt_id = 17;
delete from T_operation_r_role where role_id = 1 and opt_id = 18;
delete from T_operation_r_role where role_id = 2 and opt_id = 18;
delete from T_operation_r_role where role_id = 1 and opt_id = 19;
delete from T_operation_r_role where role_id = 2 and opt_id = 19;
delete from T_operation_r_role where role_id = 1 and opt_id = 21;
delete from T_operation_r_role where role_id = 2 and opt_id = 21;
delete from T_operation_r_role where role_id = 1 and opt_id = 25;
delete from T_operation_r_role where role_id = 2 and opt_id = 25;
delete from T_operation_r_role where role_id = 1 and opt_id = 22;
delete from T_operation_r_role where role_id = 2 and opt_id = 22;
delete from T_operation_r_role where role_id = 1 and opt_id = 23;
delete from T_operation_r_role where role_id = 2 and opt_id = 23;
delete from T_operation_r_role where role_id = 1 and opt_id = 24;
delete from T_operation_r_role where role_id = 2 and opt_id = 24;
delete from T_operation_r_role where role_id = 1 and opt_id = 33;
delete from T_operation_r_role where role_id = 2 and opt_id = 33;
delete from T_operation_r_role where role_id = 1 and opt_id = 34;
delete from T_operation_r_role where role_id = 2 and opt_id = 34;
delete from T_operation_r_role where role_id = 1 and opt_id = 35;
delete from T_operation_r_role where role_id = 2 and opt_id = 35;
delete from T_operation_r_role where role_id = 1 and opt_id = 36;
delete from T_operation_r_role where role_id = 2 and opt_id = 36;
delete from T_operation_r_role where role_id = 1 and opt_id = 37;
delete from T_operation_r_role where role_id = 2 and opt_id = 37;
delete from T_operation_r_role where role_id = 1 and opt_id = 40;
delete from T_operation_r_role where role_id = 2 and opt_id = 40;
delete from T_operation_r_role where role_id = 1 and opt_id = 38;
delete from T_operation_r_role where role_id = 2 and opt_id = 38;
delete from T_operation_r_role where role_id = 1 and opt_id = 71;
delete from T_operation_r_role where role_id = 2 and opt_id = 71;
delete from T_operation_r_role where role_id = 1 and opt_id = 72;
delete from T_operation_r_role where role_id = 2 and opt_id = 72;
delete from T_operation_r_role where role_id = 1 and opt_id = 205;
delete from T_operation_r_role where role_id = 2 and opt_id = 205;
delete from T_operation_r_role where role_id = 1 and opt_id = 206;
delete from T_operation_r_role where role_id = 2 and opt_id = 206;
delete from T_operation_r_role where role_id = 1 and opt_id = 207;
delete from T_operation_r_role where role_id = 2 and opt_id = 207;
delete from T_operation_r_role where role_id = 1 and opt_id = 208;
delete from T_operation_r_role where role_id = 2 and opt_id = 208;
delete from T_operation_r_role where role_id = 1 and opt_id = 211;
delete from T_operation_r_role where role_id = 2 and opt_id = 211;
delete from T_operation_r_role where role_id = 1 and opt_id = 213;
delete from T_operation_r_role where role_id = 2 and opt_id = 213;
delete from T_operation_r_role where role_id = 1 and opt_id = 214;
delete from T_operation_r_role where role_id = 2 and opt_id = 214;
delete from T_operation_r_role where role_id = 1 and opt_id = 73;
delete from T_operation_r_role where role_id = 2 and opt_id = 73;
delete from T_operation_r_role where role_id = 1 and opt_id = 74;
delete from T_operation_r_role where role_id = 2 and opt_id = 74;
delete from T_operation_r_role where role_id = 1 and opt_id = 75;
delete from T_operation_r_role where role_id = 2 and opt_id = 75;
delete from T_operation_r_role where role_id = 1 and opt_id = 76;
delete from T_operation_r_role where role_id = 2 and opt_id = 76;
delete from T_operation_r_role where role_id = 1 and opt_id = 77;
delete from T_operation_r_role where role_id = 2 and opt_id = 77;
delete from T_operation_r_role where role_id = 1 and opt_id = 78;
delete from T_operation_r_role where role_id = 2 and opt_id = 78;
delete from T_operation_r_role where role_id = 1 and opt_id = 91;
delete from T_operation_r_role where role_id = 2 and opt_id = 91;
delete from T_operation_r_role where role_id = 1 and opt_id = 80;
delete from T_operation_r_role where role_id = 2 and opt_id = 80;
delete from T_operation_r_role where role_id = 1 and opt_id = 82;
delete from T_operation_r_role where role_id = 2 and opt_id = 82;
delete from T_operation_r_role where role_id = 1 and opt_id = 83;
delete from T_operation_r_role where role_id = 2 and opt_id = 83;
delete from T_operation_r_role where role_id = 1 and opt_id = 92;
delete from T_operation_r_role where role_id = 2 and opt_id = 92;
delete from T_operation_r_role where role_id = 1 and opt_id = 84;
delete from T_operation_r_role where role_id = 2 and opt_id = 84;
delete from T_operation_r_role where role_id = 1 and opt_id = 86;
delete from T_operation_r_role where role_id = 2 and opt_id = 86;
delete from T_operation_r_role where role_id = 1 and opt_id = 87;
delete from T_operation_r_role where role_id = 2 and opt_id = 87;
delete from T_operation_r_role where role_id = 1 and opt_id = 88;
delete from T_operation_r_role where role_id = 2 and opt_id = 88;
delete from T_operation_r_role where role_id = 1 and opt_id = 94;
delete from T_operation_r_role where role_id = 2 and opt_id = 94;
delete from T_operation_r_role where role_id = 1 and opt_id = 95;
delete from T_operation_r_role where role_id = 2 and opt_id = 95;
delete from T_operation_r_role where role_id = 1 and opt_id = 96;
delete from T_operation_r_role where role_id = 2 and opt_id = 96;
delete from T_operation_r_role where role_id = 1 and opt_id = 97;
delete from T_operation_r_role where role_id = 2 and opt_id = 97;
delete from T_operation_r_role where role_id = 1 and opt_id = 99;
delete from T_operation_r_role where role_id = 2 and opt_id = 99;
delete from T_operation_r_role where role_id = 1 and opt_id = 98;
delete from T_operation_r_role where role_id = 2 and opt_id = 98;
delete from T_operation_r_role where role_id = 1 and opt_id = 100;
delete from T_operation_r_role where role_id = 2 and opt_id = 100;
delete from T_operation_r_role where role_id = 1 and opt_id = 101;
delete from T_operation_r_role where role_id = 2 and opt_id = 101;
delete from T_operation_r_role where role_id = 1 and opt_id = 102;
delete from T_operation_r_role where role_id = 2 and opt_id = 102;
delete from T_operation_r_role where role_id = 1 and opt_id = 103;
delete from T_operation_r_role where role_id = 2 and opt_id = 103;
delete from T_operation_r_role where role_id = 1 and opt_id = 104;
delete from T_operation_r_role where role_id = 2 and opt_id = 104;
delete from T_operation_r_role where role_id = 1 and opt_id = 105;
delete from T_operation_r_role where role_id = 2 and opt_id = 105;
delete from T_operation_r_role where role_id = 1 and opt_id = 106;
delete from T_operation_r_role where role_id = 2 and opt_id = 106;
delete from T_operation_r_role where role_id = 1 and opt_id = 107;
delete from T_operation_r_role where role_id = 2 and opt_id = 107;
delete from T_operation_r_role where role_id = 1 and opt_id = 110;
delete from T_operation_r_role where role_id = 2 and opt_id = 110;
delete from T_operation_r_role where role_id = 1 and opt_id = 108;
delete from T_operation_r_role where role_id = 2 and opt_id = 108;
delete from T_operation_r_role where role_id = 1 and opt_id = 111;
delete from T_operation_r_role where role_id = 2 and opt_id = 111;
delete from T_operation_r_role where role_id = 1 and opt_id = 112;
delete from T_operation_r_role where role_id = 2 and opt_id = 112;
delete from T_operation_r_role where role_id = 1 and opt_id = 113;
delete from T_operation_r_role where role_id = 2 and opt_id = 113;
delete from T_operation_r_role where role_id = 1 and opt_id = 115;
delete from T_operation_r_role where role_id = 2 and opt_id = 115;
delete from T_operation_r_role where role_id = 1 and opt_id = 116;
delete from T_operation_r_role where role_id = 2 and opt_id = 116;
delete from T_operation_r_role where role_id = 1 and opt_id = 117;
delete from T_operation_r_role where role_id = 2 and opt_id = 117;
delete from T_operation_r_role where role_id = 1 and opt_id = 118;
delete from T_operation_r_role where role_id = 2 and opt_id = 118;
delete from T_operation_r_role where role_id = 1 and opt_id = 119;
delete from T_operation_r_role where role_id = 2 and opt_id = 119;
delete from T_operation_r_role where role_id = 1 and opt_id = 122;
delete from T_operation_r_role where role_id = 2 and opt_id = 122;
delete from T_operation_r_role where role_id = 1 and opt_id = 120;
delete from T_operation_r_role where role_id = 2 and opt_id = 120;
delete from T_operation_r_role where role_id = 1 and opt_id = 210;
delete from T_operation_r_role where role_id = 2 and opt_id = 210;
delete from T_operation_r_role where role_id = 1 and opt_id = 123;
delete from T_operation_r_role where role_id = 2 and opt_id = 123;
delete from T_operation_r_role where role_id = 1 and opt_id = 124;
delete from T_operation_r_role where role_id = 2 and opt_id = 124;
delete from T_operation_r_role where role_id = 1 and opt_id = 125;
delete from T_operation_r_role where role_id = 2 and opt_id = 125;
delete from T_operation_r_role where role_id = 1 and opt_id = 130;
delete from T_operation_r_role where role_id = 2 and opt_id = 130;
delete from T_operation_r_role where role_id = 3 and opt_id = 130;
delete from T_operation_r_role where role_id = 1 and opt_id = 131;
delete from T_operation_r_role where role_id = 2 and opt_id = 131;
delete from T_operation_r_role where role_id = 1 and opt_id = 132;
delete from T_operation_r_role where role_id = 1 and opt_id = 133;
delete from T_operation_r_role where role_id = 1 and opt_id = 134;
delete from T_operation_r_role where role_id = 1 and opt_id = 135;
delete from T_operation_r_role where role_id = 1 and opt_id = 136;
delete from T_operation_r_role where role_id = 1 and opt_id = 137;
delete from T_operation_r_role where role_id = 1 and opt_id = 138;
delete from T_operation_r_role where role_id = 1 and opt_id = 139;
delete from T_operation_r_role where role_id = 1 and opt_id = 140;
delete from T_operation_r_role where role_id = 1 and opt_id = 141;
delete from T_operation_r_role where role_id = 1 and opt_id = 142;
delete from T_operation_r_role where role_id = 1 and opt_id = 143;
delete from T_operation_r_role where role_id = 1 and opt_id = 144;
delete from T_operation_r_role where role_id = 2 and opt_id = 144;
delete from T_operation_r_role where role_id = 1 and opt_id = 145;
delete from T_operation_r_role where role_id = 2 and opt_id = 145;
delete from T_operation_r_role where role_id = 1 and opt_id = 146;
delete from T_operation_r_role where role_id = 1 and opt_id = 147;
delete from T_operation_r_role where role_id = 1 and opt_id = 148;
delete from T_operation_r_role where role_id = 2 and opt_id = 148;
delete from T_operation_r_role where role_id = 1 and opt_id = 149;
delete from T_operation_r_role where role_id = 1 and opt_id = 202;
delete from T_operation_r_role where role_id = 1 and opt_id = 203;
delete from T_operation_r_role where role_id = 2 and opt_id = 203;
delete from T_operation_r_role where role_id = 1 and opt_id = 204;
delete from T_operation_r_role where role_id = 1 and opt_id = 150;
delete from T_operation_r_role where role_id = 2 and opt_id = 150;
delete from T_operation_r_role where role_id = 1 and opt_id = 156;
delete from T_operation_r_role where role_id = 2 and opt_id = 156;
delete from T_operation_r_role where role_id = 1 and opt_id = 157;
delete from T_operation_r_role where role_id = 2 and opt_id = 157;
delete from T_operation_r_role where role_id = 1 and opt_id = 158;
delete from T_operation_r_role where role_id = 2 and opt_id = 158;
delete from T_operation_r_role where role_id = 1 and opt_id = 159;
delete from T_operation_r_role where role_id = 2 and opt_id = 159;
delete from T_operation_r_role where role_id = 1 and opt_id = 160;
delete from T_operation_r_role where role_id = 2 and opt_id = 160;
delete from T_operation_r_role where role_id = 1 and opt_id = 161;
delete from T_operation_r_role where role_id = 2 and opt_id = 161;
delete from T_operation_r_role where role_id = 1 and opt_id = 163;
delete from T_operation_r_role where role_id = 2 and opt_id = 163;
delete from T_operation_r_role where role_id = 1 and opt_id = 162;
delete from T_operation_r_role where role_id = 2 and opt_id = 162;
delete from T_operation_r_role where role_id = 1 and opt_id = 164;
delete from T_operation_r_role where role_id = 2 and opt_id = 164;
delete from T_operation_r_role where role_id = 1 and opt_id = 165;
delete from T_operation_r_role where role_id = 2 and opt_id = 165;
delete from T_operation_r_role where role_id = 1 and opt_id = 167;
delete from T_operation_r_role where role_id = 2 and opt_id = 167;
delete from T_operation_r_role where role_id = 1 and opt_id = 166;
delete from T_operation_r_role where role_id = 2 and opt_id = 166;
delete from T_operation_r_role where role_id = 1 and opt_id = 168;
delete from T_operation_r_role where role_id = 3 and opt_id = 168;
delete from T_operation_r_role where role_id = 1 and opt_id = 169;
delete from T_operation_r_role where role_id = 3 and opt_id = 169;
delete from T_operation_r_role where role_id = 1 and opt_id = 170;
delete from T_operation_r_role where role_id = 3 and opt_id = 170;
delete from T_operation_r_role where role_id = 1 and opt_id = 171;
delete from T_operation_r_role where role_id = 3 and opt_id = 171;
delete from T_operation_r_role where role_id = 1 and opt_id = 173;
delete from T_operation_r_role where role_id = 2 and opt_id = 173;
delete from T_operation_r_role where role_id = 1 and opt_id = 182;
delete from T_operation_r_role where role_id = 2 and opt_id = 182;
delete from T_operation_r_role where role_id = 1 and opt_id = 183;
delete from T_operation_r_role where role_id = 2 and opt_id = 183;
delete from T_operation_r_role where role_id = 1 and opt_id = 184;
delete from T_operation_r_role where role_id = 2 and opt_id = 184;
delete from T_operation_r_role where role_id = 1 and opt_id = 185;
delete from T_operation_r_role where role_id = 2 and opt_id = 185;
delete from T_operation_r_role where role_id = 1 and opt_id = 186;
delete from T_operation_r_role where role_id = 2 and opt_id = 186;
delete from T_operation_r_role where role_id = 1 and opt_id = 187;
delete from T_operation_r_role where role_id = 2 and opt_id = 187;
delete from T_operation_r_role where role_id = 1 and opt_id = 188;
delete from T_operation_r_role where role_id = 1 and opt_id = 189;
delete from T_operation_r_role where role_id = 1 and opt_id = 190;
delete from T_operation_r_role where role_id = 2 and opt_id = 190;
delete from T_operation_r_role where role_id = 1 and opt_id = 191;
delete from T_operation_r_role where role_id = 1 and opt_id = 192;
delete from T_operation_r_role where role_id = 1 and opt_id = 194;
delete from T_operation_r_role where role_id = 1 and opt_id = 195;
delete from T_operation_r_role where role_id = 1 and opt_id = 193;
delete from T_operation_r_role where role_id = 1 and opt_id = 196;
delete from T_operation_r_role where role_id = 1 and opt_id = 197;
delete from T_operation_r_role where role_id = 1 and opt_id = 270;
delete from T_operation_r_role where role_id = 2 and opt_id = 270;
delete from T_operation_r_role where role_id = 1 and opt_id = 271;
delete from T_operation_r_role where role_id = 2 and opt_id = 271;
delete from T_operation_r_role where role_id = 1 and opt_id = 272;
delete from T_operation_r_role where role_id = 2 and opt_id = 272;
delete from T_operation_r_role where role_id = 1 and opt_id = 273;
delete from T_operation_r_role where role_id = 2 and opt_id = 273;
delete from T_operation_r_role where role_id = 1 and opt_id = 274;
delete from T_operation_r_role where role_id = 2 and opt_id = 274;
delete from T_operation_r_role where role_id = 1 and opt_id = 198;
delete from T_operation_r_role where role_id = 2 and opt_id = 198;
delete from T_operation_r_role where role_id = 1 and opt_id = 199;
delete from T_operation_r_role where role_id = 2 and opt_id = 199;
delete from T_operation_r_role where role_id = 1 and opt_id = 200;
delete from T_operation_r_role where role_id = 2 and opt_id = 200;
delete from T_operation_r_role where role_id = 1 and opt_id = 201;
delete from T_operation_r_role where role_id = 2 and opt_id = 201;
delete from T_operation_r_role where role_id = 1 and opt_id = 250;
delete from T_operation_r_role where role_id = 2 and opt_id = 250;
delete from T_operation_r_role where role_id = 1 and opt_id = 251;
delete from T_operation_r_role where role_id = 2 and opt_id = 251;
delete from T_operation_r_role where role_id = 1 and opt_id = 252;
delete from T_operation_r_role where role_id = 2 and opt_id = 252;

delete from T_operation_r_role where role_id = 1 and opt_id = 300;
delete from T_operation_r_role where role_id = 2 and opt_id = 300;
delete from T_operation_r_role where role_id = 1 and opt_id = 301;
delete from T_operation_r_role where role_id = 2 and opt_id = 301;
delete from T_operation_r_role where role_id = 1 and opt_id = 302;
delete from T_operation_r_role where role_id = 2 and opt_id = 302;
delete from T_operation_r_role where role_id = 1 and opt_id = 303;
delete from T_operation_r_role where role_id = 2 and opt_id = 303;
delete from T_operation_r_role where role_id = 1 and opt_id = 304;
delete from T_operation_r_role where role_id = 2 and opt_id = 304;
delete from T_operation_r_role where role_id = 1 and opt_id = 315;
delete from T_operation_r_role where role_id = 2 and opt_id = 315;
delete from T_operation_r_role where role_id = 1 and opt_id = 316;
delete from T_operation_r_role where role_id = 1 and opt_id = 317;

delete from T_operations where opt_id = 1;
delete from T_operations where opt_id = 3;
delete from T_operations where opt_id = 4;
delete from T_operations where opt_id = 11;
delete from T_operations where opt_id = 14;
delete from T_operations where opt_id = 12;
delete from T_operations where opt_id = 13;
delete from T_operations where opt_id = 15;
delete from T_operations where opt_id = 16;
delete from T_operations where opt_id = 20;
delete from T_operations where opt_id = 17;
delete from T_operations where opt_id = 18;
delete from T_operations where opt_id = 19;
delete from T_operations where opt_id = 21;
delete from T_operations where opt_id = 25;
delete from T_operations where opt_id = 22;
delete from T_operations where opt_id = 23;
delete from T_operations where opt_id = 24;
delete from T_operations where opt_id = 33;
delete from T_operations where opt_id = 34;
delete from T_operations where opt_id = 35;
delete from T_operations where opt_id = 36;
delete from T_operations where opt_id = 37;
delete from T_operations where opt_id = 40;
delete from T_operations where opt_id = 38;
delete from T_operations where opt_id = 71;
delete from T_operations where opt_id = 72;
delete from T_operations where opt_id = 205;
delete from T_operations where opt_id = 206;
delete from T_operations where opt_id = 207;
delete from T_operations where opt_id = 208;
delete from T_operations where opt_id = 211;
delete from T_operations where opt_id = 213;
delete from T_operations where opt_id = 214;
delete from T_operations where opt_id = 73;
delete from T_operations where opt_id = 74;
delete from T_operations where opt_id = 75;
delete from T_operations where opt_id = 76;
delete from T_operations where opt_id = 77;
delete from T_operations where opt_id = 78;
delete from T_operations where opt_id = 91;
delete from T_operations where opt_id = 80;
delete from T_operations where opt_id = 82;
delete from T_operations where opt_id = 83;
delete from T_operations where opt_id = 92;
delete from T_operations where opt_id = 84;
delete from T_operations where opt_id = 86;
delete from T_operations where opt_id = 87;
delete from T_operations where opt_id = 88;
delete from T_operations where opt_id = 94;
delete from T_operations where opt_id = 95;
delete from T_operations where opt_id = 96;
delete from T_operations where opt_id = 97;
delete from T_operations where opt_id = 99;
delete from T_operations where opt_id = 98;
delete from T_operations where opt_id = 100;
delete from T_operations where opt_id = 101;
delete from T_operations where opt_id = 102;
delete from T_operations where opt_id = 103;
delete from T_operations where opt_id = 104;
delete from T_operations where opt_id = 105;
delete from T_operations where opt_id = 106;
delete from T_operations where opt_id = 107;
delete from T_operations where opt_id = 110;
delete from T_operations where opt_id = 108;
delete from T_operations where opt_id = 111;
delete from T_operations where opt_id = 112;
delete from T_operations where opt_id = 113;
delete from T_operations where opt_id = 115;
delete from T_operations where opt_id = 116;
delete from T_operations where opt_id = 117;
delete from T_operations where opt_id = 118;
delete from T_operations where opt_id = 119;
delete from T_operations where opt_id = 122;
delete from T_operations where opt_id = 120;
delete from T_operations where opt_id = 210;
delete from T_operations where opt_id = 123;
delete from T_operations where opt_id = 124;
delete from T_operations where opt_id = 125;
delete from T_operations where opt_id = 130;
delete from T_operations where opt_id = 131;
delete from T_operations where opt_id = 132;
delete from T_operations where opt_id = 133;
delete from T_operations where opt_id = 134;
delete from T_operations where opt_id = 135;
delete from T_operations where opt_id = 136;
delete from T_operations where opt_id = 137;
delete from T_operations where opt_id = 138;
delete from T_operations where opt_id = 139;
delete from T_operations where opt_id = 140;
delete from T_operations where opt_id = 141;
delete from T_operations where opt_id = 142;
delete from T_operations where opt_id = 143;
delete from T_operations where opt_id = 144;
delete from T_operations where opt_id = 145;
delete from T_operations where opt_id = 146;
delete from T_operations where opt_id = 147;
delete from T_operations where opt_id = 148;
delete from T_operations where opt_id = 149;
delete from T_operations where opt_id = 202;
delete from T_operations where opt_id = 203;
delete from T_operations where opt_id = 204;
delete from T_operations where opt_id = 150;
delete from T_operations where opt_id = 156;
delete from T_operations where opt_id = 157;
delete from T_operations where opt_id = 158;
delete from T_operations where opt_id = 159;
delete from T_operations where opt_id = 160;
delete from T_operations where opt_id = 161;
delete from T_operations where opt_id = 163;
delete from T_operations where opt_id = 162;
delete from T_operations where opt_id = 164;
delete from T_operations where opt_id = 165;
delete from T_operations where opt_id = 167;
delete from T_operations where opt_id = 166;
delete from T_operations where opt_id = 168;
delete from T_operations where opt_id = 169;
delete from T_operations where opt_id = 170;
delete from T_operations where opt_id = 171;
delete from T_operations where opt_id = 173;
delete from T_operations where opt_id = 182;
delete from T_operations where opt_id = 183;
delete from T_operations where opt_id = 184;
delete from T_operations where opt_id = 185;
delete from T_operations where opt_id = 186;
delete from T_operations where opt_id = 187;
delete from T_operations where opt_id = 188;
delete from T_operations where opt_id = 189;
delete from T_operations where opt_id = 190;
delete from T_operations where opt_id = 191;
delete from T_operations where opt_id = 192;
delete from T_operations where opt_id = 194;
delete from T_operations where opt_id = 195;
delete from T_operations where opt_id = 193;
delete from T_operations where opt_id = 196;
delete from T_operations where opt_id = 197;
delete from T_operations where opt_id = 270;
delete from T_operations where opt_id = 271;
delete from T_operations where opt_id = 272;
delete from T_operations where opt_id = 273;
delete from T_operations where opt_id = 274;
delete from T_operations where opt_id = 198;
delete from T_operations where opt_id = 199;
delete from T_operations where opt_id = 200;
delete from T_operations where opt_id = 201;
delete from T_operations where opt_id = 250;
delete from T_operations where opt_id = 251;
delete from T_operations where opt_id = 252;

delete from T_operations where opt_id = 300;
delete from T_operations where opt_id = 301;
delete from T_operations where opt_id = 302;
delete from T_operations where opt_id = 303;
delete from T_operations where opt_id = 304;
delete from T_operations where opt_id = 315;
delete from T_operations where opt_id = 316;
delete from T_operations where opt_id = 317;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(3, 'lego.res', '/nem/disc/deviceTable.do', '', false, '2000');
insert into T_operation_r_role (role_id, opt_id) values (1, 3);
insert into T_operation_r_role (role_id, opt_id) values (2, 3);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4, 'lego.sys.discover', '', '', false, '2000-100');
insert into T_operation_r_role (role_id, opt_id) values (1, 4);
insert into T_operation_r_role (role_id, opt_id) values (2, 4);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(11, 'lego.sys.discover.discovedDevice', '/nem/disc/deviceTable.do', '', false, '2000-100-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 11);
insert into T_operation_r_role (role_id, opt_id) values (2, 11);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(14, 'lego.sys.discover.discovedDevice.scan', '', '', true, '2000-100-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 14);
insert into T_operation_r_role (role_id, opt_id) values (2, 14);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(12, 'lego.sys.discover.discovedDevice.delete', '', '', false, '2000-100-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 12);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(13, 'lego.sys.discover.discovedDevice.modify', '', '', false, '2000-100-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 13);
insert into T_operation_r_role (role_id, opt_id) values (2, 13);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(15, 'lego.sys.templMgr', '', '', false, '2000-200');
insert into T_operation_r_role (role_id, opt_id) values (1, 15);
insert into T_operation_r_role (role_id, opt_id) values (2, 15);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(16, 'lego.sys.templMgr.snmpTempl', '/core/system/discoveryTemplate.do', '', false, '2000-200-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 16);
insert into T_operation_r_role (role_id, opt_id) values (2, 16);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(20, 'lego.sys.templMgr.snmpTempl.scan', '', '', true, '2000-200-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 20);
insert into T_operation_r_role (role_id, opt_id) values (2, 20);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(17, 'lego.sys.templMgr.snmpTempl.add', '', '', false, '2000-200-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 17);
insert into T_operation_r_role (role_id, opt_id) values (2, 17);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(18, 'lego.sys.templMgr.snmpTempl.delete', '', '', false, '2000-200-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 18);
insert into T_operation_r_role (role_id, opt_id) values (2, 18);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(19, 'lego.sys.templMgr.snmpTempl.modify', '', '', false, '2000-200-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 19);
insert into T_operation_r_role (role_id, opt_id) values (2, 19);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(21, 'lego.sys.templMgr.telnetTempl', '/core/system/telnetTemplateList.do', '', false, '2000-200-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 21);
insert into T_operation_r_role (role_id, opt_id) values (2, 21);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(25, 'lego.sys.templMgr.telnetTempl.scan', '', '', true, '2000-200-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 25);
insert into T_operation_r_role (role_id, opt_id) values (2, 25);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(22, 'lego.sys.templMgr.telnetTempl.add', '', '', false, '2000-200-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 22);
insert into T_operation_r_role (role_id, opt_id) values (2, 22);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(23, 'lego.sys.templMgr.telnetTempl.delete', '', '', false, '2000-200-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 23);
insert into T_operation_r_role (role_id, opt_id) values (2, 23);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(24, 'lego.sys.templMgr.telnetTempl.modify', '', '', false, '2000-200-20-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 24);
insert into T_operation_r_role (role_id, opt_id) values (2, 24);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(71, 'lego.toponew', '/topo/getTopView.do', '', false, '5000');
insert into T_operation_r_role (role_id, opt_id) values (1, 71);
insert into T_operation_r_role (role_id, opt_id) values (2, 71);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(72, 'lego.toponew.scan', '', '', true, '5000-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 72);
insert into T_operation_r_role (role_id, opt_id) values (2, 72);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(205, 'lego.topo.view.name', '', '', false, '5000-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 205);
insert into T_operation_r_role (role_id, opt_id) values (2, 205);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(206, 'lego.toponew.menu.modifyphysical.view', '', '', false, '5000-25-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 206);
insert into T_operation_r_role (role_id, opt_id) values (2, 206);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(207, 'lego.topo.custom.view.name', '', '', false, '5000-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 207);
insert into T_operation_r_role (role_id, opt_id) values (2, 207);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(208, 'lego.toponew.menu.create.view', '', '', false, '5000-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 208);
insert into T_operation_r_role (role_id, opt_id) values (2, 208);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(211, 'lego.toponew.menu.modify.view', '', '', false, '5000-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 211);
insert into T_operation_r_role (role_id, opt_id) values (2, 211);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(213, 'lego.toponew.menu.delete.view', '', '', false, '5000-30-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 213);
insert into T_operation_r_role (role_id, opt_id) values (2, 213);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(73, 'lego.event', '/nem/fault/getAllAlarmList.do', '', false, '6000');
insert into T_operation_r_role (role_id, opt_id) values (1, 73);
insert into T_operation_r_role (role_id, opt_id) values (2, 73);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(74, 'lego.evtMgr', '', '', false, '6000-100');
insert into T_operation_r_role (role_id, opt_id) values (1, 74);
insert into T_operation_r_role (role_id, opt_id) values (2, 74);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(75, 'lego.evtMgr.curtAlarm', '/nem/fault/getAllAlarmList.do', '', false, '6000-100-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 75);
insert into T_operation_r_role (role_id, opt_id) values (2, 75);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(76, 'lego.evtMgr.curtAlarm.scan', '', '', true, '6000-100-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 76);
insert into T_operation_r_role (role_id, opt_id) values (2, 76);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(77, 'lego.evtMgr.curtAlarm.clear', '', '', false, '6000-100-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 77);
insert into T_operation_r_role (role_id, opt_id) values (2, 77);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(78, 'lego.evtMgr.curtAlarm.confirm', '', '', false, '6000-100-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 78);
insert into T_operation_r_role (role_id, opt_id) values (2, 78);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(91, 'lego.evtMgr.curtAlarm.experiences', '', '', false, '6000-100-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 91);
insert into T_operation_r_role (role_id, opt_id) values (2, 91);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(80, 'lego.evtMgr.curtAlarm.export', '', '', false, '6000-100-10-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 80);
insert into T_operation_r_role (role_id, opt_id) values (2, 80);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(82, 'lego.evtMgr.hisAlarm', '/nem/fault/getHistoryList.do', '', false, '6000-100-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 82);
insert into T_operation_r_role (role_id, opt_id) values (2, 82);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(83, 'lego.evtMgr.hisAlarm.scan', '', '', true, '6000-100-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 83);
insert into T_operation_r_role (role_id, opt_id) values (2, 83);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(92, 'lego.evtMgr.hisAlarm.experiences', '', '', false, '6000-100-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 92);
insert into T_operation_r_role (role_id, opt_id) values (2, 92);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(84, 'lego.evtMgr.hisAlarm.export', '', '', false, '6000-100-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 84);
insert into T_operation_r_role (role_id, opt_id) values (2, 84);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(86, 'lego.event.evtList', '/nem/fault/getEventList.do', '', false, '6000-100-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 86);
insert into T_operation_r_role (role_id, opt_id) values (2, 86);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(87, 'lego.event.evtList.scan', '', '', true, '6000-100-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 87);
insert into T_operation_r_role (role_id, opt_id) values (2, 87);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(88, 'lego.event.evtList.export', '', '', false, '6000-100-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 88);
insert into T_operation_r_role (role_id, opt_id) values (2, 88);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(94, 'lego.event.synchronize', '', '', false, '6000-200');
insert into T_operation_r_role (role_id, opt_id) values (1, 94);
insert into T_operation_r_role (role_id, opt_id) values (2, 94);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(95, 'lego.event.synchronize.manual', '/nem/fault/manualSync.do', '', false, '6000-200-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 95);
insert into T_operation_r_role (role_id, opt_id) values (2, 95);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(96, 'lego.event.synchronize.manual.scan', '', '', true, '6000-200-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 96);
insert into T_operation_r_role (role_id, opt_id) values (2, 96);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(97, 'lego.event.synchronize.manual.add', '', '', false, '6000-200-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 97);
insert into T_operation_r_role (role_id, opt_id) values (2, 97);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(99, 'lego.event.synchronize.manual.delete', '', '', false, '6000-200-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 99);
insert into T_operation_r_role (role_id, opt_id) values (2, 99);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(98, 'lego.event.synchronize.manual.resync', '', '', false, '6000-200-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 98);
insert into T_operation_r_role (role_id, opt_id) values (2, 98);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(100, 'lego.event.synchronize.timing', '/nem/fault/timingSync.do', '', false, '6000-200-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 100);
insert into T_operation_r_role (role_id, opt_id) values (2, 100);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(101, 'lego.event.synchronize.timing.scan', '', '', true, '6000-200-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 101);
insert into T_operation_r_role (role_id, opt_id) values (2, 101);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(102, 'lego.event.synchronize.timing.set', '', '', false, '6000-200-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 102);
insert into T_operation_r_role (role_id, opt_id) values (2, 102);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(103, 'lego.event.alarmShield', '', '', false, '6000-300');
insert into T_operation_r_role (role_id, opt_id) values (1, 103);
insert into T_operation_r_role (role_id, opt_id) values (2, 103);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(104, 'lego.event.alarmShield.rule', '/nem/fault/getAllRuleList.do', '', false, '6000-300-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 104);
insert into T_operation_r_role (role_id, opt_id) values (2, 104);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(105, 'lego.event.alarmShield.scan', '', '', true, '6000-300-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 105);
insert into T_operation_r_role (role_id, opt_id) values (2, 105);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(106, 'lego.event.alarmShield.add', '', '', false, '6000-300-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 106);
insert into T_operation_r_role (role_id, opt_id) values (2, 106);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(107, 'lego.event.alarmShield.delete', '', '', false, '6000-300-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 107);
insert into T_operation_r_role (role_id, opt_id) values (2, 107);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(110, 'lego.event.alarmShield.modify', '', '', false, '6000-300-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 110);
insert into T_operation_r_role (role_id, opt_id) values (2, 110);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(108, 'lego.event.alarmShield.start', '', '', false, '6000-300-10-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 108);
insert into T_operation_r_role (role_id, opt_id) values (2, 108);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(111, 'lego.event.alarmShield.shieldAlarmList', '/nem/fault/getShieldAlarmList.do', '', false, '6000-300-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 111);
insert into T_operation_r_role (role_id, opt_id) values (2, 111);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(112, 'lego.event.shieldList.scan', '', '', true, '6000-300-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 112);
insert into T_operation_r_role (role_id, opt_id) values (2, 112);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(113, 'lego.event.shieldList.export', '', '', false, '6000-300-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 113);
insert into T_operation_r_role (role_id, opt_id) values (2, 113);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(115, 'lego.event.notify', '', '', false, '6000-500');
insert into T_operation_r_role (role_id, opt_id) values (1, 115);
insert into T_operation_r_role (role_id, opt_id) values (2, 115);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(116, 'lego.event.notify.message', '/nem/fault/getAllNotifyRuleList.do', '', false, '6000-500-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 116);
insert into T_operation_r_role (role_id, opt_id) values (2, 116);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(117, 'lego.event.notify.scan', '', '', true, '6000-500-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 117);
insert into T_operation_r_role (role_id, opt_id) values (2, 117);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(118, 'lego.event.notify.add', '', '', false, '6000-500-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 118);
insert into T_operation_r_role (role_id, opt_id) values (2, 118);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(119, 'lego.event.notify.delete', '', '', false, '6000-500-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 119);
insert into T_operation_r_role (role_id, opt_id) values (2, 119);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(122, 'lego.event.notify.modify', '', '', false, '6000-500-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 122);
insert into T_operation_r_role (role_id, opt_id) values (2, 122);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(120, 'lego.event.notify.start', '', '', false, '6000-500-10-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 120);
insert into T_operation_r_role (role_id, opt_id) values (2, 120);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(210, 'lego.event.notify.pathset', '', '', false, '6000-500-10-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 210);
insert into T_operation_r_role (role_id, opt_id) values (2, 210);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(123, 'lego.event.voice', '/nem/fault/getAudioSetting.do', '', false, '6000-500-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 123);
insert into T_operation_r_role (role_id, opt_id) values (2, 123);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(124, 'lego.event.voice.scan', '', '', true, '6000-500-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 124);
insert into T_operation_r_role (role_id, opt_id) values (2, 124);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(125, 'lego.event.voice.modify', '', '', false, '6000-500-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 125);
insert into T_operation_r_role (role_id, opt_id) values (2, 125);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(130, 'lego.sys', '/cbb/admin/adminList.do', '', false, '8000');
insert into T_operation_r_role (role_id, opt_id) values (1, 130);
insert into T_operation_r_role (role_id, opt_id) values (2, 130);
insert into T_operation_r_role (role_id, opt_id) values (3, 130);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(131, 'lego.sys.operatorMgr', '', '', false, '8000-300');
insert into T_operation_r_role (role_id, opt_id) values (1, 131);
insert into T_operation_r_role (role_id, opt_id) values (2, 131);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(132, 'lego.sys.operatorMgr.operator', '/cbb/admin/adminList.do', '', false, '8000-300-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 132);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(133, 'lego.sys.operatorMgr.operator.scan', '', '', true, '8000-300-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 133);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(134, 'lego.sys.operatorMgr.operator.add', '', '', false, '8000-300-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 134);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(135, 'lego.sys.operatorMgr.operator.delete', '', '', false, '8000-300-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 135);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(136, 'lego.sys.operatorMgr.operator.edit', '', '', false, '8000-300-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 136);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(137, 'lego.sys.operatorMgr.operator.lock', '', '', false, '8000-300-10-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 137);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(138, 'lego.sys.operatorMgr.operator.resetpassword', '', '', false, '8000-300-10-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 138);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(139, 'lego.sys.role', '/cbb/admin/roleList.do', '', false, '8000-300-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 139);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(140, 'lego.sys.role.scan', '', '', true, '8000-300-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 140);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(141, 'lego.sys.role.add', '', '', false, '8000-300-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 141);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(142, 'lego.sys.role.delete', '', '', false, '8000-300-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 142);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(143, 'lego.sys.role.edit', '', '', false, '8000-300-20-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 143);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(144, 'lego.sys.onlineUserMgr', '/cbb/admin/onlineList.do', '', false, '8000-300-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 144);
insert into T_operation_r_role (role_id, opt_id) values (2, 144);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(145, 'lego.sys.onlineUserMgr.scan', '', '', true, '8000-300-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 145);
insert into T_operation_r_role (role_id, opt_id) values (2, 145);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(146, 'lego.sys.onlineUserMgr.down', '', '', false, '8000-300-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 146);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(147, 'lego.sys.sysLoginPolicy', '/cbb/admin/passPolicy.do', '', false, '8000-300-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 147);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(148, 'lego.sys.sysLoginPolicy.scan', '', '', true, '8000-300-50-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 148);
insert into T_operation_r_role (role_id, opt_id) values (2, 148);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(149, 'lego.sys.sysLoginPolicy.modify', '', '', false, '8000-300-50-10');
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(202, 'lego.sys.user.authserver', '/cbb/admin/editRadiuConf.do', '', false, '8000-300-60');
insert into T_operation_r_role (role_id, opt_id) values (1, 202);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(203, 'lego.sys.user.authserver.scan', '', '', true, '8000-300-60-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 203);
insert into T_operation_r_role (role_id, opt_id) values (2, 203);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(204, 'lego.sys.user.authserver.modify', '', '', false, '8000-300-60-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 204);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(150, 'lego.sys.systemInfo', '', '', false, '8000-400');
insert into T_operation_r_role (role_id, opt_id) values (1, 150);
insert into T_operation_r_role (role_id, opt_id) values (2, 150);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(156, 'lego.sys.systemMonitor', '/core/system/perforView.do', '', false, '8000-400-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 156);
insert into T_operation_r_role (role_id, opt_id) values (2, 156);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(157, 'lego.sys.systemMonitor.scan', '', '', true, '8000-400-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 157);
insert into T_operation_r_role (role_id, opt_id) values (2, 157);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(158, 'lego.sys.systemMonitor.Threshold.modify', '', '', false, '8000-400-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 158);
insert into T_operation_r_role (role_id, opt_id) values (2, 158);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(159, 'lego.sys.dataStorage', '', '', false, '8000-500');
insert into T_operation_r_role (role_id, opt_id) values (1, 159);
insert into T_operation_r_role (role_id, opt_id) values (2, 159);
insert into T_operation_r_role (role_id, opt_id) values (3, 159);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(160, 'lego.sys.dataStorage.sysOptLog', '/core/system/sysOptStorage.do', '', false, '8000-500-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 160);
insert into T_operation_r_role (role_id, opt_id) values (2, 160);
insert into T_operation_r_role (role_id, opt_id) values (3, 160);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(161, 'lego.sys.dataStorage.sysOptLog.scan', '', '', true, '8000-500-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 161);
insert into T_operation_r_role (role_id, opt_id) values (2, 161);
insert into T_operation_r_role (role_id, opt_id) values (3, 161);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(163, 'lego.sys.dataStorage.sysOptLog.delete', '', '', false, '8000-500-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 163);
insert into T_operation_r_role (role_id, opt_id) values (2, 163);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(162, 'lego.sys.dataStorage.sysOptLog.modify', '', '', false, '8000-500-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 162);
insert into T_operation_r_role (role_id, opt_id) values (2, 162);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(164, 'lego.sys.dataStorage.event', '/core/system/eventStorage.do', '', false, '8000-500-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 164);
insert into T_operation_r_role (role_id, opt_id) values (2, 164);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(165, 'lego.sys.dataStorage.event.scan', '', '', true, '8000-500-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 165);
insert into T_operation_r_role (role_id, opt_id) values (2, 165);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(167, 'lego.sys.dataStorage.event.delete', '', '', false, '8000-500-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 167);
insert into T_operation_r_role (role_id, opt_id) values (2, 167);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(166, 'lego.sys.dataStorage.event.modify', '', '', false, '8000-500-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 166);
insert into T_operation_r_role (role_id, opt_id) values (2, 166);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(168, 'lego.sys.sysLog', '', '', false, '8000-600');
insert into T_operation_r_role (role_id, opt_id) values (1, 168);
insert into T_operation_r_role (role_id, opt_id) values (2, 168);
insert into T_operation_r_role (role_id, opt_id) values (3, 168);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(169, 'lego.sys.sysLog.operLog', '/core/system/sysLogQuery.do', '', false, '8000-600-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 169);
insert into T_operation_r_role (role_id, opt_id) values (2, 169);
insert into T_operation_r_role (role_id, opt_id) values (3, 169);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(170, 'lego.sys.sysLog.operLog.scan', '', '', true, '8000-600-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 170);
insert into T_operation_r_role (role_id, opt_id) values (2, 170);
insert into T_operation_r_role (role_id, opt_id) values (3, 170);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(171, 'lego.sys.sysLog.operLog.exportExl', '', '', false, '8000-600-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 171);
insert into T_operation_r_role (role_id, opt_id) values (2, 171);
insert into T_operation_r_role (role_id, opt_id) values (3, 171);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(173, 'lego.sys.task', '', '', false, '8000-700');
insert into T_operation_r_role (role_id, opt_id) values (1, 173);
insert into T_operation_r_role (role_id, opt_id) values (2, 173);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(182, 'lego.sys.backgroundtask', '/cbb/task/backTaskList.do', '', false, '8000-700-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 182);
insert into T_operation_r_role (role_id, opt_id) values (2, 182);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(183, 'lego.sys.backgroundtask.scan', '', '', true, '8000-700-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 183);
insert into T_operation_r_role (role_id, opt_id) values (2, 183);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(184, 'lego.sys.backgroundtask.delete', '', '', false, '8000-700-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 184);
insert into T_operation_r_role (role_id, opt_id) values (2, 184);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(185, 'lego.sys.licenseMgr', '', '', false, '8000-800');
insert into T_operation_r_role (role_id, opt_id) values (1, 185);
insert into T_operation_r_role (role_id, opt_id) values (2, 185);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(186, 'lego.sys.License', '/core/system/getSysLicense.do', '', false, '8000-800-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 186);
insert into T_operation_r_role (role_id, opt_id) values (2, 186);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(187, 'lego.sys.License.scan', '', '', true, '8000-800-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 187);
insert into T_operation_r_role (role_id, opt_id) values (2, 187);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(188, 'lego.sys.License.import', '', '', false, '8000-800-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 188);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(189, 'lego.sys.License.export', '', '', false, '8000-800-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 189);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(190, 'lego.sys.grademgr', '', '', false, '8000-900');
insert into T_operation_r_role (role_id, opt_id) values (1, 190);
insert into T_operation_r_role (role_id, opt_id) values (2, 190);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(191, 'lego.sys.grademgr.nms', '/core/system/listNmsConfig.do', '', false, '8000-900-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 191);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(192, 'lego.sys.grademgr.nms.scan', '', '', true, '8000-900-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 192);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(194, 'lego.sys.grademgr.nms.add', '', '', false, '8000-900-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 194);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(195, 'lego.sys.grademgr.nms.delete', '', '', false, '8000-900-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 195);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(193, 'lego.sys.grademgr.nms.setlocal', '', '', false, '8000-900-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 193);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(196, 'lego.sys.grademgr.nms.start', '', '', false, '8000-900-10-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 196);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(197, 'lego.sys.grademgr.nms.modify', '', '', false, '8000-900-10-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 197);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(270, 'lego.sys.grademgr.northnms', '/core/system/addListNmsConfig.do', '', false, '8000-900-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 270);
insert into T_operation_r_role (role_id, opt_id) values (2, 270);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(271, 'lego.sys.grademgr.northnms.scan', '', '', true, '8000-900-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 271);
insert into T_operation_r_role (role_id, opt_id) values (2, 271);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(272, 'lego.sys.grademgr.northnms.add', '', '', false, '8000-900-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 272);
insert into T_operation_r_role (role_id, opt_id) values (2, 272);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(273, 'lego.sys.grademgr.northnms.delete', '', '', false, '8000-900-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 273);
insert into T_operation_r_role (role_id, opt_id) values (2, 273);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(274, 'lego.sys.grademgr.northnms.modify', '', '', false, '8000-900-20-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 274);
insert into T_operation_r_role (role_id, opt_id) values (2, 274);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(198, 'lego.sys.notifyServer', '', '', false, '8000-1000');
insert into T_operation_r_role (role_id, opt_id) values (1, 198);
insert into T_operation_r_role (role_id, opt_id) values (2, 198);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(199, 'lego.sys.serverInfo', '/nem/fault/showserver.do', '', false, '8000-1000-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 199);
insert into T_operation_r_role (role_id, opt_id) values (2, 199);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(200, 'lego.sys.server.scan', '', '', true, '8000-1000-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 200);
insert into T_operation_r_role (role_id, opt_id) values (2, 200);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(201, 'lego.sys.serverEdit', '', '', false, '8000-1000-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 201);
insert into T_operation_r_role (role_id, opt_id) values (2, 201);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(250, 'lego.report', '/cbb/report/ddosReport.do?busId=1', '', false, '7000');
insert into T_operation_r_role (role_id, opt_id) values (1, 250);
insert into T_operation_r_role (role_id, opt_id) values (2, 250);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(251, 'lego.report.once', '', '', false, '7000-100');
insert into T_operation_r_role (role_id, opt_id) values (1, 251);
insert into T_operation_r_role (role_id, opt_id) values (2, 251);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(252, 'lego.report.once.scan', '', '', true, '7000-100-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 252);
insert into T_operation_r_role (role_id, opt_id) values (2, 252);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(315, 'lego.sys.grademgr.nms.trapConfig', '/core/system/trapParamConfig.do', '', false, '8000-900-30');
insert into T_operation_r_role (role_id, opt_id) values (1,315);
insert into T_operation_r_role (role_id, opt_id) values (2,315);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(316, 'lego.sys.grademgr.nms.trapConfig.scan', '', '', true, '8000-900-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 316);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(317, 'lego.sys.grademgr.nms.trapConfig.edit', '', '', false, '8000-900-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 317);

insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(300, 'lego.sys.resourceGroup', '/cbb/res/resGroupTable.do', '', false, '8000-111-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 300);
insert into T_operation_r_role (role_id, opt_id) values (2, 300);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(301, 'lego.sys.resourceGroup.scan', '', '', true, '8000-111-40-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 301);
insert into T_operation_r_role (role_id, opt_id) values (2, 301);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(302, 'lego.sys.resourceGroup.create', '', '', false, '8000-111-40-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 302);
insert into T_operation_r_role (role_id, opt_id) values (2, 302);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(303, 'lego.sys.resourceGroup.delete', '', '', false, '8000-111-40-3');
insert into T_operation_r_role (role_id, opt_id) values (1, 303);
insert into T_operation_r_role (role_id, opt_id) values (2, 303);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(304, 'lego.sys.resourceGroup.modify', '', '', false, '8000-111-40-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 304);
insert into T_operation_r_role (role_id, opt_id) values (2, 304);

-- insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(260, 'lego.toponew.menu.create.view', '', '', false, '5000-65');
-- insert into T_operation_r_role (role_id, opt_id) values (1, 260);
-- insert into T_operation_r_role (role_id, opt_id) values (2, 260);
-- insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(261, 'lego.toponew.menu.delete.view', '', '', false, '5000-70');
-- insert into T_operation_r_role (role_id, opt_id) values (1, 261);
-- insert into T_operation_r_role (role_id, opt_id) values (2, 261);
-- insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(262, 'lego.toponew.menu.modify.view', '', '', false, '5000-75');
-- insert into T_operation_r_role (role_id, opt_id) values (1, 262);
-- insert into T_operation_r_role (role_id, opt_id) values (2, 262);
-- insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(263, 'lego.toponew.menu.addnode.view', '', '', false, '5000-80');
-- insert into T_operation_r_role (role_id, opt_id) values (1, 263);
-- insert into T_operation_r_role (role_id, opt_id) values (2, 263);
-- insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(267, 'lego.toponew.menu.deletenode.view', '', '', false, '5000-85');
-- insert into T_operation_r_role (role_id, opt_id) values (1, 267);
-- insert into T_operation_r_role (role_id, opt_id) values (2, 267);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(500, 'lego.sys.maintenance.exportreport', 'core/system/reportExport.do', '', false, '8000-500-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 500);
insert into T_operation_r_role (role_id, opt_id) values (2, 500);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(501, 'lego.sys.maintenance.exportreport.scan', '', '', true, '8000-500-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 501);
insert into T_operation_r_role (role_id, opt_id) values (2, 501);
delete from T_portalconfig where id in (1);
INSERT INTO T_portalconfig(id, category, title, url, opt_id) VALUES (1, 'lego.dic.module.fault','lego.lab.fault.all;ism.base.poralconfig.describe.1','/nem/fault/getAllAlarmCountChart.do','lego.evtMgr.curtAlarm.scan');
--INSERT INTO T_portalconfig(id, category, title, url, opt_id) VALUES (2, 'lego.lab.nms.layeredNms','lego.dic.module.slave;ism.base.poralconfig.describe.2','/core/system/getHomePageNmsView.do?heightResize=true','lego.sys.grademgr.nms.scan');
delete from T_topo_img_define where img_name = 'node';
insert into T_topo_img_define values('node', 'ND', 'node.png');
delete from T_topo_img_define where img_name = 'node_offline';
insert into T_topo_img_define values('node_offline', 'ND', 'node_offline.png');
delete from T_topo_img_define where img_name = 'node_critical';
insert into T_topo_img_define values('node_critical', 'ND', 'node_critical.png');
delete from T_topo_img_define where img_name = 'node_major';
insert into T_topo_img_define values('node_major', 'ND', 'node_major.png');
delete from T_topo_img_define where img_name = 'node_minor';
insert into T_topo_img_define values('node_minor', 'ND', 'node_minor.png');
delete from T_topo_img_define where img_name = 'node_warning';
insert into T_topo_img_define values('node_warning', 'ND', 'node_warning.png');
delete from T_topo_img_define where img_name = 'LocalNMS';
insert into T_topo_img_define values('LocalNMS', 'ND', 'LocalNMS.png');
delete from T_topo_img_define where img_name = 'LocalNMS_offline';
insert into T_topo_img_define values('LocalNMS_offline', 'ND', 'LocalNMS_offline.png');
delete from T_topo_img_define where img_name = 'LocalNMS_critical';
insert into T_topo_img_define values('LocalNMS_critical', 'ND', 'LocalNMS_critical.png');
delete from T_topo_img_define where img_name = 'LocalNMS_major';
insert into T_topo_img_define values('LocalNMS_major', 'ND', 'LocalNMS_major.png');
delete from T_topo_img_define where img_name = 'LocalNMS_minor';
insert into T_topo_img_define values('LocalNMS_minor', 'ND', 'LocalNMS_minor.png');
delete from T_topo_img_define where img_name = 'LocalNMS_warning';
insert into T_topo_img_define values('LocalNMS_warning', 'ND', 'LocalNMS_warning.png');
delete from T_topo_img_define where img_name = 'SubNMS';
insert into T_topo_img_define values('SubNMS', 'ND', 'SubNMS.png');
delete from T_topo_img_define where img_name = 'SubNMS_offline';
insert into T_topo_img_define values('SubNMS_offline', 'ND', 'SubNMS_offline.png');
delete from T_topo_img_define where img_name = 'SubNMS_critical';
insert into T_topo_img_define values('SubNMS_critical', 'ND', 'SubNMS_critical.png');
delete from T_topo_img_define where img_name = 'SubNMS_major';
insert into T_topo_img_define values('SubNMS_major', 'ND', 'SubNMS_major.png');
delete from T_topo_img_define where img_name = 'SubNMS_minor';
insert into T_topo_img_define values('SubNMS_minor', 'ND', 'SubNMS_minor.png');
delete from T_topo_img_define where img_name = 'SubNMS_warning';
insert into T_topo_img_define values('SubNMS_warning', 'ND', 'SubNMS_warning.png');
delete from T_topo_img_define where img_name = 'ResourceGroup';
insert into T_topo_img_define values('ResourceGroup', 'ND', 'ResourceGroup.png');
delete from T_topo_img_define where img_name = 'ResourceGroup_offline';
insert into T_topo_img_define values('ResourceGroup_offline', 'ND', 'ResourceGroup_offline.png');
delete from T_topo_img_define where img_name = 'ResourceGroup_critical';
insert into T_topo_img_define values('ResourceGroup_critical', 'ND', 'ResourceGroup_critical.png');
delete from T_topo_img_define where img_name = 'ResourceGroup_major';
insert into T_topo_img_define values('ResourceGroup_major', 'ND', 'ResourceGroup_major.png');
delete from T_topo_img_define where img_name = 'ResourceGroup_minor';
insert into T_topo_img_define values('ResourceGroup_minor', 'ND', 'ResourceGroup_minor.png');
delete from T_topo_img_define where img_name = 'ResourceGroup_warning';
insert into T_topo_img_define values('ResourceGroup_warning', 'ND', 'ResourceGroup_warning.png');
delete from T_device_type_relation where tid = 5000;
insert into T_device_type_relation (tid,parent_type, child_type, page_url) VALUES (5000,'lego.dic.discoverypolicy.thirdPartyDevice', 'lego.dic.discoverypolicy.thirdPartyDevice' ,'');
delete from T_operation_r_role where role_id = 1 and opt_id = 6600;
delete from T_operation_r_role where role_id = 2 and opt_id = 6600;
delete from T_operation_r_role where role_id = 1 and opt_id = 6610;
delete from T_operation_r_role where role_id = 2 and opt_id = 6610;
delete from T_operation_r_role where role_id = 1 and opt_id = 6611;
delete from T_operation_r_role where role_id = 2 and opt_id = 6611;
delete from T_operation_r_role where role_id = 1 and opt_id = 6612;
delete from T_operation_r_role where role_id = 2 and opt_id = 6612;
delete from T_operation_r_role where role_id = 1 and opt_id = 6613;
delete from T_operation_r_role where role_id = 2 and opt_id = 6613;
delete from T_operation_r_role where role_id = 1 and opt_id = 6614;
delete from T_operation_r_role where role_id = 2 and opt_id = 6614;
delete from T_operation_r_role where role_id = 1 and opt_id = 6615;
delete from T_operation_r_role where role_id = 2 and opt_id = 6615;
delete from T_operation_r_role where role_id = 1 and opt_id = 6616;
delete from T_operation_r_role where role_id = 2 and opt_id = 6616;
delete from T_operation_r_role where role_id = 1 and opt_id = 6617;
delete from T_operation_r_role where role_id = 2 and opt_id = 6617;
delete from T_operation_r_role where role_id = 1 and opt_id = 191;
delete from T_operation_r_role where role_id = 1 and opt_id = 193;
delete from T_operation_r_role where role_id = 1 and opt_id = 194;
delete from T_operation_r_role where role_id = 1 and opt_id = 195;
delete from T_operation_r_role where role_id = 1 and opt_id = 196;

delete from T_operations where opt_id = 6600;
delete from T_operations where opt_id = 6610;
delete from T_operations where opt_id = 6611;
delete from T_operations where opt_id = 6612;
delete from T_operations where opt_id = 6613;
delete from T_operations where opt_id = 6614;
delete from T_operations where opt_id = 6615;
delete from T_operations where opt_id = 6616;
delete from T_operations where opt_id = 6617;
--delete from T_operations where opt_id = 191;
--delete from T_operations where opt_id = 193;
--delete from T_operations where opt_id = 194;
--delete from T_operations where opt_id = 195;
--delete from T_operations where opt_id = 196;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(6600, 'ism.alarm.threshold', '', '', false, '6000-600');
insert into T_operation_r_role (role_id, opt_id) values (1, 6600);
insert into T_operation_r_role (role_id, opt_id) values (2, 6600);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(6610, 'ism.alarm.threshold.details', '/ism/cbb/base/toDeviceList.do', '', false, '6000-600-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 6610);
insert into T_operation_r_role (role_id, opt_id) values (2, 6610);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(6611, 'ism.alarm.threshold.details.scan', '', '', true, '6000-600-10-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 6611);
insert into T_operation_r_role (role_id, opt_id) values (2, 6611);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(6612, 'ism.alarm.threshold.details.modify', '', '', false, '6000-600-10-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 6612);
insert into T_operation_r_role (role_id, opt_id) values (2, 6612);

delete from T_operation_r_role where role_id = 1 and opt_id = 192;
delete from T_operation_r_role where role_id = 2 and opt_id = 192;
delete from T_operation_r_role where role_id = 1 and opt_id = 15;
delete from T_operation_r_role where role_id = 1 and opt_id = 16;
delete from T_operation_r_role where role_id = 1 and opt_id = 20;
delete from T_operation_r_role where role_id = 1 and opt_id = 17;
delete from T_operation_r_role where role_id = 1 and opt_id = 18;
delete from T_operation_r_role where role_id = 1 and opt_id = 19;
delete from T_operation_r_role where role_id = 1 and opt_id = 21;
delete from T_operation_r_role where role_id = 1 and opt_id = 25;
delete from T_operation_r_role where role_id = 1 and opt_id = 22;
delete from T_operation_r_role where role_id = 1 and opt_id = 23;
delete from T_operation_r_role where role_id = 1 and opt_id = 24;
delete from T_operation_r_role where role_id = 1 and opt_id = 33;
delete from T_operation_r_role where role_id = 1 and opt_id = 34;
delete from T_operation_r_role where role_id = 1 and opt_id = 35;
delete from T_operation_r_role where role_id = 1 and opt_id = 36;
delete from T_operation_r_role where role_id = 1 and opt_id = 37;
delete from T_operation_r_role where role_id = 1 and opt_id = 39;
delete from T_operation_r_role where role_id = 1 and opt_id = 40;
delete from T_operation_r_role where role_id = 2 and opt_id = 15;
delete from T_operation_r_role where role_id = 2 and opt_id = 16;
delete from T_operation_r_role where role_id = 2 and opt_id = 20;
delete from T_operation_r_role where role_id = 2 and opt_id = 17;
delete from T_operation_r_role where role_id = 2 and opt_id = 18;
delete from T_operation_r_role where role_id = 2 and opt_id = 19;
delete from T_operation_r_role where role_id = 2 and opt_id = 21;
delete from T_operation_r_role where role_id = 2 and opt_id = 25;
delete from T_operation_r_role where role_id = 2 and opt_id = 22;
delete from T_operation_r_role where role_id = 2 and opt_id = 23;
delete from T_operation_r_role where role_id = 2 and opt_id = 24;
delete from T_operation_r_role where role_id = 2 and opt_id = 33;
delete from T_operation_r_role where role_id = 2 and opt_id = 34;
delete from T_operation_r_role where role_id = 2 and opt_id = 35;
delete from T_operation_r_role where role_id = 2 and opt_id = 36;
delete from T_operation_r_role where role_id = 2 and opt_id = 37;
delete from T_operation_r_role where role_id = 2 and opt_id = 39;
delete from T_operation_r_role where role_id = 2 and opt_id = 40;


--delete from T_operations where opt_id = 192;
update T_operations set serial_number = '8000-111' where opt_id = 4;
update T_operations set serial_number = '8000-111-20' where opt_id = 11;
update T_operations set serial_number = '8000-111-20-5' where opt_id = 14;
update T_operations set serial_number = '8000-111-20-10' where opt_id = 12;
update T_operations set serial_number = '8000-111-20-15' where opt_id = 13;
delete from T_operations where opt_id = 15;
delete from T_operations where opt_id = 16;
delete from T_operations where opt_id = 20;
delete from T_operations where opt_id = 17;
delete from T_operations where opt_id = 18;
delete from T_operations where opt_id = 19;
delete from T_operations where opt_id = 21;
delete from T_operations where opt_id = 25;
delete from T_operations where opt_id = 22;
delete from T_operations where opt_id = 23;
delete from T_operations where opt_id = 24;
delete from T_operations where opt_id = 33;
delete from T_operations where opt_id = 34;
delete from T_operations where opt_id = 35;
delete from T_operations where opt_id = 36;
delete from T_operations where opt_id = 37;
delete from T_operations where opt_id = 39;
delete from T_operations where opt_id = 40;
insert into T_licenseconsume values(1, 'NEMAL' , 'LNSHRICSMA031' , '744c841604a237b32daee986d16d15ef.'  );
insert into T_licenseconsume values(2, 'NEMAL' , 'LNSHRICSMB031' , '744c841604a237b32daee986d16d15ef.'  );
insert into T_licenseconsume values(3, 'NEMAL' , 'LNSHRICSMC31' , '744c841604a237b32daee986d16d15ef.'  );

insert into T_licenseconsume values(4, 'NEMAL' , 'LNSHRICSIA031' , '744c841604a237b32daee986d16d15ef.'  );
insert into T_licenseconsume values(5, 'NEMAL' , 'LNSHRICSIB031' , '744c841604a237b32daee986d16d15ef.'  );
insert into T_licenseconsume values(6, 'NEMAL' , 'LNSHRICSIC31' , '744c841604a237b32daee986d16d15ef.'  );

insert into T_licenseconsume values(7, 'NEMAL' , 'LNSHRICSRA031' , '744c841604a237b32daee986d16d15ef.'  );
insert into T_licenseconsume values(8, 'NEMAL' , 'LNSHRICSRB031' , '744c841604a237b32daee986d16d15ef.'  );
insert into T_licenseconsume values(9, 'NEMAL' , 'LNSHRICSRC31' , '744c841604a237b32daee986d16d15ef.'  );

insert into T_licenseconsume values(10, 'NEMAL' , 'LNSHRICSMH31' , '744c841604a237b32daee986d16d15ef.'  );

insert into T_licenseconsume values(11, 'MFUNCP' , 'LNSHFICSM031' , '744c841604a237b32daee986d16d15ef.'  );
insert into T_licenseconsume values(12, 'MFUNCP' , 'LNSHFICSI031' , '744c841604a237b32daee986d16d15ef.'  );
insert into T_licenseconsume values(13, 'MFUNCP' , 'LNSHFICSR031' , '744c841604a237b32daee986d16d15ef.'  );
insert into T_licenseconsume values(14, 'MFUNCP' , 'LNSHFICSN031' , '744c841604a237b32daee986d16d15ef.'  );

insert into T_licenseconsumepolicy values(1, 'NEMAL' , 'LNSHRICSMA031' ,1, 1, 1);
insert into T_licenseconsumepolicy values(2, 'NEMAL' , 'LNSHRICSMB031' ,1, 1, 2);
insert into T_licenseconsumepolicy values(3, 'NEMAL' , 'LNSHRICSMC31' ,1, 1, 3);

insert into T_licenseconsumepolicy values(4, 'NEMAL' , 'LNSHRICSIA031' ,1, 1, 4);
insert into T_licenseconsumepolicy values(5, 'NEMAL' , 'LNSHRICSIB031' ,1, 1, 5);
insert into T_licenseconsumepolicy values(6, 'NEMAL' , 'LNSHRICSIC31' ,1, 1, 6);

insert into T_licenseconsumepolicy values(7, 'NEMAL' , 'LNSHRICSRA031' ,1, 1, 7);
insert into T_licenseconsumepolicy values(8, 'NEMAL' , 'LNSHRICSRB031' ,1, 1, 8);
insert into T_licenseconsumepolicy values(9, 'NEMAL' , 'LNSHRICSRC31' ,1, 1, 9);

insert into T_licenseconsumepolicy values(10, 'NEMAL' , 'LNSHRICSMH31' ,1, 1, 10);
delete from T_operation_r_role where role_id = 1 and opt_id = 13;
delete from T_operation_r_role where role_id = 2 and opt_id = 13;
delete from T_operation_r_role where role_id = 1 and opt_id = 73;
delete from T_operation_r_role where role_id = 2 and opt_id = 73;
delete from T_operation_r_role where role_id = 1 and opt_id = 116;
delete from T_operation_r_role where role_id = 2 and opt_id = 116;
delete from T_operation_r_role where role_id = 1 and opt_id = 117;
delete from T_operation_r_role where role_id = 2 and opt_id = 117;
delete from T_operation_r_role where role_id = 1 and opt_id = 118;
delete from T_operation_r_role where role_id = 2 and opt_id = 118;
delete from T_operation_r_role where role_id = 1 and opt_id = 119;
delete from T_operation_r_role where role_id = 2 and opt_id = 119;
delete from T_operation_r_role where role_id = 1 and opt_id = 120;
delete from T_operation_r_role where role_id = 2 and opt_id = 120;
delete from T_operation_r_role where role_id = 1 and opt_id = 122;
delete from T_operation_r_role where role_id = 2 and opt_id = 122;
delete from T_operation_r_role where role_id = 1 and opt_id = 123;
delete from T_operation_r_role where role_id = 2 and opt_id = 123;
delete from T_operation_r_role where role_id = 1 and opt_id = 124;
delete from T_operation_r_role where role_id = 2 and opt_id = 124;
delete from T_operation_r_role where role_id = 1 and opt_id = 125;
delete from T_operation_r_role where role_id = 2 and opt_id = 125;
delete from T_operation_r_role where role_id = 1 and opt_id = 130;
delete from T_operation_r_role where role_id = 2 and opt_id = 130;
delete from T_operation_r_role where role_id = 3 and opt_id = 130;
delete from T_operation_r_role where role_id = 1 and opt_id = 210;
delete from T_operation_r_role where role_id = 2 and opt_id = 210;
delete from T_operation_r_role where role_id = 1 and opt_id = 9000;
delete from T_operation_r_role where role_id = 2 and opt_id = 9000;
delete from T_operation_r_role where role_id = 1 and opt_id = 9085;
delete from T_operation_r_role where role_id = 2 and opt_id = 9085;
delete from T_operation_r_role where role_id = 1 and opt_id = 9087;
delete from T_operation_r_role where role_id = 2 and opt_id = 9087;
delete from T_operation_r_role where role_id = 1 and opt_id = 9200;
delete from T_operation_r_role where role_id = 2 and opt_id = 9200;
delete from T_operation_r_role where role_id = 1 and opt_id = 9202;
delete from T_operation_r_role where role_id = 2 and opt_id = 9202;
delete from T_operation_r_role where role_id = 1 and opt_id = 9300;
delete from T_operation_r_role where role_id = 2 and opt_id = 9300;
delete from T_operation_r_role where role_id = 1 and opt_id = 9301;
delete from T_operation_r_role where role_id = 2 and opt_id = 9301;
delete from T_operation_r_role where role_id = 1 and opt_id = 9302;
delete from T_operation_r_role where role_id = 2 and opt_id = 9302;
delete from T_operation_r_role where role_id = 1 and opt_id = 9303;
delete from T_operation_r_role where role_id = 2 and opt_id = 9303;
delete from T_operation_r_role where role_id = 1 and opt_id = 9304;
delete from T_operation_r_role where role_id = 2 and opt_id = 9304;
delete from T_operation_r_role where role_id = 1 and opt_id = 9305;
delete from T_operation_r_role where role_id = 2 and opt_id = 9305;
delete from T_operation_r_role where role_id = 1 and opt_id = 9306;
delete from T_operation_r_role where role_id = 2 and opt_id = 9306;
delete from T_operation_r_role where role_id = 1 and opt_id = 9308;
delete from T_operation_r_role where role_id = 2 and opt_id = 9308;
delete from T_operations where opt_id = 13;
delete from T_operations where opt_id = 73;
delete from T_operations where opt_id = 116;
delete from T_operations where opt_id = 117;
delete from T_operations where opt_id = 118;
delete from T_operations where opt_id = 119;
delete from T_operations where opt_id = 120;
delete from T_operations where opt_id = 122;
delete from T_operations where opt_id = 123;
delete from T_operations where opt_id = 124;
delete from T_operations where opt_id = 125;
delete from T_operations where opt_id = 130;
delete from T_operations where opt_id = 210;
delete from T_operations where opt_id = 9000;
delete from T_operations where opt_id = 9085;
delete from T_operations where opt_id = 9087;
delete from T_operations where opt_id = 9200;
delete from T_operations where opt_id = 9202;
delete from T_operations where opt_id = 9203;
delete from T_operations where opt_id = 9204;
delete from T_operations where opt_id = 9205;
delete from T_operations where opt_id = 9206;
delete from T_operations where opt_id = 9300;
delete from T_operations where opt_id = 9301;
delete from T_operations where opt_id = 9302;
delete from T_operations where opt_id = 9303;
delete from T_operations where opt_id = 9304;
delete from T_operations where opt_id = 9305;
delete from T_operations where opt_id = 9306;
delete from T_operations where opt_id = 9308;
delete from T_role where role_id in (4); 
insert into T_role values(4,'11','20100203','NBIRole','ThirdPart System User Group',1);

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(13, 'lego.sys.discover.discovedDevice.modify', '', '', 0, '8000-150-1-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 13);
insert into T_operation_r_role (role_id, opt_id) values (2, 13);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(130, 'ism.drm.settings.menuname', '/cbb/admin/adminList.do', '', 0, '8000');
insert into T_operation_r_role (role_id, opt_id) values (1, 130);
insert into T_operation_r_role (role_id, opt_id) values (2, 130);
insert into T_operation_r_role (role_id, opt_id) values (3, 130);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9000, 'ism.drm.protection.menuname', '', '', 0, '2050');
insert into T_operation_r_role (role_id, opt_id) values (1, 9000);
insert into T_operation_r_role (role_id, opt_id) values (2, 9000);
insert into T_operation_r_role (role_id, opt_id) values (4, 9000);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9085, 'ism.drm.protect.policy.template.management.menuname', '', '', 0, '2050-300');
insert into T_operation_r_role (role_id, opt_id) values (1, 9085);
insert into T_operation_r_role (role_id, opt_id) values (2, 9085);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9087, 'ism.drm.protect.policy.template.auth.scan', '', '', 1, '2050-300-100-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9087);
insert into T_operation_r_role (role_id, opt_id) values (2, 9087);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9200, 'ism.drm.monitor.topology.mgt.menuname', '', '', 0, '6000-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 9200);
insert into T_operation_r_role (role_id, opt_id) values (2, 9200);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9202, 'ism.drm.monitor.gloable.topo.auth.scan', '', '', 1, '6000-50-10-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9202);
insert into T_operation_r_role (role_id, opt_id) values (2, 9202);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9300, 'ism.drm.site.mgt.menuname', '', '', 0, '8000-150');
insert into T_operation_r_role (role_id, opt_id) values (1, 9300);
insert into T_operation_r_role (role_id, opt_id) values (2, 9300);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9301, 'ism.drm.site.menuname', '/ism/drm/site/listSite.do', '', 0, '8000-150-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9301);
insert into T_operation_r_role (role_id, opt_id) values (2, 9301);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9302, 'ism.drm.site.auth.scan', '', '', 1, '8000-150-1-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9302);
insert into T_operation_r_role (role_id, opt_id) values (2, 9302);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9303, 'ism.drm.site.auth.add', '', '', 0, '8000-150-1-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 9303);
insert into T_operation_r_role (role_id, opt_id) values (2, 9303);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9304, 'ism.drm.site.auth.modify', '', '', 0, '8000-150-1-3');
insert into T_operation_r_role (role_id, opt_id) values (1, 9304);
insert into T_operation_r_role (role_id, opt_id) values (2, 9304);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9305, 'ism.drm.site.auth.delete', '', '', 0, '8000-150-1-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 9305);
insert into T_operation_r_role (role_id, opt_id) values (2, 9305);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9306, 'ism.drm.site.auth.refresh', '', '', 0, '8000-150-1-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 9306);
insert into T_operation_r_role (role_id, opt_id) values (2, 9306);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9308, 'ism.drm.storage.management', '', '', 0, '8000-150-1-7');
insert into T_operation_r_role (role_id, opt_id) values (1, 9308);
insert into T_operation_r_role (role_id, opt_id) values (2, 9308);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9371, 'ism.drm.dump.configdata', '/ism/drm/base/ConfigExportPage.do', '', 0, '8000-500-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 9371);
insert into T_operation_r_role (role_id, opt_id) values (2, 9371);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9372, 'ism.drm.dump.configdata.scan', '', '', 0, '8000-500-40-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9372);
insert into T_operation_r_role (role_id, opt_id) values (2, 9372);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9373, 'ism.drm.sys.exportrlog', '/ism/drm/base/logsExportPage.do', '', 0, '8000-600-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 9373);
insert into T_operation_r_role (role_id, opt_id) values (2, 9373);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9374, 'ism.drm.sys.exportrlog.scan', '', '', 0, '8000-600-20-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9374);
insert into T_operation_r_role (role_id, opt_id) values (2, 9374);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(73, 'ism.drm.monitor.menuname', '/nem/fault/getAllAlarmList.do', '', 0, '6000');
insert into T_operation_r_role (role_id, opt_id) values (1, 73);
insert into T_operation_r_role (role_id, opt_id) values (2, 73);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(116, 'lego.event.notify.message', '/nem/fault/getAllNotifyRuleList.do', '', 0, '6000-100-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 116);
insert into T_operation_r_role (role_id, opt_id) values (2, 116);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(117, 'lego.event.notify.scan', '', '', 1, '6000-100-40-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 117);
insert into T_operation_r_role (role_id, opt_id) values (2, 117);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(118, 'lego.event.notify.add', '', '', 0, '6000-100-40-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 118);
insert into T_operation_r_role (role_id, opt_id) values (2, 118);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(119, 'lego.event.notify.delete', '', '', 0, '6000-100-40-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 119);
insert into T_operation_r_role (role_id, opt_id) values (2, 119);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(122, 'lego.event.notify.modify', '', '', 0, '6000-100-40-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 122);
insert into T_operation_r_role (role_id, opt_id) values (2, 122);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(120, 'lego.event.notify.start', '', '', 0, '6000-100-40-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 120);
insert into T_operation_r_role (role_id, opt_id) values (2, 120);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(210, 'lego.event.notify.pathset', '', '', 0, '6000-100-40-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 210);
insert into T_operation_r_role (role_id, opt_id) values (2, 210);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(123, 'lego.event.voice', '/nem/fault/getAudioSetting.do', '', 0, '6000-100-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 123);
insert into T_operation_r_role (role_id, opt_id) values (2, 123);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(124, 'lego.event.voice.scan', '', '', 1, '6000-100-50-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 124);
insert into T_operation_r_role (role_id, opt_id) values (2, 124);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(125, 'lego.event.voice.modify', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 125);
insert into T_operation_r_role (role_id, opt_id) values (2, 125);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9379, 'ism.drm.home.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9379);
insert into T_operation_r_role (role_id, opt_id) values (2, 9379);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9380, 'ism.drm.task.mgt.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9380);
insert into T_operation_r_role (role_id, opt_id) values (2, 9380);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9381, 'ism.drm.task.mgt.delete.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9381);
insert into T_operation_r_role (role_id, opt_id) values (2, 9381);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9123, 'ism.drm.drp.auth.recoverysetting.modify.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9123);
insert into T_operation_r_role (role_id, opt_id) values (2, 9123);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9211, 'ism.drm.monitor.gloable.topo.auth.set.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9211);
insert into T_operation_r_role (role_id, opt_id) values (2, 9211);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9350, 'ism.drm.resource.mgt.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9350);
insert into T_operation_r_role (role_id, opt_id) values (2, 9350);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9351, 'ism.drm.resource.mgt.scan.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9351);
insert into T_operation_r_role (role_id, opt_id) values (2, 9351);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9353, 'ism.drm.resource.mgt.modify.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9353);
insert into T_operation_r_role (role_id, opt_id) values (2, 9353);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9354, 'ism.drm.resource.mgt.delete.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9354);
insert into T_operation_r_role (role_id, opt_id) values (2, 9354);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9356, 'ism.drm.resource.mgt.refresh.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9356);
insert into T_operation_r_role (role_id, opt_id) values (2, 9356);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9355, 'ism.drm.resource.mgt.jumpToDevMgr.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9355);
insert into T_operation_r_role (role_id, opt_id) values (2, 9355);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9377, 'ism.drm.dump.configdata.setting.operateID', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9377);
insert into T_operation_r_role (role_id, opt_id) values (2, 9377);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9004, 'ism.drm.protectgroup.menuname', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9004);
insert into T_operation_r_role (role_id, opt_id) values (2, 9004);
insert into T_operation_r_role (role_id, opt_id) values (4, 9004);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9006, 'ism.drm.protectgroup.auth.scan', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9006);
insert into T_operation_r_role (role_id, opt_id) values (2, 9006);
insert into T_operation_r_role (role_id, opt_id) values (4, 9006);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9007, 'ism.drm.protectgroup.auth.add', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9007);
insert into T_operation_r_role (role_id, opt_id) values (2, 9007);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9008, 'ism.drm.protectgroup.auth.modify', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9008);
insert into T_operation_r_role (role_id, opt_id) values (2, 9008);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9009, 'ism.drm.protectgroup.auth.delete', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9009);
insert into T_operation_r_role (role_id, opt_id) values (2, 9009);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9010, 'ism.drm.protectgroup.auth.execute', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9010);
insert into T_operation_r_role (role_id, opt_id) values (2, 9010);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9011, 'ism.drm.protectgroup.auth.disable', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9011);
insert into T_operation_r_role (role_id, opt_id) values (2, 9011);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9012, 'ism.drm.protectgroup.auth.enable', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9012);
insert into T_operation_r_role (role_id, opt_id) values (2, 9012);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9013, 'ism.drm.protectgroup.auth.export', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9013);
insert into T_operation_r_role (role_id, opt_id) values (2, 9013);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9014, 'ism.drm.protectgroup.auth.refresh', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9014);
insert into T_operation_r_role (role_id, opt_id) values (2, 9014);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9088, 'ism.drm.12.protectgroup.auth.management', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9088);
insert into T_operation_r_role (role_id, opt_id) values (2, 9088);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9100, 'ism.drm.disaster.recovery.menuname', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9100);
insert into T_operation_r_role (role_id, opt_id) values (2, 9100);
insert into T_operation_r_role (role_id, opt_id) values (4, 9100);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9105, 'ism.drm.drp.auth.scan', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9105);
insert into T_operation_r_role (role_id, opt_id) values (2, 9105);
insert into T_operation_r_role (role_id, opt_id) values (4, 9105);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9106, 'ism.drm.drp.auth.add', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9106);
insert into T_operation_r_role (role_id, opt_id) values (2, 9106);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9109, 'ism.drm.drp.auth.modify', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9109);
insert into T_operation_r_role (role_id, opt_id) values (2, 9109);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9110, 'ism.drm.drp.auth.delete', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9110);
insert into T_operation_r_role (role_id, opt_id) values (2, 9110);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9121, 'ism.drm.drp.local.auth.rollback', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9121);
insert into T_operation_r_role (role_id, opt_id) values (2, 9121);
insert into T_operation_r_role (role_id, opt_id) values (4, 9121);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9111, 'ism.drm.drp.auth.test', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9111);
insert into T_operation_r_role (role_id, opt_id) values (2, 9111);
insert into T_operation_r_role (role_id, opt_id) values (4, 9111);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9112, 'ism.drm.drp.auth.cleartest', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9112);
insert into T_operation_r_role (role_id, opt_id) values (2, 9112);
insert into T_operation_r_role (role_id, opt_id) values (4, 9112);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9107, 'ism.drm.drp.auth.planed.motion', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9107);
insert into T_operation_r_role (role_id, opt_id) values (2, 9107);
insert into T_operation_r_role (role_id, opt_id) values (4, 9107);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9108, 'ism.drm.drp.auth.disaster.recovery', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9108);
insert into T_operation_r_role (role_id, opt_id) values (2, 9108);
insert into T_operation_r_role (role_id, opt_id) values (4, 9108);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9113, 'ism.drm.drp.auth.reprotect', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9113);
insert into T_operation_r_role (role_id, opt_id) values (2, 9113);
insert into T_operation_r_role (role_id, opt_id) values (4, 9113);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9124, 'ism.drm.drp.auth.recoverymapping.export', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9124);
insert into T_operation_r_role (role_id, opt_id) values (2, 9124);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9203, 'ism.drm.monitor.report.mgt.menuname', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9203);
insert into T_operation_r_role (role_id, opt_id) values (2, 9203);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9204, 'ism.drm.report.protection.menuname', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9204);
insert into T_operation_r_role (role_id, opt_id) values (2, 9204);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9205, 'ism.drm.report.protection.auth.scan', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9205);
insert into T_operation_r_role (role_id, opt_id) values (2, 9205);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9206, 'ism.drm.report.protection.auth.exportxls', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9206);
insert into T_operation_r_role (role_id, opt_id) values (2, 9206);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9207, 'ism.drm.report.recovery.menuname', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9207);
insert into T_operation_r_role (role_id, opt_id) values (2, 9207);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9208, 'ism.drm.report.rp.auth.scan', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9208);
insert into T_operation_r_role (role_id, opt_id) values (2, 9208);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9209, 'ism.drm.report.rp.auth.exportxls', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9209);
insert into T_operation_r_role (role_id, opt_id) values (2, 9209);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9375, 'ism.drm.dump.software.doc.menuname', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9375);
insert into T_operation_r_role (role_id, opt_id) values (2, 9375);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9376, 'ism.drm.dump.software.doc.scan', '', '', 0, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9376);
insert into T_operation_r_role (role_id, opt_id) values (2, 9376);

delete from T_operation_r_role where role_id = 1 and opt_id = 94;
delete from T_operation_r_role where role_id = 2 and opt_id = 94;
delete from T_operation_r_role where role_id = 1 and opt_id = 95;
delete from T_operation_r_role where role_id = 2 and opt_id = 95;
delete from T_operation_r_role where role_id = 1 and opt_id = 96;
delete from T_operation_r_role where role_id = 2 and opt_id = 96;
delete from T_operation_r_role where role_id = 1 and opt_id = 97;
delete from T_operation_r_role where role_id = 2 and opt_id = 97;
delete from T_operation_r_role where role_id = 1 and opt_id = 99;
delete from T_operation_r_role where role_id = 2 and opt_id = 99;
delete from T_operation_r_role where role_id = 1 and opt_id = 98;
delete from T_operation_r_role where role_id = 2 and opt_id = 98;
delete from T_operation_r_role where role_id = 1 and opt_id = 100;
delete from T_operation_r_role where role_id = 2 and opt_id = 100;
delete from T_operation_r_role where role_id = 1 and opt_id = 101;
delete from T_operation_r_role where role_id = 2 and opt_id = 101;
delete from T_operation_r_role where role_id = 1 and opt_id = 102;
delete from T_operation_r_role where role_id = 2 and opt_id = 102;
delete from T_operation_r_role where role_id = 1 and opt_id = 103;
delete from T_operation_r_role where role_id = 2 and opt_id = 103;
delete from T_operation_r_role where role_id = 1 and opt_id = 104;
delete from T_operation_r_role where role_id = 2 and opt_id = 104;
delete from T_operation_r_role where role_id = 1 and opt_id = 105;
delete from T_operation_r_role where role_id = 2 and opt_id = 105;
delete from T_operation_r_role where role_id = 1 and opt_id = 106;
delete from T_operation_r_role where role_id = 2 and opt_id = 106;
delete from T_operation_r_role where role_id = 1 and opt_id = 107;
delete from T_operation_r_role where role_id = 2 and opt_id = 107;
delete from T_operation_r_role where role_id = 1 and opt_id = 110;
delete from T_operation_r_role where role_id = 2 and opt_id = 110;
delete from T_operation_r_role where role_id = 1 and opt_id = 108;
delete from T_operation_r_role where role_id = 2 and opt_id = 108;
delete from T_operation_r_role where role_id = 1 and opt_id = 111;
delete from T_operation_r_role where role_id = 2 and opt_id = 111;
delete from T_operation_r_role where role_id = 1 and opt_id = 112;
delete from T_operation_r_role where role_id = 2 and opt_id = 112;
delete from T_operation_r_role where role_id = 1 and opt_id = 113;
delete from T_operation_r_role where role_id = 2 and opt_id = 113;
delete from T_operation_r_role where role_id = 1 and opt_id = 185;
delete from T_operation_r_role where role_id = 2 and opt_id = 185;
delete from T_operation_r_role where role_id = 1 and opt_id = 186;
delete from T_operation_r_role where role_id = 2 and opt_id = 186;
delete from T_operation_r_role where role_id = 1 and opt_id = 187;
delete from T_operation_r_role where role_id = 2 and opt_id = 187;
delete from T_operation_r_role where role_id = 1 and opt_id = 188;
delete from T_operation_r_role where role_id = 2 and opt_id = 188;
delete from T_operation_r_role where role_id = 1 and opt_id = 189;
delete from T_operation_r_role where role_id = 2 and opt_id = 189;
delete from T_operation_r_role where role_id = 1 and opt_id = 191;
delete from T_operation_r_role where role_id = 2 and opt_id = 191;
delete from T_operation_r_role where role_id = 1 and opt_id = 192;
delete from T_operation_r_role where role_id = 2 and opt_id = 192;
delete from T_operation_r_role where role_id = 1 and opt_id = 193;
delete from T_operation_r_role where role_id = 2 and opt_id = 193;
delete from T_operation_r_role where role_id = 1 and opt_id = 194;
delete from T_operation_r_role where role_id = 2 and opt_id = 194;
delete from T_operation_r_role where role_id = 1 and opt_id = 195;
delete from T_operation_r_role where role_id = 2 and opt_id = 195;
delete from T_operation_r_role where role_id = 1 and opt_id = 196;
delete from T_operation_r_role where role_id = 2 and opt_id = 196;
delete from T_operation_r_role where role_id = 1 and opt_id = 197;
delete from T_operation_r_role where role_id = 2 and opt_id = 197;
delete from T_operation_r_role where role_id = 1 and opt_id = 300;
delete from T_operation_r_role where role_id = 2 and opt_id = 300;
delete from T_operation_r_role where role_id = 1 and opt_id = 301;
delete from T_operation_r_role where role_id = 2 and opt_id = 301;
delete from T_operation_r_role where role_id = 1 and opt_id = 302;
delete from T_operation_r_role where role_id = 2 and opt_id = 302;
delete from T_operation_r_role where role_id = 1 and opt_id = 303;
delete from T_operation_r_role where role_id = 2 and opt_id = 303;
delete from T_operation_r_role where role_id = 1 and opt_id = 304;
delete from T_operation_r_role where role_id = 2 and opt_id = 304;
delete from T_operations where opt_id = 94;
delete from T_operations where opt_id = 95;
delete from T_operations where opt_id = 96;
delete from T_operations where opt_id = 97;
delete from T_operations where opt_id = 99;
delete from T_operations where opt_id = 98;
delete from T_operations where opt_id = 100;
delete from T_operations where opt_id = 101;
delete from T_operations where opt_id = 102;
delete from T_operations where opt_id = 103;
delete from T_operations where opt_id = 104;
delete from T_operations where opt_id = 105;
delete from T_operations where opt_id = 106;
delete from T_operations where opt_id = 107;
delete from T_operations where opt_id = 110;
delete from T_operations where opt_id = 108;
delete from T_operations where opt_id = 111;
delete from T_operations where opt_id = 112;
delete from T_operations where opt_id = 113;
delete from T_operations where opt_id = 185;
delete from T_operations where opt_id = 186;
delete from T_operations where opt_id = 187;
delete from T_operations where opt_id = 188;
delete from T_operations where opt_id = 189;
delete from T_operations where opt_id = 191;
delete from T_operations where opt_id = 192;
delete from T_operations where opt_id = 193;
delete from T_operations where opt_id = 194;
delete from T_operations where opt_id = 195;
delete from T_operations where opt_id = 196;
delete from T_operations where opt_id = 197;
delete from T_operations where opt_id = 300;
delete from T_operations where opt_id = 301;
delete from T_operations where opt_id = 302;
delete from T_operations where opt_id = 303;
delete from T_operations where opt_id = 304;
delete from T_operation_r_role where role_id = 1 and opt_id = 6600;
delete from T_operation_r_role where role_id = 2 and opt_id = 6600;
delete from T_operation_r_role where role_id = 1 and opt_id = 6610;
delete from T_operation_r_role where role_id = 2 and opt_id = 6610;
delete from T_operation_r_role where role_id = 1 and opt_id = 6611;
delete from T_operation_r_role where role_id = 2 and opt_id = 6611;
delete from T_operation_r_role where role_id = 1 and opt_id = 6612;
delete from T_operation_r_role where role_id = 2 and opt_id = 6612;
delete from T_operation_r_role where role_id = 1 and opt_id = 3;
delete from T_operation_r_role where role_id = 2 and opt_id = 3;
delete from T_operation_r_role where role_id = 1 and opt_id = 205;
delete from T_operation_r_role where role_id = 2 and opt_id = 205;
delete from T_operation_r_role where role_id = 1 and opt_id = 206;
delete from T_operation_r_role where role_id = 2 and opt_id = 206;
delete from T_operation_r_role where role_id = 1 and opt_id = 207;
delete from T_operation_r_role where role_id = 2 and opt_id = 207;
delete from T_operation_r_role where role_id = 1 and opt_id = 208;
delete from T_operation_r_role where role_id = 2 and opt_id = 208;
delete from T_operation_r_role where role_id = 1 and opt_id = 210;
delete from T_operation_r_role where role_id = 2 and opt_id = 210;
delete from T_operation_r_role where role_id = 1 and opt_id = 250;
delete from T_operation_r_role where role_id = 2 and opt_id = 250;
delete from T_operation_r_role where role_id = 1 and opt_id = 251;
delete from T_operation_r_role where role_id = 2 and opt_id = 251;
delete from T_operation_r_role where role_id = 1 and opt_id = 252;
delete from T_operation_r_role where role_id = 2 and opt_id = 252;
delete from T_operation_r_role where role_id = 1 and opt_id = 71;
delete from T_operation_r_role where role_id = 2 and opt_id = 71;
delete from T_operation_r_role where role_id = 1 and opt_id = 72;
delete from T_operation_r_role where role_id = 2 and opt_id = 72;
delete from T_operation_r_role where role_id = 1 and opt_id = 86;
delete from T_operation_r_role where role_id = 2 and opt_id = 86;
delete from T_operation_r_role where role_id = 1 and opt_id = 87;
delete from T_operation_r_role where role_id = 2 and opt_id = 87;
delete from T_operation_r_role where role_id = 1 and opt_id = 88;
delete from T_operation_r_role where role_id = 2 and opt_id = 88;
delete from T_operations where opt_id = 6600;
delete from T_operations where opt_id = 6610;
delete from T_operations where opt_id = 6611;
delete from T_operations where opt_id = 6612;
delete from T_operations where opt_id = 3;
delete from T_operations where opt_id = 205;
delete from T_operations where opt_id = 206;
delete from T_operations where opt_id = 207;
delete from T_operations where opt_id = 208;
delete from T_operations where opt_id = 210;
delete from T_operations where opt_id = 250;
delete from T_operations where opt_id = 251;
delete from T_operations where opt_id = 252;
delete from T_operations where opt_id = 71;
delete from T_operations where opt_id = 72;
delete from T_operations where opt_id = 86;
delete from T_operations where opt_id = 87;
delete from T_operations where opt_id = 88;
--delete from rdv1r3c00
delete from T_operation_r_role where opt_id = 9001;
delete from T_operation_r_role where opt_id = 9002;
delete from T_operation_r_role where opt_id = 9003;
delete from T_operation_r_role where opt_id = 9086;
delete from T_operation_r_role where opt_id = 9201;
delete from T_operation_r_role where opt_id = 92;
delete from T_operation_r_role where opt_id = 115;
delete from T_operation_r_role where opt_id = 4;
delete from T_operation_r_role where opt_id = 11;
delete from T_operation_r_role where opt_id = 12;
delete from T_operation_r_role where opt_id = 13;
delete from T_operation_r_role where opt_id = 14;
delete from T_operation_r_role where opt_id = 173;
delete from T_operation_r_role where opt_id = 182;
delete from T_operation_r_role where opt_id = 183;
delete from T_operation_r_role where opt_id = 184;
delete from T_operation_r_role where opt_id = 500;
delete from T_operation_r_role where opt_id = 501;
delete from T_operation_r_role where opt_id = 9307;
delete from T_operation_r_role where opt_id = 9308;
delete from T_operation_r_role where opt_id = 9309;
delete from T_operation_r_role where opt_id = 9310;
delete from T_operation_r_role where opt_id = 9311;
delete from T_operations where opt_id = 9001;
delete from T_operations where opt_id = 9002;
delete from T_operations where opt_id = 9003;
delete from T_operations where opt_id = 9086;
delete from T_operations where opt_id = 9201;
delete from T_operations where opt_id = 92;
delete from T_operations where opt_id = 115;
delete from T_operations where opt_id = 4;
delete from T_operations where opt_id = 11;
delete from T_operations where opt_id = 12;
delete from T_operations where opt_id = 13;
delete from T_operations where opt_id = 14;
delete from T_operations where opt_id = 173;
delete from T_operations where opt_id = 182;
delete from T_operations where opt_id = 183;
delete from T_operations where opt_id = 184;
delete from T_operations where opt_id = 500;
delete from T_operations where opt_id = 501;
delete from T_operations where opt_id = 9307;
delete from T_operations where opt_id = 9308;
delete from T_operations where opt_id = 9309;
delete from T_operations where opt_id = 9310;
delete from T_operations where opt_id = 9311;
--new from rdv1r3c10
delete from T_operation_r_role where opt_id = 9379;
delete from T_operations where opt_id = 9379;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9379, 'ism.drm.home.operateID', '', '', false, '2040');
insert into T_operation_r_role (role_id, opt_id) values (1, 9379);
insert into T_operation_r_role (role_id, opt_id) values (2, 9379);
delete from T_operation_r_role where opt_id = 9380;
delete from T_operations where opt_id = 9380;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9380, 'ism.drm.task.mgt.operateID', '', '', false, '2040-100');
insert into T_operation_r_role (role_id, opt_id) values (1, 9380);
insert into T_operation_r_role (role_id, opt_id) values (2, 9380);
delete from T_operation_r_role where opt_id = 9381;
delete from T_operations where opt_id = 9381;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9381, 'ism.drm.task.mgt.delete.operateID', '', '', false, '2040-100-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9381);
insert into T_operation_r_role (role_id, opt_id) values (2, 9381);
delete from T_operation_r_role where opt_id = 9000;
delete from T_operations where opt_id = 9000;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9000, 'ism.drm.protection.menuname', '', '', false, '2050');
insert into T_operation_r_role (role_id, opt_id) values (1, 9000);
insert into T_operation_r_role (role_id, opt_id) values (2, 9000);
insert into T_operation_r_role (role_id, opt_id) values (4, 9000);
delete from T_operation_r_role where opt_id = 9004;
delete from T_operations where opt_id = 9004;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9004, 'ism.drm.protectgroup.menuname', '', '', false, '2050-200');
insert into T_operation_r_role (role_id, opt_id) values (1, 9004);
insert into T_operation_r_role (role_id, opt_id) values (2, 9004);
insert into T_operation_r_role (role_id, opt_id) values (4, 9004);
delete from T_operation_r_role where opt_id = 9006;
delete from T_operations where opt_id = 9006;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9006, 'ism.drm.protectgroup.auth.scan', '', '', false, '2050-200-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9006);
insert into T_operation_r_role (role_id, opt_id) values (2, 9006);
insert into T_operation_r_role (role_id, opt_id) values (4, 9006);
delete from T_operation_r_role where opt_id = 9007;
delete from T_operations where opt_id = 9007;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9007, 'ism.drm.protectgroup.auth.add', '', '', false, '2050-200-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 9007);
insert into T_operation_r_role (role_id, opt_id) values (2, 9007);
delete from T_operation_r_role where opt_id = 9008;
delete from T_operations where opt_id = 9008;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9008, 'ism.drm.protectgroup.auth.modify', '', '', false, '2050-200-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 9008);
insert into T_operation_r_role (role_id, opt_id) values (2, 9008);
delete from T_operation_r_role where opt_id = 9009;
delete from T_operations where opt_id = 9009;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9009, 'ism.drm.protectgroup.auth.delete', '', '', false, '2050-200-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 9009);
insert into T_operation_r_role (role_id, opt_id) values (2, 9009);
delete from T_operation_r_role where opt_id = 9010;
delete from T_operations where opt_id = 9010;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9010, 'ism.drm.protectgroup.auth.execute', '', '', false, '2050-200-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 9010);
insert into T_operation_r_role (role_id, opt_id) values (2, 9010);
delete from T_operation_r_role where opt_id = 9011;
delete from T_operations where opt_id = 9011;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9011, 'ism.drm.protectgroup.auth.disable', '', '', false, '2050-200-35');
insert into T_operation_r_role (role_id, opt_id) values (1, 9011);
insert into T_operation_r_role (role_id, opt_id) values (2, 9011);
delete from T_operation_r_role where opt_id = 9012;
delete from T_operations where opt_id = 9012;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9012, 'ism.drm.protectgroup.auth.enable', '', '', false, '2050-200-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 9012);
insert into T_operation_r_role (role_id, opt_id) values (2, 9012);
delete from T_operation_r_role where opt_id = 9013;
delete from T_operations where opt_id = 9013;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9013, 'ism.drm.protectgroup.auth.export', '', '', false, '2050-200-45');
insert into T_operation_r_role (role_id, opt_id) values (1, 9013);
insert into T_operation_r_role (role_id, opt_id) values (2, 9013);
delete from T_operation_r_role where opt_id = 9014;
delete from T_operations where opt_id = 9014;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9014, 'ism.drm.protectgroup.auth.refresh', '', '', false, '2050-200-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 9014);
insert into T_operation_r_role (role_id, opt_id) values (2, 9014);
delete from T_operation_r_role where opt_id = 9088;
delete from T_operations where opt_id = 9088;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9088, 'ism.drm.12.protectgroup.auth.management', '', '', false, '2050-200-55');
insert into T_operation_r_role (role_id, opt_id) values (1, 9088);
insert into T_operation_r_role (role_id, opt_id) values (2, 9088);
delete from T_operation_r_role where opt_id = 9100;
delete from T_operations where opt_id = 9100;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9100, 'ism.drm.disaster.recovery.menuname', '', '', false, '2060');
insert into T_operation_r_role (role_id, opt_id) values (1, 9100);
insert into T_operation_r_role (role_id, opt_id) values (2, 9100);
insert into T_operation_r_role (role_id, opt_id) values (4, 9100);
delete from T_operation_r_role where opt_id = 9105;
delete from T_operations where opt_id = 9105;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9105, 'ism.drm.drp.auth.scan', '', '', false, '2060-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9105);
insert into T_operation_r_role (role_id, opt_id) values (2, 9105);
insert into T_operation_r_role (role_id, opt_id) values (4, 9105);
delete from T_operation_r_role where opt_id = 9106;
delete from T_operations where opt_id = 9106;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9106, 'ism.drm.drp.auth.add', '', '', false, '2060-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 9106);
insert into T_operation_r_role (role_id, opt_id) values (2, 9106);
delete from T_operation_r_role where opt_id = 9109;
delete from T_operations where opt_id = 9109;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9109, 'ism.drm.drp.auth.modify', '', '', false, '2060-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 9109);
insert into T_operation_r_role (role_id, opt_id) values (2, 9109);
delete from T_operation_r_role where opt_id = 9110;
delete from T_operations where opt_id = 9110;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9110, 'ism.drm.drp.auth.delete', '', '', false, '2060-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 9110);
insert into T_operation_r_role (role_id, opt_id) values (2, 9110);
delete from T_operation_r_role where opt_id = 9121;
delete from T_operations where opt_id = 9121;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9121, 'ism.drm.drp.local.auth.rollback', '', '', false, '2060-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 9121);
insert into T_operation_r_role (role_id, opt_id) values (2, 9121);
insert into T_operation_r_role (role_id, opt_id) values (4, 9121);
delete from T_operation_r_role where opt_id = 9111;
delete from T_operations where opt_id = 9111;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9111, 'ism.drm.drp.auth.test', '', '', false, '2060-35');
insert into T_operation_r_role (role_id, opt_id) values (1, 9111);
insert into T_operation_r_role (role_id, opt_id) values (2, 9111);
insert into T_operation_r_role (role_id, opt_id) values (4, 9111);
delete from T_operation_r_role where opt_id = 9112;
delete from T_operations where opt_id = 9112;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9112, 'ism.drm.drp.auth.cleartest', '', '', false, '2060-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 9112);
insert into T_operation_r_role (role_id, opt_id) values (2, 9112);
insert into T_operation_r_role (role_id, opt_id) values (4, 9112);
delete from T_operation_r_role where opt_id = 9107;
delete from T_operations where opt_id = 9107;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9107, 'ism.drm.drp.auth.planed.motion', '', '', false, '2060-45');
insert into T_operation_r_role (role_id, opt_id) values (1, 9107);
insert into T_operation_r_role (role_id, opt_id) values (2, 9107);
insert into T_operation_r_role (role_id, opt_id) values (4, 9107);
delete from T_operation_r_role where opt_id = 9108;
delete from T_operations where opt_id = 9108;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9108, 'ism.drm.drp.auth.disaster.recovery', '', '', false, '2060-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 9108);
insert into T_operation_r_role (role_id, opt_id) values (2, 9108);
insert into T_operation_r_role (role_id, opt_id) values (4, 9108);
delete from T_operation_r_role where opt_id = 9113;
delete from T_operations where opt_id = 9113;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9113, 'ism.drm.drp.auth.reprotect', '', '', false, '2060-55');
insert into T_operation_r_role (role_id, opt_id) values (1, 9113);
insert into T_operation_r_role (role_id, opt_id) values (2, 9113);
insert into T_operation_r_role (role_id, opt_id) values (4, 9113);
delete from T_operation_r_role where opt_id = 9123;
delete from T_operations where opt_id = 9123;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9123, 'ism.drm.drp.auth.recoverysetting.modify.operateID', '', '', false, '2060-60');
insert into T_operation_r_role (role_id, opt_id) values (1, 9123);
insert into T_operation_r_role (role_id, opt_id) values (2, 9123);
delete from T_operation_r_role where opt_id = 9124;
delete from T_operations where opt_id = 9124;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9124, 'ism.drm.drp.auth.recoverymapping.export', '', '', false, '2060-65');
insert into T_operation_r_role (role_id, opt_id) values (1, 9124);
insert into T_operation_r_role (role_id, opt_id) values (2, 9124);
delete from T_operation_r_role where opt_id = 73;
delete from T_operations where opt_id = 73;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(73, 'ism.drm.monitor.menuname', '', '', false, '6000');
insert into T_operation_r_role (role_id, opt_id) values (1, 73);
insert into T_operation_r_role (role_id, opt_id) values (2, 73);
delete from T_operation_r_role where opt_id = 9200;
delete from T_operations where opt_id = 9200;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9200, 'ism.drm.monitor.topology.mgt.menuname', '', '', false, '6000-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 9200);
insert into T_operation_r_role (role_id, opt_id) values (2, 9200);
delete from T_operation_r_role where opt_id = 9202;
delete from T_operations where opt_id = 9202;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9202, 'ism.drm.monitor.gloable.topo.auth.scan', '', '', false, '6000-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9202);
insert into T_operation_r_role (role_id, opt_id) values (2, 9202);
delete from T_operation_r_role where opt_id = 9211;
delete from T_operations where opt_id = 9211;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9211, 'ism.drm.monitor.gloable.topo.auth.set.operateID', '', '', false, '6000-50-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 9211);
insert into T_operation_r_role (role_id, opt_id) values (2, 9211);
delete from T_operation_r_role where opt_id = 74;
delete from T_operations where opt_id = 74;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(74, 'lego.evtMgr', '', '', false, '6000-100');
insert into T_operation_r_role (role_id, opt_id) values (1, 74);
insert into T_operation_r_role (role_id, opt_id) values (2, 74);
delete from T_operation_r_role where opt_id = 75;
delete from T_operations where opt_id = 75;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(75, 'lego.evtMgr.curtAlarm', '', '', false, '6000-100-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 75);
insert into T_operation_r_role (role_id, opt_id) values (2, 75);
delete from T_operation_r_role where opt_id = 76;
delete from T_operations where opt_id = 76;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(76, 'lego.evtMgr.curtAlarm.scan', '', '', false, '6000-100-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 76);
insert into T_operation_r_role (role_id, opt_id) values (2, 76);
delete from T_operation_r_role where opt_id = 77;
delete from T_operations where opt_id = 77;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(77, 'lego.evtMgr.curtAlarm.clear', '', '', false, '6000-100-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 77);
insert into T_operation_r_role (role_id, opt_id) values (2, 77);
delete from T_operation_r_role where opt_id = 78;
delete from T_operations where opt_id = 78;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(78, 'lego.evtMgr.curtAlarm.confirm', '', '', false, '6000-100-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 78);
insert into T_operation_r_role (role_id, opt_id) values (2, 78);
delete from T_operation_r_role where opt_id = 91;
delete from T_operations where opt_id = 91;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(91, 'lego.evtMgr.curtAlarm.experiences', '', '', false, '6000-100-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 91);
insert into T_operation_r_role (role_id, opt_id) values (2, 91);
delete from T_operation_r_role where opt_id = 80;
delete from T_operations where opt_id = 80;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(80, 'lego.evtMgr.curtAlarm.export', '', '', false, '6000-100-10-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 80);
insert into T_operation_r_role (role_id, opt_id) values (2, 80);
delete from T_operation_r_role where opt_id = 82;
delete from T_operations where opt_id = 82;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(82, 'lego.evtMgr.hisAlarm', '', '', false, '6000-100-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 82);
insert into T_operation_r_role (role_id, opt_id) values (2, 82);
delete from T_operation_r_role where opt_id = 83;
delete from T_operations where opt_id = 83;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(83, 'lego.evtMgr.hisAlarm.scan', '', '', false, '6000-100-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 83);
insert into T_operation_r_role (role_id, opt_id) values (2, 83);
delete from T_operation_r_role where opt_id = 84;
delete from T_operations where opt_id = 84;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(84, 'lego.evtMgr.hisAlarm.export', '', '', false, '6000-100-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 84);
insert into T_operation_r_role (role_id, opt_id) values (2, 84);
delete from T_operation_r_role where opt_id = 116;
delete from T_operations where opt_id = 116;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(116, 'lego.event.notify.message', '', '', false, '6000-100-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 116);
insert into T_operation_r_role (role_id, opt_id) values (2, 116);
delete from T_operation_r_role where opt_id = 117;
delete from T_operations where opt_id = 117;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(117, 'lego.event.notify.scan', '', '', false, '6000-100-40-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 117);
insert into T_operation_r_role (role_id, opt_id) values (2, 117);
delete from T_operation_r_role where opt_id = 118;
delete from T_operations where opt_id = 118;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(118, 'lego.event.notify.add', '', '', false, '6000-100-40-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 118);
insert into T_operation_r_role (role_id, opt_id) values (2, 118);
delete from T_operation_r_role where opt_id = 122;
delete from T_operations where opt_id = 122;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(122, 'lego.event.notify.modify', '', '', false, '6000-100-40-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 122);
insert into T_operation_r_role (role_id, opt_id) values (2, 122);
delete from T_operation_r_role where opt_id = 119;
delete from T_operations where opt_id = 119;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(119, 'lego.event.notify.delete', '', '', false, '6000-100-40-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 119);
insert into T_operation_r_role (role_id, opt_id) values (2, 119);
delete from T_operation_r_role where opt_id = 120;
delete from T_operations where opt_id = 120;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(120, 'lego.event.notify.start', '', '', false, '6000-100-40-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 120);
insert into T_operation_r_role (role_id, opt_id) values (2, 120);
delete from T_operation_r_role where opt_id = 123;
delete from T_operations where opt_id = 123;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(123, 'lego.event.voice', '', '', false, '6000-100-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 123);
insert into T_operation_r_role (role_id, opt_id) values (2, 123);
delete from T_operation_r_role where opt_id = 124;
delete from T_operations where opt_id = 124;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(124, 'lego.event.voice.scan', '', '', false, '6000-100-50-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 124);
insert into T_operation_r_role (role_id, opt_id) values (2, 124);
delete from T_operation_r_role where opt_id = 125;
delete from T_operations where opt_id = 125;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(125, 'lego.event.voice.modify', '', '', false, '6000-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 125);
insert into T_operation_r_role (role_id, opt_id) values (2, 125);
delete from T_operation_r_role where opt_id = 9203;
delete from T_operations where opt_id = 9203;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9203, 'ism.drm.monitor.report.mgt.menuname', '', '', false, '6000-600');
insert into T_operation_r_role (role_id, opt_id) values (1, 9203);
insert into T_operation_r_role (role_id, opt_id) values (2, 9203);
delete from T_operation_r_role where opt_id = 9204;
delete from T_operations where opt_id = 9204;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9204, 'ism.drm.report.protection.menuname', '', '', false, '6000-600-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9204);
insert into T_operation_r_role (role_id, opt_id) values (2, 9204);
delete from T_operation_r_role where opt_id = 9205;
delete from T_operations where opt_id = 9205;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9205, 'ism.drm.report.protection.auth.scan', '', '', false, '6000-600-10-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9205);
insert into T_operation_r_role (role_id, opt_id) values (2, 9205);
delete from T_operation_r_role where opt_id = 9206;
delete from T_operations where opt_id = 9206;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9206, 'ism.drm.report.protection.auth.exportxls', '', '', false, '6000-600-10-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 9206);
insert into T_operation_r_role (role_id, opt_id) values (2, 9206);
delete from T_operation_r_role where opt_id = 9207;
delete from T_operations where opt_id = 9207;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9207, 'ism.drm.report.recovery.menuname', '', '', false, '6000-600-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 9207);
insert into T_operation_r_role (role_id, opt_id) values (2, 9207);
delete from T_operation_r_role where opt_id = 9208;
delete from T_operations where opt_id = 9208;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9208, 'ism.drm.report.rp.auth.scan', '', '', false, '6000-600-20-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9208);
insert into T_operation_r_role (role_id, opt_id) values (2, 9208);
delete from T_operation_r_role where opt_id = 9209;
delete from T_operations where opt_id = 9209;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9209, 'ism.drm.report.rp.auth.exportxls', '', '', false, '6000-600-20-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 9209);
insert into T_operation_r_role (role_id, opt_id) values (2, 9209);
delete from T_operation_r_role where opt_id = 130;
delete from T_operations where opt_id = 130;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(130, 'ism.drm.settings.menuname', '', '', false, '8000');
insert into T_operation_r_role (role_id, opt_id) values (1, 130);
insert into T_operation_r_role (role_id, opt_id) values (2, 130);
insert into T_operation_r_role (role_id, opt_id) values (3, 130);
delete from T_operation_r_role where opt_id = 131;
delete from T_operations where opt_id = 131;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(131, 'lego.sys.operatorMgr', '', '', false, '8000-300');
insert into T_operation_r_role (role_id, opt_id) values (1, 131);
insert into T_operation_r_role (role_id, opt_id) values (2, 131);
delete from T_operation_r_role where opt_id = 132;
delete from T_operations where opt_id = 132;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(132, 'lego.sys.operatorMgr.operator', '', '', false, '8000-300-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 132);
delete from T_operation_r_role where opt_id = 133;
delete from T_operations where opt_id = 133;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(133, 'lego.sys.operatorMgr.operator.scan', '', '', false, '8000-300-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 133);
delete from T_operation_r_role where opt_id = 134;
delete from T_operations where opt_id = 134;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(134, 'lego.sys.operatorMgr.operator.add', '', '', false, '8000-300-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 134);
delete from T_operation_r_role where opt_id = 136;
delete from T_operations where opt_id = 136;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(136, 'lego.sys.operatorMgr.operator.edit', '', '', false, '8000-300-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 136);
delete from T_operation_r_role where opt_id = 135;
delete from T_operations where opt_id = 135;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(135, 'lego.sys.operatorMgr.operator.delete', '', '', false, '8000-300-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 135);
delete from T_operation_r_role where opt_id = 137;
delete from T_operations where opt_id = 137;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(137, 'lego.sys.operatorMgr.operator.lock', '', '', false, '8000-300-10-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 137);
delete from T_operation_r_role where opt_id = 138;
delete from T_operations where opt_id = 138;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(138, 'lego.sys.operatorMgr.operator.resetpassword', '', '', false, '8000-300-10-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 138);
delete from T_operation_r_role where opt_id = 139;
delete from T_operations where opt_id = 139;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(139, 'lego.sys.role', '', '', false, '8000-300-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 139);
delete from T_operation_r_role where opt_id = 140;
delete from T_operations where opt_id = 140;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(140, 'lego.sys.role.scan', '', '', false, '8000-300-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 140);
delete from T_operation_r_role where opt_id = 141;
delete from T_operations where opt_id = 141;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(141, 'lego.sys.role.add', '', '', false, '8000-300-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 141);
delete from T_operation_r_role where opt_id = 143;
delete from T_operations where opt_id = 143;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(143, 'lego.sys.role.edit', '', '', false, '8000-300-20-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 143);
delete from T_operation_r_role where opt_id = 142;
delete from T_operations where opt_id = 142;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(142, 'lego.sys.role.delete', '', '', false, '8000-300-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 142);
delete from T_operation_r_role where opt_id = 144;
delete from T_operations where opt_id = 144;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(144, 'lego.sys.onlineUserMgr', '', '', false, '8000-300-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 144);
insert into T_operation_r_role (role_id, opt_id) values (2, 144);
delete from T_operation_r_role where opt_id = 145;
delete from T_operations where opt_id = 145;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(145, 'lego.sys.onlineUserMgr.scan', '', '', false, '8000-300-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 145);
insert into T_operation_r_role (role_id, opt_id) values (2, 145);
delete from T_operation_r_role where opt_id = 146;
delete from T_operations where opt_id = 146;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(146, 'lego.sys.onlineUserMgr.down', '', '', false, '8000-300-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 146);
delete from T_operation_r_role where opt_id = 147;
delete from T_operations where opt_id = 147;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(147, 'lego.sys.sysLoginPolicy', '', '', false, '8000-300-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 147);
delete from T_operation_r_role where opt_id = 148;
delete from T_operations where opt_id = 148;
delete from T_operation_r_role where opt_id = 149;
delete from T_operations where opt_id = 149;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(149, 'lego.sys.sysLoginPolicy.modify', '', '', false, '8000-300-50-10');
delete from T_operation_r_role where opt_id = 202;
delete from T_operations where opt_id = 202;
delete from T_operation_r_role where opt_id = 203;
delete from T_operations where opt_id = 203;
delete from T_operation_r_role where opt_id = 204;
delete from T_operations where opt_id = 204;
delete from T_operation_r_role where opt_id = 150;
delete from T_operations where opt_id = 150;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(150, 'lego.sys.systemInfo', '', '', false, '8000-400');
insert into T_operation_r_role (role_id, opt_id) values (1, 150);
insert into T_operation_r_role (role_id, opt_id) values (2, 150);
delete from T_operation_r_role where opt_id = 156;
delete from T_operations where opt_id = 156;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(156, 'lego.sys.systemMonitor', '', '', false, '8000-400-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 156);
insert into T_operation_r_role (role_id, opt_id) values (2, 156);
delete from T_operation_r_role where opt_id = 157;
delete from T_operations where opt_id = 157;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(157, 'lego.sys.systemMonitor.scan', '', '', false, '8000-400-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 157);
insert into T_operation_r_role (role_id, opt_id) values (2, 157);
delete from T_operation_r_role where opt_id = 158;
delete from T_operations where opt_id = 158;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(158, 'lego.sys.systemMonitor.Threshold.modify', '', '', false, '8000-400-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 158);
insert into T_operation_r_role (role_id, opt_id) values (2, 158);
delete from T_operation_r_role where opt_id = 159;
delete from T_operations where opt_id = 159;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(159, 'lego.sys.dataStorage', '', '', false, '8000-500');
insert into T_operation_r_role (role_id, opt_id) values (1, 159);
insert into T_operation_r_role (role_id, opt_id) values (2, 159);
insert into T_operation_r_role (role_id, opt_id) values (3, 159);
delete from T_operation_r_role where opt_id = 160;
delete from T_operations where opt_id = 160;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(160, 'lego.sys.dataStorage.sysOptLog', '', '', false, '8000-500-10');
insert into T_operation_r_role (role_id, opt_id) values (3, 160);
delete from T_operation_r_role where opt_id = 161;
delete from T_operations where opt_id = 161;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(161, 'lego.sys.dataStorage.sysOptLog.scan', '', '', false, '8000-500-10-5');
insert into T_operation_r_role (role_id, opt_id) values (3, 161);
delete from T_operation_r_role where opt_id = 162;
delete from T_operations where opt_id = 162;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(162, 'lego.sys.dataStorage.sysOptLog.modify', '', '', false, '8000-500-10-15');
delete from T_operation_r_role where opt_id = 163;
delete from T_operations where opt_id = 163;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(163, 'lego.sys.dataStorage.sysOptLog.delete', '', '', false, '8000-500-10-10');
delete from T_operation_r_role where opt_id = 164;
delete from T_operations where opt_id = 164;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(164, 'lego.sys.dataStorage.event', '', '', false, '8000-500-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 164);
insert into T_operation_r_role (role_id, opt_id) values (2, 164);
delete from T_operation_r_role where opt_id = 165;
delete from T_operations where opt_id = 165;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(165, 'lego.sys.dataStorage.event.scan', '', '', false, '8000-500-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 165);
insert into T_operation_r_role (role_id, opt_id) values (2, 165);
delete from T_operation_r_role where opt_id = 166;
delete from T_operations where opt_id = 166;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(166, 'lego.sys.dataStorage.event.modify', '', '', false, '8000-500-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 166);
insert into T_operation_r_role (role_id, opt_id) values (2, 166);
delete from T_operation_r_role where opt_id = 167;
delete from T_operations where opt_id = 167;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(167, 'lego.sys.dataStorage.event.delete', '', '', false, '8000-500-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 167);
insert into T_operation_r_role (role_id, opt_id) values (2, 167);
delete from T_operation_r_role where opt_id = 9371;
delete from T_operations where opt_id = 9371;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9371, 'ism.drm.dump.configdata', '', '', false, '8000-500-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 9371);
insert into T_operation_r_role (role_id, opt_id) values (2, 9371);
delete from T_operation_r_role where opt_id = 9377;
delete from T_operations where opt_id = 9377;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9377, 'ism.drm.dump.configdata.setting.operateID', '', '', false, '8000-500-40-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9377);
insert into T_operation_r_role (role_id, opt_id) values (2, 9377);
delete from T_operation_r_role where opt_id = 9372;
delete from T_operations where opt_id = 9372;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9372, 'ism.drm.dump.configdata.scan', '', '', false, '8000-500-40-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9372);
insert into T_operation_r_role (role_id, opt_id) values (2, 9372);
delete from T_operation_r_role where opt_id = 9375;
delete from T_operations where opt_id = 9375;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9375, 'ism.drm.dump.software.doc.menuname', '', '', false, '8000-500-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 9375);
insert into T_operation_r_role (role_id, opt_id) values (2, 9375);
delete from T_operation_r_role where opt_id = 9376;
delete from T_operations where opt_id = 9376;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9376, 'ism.drm.dump.software.doc.scan', '', '', false, '8000-500-50-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9376);
insert into T_operation_r_role (role_id, opt_id) values (2, 9376);
delete from T_operation_r_role where opt_id = 9373;
delete from T_operations where opt_id = 9373;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9373, 'ism.drm.sys.exportrlog', '', '', false, '8000-600-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 9373);
delete from T_operation_r_role where opt_id = 9374;
delete from T_operations where opt_id = 9374;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9374, 'ism.drm.sys.exportrlog.scan', '', '', false, '8000-600-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 9374);
delete from T_operation_r_role where opt_id = 168;
delete from T_operations where opt_id = 168;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(168, 'lego.sys.sysLog', '', '', false, '8000-600');
insert into T_operation_r_role (role_id, opt_id) values (1, 168);
insert into T_operation_r_role (role_id, opt_id) values (2, 168);
insert into T_operation_r_role (role_id, opt_id) values (3, 168);
delete from T_operation_r_role where opt_id = 169;
delete from T_operations where opt_id = 169;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(169, 'lego.sys.sysLog.operLog', '', '', false, '8000-600-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 169);
insert into T_operation_r_role (role_id, opt_id) values (2, 169);
insert into T_operation_r_role (role_id, opt_id) values (3, 169);
delete from T_operation_r_role where opt_id = 170;
delete from T_operations where opt_id = 170;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(170, 'lego.sys.sysLog.operLog.scan', '', '', false, '8000-600-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 170);
insert into T_operation_r_role (role_id, opt_id) values (2, 170);
insert into T_operation_r_role (role_id, opt_id) values (3, 170);
delete from T_operation_r_role where opt_id = 171;
delete from T_operations where opt_id = 171;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(171, 'lego.sys.sysLog.operLog.exportExl', '', '', false, '8000-600-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 171);
insert into T_operation_r_role (role_id, opt_id) values (2, 171);
insert into T_operation_r_role (role_id, opt_id) values (3, 171);
delete from T_operation_r_role where opt_id = 190;
delete from T_operations where opt_id = 190;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(190, 'lego.sys.grademgr', '', '', false, '8000-900');
insert into T_operation_r_role (role_id, opt_id) values (1, 190);
insert into T_operation_r_role (role_id, opt_id) values (2, 190);
delete from T_operation_r_role where opt_id = 270;
delete from T_operations where opt_id = 270;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(270, 'lego.sys.grademgr.northnms', '', '', false, '8000-900-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 270);
insert into T_operation_r_role (role_id, opt_id) values (2, 270);
delete from T_operation_r_role where opt_id = 271;
delete from T_operations where opt_id = 271;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(271, 'lego.sys.grademgr.northnms.scan', '', '', false, '8000-900-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 271);
insert into T_operation_r_role (role_id, opt_id) values (2, 271);
delete from T_operation_r_role where opt_id = 272;
delete from T_operations where opt_id = 272;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(272, 'lego.sys.grademgr.northnms.add', '', '', false, '8000-900-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 272);
insert into T_operation_r_role (role_id, opt_id) values (2, 272);
delete from T_operation_r_role where opt_id = 274;
delete from T_operations where opt_id = 274;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(274, 'lego.sys.grademgr.northnms.modify', '', '', false, '8000-900-20-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 274);
insert into T_operation_r_role (role_id, opt_id) values (2, 274);
delete from T_operation_r_role where opt_id = 273;
delete from T_operations where opt_id = 273;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(273, 'lego.sys.grademgr.northnms.delete', '', '', false, '8000-900-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 273);
insert into T_operation_r_role (role_id, opt_id) values (2, 273);
delete from T_operation_r_role where opt_id = 315;
delete from T_operations where opt_id = 315;
delete from T_operation_r_role where opt_id = 316;
delete from T_operations where opt_id = 316;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(316, 'lego.sys.grademgr.nms.trapConfig.scan', '', '', false, '8000-900-20-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 316);
insert into T_operation_r_role (role_id, opt_id) values (2, 316);
delete from T_operation_r_role where opt_id = 317;
delete from T_operations where opt_id = 317;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(317, 'lego.sys.grademgr.nms.trapConfig.modify', '', '', false, '8000-900-20-3');
insert into T_operation_r_role (role_id, opt_id) values (1, 317);
insert into T_operation_r_role (role_id, opt_id) values (2, 317);
delete from T_operation_r_role where opt_id = 198;
delete from T_operations where opt_id = 198;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(198, 'lego.sys.notifyServer', '', '', false, '8000-1000');
insert into T_operation_r_role (role_id, opt_id) values (1, 198);
insert into T_operation_r_role (role_id, opt_id) values (2, 198);
delete from T_operation_r_role where opt_id = 199;
delete from T_operations where opt_id = 199;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(199, 'lego.sys.serverInfo', '', '', false, '8000-1000-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 199);
insert into T_operation_r_role (role_id, opt_id) values (2, 199);
delete from T_operation_r_role where opt_id = 200;
delete from T_operations where opt_id = 200;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(200, 'lego.sys.server.scan', '', '', false, '8000-1000-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 200);
insert into T_operation_r_role (role_id, opt_id) values (2, 200);
delete from T_operation_r_role where opt_id = 201;
delete from T_operations where opt_id = 201;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(201, 'lego.sys.serverEdit', '', '', false, '8000-1000-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 201);
insert into T_operation_r_role (role_id, opt_id) values (2, 201);
delete from T_operation_r_role where opt_id = 211;
delete from T_operations where opt_id = 211;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(211, 'lego.sys.callhome', '', '', false, '8000-1100');
insert into T_operation_r_role (role_id, opt_id) values (1, 211);
insert into T_operation_r_role (role_id, opt_id) values (2, 211);
delete from T_operation_r_role where opt_id = 212;
delete from T_operations where opt_id = 212;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(212, 'lego.sys.callhomeInfo', '', '', false, '8000-1100-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 212);
insert into T_operation_r_role (role_id, opt_id) values (2, 212);
delete from T_operation_r_role where opt_id = 218;
delete from T_operations where opt_id = 218;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(218, 'lego.sys.cloudservice.scan', '', '', false, '8000-1100-10-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 218);
insert into T_operation_r_role (role_id, opt_id) values (2, 218);
delete from T_operation_r_role where opt_id = 214;
delete from T_operations where opt_id = 214;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(214, 'lego.lab.cloudservice.notify.add', '', '', false, '8000-1100-10-6');
insert into T_operation_r_role (role_id, opt_id) values (1, 214);
insert into T_operation_r_role (role_id, opt_id) values (2, 214);
delete from T_operation_r_role where opt_id = 213;
delete from T_operations where opt_id = 213;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(213, 'lego.lab.cloudservice.baseinfo.modify', '', '', false, '8000-1100-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 213);
insert into T_operation_r_role (role_id, opt_id) values (2, 213);
delete from T_operation_r_role where opt_id = 215;
delete from T_operations where opt_id = 215;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(215, 'lego.lab.cloudservice.notify.del', '', '', false, '8000-1100-10-7');
insert into T_operation_r_role (role_id, opt_id) values (1, 215);
insert into T_operation_r_role (role_id, opt_id) values (2, 215);
delete from T_operation_r_role where opt_id = 216;
delete from T_operations where opt_id = 216;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(216, 'lego.sys.bureau', '', '', false, '8000-1100-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 216);
insert into T_operation_r_role (role_id, opt_id) values (2, 216);
delete from T_operation_r_role where opt_id = 219;
delete from T_operations where opt_id = 219;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(219, 'lego.sys.bureau.scan', '', '', false, '8000-1100-20-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 219);
insert into T_operation_r_role (role_id, opt_id) values (2, 219);
delete from T_operation_r_role where opt_id = 217;
delete from T_operations where opt_id = 217;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(217, 'lego.sys.bureauEdit', '', '', false, '8000-1100-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 217);
insert into T_operation_r_role (role_id, opt_id) values (2, 217);
delete from T_operation_r_role where opt_id = 9388;
delete from T_operations where opt_id = 9388;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9388, 'ism.drm.thirdservice', '', '', false, '8000-1300');
insert into T_operation_r_role (role_id, opt_id) values (1, 9388);
insert into T_operation_r_role (role_id, opt_id) values (2, 9388);
delete from T_operation_r_role where opt_id = 9389;
delete from T_operations where opt_id = 9389;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9389, 'ism.drm.thirdservice.oc', '', '', false, '8000-1300-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9389);
insert into T_operation_r_role (role_id, opt_id) values (2, 9389);
delete from T_operations where opt_id = 9390;
delete from T_operation_r_role where opt_id = 9390;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9390, 'ism.drm.thirdservice.oc.scan', '', '', false, '8000-1300-10-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9390);
insert into T_operation_r_role (role_id, opt_id) values (2, 9390);
delete from T_operations where opt_id = 9391;
delete from T_operation_r_role where opt_id = 9391;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9391, 'ism.drm.thirdservice.oc.modify', '', '', false, '8000-1300-10-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 9391);
insert into T_operation_r_role (role_id, opt_id) values (2, 9391);


delete from T_operation_r_role where opt_id = 9395;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9395, 'ism.drm.sys.log.notify', '', '', false, '8000-600-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 9395);
insert into T_operation_r_role (role_id, opt_id) values (2, 9395);
delete from T_operation_r_role where opt_id = 9396;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9396, 'ism.drm.sys.log.notify.scan', '', '', false, '8000-600-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 9396);
insert into T_operation_r_role (role_id, opt_id) values (2, 9396);
delete from T_operation_r_role where opt_id = 9397;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9397, 'ism.drm.sys.log.notify.set', '', '', false, '8000-600-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9397);
insert into T_operation_r_role (role_id, opt_id) values (2, 9397);
delete from T_operation_r_role where opt_id = 9385;
delete from T_operations where opt_id = 9385;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9385, 'ism.drm.license.mgt.operateID', '', '', false, '8000-1200');
insert into T_operation_r_role (role_id, opt_id) values (1, 9385);
delete from T_operation_r_role where opt_id = 9386;
delete from T_operations where opt_id = 9386;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9386, 'ism.drm.license.mgt.scan.operateID', '', '', false, '8000-1200-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9386);
delete from T_operation_r_role where opt_id = 9387;
delete from T_operations where opt_id = 9387;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9387, 'ism.drm.license.mgt.set.operateID', '', '', false, '8000-1200-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 9387);
delete from T_operation_r_role where opt_id = 9378;
delete from T_operations where opt_id = 9378;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9378, 'ism.drm.sys.exportrlog.setting.operateID', '', '', false, '8000-600-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9378);
--Begin delete from RD V100R005C00
delete from T_operation_r_role where opt_id = 9085;
delete from T_operation_r_role where opt_id = 9087;
delete from T_operation_r_role where opt_id = 9350;
delete from T_operation_r_role where opt_id = 9351;
delete from T_operation_r_role where opt_id = 9352;
delete from T_operation_r_role where opt_id = 9353;
delete from T_operation_r_role where opt_id = 9354;
delete from T_operation_r_role where opt_id = 9356;
delete from T_operation_r_role where opt_id = 9355;
delete from T_operation_r_role where opt_id = 9300;
delete from T_operation_r_role where opt_id = 9301;
delete from T_operation_r_role where opt_id = 9302;
delete from T_operation_r_role where opt_id = 9303;
delete from T_operation_r_role where opt_id = 9304;
delete from T_operation_r_role where opt_id = 9305;
delete from T_operation_r_role where opt_id = 9306;
delete from T_operation_r_role where opt_id = 9312;
delete from T_operation_r_role where opt_id = 9400;
delete from T_operation_r_role where opt_id = 9401;
delete from T_operation_r_role where opt_id = 9402;
delete from T_operation_r_role where opt_id = 9403;
delete from T_operation_r_role where opt_id = 9404;
delete from T_operation_r_role where opt_id = 9405;
delete from T_operation_r_role where opt_id = 9406;
delete from T_operation_r_role where opt_id = 9407;
delete from T_operation_r_role where opt_id = 9408;
delete from T_operation_r_role where opt_id = 9409;
delete from T_operation_r_role where opt_id = 9410;
delete from T_operations where opt_id = 9085;
delete from T_operations where opt_id = 9087;
delete from T_operations where opt_id = 9350;
delete from T_operations where opt_id = 9351;
delete from T_operations where opt_id = 9352;
delete from T_operations where opt_id = 9353;
delete from T_operations where opt_id = 9354;
delete from T_operations where opt_id = 9356;
delete from T_operations where opt_id = 9355;
delete from T_operations where opt_id = 9300;
delete from T_operations where opt_id = 9301;
delete from T_operations where opt_id = 9302;
delete from T_operations where opt_id = 9303;
delete from T_operations where opt_id = 9304;
delete from T_operations where opt_id = 9305;
delete from T_operations where opt_id = 9306;
delete from T_operations where opt_id = 9312;
delete from T_operations where opt_id = 9400;
delete from T_operations where opt_id = 9401;
delete from T_operations where opt_id = 9402;
delete from T_operations where opt_id = 9403;
delete from T_operations where opt_id = 9404;
delete from T_operations where opt_id = 9405;
delete from T_operations where opt_id = 9406;
delete from T_operations where opt_id = 9407;
delete from T_operations where opt_id = 9408;
delete from T_operations where opt_id = 9409;
delete from T_operations where opt_id = 9410;
--End delete from RD V100R005C00
--Begin new from RD V100R005C00
delete from T_operation_r_role where opt_id = 9315;
delete from T_operations where opt_id = 9315;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9315, 'ism.drm.resource.menuname', '', '', false, '2045');
insert into T_operation_r_role (role_id, opt_id) values (1, 9315);
insert into T_operation_r_role (role_id, opt_id) values (2, 9315);
delete from T_operation_r_role where opt_id = 9316;
delete from T_operations where opt_id = 9316;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9316, 'ism.drm.servers.operationID', '', '', false, '2045-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 9316);
insert into T_operation_r_role (role_id, opt_id) values (2, 9316);
delete from T_operation_r_role where opt_id = 9317;
delete from T_operations where opt_id = 9317;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9317, 'ism.drm.servers.auth.scan', '', '', false, '2045-10-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9317);
insert into T_operation_r_role (role_id, opt_id) values (2, 9317);
delete from T_operation_r_role where opt_id = 9318;
delete from T_operations where opt_id = 9318;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9318, 'ism.drm.servers.auth.add', '', '', false, '2045-10-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 9318);
delete from T_operation_r_role where opt_id = 9319;
delete from T_operations where opt_id = 9319;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9319, 'ism.drm.servers.auth.modify', '', '', false, '2045-10-3');
insert into T_operation_r_role (role_id, opt_id) values (1, 9319);
delete from T_operation_r_role where opt_id = 9320;
delete from T_operations where opt_id = 9320;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9320, 'ism.drm.servers.auth.delete', '', '', false, '2045-10-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 9320);
delete from T_operation_r_role where opt_id = 9321;
delete from T_operations where opt_id = 9321;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9321, 'ism.drm.servers.auth.refresh', '', '', false, '2045-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 9321);
insert into T_operation_r_role (role_id, opt_id) values (2, 9321);
delete from T_operation_r_role where opt_id = 9322;
delete from T_operations where opt_id = 9322;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9322, 'ism.drm.site.auth.site', '', '', false, '2045-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 9322);
insert into T_operation_r_role (role_id, opt_id) values (2, 9322);
insert into T_operation_r_role (role_id, opt_id) values (4, 9322);
delete from T_operation_r_role where opt_id = 9323;
delete from T_operations where opt_id = 9323;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9323, 'ism.drm.site.auth.scan', '', '', false, '2045-10-20-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 9323);
insert into T_operation_r_role (role_id, opt_id) values (2, 9323);
insert into T_operation_r_role (role_id, opt_id) values (4, 9323);
delete from T_operation_r_role where opt_id = 9324;
delete from T_operations where opt_id = 9324;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9324, 'ism.drm.site.auth.add', '', '', false, '2045-10-20-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 9324);
insert into T_operation_r_role (role_id, opt_id) values (2, 9324);
delete from T_operation_r_role where opt_id = 9325;
delete from T_operations where opt_id = 9325;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9325, 'ism.drm.site.auth.modify', '', '', false, '2045-10-20-3');
insert into T_operation_r_role (role_id, opt_id) values (1, 9325);
insert into T_operation_r_role (role_id, opt_id) values (2, 9325);
delete from T_operation_r_role where opt_id = 9326;
delete from T_operations where opt_id = 9326;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9326, 'ism.drm.site.auth.delete', '', '', false, '2045-10-20-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 9326);
insert into T_operation_r_role (role_id, opt_id) values (2, 9326);
delete from T_operation_r_role where opt_id = 9327;
delete from T_operations where opt_id = 9327;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9327, 'ism.drm.site.auth.refresh', '', '', false, '2045-10-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 9327);
insert into T_operation_r_role (role_id, opt_id) values (2, 9327);
delete from T_operation_r_role where opt_id = 9328;
delete from T_operations where opt_id = 9328;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9328, 'ism.drm.site.resource.auth.management.operateID', '', '', false, '2045-10-20-6');
insert into T_operation_r_role (role_id, opt_id) values (1, 9328);
insert into T_operation_r_role (role_id, opt_id) values (2, 9328);

--End new from RD V100R005C00

--Begin delete from RD V2R1C30
delete from T_operation_r_role where opt_id = 9492;
delete from T_operations where opt_id = 9492;
delete from T_operation_r_role where opt_id = 9392;
delete from T_operations where opt_id = 9392;
delete from T_operations where opt_id = 9393;
delete from T_operation_r_role where opt_id = 9393;
delete from T_operations where opt_id = 9394;
delete from T_operation_r_role where opt_id = 9394;
--���ļ������ڳ�ʼ��OCAdmin��ɫ�������Ȩ�ޡ�
--��װ�����У���Է�SSO���ɲ��𳡾���������ʹ�ø��ļ����г�ʼ����
--��ֹ���ļ���д������SQL���
--�����Ҫ�޸�����SQL���ʱ,��ͬ������LegoInstall�����е�InitDBTool.java��updateSsoRole������Ӧ��SQL����Ƿ��޸ġ�SSO��ɫ�����Ĵ����Ƿ��ڴ����д���ģ���������SQL�ű�������һ������������������ͬ��
insert into T_role values(-1,'11','20100203','OCAdmin','ManageOne O&M Plane Admin Role',1);
with permission as (select * from T_operation_r_role where role_id = 1 and opt_id not in (select opt_id from T_operations where serial_number in ('8000-300','8000-300-10','8000-300-10-5','8000-300-10-10','8000-300-10-20','8000-300-10-15','8000-300-10-25','8000-300-10-30','8000-300-20','8000-300-20-5','8000-300-20-10','8000-300-20-20','8000-300-20-15','8000-300-30','8000-300-30-5','8000-300-30-10','8000-300-50'))) insert into T_operation_r_role(role_id, opt_id) select -1, permission.opt_id from permission;
delete from T_operation_r_role where opt_id = 9125;
delete from T_operations where opt_id = 9125;
delete from T_operation_r_role where opt_id = 9126;
delete from T_operations where opt_id = 9126;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9125, 'ism.drm.drp.auth.disaster.mountplan.mount', '', '', false, '2060-70');
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9126, 'ism.drm.drp.auth.disaster.mountplan.unmount', '', '', false, '2060-75');

insert into T_operation_r_role (role_id, opt_id) values (1, 9125);
insert into T_operation_r_role (role_id, opt_id) values (2, 9125);
insert into T_operation_r_role (role_id, opt_id) values (1, 9126);
insert into T_operation_r_role (role_id, opt_id) values (2, 9126);


delete from T_operation_r_role where opt_id = 9400;
delete from T_operations where opt_id = 9400;
delete from T_operation_r_role where opt_id = 9401;
delete from T_operations where opt_id = 9401;
delete from T_operation_r_role where opt_id = 9402;
delete from T_operations where opt_id = 9402;
delete from T_operation_r_role where opt_id = 9403;
delete from T_operations where opt_id = 9403;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9400, 'ism.drm.proxyserver.management', '', '', false, '8000-1400');
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9401, 'ism.drm.proxyserver', '', '', false, '8000-1400-10');
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9402, 'ism.drm.proxyserver.scan', '', '', false, '8000-1400-10-1');
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9403, 'ism.drm.proxyserver.config', '', '', false, '8000-1400-10-2');

insert into T_operation_r_role (role_id, opt_id) values (1, 9400);
insert into T_operation_r_role (role_id, opt_id) values (1, 9401);
insert into T_operation_r_role (role_id, opt_id) values (1, 9402);
insert into T_operation_r_role (role_id, opt_id) values (1, 9403);
insert into T_operation_r_role (role_id, opt_id) values (2, 9400);
insert into T_operation_r_role (role_id, opt_id) values (2, 9401);
insert into T_operation_r_role (role_id, opt_id) values (2, 9402);
insert into T_operation_r_role (role_id, opt_id) values (2, 9403);



--清除个人数据权限定义
delete from T_operation_r_role where opt_id = 174;
delete from T_operations where opt_id = 174;
delete from T_operation_r_role where opt_id = 175;
delete from T_operations where opt_id = 175;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(174, 'ism.drm.personal.data.menuname', '', '', false, '8000-500-60');
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(175, 'ism.drm.personal.data.clear', '', '', false, '8000-500-60-1');

insert into T_operation_r_role (role_id, opt_id) values (1, 174);
insert into T_operation_r_role (role_id, opt_id) values (1, 175);
--给OCadmin增加权限，由于创建OCadmin在12_lego.sql,所有之后的sql如果新增OCadmin的权限必须执行如下类似的语句来给OCadmin赋予权限,sql语句的意思是如果存在role_id为-1，且存在opt_id为9379的一条数据，那么就新增一条权限，防止增加脏数据（传统云）
with permission as (select * from T_operation_r_role where role_id = -1 and opt_id = 9379) insert into T_operation_r_role(role_id, opt_id) select -1, 174 from permission;
with permission as (select * from T_operation_r_role where role_id = -1 and opt_id = 9379) insert into T_operation_r_role(role_id, opt_id) select -1, 175 from permission;

-- 热迁移增加权限
delete from T_operation_r_role where opt_id = 9128;
delete from T_operations where opt_id = 9128;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(9128, 'ism.drm.drp.auth.planed.hotmigration', '', '', false, '2060-80');

insert into T_operation_r_role (role_id, opt_id) values (1, 9128);
insert into T_operation_r_role (role_id, opt_id) values (2, 9128);

--给OCadmin增加权限，由于创建OCadmin在12_lego.sql,所有之后的sql如果新增OCadmin的权限必须执行如下类似的语句来给OCadmin赋予权限,sql语句的意思是如果存在role_id为-1，且存在opt_id为9379的一条数据，那么就新增一条权限，防止增加脏数据（传统云）
with permission as (select * from T_operation_r_role where role_id = -1 and opt_id = 9379) insert into T_operation_r_role(role_id, opt_id) select -1, 9128 from permission;

-- 为OCAdmin角色权限查看管理员的权限
delete from T_operation_r_role where opt_id = 132 and role_id = -1;
delete from T_operation_r_role where opt_id = 133 and role_id = -1;
with permission as (select * from T_role where role_id = -1) insert into T_operation_r_role(role_id, opt_id) select -1, 132 from permission;
with permission as (select * from T_role where role_id = -1) insert into T_operation_r_role(role_id, opt_id) select -1, 133 from permission;
-- 清除分级管理权限定义
delete from T_operation_r_role where opt_id = 190;
delete from T_operation_r_role where opt_id = 270;
delete from T_operation_r_role where opt_id = 271;
delete from T_operation_r_role where opt_id = 272;
delete from T_operation_r_role where opt_id = 273;
delete from T_operation_r_role where opt_id = 274;
delete from T_operation_r_role where opt_id = 316;
delete from T_operation_r_role where opt_id = 317;
delete from T_operations where opt_id = 190;
delete from T_operations where opt_id = 270;
delete from T_operations where opt_id = 271;
delete from T_operations where opt_id = 272;
delete from T_operations where opt_id = 273;
delete from T_operations where opt_id = 274;
delete from T_operations where opt_id = 316;
delete from T_operations where opt_id = 317;

-- 清除通知服务器权限定义
delete from T_operation_r_role where opt_id = 198;
delete from T_operation_r_role where opt_id = 199;
delete from T_operation_r_role where opt_id = 200;
delete from T_operation_r_role where opt_id = 201;
delete from T_operations where opt_id = 198;
delete from T_operations where opt_id = 199;
delete from T_operations where opt_id = 200;
delete from T_operations where opt_id = 201;

-- 清除远程维护权限定义
delete from T_operation_r_role where opt_id = 211;
delete from T_operation_r_role where opt_id = 212;
delete from T_operation_r_role where opt_id = 213;
delete from T_operation_r_role where opt_id = 214;
delete from T_operation_r_role where opt_id = 215;
delete from T_operation_r_role where opt_id = 216;
delete from T_operation_r_role where opt_id = 217;
delete from T_operation_r_role where opt_id = 218;
delete from T_operation_r_role where opt_id = 219;
delete from T_operations where opt_id = 211;
delete from T_operations where opt_id = 212;
delete from T_operations where opt_id = 213;
delete from T_operations where opt_id = 214;
delete from T_operations where opt_id = 215;
delete from T_operations where opt_id = 216;
delete from T_operations where opt_id = 217;
delete from T_operations where opt_id = 218;
delete from T_operations where opt_id = 219;

-- 清除代理服务器管理权限定义
delete from T_operation_r_role where opt_id = 9400;
delete from T_operation_r_role where opt_id = 9401;
delete from T_operation_r_role where opt_id = 9402;
delete from T_operation_r_role where opt_id = 9403;
delete from T_operations where opt_id = 9400;
delete from T_operations where opt_id = 9401;
delete from T_operations where opt_id = 9402;
delete from T_operations where opt_id = 9403;

-- 清除保护-保护组-应用认证权限定义
delete from T_operation_r_role where opt_id = 9088;
delete from T_operations where opt_id = 9088;

-- 清除恢复-挂载/卸载权限定义
delete from T_operation_r_role where opt_id = 9125;
delete from T_operation_r_role where opt_id = 9126;
delete from T_operations where opt_id = 9125;
delete from T_operations where opt_id = 9126;

-- 清除监控-拓扑权限定义
delete from T_operation_r_role where opt_id = 9200;
delete from T_operation_r_role where opt_id = 9202;
delete from T_operation_r_role where opt_id = 9211;
delete from T_operations where opt_id = 9200;
delete from T_operations where opt_id = 9202;
delete from T_operations where opt_id = 9211;

-- 清除监控-告警管理-远程通知权限定义
delete from T_operation_r_role where opt_id = 116;
delete from T_operation_r_role where opt_id = 117;
delete from T_operation_r_role where opt_id = 118;
delete from T_operation_r_role where opt_id = 119;
delete from T_operation_r_role where opt_id = 120;
delete from T_operation_r_role where opt_id = 122;
delete from T_operations where opt_id = 116;
delete from T_operations where opt_id = 117;
delete from T_operations where opt_id = 118;
delete from T_operations where opt_id = 119;
delete from T_operations where opt_id = 120;
delete from T_operations where opt_id = 122;

-- 清除设置-数据维护-个人数据权限定义
delete from T_operation_r_role where opt_id = 174;
delete from T_operation_r_role where opt_id = 175;
delete from T_operations where opt_id = 174;
delete from T_operations where opt_id = 175;

-- 新增安全策略-查看权限
delete from T_operations where opt_id = 148;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(148, 'lego.sys.sysLoginPolicy.scan', '', '', false, '8000-300-50-5');
-- 给用户新增安全策略权限（admin：查看、编辑）
delete from T_operation_r_role where opt_id = 147 and role_id = 1;
delete from T_operation_r_role where opt_id = 148 and role_id = 1;
delete from T_operation_r_role where opt_id = 149 and role_id = 1;
insert into T_operation_r_role (role_id, opt_id) values (1, 147);
insert into T_operation_r_role (role_id, opt_id) values (1, 148);
insert into T_operation_r_role (role_id, opt_id) values (1, 149);
-- 给用户新增安全策略权限（operator：查看）
delete from T_operation_r_role where opt_id = 147 and role_id = 2;
delete from T_operation_r_role where opt_id = 148 and role_id = 2;
insert into T_operation_r_role (role_id, opt_id) values (2, 147);
insert into T_operation_r_role (role_id, opt_id) values (2, 148);
-- 给用户新增安全策略权限（auditor：查看）
delete from T_operation_r_role where opt_id = 147 and role_id = 3;
delete from T_operation_r_role where opt_id = 148 and role_id = 3;
insert into T_operation_r_role (role_id, opt_id) values (3, 147);
insert into T_operation_r_role (role_id, opt_id) values (3, 148);
-- 给用户新增安全策略权限（OCAdmin：查看）
delete from T_operation_r_role where opt_id = 147 and role_id = -1;
delete from T_operation_r_role where opt_id = 148 and role_id = -1;
with permission as (select * from T_role where role_id = -1) insert into T_operation_r_role(role_id, opt_id) select -1, 147 from permission;
with permission as (select * from T_role where role_id = -1) insert into T_operation_r_role(role_id, opt_id) select -1, 148 from permission;

-- 给admin新增设置-操作日志转储权限
delete from T_operation_r_role where opt_id = 160 and role_id = 1;
delete from T_operation_r_role where opt_id = 161 and role_id = 1;
delete from T_operation_r_role where opt_id = 162 and role_id = 1;
delete from T_operation_r_role where opt_id = 163 and role_id = 1;
insert into T_operation_r_role (role_id, opt_id) values (1, 160);
insert into T_operation_r_role (role_id, opt_id) values (1, 161);
insert into T_operation_r_role (role_id, opt_id) values (1, 162);
insert into T_operation_r_role (role_id, opt_id) values (1, 163);

-- 新增安全策略下的证书开关-查看/编辑权限
delete from T_operations where opt_id = 318;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(318, 'lego.sys.certSwitch.scan', '', '', false, '8000-300-50-15');
delete from T_operations where opt_id = 319;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(319, 'lego.sys.certSwitch.modify', '', '', false, '8000-300-50-20');
-- 给用户新增证书开关权限（admin：查看、编辑）
delete from T_operation_r_role where opt_id = 318 and role_id = 1;
delete from T_operation_r_role where opt_id = 319 and role_id = 1;
insert into T_operation_r_role (role_id, opt_id) values (1, 318);
insert into T_operation_r_role (role_id, opt_id) values (1, 319);
-- 给用户新增证书开关权限（operator：查看）
delete from T_operation_r_role where opt_id = 318 and role_id = 2;
insert into T_operation_r_role (role_id, opt_id) values (2, 318);
-- 给用户新增证书开关权限（auditor：查看）
delete from T_operation_r_role where opt_id = 318 and role_id = 3;
insert into T_operation_r_role (role_id, opt_id) values (3, 318);
-- 给用户新增证书开关权限（OCAdmin：查看、编辑）
delete from T_operation_r_role where opt_id = 318 and role_id = -1;
delete from T_operation_r_role where opt_id = 319 and role_id = -1;
with permission as (select * from T_role where role_id = -1) insert into T_operation_r_role(role_id, opt_id) select -1, 318 from permission;
with permission as (select * from T_role where role_id = -1) insert into T_operation_r_role(role_id, opt_id) select -1, 319 from permission;

-- add index.scan in view for auditor
delete from T_operation_r_role where opt_id = 9379 and role_id = 3;
insert into T_operation_r_role (role_id, opt_id) values (3, 9379);
-- add backtask.scan in view for auditor
delete from T_operation_r_role where opt_id = 9380 and role_id = 3;
insert into T_operation_r_role (role_id, opt_id) values (3, 9380);
-- add operatorMgr.scan in view for auditor
delete from T_operation_r_role where opt_id = 131 and role_id = 3;
insert into T_operation_r_role (role_id, opt_id) values (3, 131);
-- 修改LEGO数据库和RDDBUSER的默认连接数
update PG_DATABASE set DATCONNLIMIT = '200' where DATNAME ='LEGO';
alter user RDDBUSER with connection limit 200;
delete from T_operation_r_role where role_id = 4 and opt_id = 9323;
insert into T_operation_r_role (role_id, opt_id) values (4, 9323);
insert into T_main_device_type values ('ism.drm.deviceType.fusionsphere.mainType', 'Dr_Cloud');
insert into T_sub_device_type values ('ism.drm.deviceType.fusionsphereopenstack.subType','Dr_Openstack');
insert into T_device_type_relation (parent_type, child_type, page_url) VALUES ('ism.drm.deviceType.fusionsphere.mainType','ism.drm.deviceType.fusionsphereopenstack.subType','/ism/drm/vrm/discoveryDrVRMField.do');
