/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.job;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.job.AbstractDrmQuartzJob;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ProtectGroupLockCheckingJob
extends AbstractDrmQuartzJob {
    private static final Log logger = LogFactory.getInstance(ProtectGroupLockCheckingJob.class);
    private long lockTimeout = 1800000L;

    public ProtectGroupLockCheckingJob() {
        this.setJobName("JOB_ProtectGroupLockChecking");
        this.setJobGroupName("JOB_GROUP_ProtectGroupLockChecking");
        this.setTriggerName("PgLockCheckingTrigger");
    }

    public void setLockTimeout(long lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        List<ProtectGroup> allLockedProtectGroups = this.getAllLockedProtectGroups();
        if (VerifyUtil.isEmpty(allLockedProtectGroups)) {
            logger.warn((Object)"AllLockedProtectGroups is empty.");
            return;
        }
        IProtectGroupBaseService protectGroupService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        long curTime = new Date().getTime();
        for (ProtectGroup protectGroup : allLockedProtectGroups) {
            if (this.lockTimeout > curTime - protectGroup.getLockTime()) continue;
            try {
                protectGroupService.unlockProtectGroup(new String[]{protectGroup.getUuid()});
            }
            catch (Exception e) {
                logger.error((Object)"Unlock protect group failed. PgId: %s, Name: %s %s", new Object[]{protectGroup.getUuid(), protectGroup.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProtectGroup> getAllLockedProtectGroups() {
        Session session;
        List<ProtectGroup> allProtectGroups;
        block4: {
            allProtectGroups = new ArrayList<ProtectGroup>();
            session = null;
            try {
                session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
                String querySQL = "select pg.PGID, pg.LOCKTIME, pg.PGNAME from ti_protectgroup pg where pg.ISPRIMARY=1 and pg.STATUS=4";
                NativeQuery query = session.createSQLQuery(querySQL);
                List result = query.list();
                if (VerifyUtil.isEmpty((Collection)result)) break block4;
                allProtectGroups = this.constructProtectGroups(result);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"Getting all protect groups failed. error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return allProtectGroups;
    }

    private List<ProtectGroup> constructProtectGroups(List<?> result) {
        ArrayList<ProtectGroup> allProtectGrops = new ArrayList<ProtectGroup>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 3 != (values = (Object[])object).length) continue;
            ProtectGroup protectGroup = new ProtectGroup();
            protectGroup.setUuid(String.valueOf(values[0]));
            protectGroup.setLockTime(Long.valueOf(String.valueOf(values[1])));
            protectGroup.setName(String.valueOf(values[2]));
            allProtectGrops.add(protectGroup);
        }
        return allProtectGrops;
    }
}

