/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public final class ResourceUtil
implements InitializingBean {
    private static final Log logger = LogFactory.getInstance(ResourceUtil.class);
    private static final String DEFAULT_PROPERTIES = "conf.properties";
    private static Properties props = new Properties();
    private static ResourceUtil instance;

    public static synchronized ResourceUtil getInstance() {
        if (instance == null) {
            instance = new ResourceUtil();
        }
        return instance;
    }

    public static String getValue(String key) {
        return ResourceUtil.getValue(key, null);
    }

    public static String getValue(String key, String defaultValue) {
        String value = defaultValue;
        if (props != null) {
            value = props.getProperty(key, defaultValue);
        }
        return value;
    }

    public void afterPropertiesSet() {
        ResourceUtil.setProps(this.readProperties(DEFAULT_PROPERTIES, ResourceUtil.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties readProperties(String propFile, Class loadBaseClass) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            String jarfileName = AdapterUtils.getClassJarPath((Class)loadBaseClass);
            if (jarfileName == null) {
                logger.error((Object)"Read default.properties jarfileName null.");
            } else {
                URL url = AdapterUtils.getUrlResourceFromJar((ClassLoader)loadBaseClass.getClassLoader(), (String)jarfileName, (String)propFile);
                if (url != null) {
                    inputStream = url.openStream();
                    properties.load(inputStream);
                }
            }
            this.closeInputStream(inputStream);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Read default.properties fail. error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                this.closeInputStream(inputStream);
            }
            catch (Throwable throwable) {
                this.closeInputStream(inputStream);
                throw throwable;
            }
        }
        return properties;
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Closing input stream failed. error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private static void setProps(Properties props) {
        ResourceUtil.props = props;
    }
}

