/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util.dao;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.lego.core.base.persistance.SessionUtil;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.springframework.lang.Nullable;

public final class HibernateUtil
extends SessionUtil {
    private static final ThreadLocal<Session> SESSION = new ThreadLocal();

    private HibernateUtil() {
    }

    public static <T> T execute(Supplier<T> supplier) {
        return HibernateUtil.execute(supplier, null);
    }

    public static void execute(Runnable runnable) {
        HibernateUtil.execute(runnable, null);
    }

    public static void execute(Consumer<Session> consumer) {
        HibernateUtil.call(session -> {
            consumer.accept((Session)session);
            return null;
        });
    }

    public static <T> T call(Function<Session, T> function) {
        return (T)HibernateUtil.execute(() -> function.apply(HibernateUtil.getSession()), null);
    }

    public static <T, R> R call(BiFunction<Session, T, R> biFunction, T param) {
        return (R)HibernateUtil.call(session -> biFunction.apply((Session)session, param));
    }

    public static void execute(Runnable runnable, Session session) {
        HibernateUtil.execute(() -> {
            runnable.run();
            return null;
        }, session);
    }

    public static <T> T execute(Supplier<T> supplier, Session session) {
        T result = null;
        boolean flag = false;
        Session last = null;
        if (session != null) {
            last = SESSION.get();
            SESSION.set(session);
        } else {
            session = HibernateUtil.getSession();
        }
        if (session == null) {
            session = HibernateUtil.openSession();
            SESSION.set(session);
            flag = true;
        }
        Transaction transaction = null;
        boolean commit = false;
        try {
            transaction = session.getTransaction();
            if (transaction == null) {
                transaction = session.beginTransaction();
                commit = true;
            }
            if (!transaction.isActive()) {
                transaction.begin();
                commit = true;
            }
            result = supplier.get();
            if (commit) {
                transaction.commit();
            }
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            throw e;
        }
        finally {
            if (flag) {
                HibernateUtil.close((Session)session);
                SESSION.remove();
            } else if (last != null) {
                SESSION.set(last);
            } else {
                SESSION.remove();
            }
        }
        return result;
    }

    @Nullable
    public static Session openSession() {
        SessionFactory sessionFactory = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory();
        if (sessionFactory == null) {
            return null;
        }
        return sessionFactory.openSession();
    }

    public static Session getSession() {
        return SESSION.get();
    }
}

