/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessBaseUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.quartz.Scheduler;
import org.springframework.orm.hibernate5.HibernateTemplate;

public abstract class RecoveryProcessBaseServiceImpl
implements IRecoveryProcessBaseService {
    protected static Map<Integer, Integer> statusMapping = new HashMap<Integer, Integer>();
    private static final Log logger = LogFactory.getInstance(RecoveryProcessBaseServiceImpl.class);
    protected IRecoveryPlanBaseService recoveryPlanService;
    protected IMoDao moDao;
    protected Scheduler quartzScheduler;

    public void setRecoveryPlanService(IRecoveryPlanBaseService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public IRecoveryPlanBaseService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public String createRecoveryProcessDetail(RecoveryProcessorDetail recoveryProcessDetail, boolean isUpdate) {
        if (recoveryProcessDetail == null) {
            logger.error((Object)"The parameter recoveryProcessDetail is null.");
            return null;
        }
        String recoveryProcId = null;
        try {
            HibernateTemplate hibernateTpl = this.moDao.getHibernateTemplate();
            if (isUpdate) {
                hibernateTpl.update((Object)recoveryProcessDetail);
            } else {
                hibernateTpl.save((Object)recoveryProcessDetail);
            }
            recoveryProcId = recoveryProcessDetail.getDetailId();
        }
        catch (Exception e) {
            logger.error((Object)"Creating process detail failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return recoveryProcId;
    }

    public boolean deleteRecoveryProcessor(String procId) {
        if (VerifyUtil.isEmpty((String)procId)) {
            logger.error((Object)"The parameter is null.");
            return false;
        }
        boolean isSuccess = true;
        try {
            RecoveryProcessor recoveryProcessor = this.getRecoveryProcess(procId);
            this.deleteRecoveryProcessor(recoveryProcessor);
        }
        catch (Exception e) {
            logger.error((Object)"deleteRecoveryProcessor failed.");
            isSuccess = false;
        }
        return isSuccess;
    }

    public void deleteRecoveryProcessor(RecoveryProcessor recoveryProcessor) {
        if (VerifyUtil.isEmpty((Object)recoveryProcessor)) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            this.moDao.getHibernateTemplate().delete((Object)recoveryProcessor);
            logger.debug((Object)this.recordDeletedRecoveryProcess(recoveryProcessor), 90160758784000L);
        }
        catch (Exception e) {
            String errorMsg = "Delete recovery process failed. ProcId:" + recoveryProcessor.getProcId() + ",Name:" + recoveryProcessor.getName();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryPlan(String recoveryPlanId, int planStatus, DrmEnumDefine.RecoveryPlanExecuteTypeE planExecuteType, Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap, Integer planProgress, int processStatus) {
        if (!this.checkParametersForUpdate(recoveryPlanId, planStatus, planExecuteType, planProgress)) {
            return false;
        }
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlan(recoveryPlanId, false, false);
        if (recoveryPlan == null) {
            logger.error((Object)"The recovery plan does not exist. Id:%s.", new Object[]{recoveryPlanId});
            return false;
        }
        try {
            recoveryPlan.setLastExecuteType(planExecuteType.getValue());
            recoveryPlan.setPlanStatus(planStatus);
            recoveryPlan.setProcessStatus(processStatus);
            if (planProgress != null) {
                recoveryPlan.setPlanProgress(planProgress.intValue());
            }
            this.recordDrillingResult(planStatus, planExecuteType, recoveryPlan);
            logger.info((Object)"Update recovery plan status. Plan name: %s, Id:%s, Status:%s,Execute type: %s, Progress: %s", new Object[]{recoveryPlan.getName(), recoveryPlan.getPlanId(), planStatus, planExecuteType, planProgress});
            Session session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                session.beginTransaction();
                session.saveOrUpdate((Object)recoveryPlan);
                this.recoveryPlanService.updatePoRecoveryStatus(recoveryPlan.getProtectGroups(), poRecoveryStatusMap, session);
                session.getTransaction().commit();
            }
            catch (Exception e) {
                try {
                    DBOperationUtil.rollbackSession(session);
                    ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateRecoverySettings failed.", (long)-1L, null, (Log)logger);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
            DBOperationUtil.closeSession(session);
            this.syncUpdateToRemote(poRecoveryStatusMap, recoveryPlan);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"updateRecoveryPlan failed. Id:%s,error is %s.", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
    }

    private void recordDrillingResult(int planStatus, DrmEnumDefine.RecoveryPlanExecuteTypeE planExecuteType, RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.equals((Object)planExecuteType)) {
            recoveryPlan.setLastTestStatus(planStatus);
            String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
            recoveryPlan.getGlobalSettings().put(disasterSiteId + "_TestResult", String.valueOf(planStatus));
            String hostOrGroupId = RecoveryServiceUtil.getDisasterHostSN(recoveryPlan);
            if (!VerifyUtil.isEmpty((String)hostOrGroupId)) {
                recoveryPlan.getGlobalSettings().put(hostOrGroupId + "_TestResult", String.valueOf(planStatus));
            }
        }
    }

    protected void syncUpdateToRemote(Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap, RecoveryPlan recoveryPlan) {
    }

    public boolean updateRecoveryPlan(RecoveryPlan recoveryPlan) {
        boolean updateResult = false;
        if (recoveryPlan == null) {
            logger.error((Object)"The parameter recoveryPlan is null.");
            return updateResult;
        }
        try {
            ProtectGroup protectGroup = (ProtectGroup)recoveryPlan.getProtectGroups().iterator().next();
            if (30 == protectGroup.getTemplate().getType() && RecoveryPlanUse.PUBLIC_USE.getValue() == recoveryPlan.getUse().intValue()) {
                recoveryPlan.setPlanType(DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue());
            }
            this.moDao.getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
            updateResult = true;
        }
        catch (Exception e) {
            logger.error((Object)"Updating recovery plan failed,error:%s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryPlanProgress(String recoveryPlanId, int progressRatio) {
        int planProgress;
        NativeQuery query;
        Session session;
        boolean updateResult;
        block9: {
            List results;
            block8: {
                updateResult = false;
                if (VerifyUtil.isEmpty((String)recoveryPlanId) || 0 > progressRatio || 100 < progressRatio) {
                    logger.error((Object)"The parameter is invalid. Id:%s,ProgressRatio:%s.", new Object[]{recoveryPlanId, progressRatio});
                    return updateResult;
                }
                session = null;
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String querySql = "select PLANPROGRESS from ti_recoveryplan where PLANID=:recoveryPlanId";
                query = session.createSQLQuery(querySql);
                query.setParameter("recoveryPlanId", (Object)recoveryPlanId);
                results = query.list();
                if (!VerifyUtil.isEmpty((Collection)results)) break block8;
                logger.error((Object)"The recovery plan does not exist. Id:%s.", new Object[]{recoveryPlanId});
                boolean bl = updateResult;
                DBOperationUtil.closeSession(session);
                return bl;
            }
            planProgress = (Integer)results.get(0);
            if (0 >= planProgress) {
                planProgress = 0;
            }
            if (100 > (planProgress += progressRatio)) break block9;
            logger.warn((Object)"The progress is extend 100. PlanId:%s, planProgress:%s,progressRatio:%s ", new Object[]{recoveryPlanId, planProgress, progressRatio});
            boolean bl = true;
            DBOperationUtil.closeSession(session);
            return bl;
        }
        try {
            String updateSql = "update ti_recoveryplan set PLANPROGRESS=:planProgress where PLANID=:recoveryPlanId";
            query = session.createSQLQuery(updateSql);
            query.setParameter("planProgress", (Object)planProgress);
            query.setParameter("recoveryPlanId", (Object)recoveryPlanId);
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
            updateResult = true;
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Updating recovery plan progress failed. Id:%s,error:%s.", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryProcessorDetail getRecoveryProcessDetail(String logId, String procId) {
        Session session;
        RecoveryProcessorDetail detail;
        block5: {
            if (VerifyUtil.isEmpty((String)logId) || VerifyUtil.isEmpty((String)procId)) {
                logger.error((Object)"The parameter logId or procId is null.");
                return null;
            }
            detail = null;
            session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String queryHql = "from RecoveryProcessorDetail where parentDetailId=null and logId=:logId and procId=:procId";
                Query query = session.createQuery(queryHql);
                query.setParameter("logId", (Object)logId);
                query.setParameter("procId", (Object)procId);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) break block5;
                detail = (RecoveryProcessorDetail)results.get(0);
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"Getting recovery process detail failed. LogId:%s,ProcId:%s,error:%s.", new Object[]{logId, procId, ExceptionUtil.getErrorMessage((Throwable)ex)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return detail;
    }

    public boolean saveOrUpdateRecoveryProcessDetail(RecoveryProcessorDetail processDetail) {
        boolean updateResult = false;
        if (processDetail == null) {
            logger.error((Object)"The parameter processDetail is null.");
            return updateResult;
        }
        try {
            this.moDao.getHibernateTemplate().saveOrUpdate((Object)processDetail);
            updateResult = true;
        }
        catch (Exception ex) {
            logger.error((Object)"Updating recovery process detail failed,error :%s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryProcessDetail(RecoveryProcessorDetail processDetail) {
        boolean updateResult = false;
        if (processDetail == null || processDetail.getDetailId() == null) {
            logger.error((Object)"The parameter processDetail is null.");
            return updateResult;
        }
        Session session = null;
        try {
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("update ti_recoveryprocessordetail set PROCESSSTATUS=:processStatus, ENDTIME=:endTime");
            updateSql.append(", PROCESSDETAIL=:processDetail, PROCESSDETAILPARAMS=:processDetailParams");
            updateSql.append(", ISSKIPPED=:isSkipped");
            if (processDetail.getProcessName() != null) {
                updateSql.append(", PROCESSNAME=:processName");
            }
            if (processDetail.getProcessNameParams() != null) {
                updateSql.append(", PROCESSNAMEPARAMS=:processNameParams");
            }
            updateSql.append(" where DETAILID=:detailId");
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(updateSql.toString());
            query.setParameter("processStatus", (Object)processDetail.getProcessStatus());
            query.setParameter("endTime", (Object)processDetail.getEndTime());
            query.setParameter("processDetail", (Object)processDetail.getProcessDetail());
            query.setParameter("processDetailParams", (Object)processDetail.getProcessDetailParams());
            query.setParameter("isSkipped", (Object)processDetail.getIsSkipped());
            if (processDetail.getProcessName() != null) {
                query.setParameter("processName", (Object)processDetail.getProcessName());
            }
            if (processDetail.getProcessNameParams() != null) {
                query.setParameter("processNameParams", (Object)processDetail.getProcessNameParams());
            }
            query.setParameter("detailId", (Object)processDetail.getDetailId());
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
            updateResult = true;
            DBOperationUtil.closeSession(session);
        }
        catch (Exception ex) {
            DBOperationUtil.rollbackSession(session);
            logger.error((Object)"Updating recovery process detail failed. Id:%s,error:%s.", new Object[]{processDetail.getDetailId(), ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return updateResult;
    }

    public boolean updateRecoveryProcessDetail(String procDetailId, int procDetailStatus, String procEndTime, String procDetail, String procDetailParams) {
        if (VerifyUtil.isEmpty((String)procDetailId) || DrmEnumDefine.RecoveryPlanExecuteResultE.getType((int)procDetailStatus) == null || VerifyUtil.isEmpty((String)procEndTime)) {
            logger.error((Object)"The parameter is null.");
            return false;
        }
        RecoveryProcessorDetail processDetail = new RecoveryProcessorDetail();
        processDetail.setDetailId(procDetailId);
        processDetail.setProcessStatus(procDetailStatus);
        processDetail.setEndTime(procEndTime);
        processDetail.setProcessDetail(procDetail);
        processDetail.setProcessDetailParams(procDetailParams);
        return this.updateRecoveryProcessDetail(processDetail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRecoveryProcessDetail() {
        Session session = null;
        try {
            String updateSql1 = "update ti_recoveryprocessordetail set PROCESSNAMEPARAMS=:procNameParams ";
            updateSql1 = updateSql1 + "where PROCESSSTATUS=3 and (PROCESSNAMEPARAMS is null or PROCESSNAMEPARAMS='')";
            String updateSql2 = "update ti_recoveryprocessordetail set PROCESSSTATUS=1 ,PROCESSDETAIL=:detail where PROCESSSTATUS=3";
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query1 = session.createSQLQuery(updateSql1);
            NativeQuery query2 = session.createSQLQuery(updateSql2);
            String[] strArray = new String[6];
            for (int index = 0; index < strArray.length; ++index) {
                strArray[index] = "--";
            }
            query1.setParameter("procNameParams", (Object)RecoveryProcessBaseUtil.constructParamsString(strArray));
            query2.setParameter("detail", (Object)"lego.err.1073947452");
            session.beginTransaction();
            query1.executeUpdate();
            query2.executeUpdate();
            session.getTransaction().commit();
            DBOperationUtil.closeSession(session);
        }
        catch (Exception ex) {
            DBOperationUtil.rollbackSession(session);
            logger.error((Object)"Updating recovery process detail failed,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryProcessor(RecoveryProcessor recoveryProcess) {
        boolean updateResult = false;
        if (recoveryProcess == null) {
            logger.error((Object)"The parameter recoveryProcess is null.");
            return updateResult;
        }
        Session session = null;
        try {
            if (!VerifyUtil.isEmpty((String)recoveryProcess.getProcId()) && recoveryProcess.getIsNeedSave().booleanValue()) {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                session.beginTransaction();
                session.saveOrUpdate((Object)recoveryProcess);
                session.getTransaction().commit();
            }
            updateResult = true;
        }
        catch (Exception ex) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Updating recovery process failed,error:%s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return updateResult;
    }

    public void updateRecoveryProcessDefinition(RecoveryProcessDefinition rpDefinition) {
        Session session = HibernateUtil.getSession();
        if (session != null) {
            session.saveOrUpdate((Object)rpDefinition);
        } else {
            this.moDao.getHibernateTemplate().saveOrUpdate((Object)rpDefinition);
        }
    }

    public boolean deleteRecoveryProcessDefinition(RecoveryProcessDefinition rpDefinition) {
        boolean isSuccess = false;
        if (VerifyUtil.isEmpty((Object)rpDefinition)) {
            logger.error((Object)"The parameter rpDefinition is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            this.moDao.getHibernateTemplate().delete((Object)rpDefinition);
            isSuccess = true;
        }
        catch (Exception ex) {
            String errorMsg = String.format(Locale.ROOT, "Delete rpDefinition failed. Plan id:%s,Id:%s.", rpDefinition.getPlanId(), rpDefinition.getProcessId());
            ExceptionUtil.rethrowException((Throwable)ex, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryLog(String recoveryLogId, int logStatus, String endTime) {
        boolean updateResult = false;
        if (VerifyUtil.isEmpty((String)recoveryLogId) || null == DrmEnumDefine.RecoveryPlanExecuteResultE.getType((int)logStatus) || VerifyUtil.isEmpty((String)endTime)) {
            logger.error((Object)"The parameter is null. logId:%s,LogStatus:%s,EndTime:%s.", new Object[]{recoveryLogId, logStatus, endTime});
            return updateResult;
        }
        Session session = null;
        try {
            String updateSql = "update ti_recoverylog set LOGSTATUS=:logStatus, ENDTIME=:endTime where LOGID=:logId";
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(updateSql);
            query.setParameter("logStatus", (Object)logStatus);
            query.setParameter("endTime", (Object)endTime);
            query.setParameter("logId", (Object)recoveryLogId);
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
            updateResult = true;
        }
        catch (Exception ex) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Updating recovery log failed. Id:%s,error :%s.", new Object[]{recoveryLogId, ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecoveryProcessor> getRecoveryProcessors(String planId, List<QueryCondition> conditions, Class<? extends RecoveryProcessor> cls) {
        RecoveryProcessDefinition rpDefinition;
        Session session;
        List<Object> recoveryProcessors;
        block6: {
            recoveryProcessors = new ArrayList<RecoveryProcessor>();
            if (VerifyUtil.isEmpty((String)planId)) {
                logger.error((Object)"The parameter planId is null.");
                return recoveryProcessors;
            }
            session = null;
            rpDefinition = this.getRecoveryProcessDefinition(planId, conditions);
            if (null != rpDefinition) break block6;
            ArrayList<RecoveryProcessor> arrayList = recoveryProcessors;
            DBOperationUtil.closeSession(session);
            return arrayList;
        }
        try {
            HibernateTemplate template = this.moDao.getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            recoveryProcessors = session.createCriteria(cls).add((Criterion)Restrictions.eq((String)"processId", (Object)rpDefinition.getProcessId())).list();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"Getting recovery processes failed. PlanId:%s,ClassName:%s,error :%s.", new Object[]{planId, cls.getSimpleName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return recoveryProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryProcessDefinition getRecoveryProcessDefinition(String planId, List<QueryCondition> conditions) {
        Session session;
        RecoveryProcessDefinition rpDefinition;
        block6: {
            if (planId == null || VerifyUtil.isEmpty(conditions)) {
                logger.error((Object)"Paramers planId or condition is null.");
                return null;
            }
            rpDefinition = null;
            session = null;
            try {
                HibernateTemplate template = this.moDao.getHibernateTemplate();
                session = template.getSessionFactory().openSession();
                List criterionList = this.moDao.translatePropsToCriterions(conditions);
                Criteria criteria = session.createCriteria(RecoveryProcessDefinition.class);
                criteria.add((Criterion)Restrictions.eq((String)"planId", (Object)planId));
                for (Criterion criterion : criterionList) {
                    criteria.add(criterion);
                }
                criteria.add((Criterion)Restrictions.eq((String)"planId", (Object)planId));
                List results = criteria.list();
                if (VerifyUtil.isEmpty((Collection)results) || results.size() != 1) break block6;
                rpDefinition = (RecoveryProcessDefinition)results.get(0);
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"Getting recovery process definition failed. PlanId:%s,error :%s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)ex)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return rpDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSubRecoveryProcessor(String procId) {
        if (VerifyUtil.isEmpty((String)procId)) {
            logger.error((Object)"The parameter procId is null.");
            return false;
        }
        RecoveryProcessor recoveryProcess = this.getRecoveryProcess(procId);
        boolean isSuccess = true;
        if (recoveryProcess == null) {
            logger.error((Object)"The recovery process does not exist. ProcId:%s.", new Object[]{procId});
            return isSuccess;
        }
        Session session = null;
        try {
            HibernateTemplate template = this.moDao.getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            ArrayList<String> logMessages = new ArrayList<String>();
            session.beginTransaction();
            this.deleteSubProcess(session, recoveryProcess, logMessages);
            session.getTransaction().commit();
            for (String logMessage : logMessages) {
                logger.debug((Object)logMessage);
            }
        }
        catch (Exception ex) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Delete sub recovery process failed. ProcId:%s.", new Object[]{procId});
                isSuccess = false;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryProcessor getRecoveryProcess(String procId) {
        Session session;
        RecoveryProcessor recoveryProcess;
        block4: {
            recoveryProcess = null;
            session = null;
            try {
                HibernateTemplate template = this.moDao.getHibernateTemplate();
                session = template.getSessionFactory().openSession();
                String queryHql = "from RecoveryProcessor rp where rp.procId=:procId";
                Query query = session.createQuery(queryHql);
                query.setParameter("procId", (Object)procId);
                List recoveryProcesses = query.list();
                if (recoveryProcesses == null || recoveryProcesses.isEmpty()) break block4;
                recoveryProcess = (RecoveryProcessor)recoveryProcesses.get(0);
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"Getting recovery process failed. Id:%s,error :%s.", new Object[]{procId, ExceptionUtil.getErrorMessage((Throwable)ex)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return recoveryProcess;
    }

    private void deleteSubProcess(Session session, RecoveryProcessor recoveryProcess, List<String> logMessages) {
        if (recoveryProcess.getChildProc() != null && !recoveryProcess.getChildProc().isEmpty()) {
            for (RecoveryProcessor subProcess : recoveryProcess.getChildProc()) {
                session.delete((Object)subProcess);
                String logMsg = this.recordDeletedRecoveryProcess(subProcess);
                logMessages.add(logMsg);
            }
        }
    }

    private String recordDeletedRecoveryProcess(RecoveryProcessor recoveryProcess) {
        StringBuilder builder = new StringBuilder();
        builder.append("The process is deleted. ProcName:");
        builder.append(recoveryProcess.getProcName());
        builder.append(",ProcType:");
        builder.append(recoveryProcess.getProcType());
        builder.append(",ProcId:");
        builder.append(recoveryProcess.getProcId());
        builder.append(",PlanId:");
        builder.append(recoveryProcess.getPlanId());
        return builder.toString();
    }

    private boolean checkParametersForUpdate(String recoveryPlanId, int planStatus, DrmEnumDefine.RecoveryPlanExecuteTypeE planExecuteType, Integer planProgress) {
        boolean isValidPlanProgress = false;
        if (planProgress == null || 0 <= planProgress && 100 >= planProgress) {
            isValidPlanProgress = true;
        }
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || !isValidPlanProgress || DrmEnumDefine.RecoveryPlanStatusE.getType((int)planStatus) == null || planExecuteType == null) {
            logger.error((Object)"Invalid parameter");
            return false;
        }
        return true;
    }

    private void changePlanStatusToFailed(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanStatusE curPlanStatus) {
        Integer targetStatus = curPlanStatus.getFailStatusWhenRunning();
        if (targetStatus != null) {
            logger.info((Object)"Set RecoveryPlan Failed planId:%s, change before status:%s, change after status:%s", new Object[]{recoveryPlan.getPlanId(), recoveryPlan.getPlanStatus(), targetStatus});
            recoveryPlan.setPlanStatus(targetStatus.intValue());
        }
    }

    static {
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING.getValue(), DrmEnumDefine.RecoveryPlanStatusE.MOUNTING_REPLICA.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING.getValue(), DrmEnumDefine.RecoveryPlanStatusE.UMOUNTING_REPLICA.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.MOUNT_FAILED.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.MOUNT_COMPLETED.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_COMPLETED.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_FAILED.getValue());
    }
}

