/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.license;

import com.adaptivelm.license.base.LicLogLevelEnum;
import com.adaptivelm.license.basecallback.LicBaseCallbackGetEsn;
import com.adaptivelm.license.basecallback.LicBaseCallbackPsRead;
import com.adaptivelm.license.basecallback.LicBaseCallbackPsWrite;
import com.adaptivelm.license.basecallback.LicBaseCallbacks;
import com.adaptivelm.license.common.LicenseException;
import com.adaptivelm.license.lkmgr.LicLkActiveRslts;
import com.adaptivelm.license.lkmgr.LicLkBbomTypeEnum;
import com.adaptivelm.license.lkmgr.LicLkPrdAndLic;
import com.adaptivelm.license.lkmgr.LicLkStore;
import com.adaptivelm.license.lkmgr.LicLkStoreBbom;
import com.adaptivelm.license.productmgr.LicPrdBBOMInfo;
import com.adaptivelm.license.productmgr.LicPrdBaseInfo;
import com.adaptivelm.license.productmgr.LicPrdExtendInfo;
import com.adaptivelm.license.productmgr.LicPrdInfo;
import com.adaptivelm.license.service.LicenseConfigService;
import com.adaptivelm.license.service.LicenseOperationService;
import com.adaptivelm.license.statemgr.LicStateChkCfg;
import com.adaptivelm.license.statemgr.LicStateChkItemEnumType;
import com.adaptivelm.license.statemgr.LicStateLicEnumType;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.license.LicenseKey;
import com.huawei.ism.drm.license.RDAppCallback;
import com.huawei.ism.drm.license.sdk.ILicenseUseInter;
import com.huawei.lego.cbb.license.sdk.model.FeatureBo;
import com.huawei.lego.cbb.license.sdk.model.FunctionItemBo;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.license.sdk.model.ResourceItemBo;
import com.huawei.lego.cbb.license.sdk.model.po.LicenseInfo;
import com.huawei.lego.cbb.license.util.LicConstants;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.Session;

public class RDLicenseFactory {
    private static final String LIC_FILES_TMP = "lic/lctm";
    private static final String PRD_NAME = "OceanStor BCManager";
    private static final String PRD_VER = "8";
    private static final int PRD_ID = 0;
    private static final int RES_MAX_COUNT = 10000;
    private static final int RES_CAPACITY_MAX_COUNT = 1000000;
    private static final int FUN_BASE_COUNT = 10001;
    private static final Object ACTIVE_LIC_LOCK = new Object();
    private static RDLicenseFactory instance = null;
    private static final LicenseOperationService ALM_OPER_SERVICE = new LicenseOperationService();
    private static final LicenseConfigService ALM_CONF_SERVICE = new LicenseConfigService();
    private final transient Log logger = LogFactory.getInstance(RDLicenseFactory.class);
    private String productKeyInfo = LicenseKey.getInstance().getKey();

    private RDLicenseFactory() {
        if (this.productKeyInfo == null) {
            throw new LegoCheckedException(1073947436L);
        }
        try {
            this.registerCallback();
            this.setLogLevel();
            ALM_CONF_SERVICE.start();
            this.prdAdd();
            this.stateCheckCfg();
        }
        catch (LicenseException e) {
            this.logger.error((Object)"Init RDLicenseFactory failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Init RDLicenseFactory failed." + (Object)((Object)e));
        }
    }

    public static synchronized RDLicenseFactory getInstance() {
        if (instance == null) {
            try {
                instance = new RDLicenseFactory();
            }
            catch (LegoCheckedException e) {
                instance = null;
                throw e;
            }
        }
        return instance;
    }

    private void registerCallback() {
        LicBaseCallbacks callBacks = new LicBaseCallbacks();
        RDAppCallback callBackFuncs = new RDAppCallback();
        callBacks.setGetEsnCallback((LicBaseCallbackGetEsn)callBackFuncs);
        callBacks.setPsReadCallback((LicBaseCallbackPsRead)callBackFuncs);
        callBacks.setPsWriteCallback((LicBaseCallbackPsWrite)callBackFuncs);
        try {
            ALM_CONF_SERVICE.registBaseCallback(callBacks);
            this.logger.info((Object)"Register base callback functions succeed.");
        }
        catch (LicenseException e) {
            this.logger.error((Object)"Register base callback functions failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Register base callback functions failed." + (Object)((Object)e));
        }
    }

    private void setLogLevel() {
        try {
            ALM_CONF_SERVICE.setLogLevel(LicLogLevelEnum.ALM_LOG_LEVEL_INFO);
        }
        catch (LicenseException e) {
            this.logger.error((Object)"Set log level failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Set log level failed." + (Object)((Object)e));
        }
    }

    private void registerBbomInfo(ArrayList<LicPrdBBOMInfo> itemList) {
        List<String> countItemList = Arrays.asList("LSTQDPMN", "LSTQDPMP", "LSTQCSHA", "LSTQCSDR", "LSTQVHA", "BOMBCMREPSWTB", "BOMVOLDRSSWTB");
        for (int i = 0; i < countItemList.size(); ++i) {
            LicPrdBBOMInfo itemInfo = new LicPrdBBOMInfo();
            itemInfo.setType(LicLkBbomTypeEnum.ALM_LIC_BBOM_RESOURCE);
            itemInfo.setBbomId(i + 1);
            String resourceName = countItemList.get(i);
            itemInfo.setName(resourceName);
            long maxVal = ILicenseUseInter.isCapacityRes((String)resourceName) ? 1000000L : 10000L;
            itemInfo.setMaxVal(maxVal);
            itemInfo.setDfltVal(1L);
            itemInfo.setMinVal(0L);
            itemList.add(itemInfo);
        }
        List<String> controlItemList = Arrays.asList("LSTQDPMM", "LSTQDPMH");
        for (int i = 0; i < controlItemList.size(); ++i) {
            LicPrdBBOMInfo itemInfo = new LicPrdBBOMInfo();
            itemInfo.setType(LicLkBbomTypeEnum.ALM_LIC_BBOM_FUNCTION);
            itemInfo.setBbomId(i + 10001);
            itemInfo.setName(controlItemList.get(i));
            itemInfo.setDfltVal(0L);
            itemList.add(itemInfo);
        }
    }

    private void prdAdd() {
        LicPrdBaseInfo prdBase = new LicPrdBaseInfo();
        prdBase.setPrdName(PRD_NAME);
        prdBase.setPrdVer(PRD_VER);
        prdBase.setPrdId(0);
        ArrayList<LicPrdBBOMInfo> itemList = new ArrayList<LicPrdBBOMInfo>();
        this.registerBbomInfo(itemList);
        LicPrdExtendInfo extendInfo = new LicPrdExtendInfo();
        extendInfo.setSafeTimeEnable(false);
        extendInfo.setEsnVerMisOnce(false);
        extendInfo.setUseMinValInPartOver(false);
        extendInfo.setFixTimeSupport(false);
        extendInfo.setForceCmpSupport(false);
        LicPrdInfo node = new LicPrdInfo();
        node.setBase(prdBase);
        node.setPrdKey(this.productKeyInfo);
        node.setBboms(itemList);
        node.setExtend(extendInfo);
        node.setExtend(extendInfo);
        ArrayList<LicPrdInfo> prdInfoList = new ArrayList<LicPrdInfo>();
        prdInfoList.add(node);
        try {
            int registerResult = ALM_CONF_SERVICE.prdAdd(prdInfoList);
            if (node.getRet() != 0 || registerResult != 0) {
                this.logger.error((Object)"Register bbom Info failed: ALM_CONF_SERVICE.prdAdd fail");
                throw new LegoCheckedException("ALM_CONF_SERVICE.prdAdd failed.");
            }
            this.logger.info((Object)"Register bbom Info success.");
        }
        catch (LicenseException e) {
            this.logger.error((Object)"Register bbom Info failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Register bbom Info failed." + (Object)((Object)e));
        }
    }

    private void stateCheckCfg() {
        LicStateChkCfg prdVerCfg = new LicStateChkCfg();
        prdVerCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_PRD_VER);
        prdVerCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_VALID);
        prdVerCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_VALID);
        prdVerCfg.setIgnore(false);
        prdVerCfg.setIgnoreUpAndLower(false);
        LicStateChkCfg prdNameCfg = new LicStateChkCfg();
        prdNameCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_PRD_NAME);
        prdNameCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_INVALID);
        prdNameCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_INVALID);
        prdNameCfg.setIgnore(false);
        prdNameCfg.setIgnoreUpAndLower(false);
        LicStateChkCfg esnCfg = new LicStateChkCfg();
        esnCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_ESN);
        esnCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_INVALID);
        esnCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_INVALID);
        esnCfg.setIgnore(false);
        esnCfg.setIgnoreUpAndLower(true);
        LicStateChkCfg deadlineOverCfg = new LicStateChkCfg();
        deadlineOverCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_DEADLINE_OVER);
        deadlineOverCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_GRACE_PERIOD);
        deadlineOverCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_GRACE_PERIOD);
        deadlineOverCfg.setIgnore(false);
        deadlineOverCfg.setIgnoreUpAndLower(false);
        LicStateChkCfg rvkCfg = new LicStateChkCfg();
        rvkCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_RVK);
        rvkCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_GRACE_PERIOD);
        rvkCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_GRACE_PERIOD);
        rvkCfg.setIgnore(false);
        rvkCfg.setIgnoreUpAndLower(false);
        ArrayList<LicStateChkCfg> stateChkCfgInfo = new ArrayList<LicStateChkCfg>();
        stateChkCfgInfo.add(prdVerCfg);
        stateChkCfgInfo.add(prdNameCfg);
        stateChkCfgInfo.add(esnCfg);
        stateChkCfgInfo.add(deadlineOverCfg);
        stateChkCfgInfo.add(rvkCfg);
        try {
            ALM_CONF_SERVICE.stateCheckCfg(0, stateChkCfgInfo);
        }
        catch (LicenseException e) {
            this.logger.error((Object)"stateCheckCfg failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("stateCheckCfg failed." + (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LicenseInfo activateLic(byte[] licFile) {
        FileOutputStream output = null;
        FileInputStream fileInputStream = null;
        File file = null;
        Object object = ACTIVE_LIC_LOCK;
        synchronized (object) {
            try {
                this.logger.info((Object)"Check licFile size: %s", new Object[]{String.valueOf(licFile.length)});
                file = new File(this.getTmpFile());
                output = new FileOutputStream(file);
                output.write(licFile);
                output.flush();
                File file2 = new File(this.getTmpFile());
                fileInputStream = new FileInputStream(file2);
                ArrayList<LicLkPrdAndLic> licActiveList = new ArrayList<LicLkPrdAndLic>();
                LicLkPrdAndLic node = new LicLkPrdAndLic();
                node.setPrdId(0);
                node.setFileInputSteam(fileInputStream);
                licActiveList.add(node);
                LicLkActiveRslts activeRslts = ALM_OPER_SERVICE.licGeneralActive(licActiveList);
                if (!VerifyUtil.isEmpty((Object)activeRslts) && activeRslts.getFailNum() != 0) {
                    this.logger.error((Object)"LicGeneralActive failed, failed num: %s", new Object[]{String.valueOf(activeRslts.getFailNum())});
                    throw new LegoCheckedException(1073947422L, "licGeneralActive failed");
                }
                this.logger.info((Object)"Active LicenseKey Success.");
            }
            catch (LicenseException e) {
                try {
                    this.logger.error((Object)"ActivateLic LicenseException: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                    throw new LegoCheckedException(1073947422L, "activateLic LicenseException, errorCode=" + e.getErrorCode());
                    catch (LegoCheckedException e2) {
                        this.logger.error((Object)"LicGeneralActive failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
                        throw new LegoCheckedException(1073947422L, "licGeneralActive failed: " + (Object)((Object)e2));
                    }
                    catch (IOException e3) {
                        this.logger.error((Object)"ActivateLic IOException: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e3)});
                        throw new LegoCheckedException(1073947422L, "ActivateLic IOException: " + e3);
                    }
                }
                catch (Throwable throwable) {
                    CommonUtil.close(output);
                    CommonUtil.close(fileInputStream);
                    this.deleteLicenseFile(file);
                    throw throwable;
                }
            }
            CommonUtil.close((Closeable)output);
            CommonUtil.close((Closeable)fileInputStream);
            this.deleteLicenseFile(file);
            return this.getLicenseInfo(licFile);
        }
    }

    private LicenseInfo getLicenseInfo(byte[] licFile) {
        LicenseInfo licenseInfo;
        try {
            LicLkStore lkStore = ALM_OPER_SERVICE.licGeneralQuery(0);
            licenseInfo = new LicenseInfo();
            licenseInfo.setProductESN((String)lkStore.getGeneral().getEsns().get(0));
            licenseInfo.setProductName(lkStore.getGeneral().getFilePrdName());
            licenseInfo.setProductVers(lkStore.getGeneral().getFilePrdVer());
            licenseInfo.setFile(this.createBlob(licFile));
            licenseInfo.setUploadTime(System.currentTimeMillis());
            licenseInfo.setInUse(true);
            licenseInfo.setSoftId(lkStore.getGeneral().getSoftId());
        }
        catch (LicenseException e) {
            this.logger.error((Object)"Query license error when activateLic: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Query license failed when activateLic: " + (Object)((Object)e));
        }
        return licenseInfo;
    }

    private Blob createBlob(byte[] licFile) {
        Session session;
        block4: {
            Blob blob;
            session = null;
            IBaseDao baseDao = CommonDAOLocator.getBaseDao();
            try {
                session = Objects.requireNonNull(baseDao.getHibernateTemplate().getSessionFactory()).openSession();
                if (null == session) break block4;
                blob = session.getLobHelper().createBlob(licFile);
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)("createBlob Exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
                    throw new LegoCheckedException("createBlob Exception." + e);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
            }
            DBOperationUtil.closeSession(session);
            return blob;
        }
        DBOperationUtil.closeSession(session);
        return null;
    }

    private String getTmpFile() {
        String lrPath = PathUtil.getLegoRuntimePath();
        return lrPath + File.separator + LIC_FILES_TMP;
    }

    private void deleteLicenseFile(File file) {
        try {
            if (file != null && file.exists()) {
                boolean result = file.delete();
                this.logger.debug((Object)("delete license file:" + result));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("delete license file exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException("delete license file exception." + e);
        }
    }

    private long getLicDeadlineTime(String runtime) {
        this.logger.debug((Object)("getLicDeadlineTime-->" + runtime));
        return 0L;
    }

    public long isLicExpired() {
        try {
            LicLkStore lkStore = ALM_OPER_SERVICE.licGeneralQuery(0);
            long feaRunTime = 0L;
            if (!lkStore.getBboms().isEmpty()) {
                feaRunTime = this.getLicDeadlineTime(((LicLkStoreBbom)lkStore.getBboms().get(0)).getTimeInfo().getValidInfo().getDeadLine());
            }
            long deadlineTime = feaRunTime / LicConstants.MILLSECOND_ONE_DAY + 1L;
            long currTime = new Date().getTime() / LicConstants.MILLSECOND_ONE_DAY;
            long remainNum = deadlineTime - currTime;
            this.logger.info((Object)(">>>>" + deadlineTime + "-" + currTime + " = license's remain day is :-- " + remainNum));
            return remainNum;
        }
        catch (LicenseException e) {
            this.logger.error((Object)("isLicExpired failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return 0L;
        }
    }

    public boolean checkLicItemValid(String feaName, String itemName) {
        try {
            LicLkStore lkStore = ALM_OPER_SERVICE.licGeneralQuery(0);
            for (int i = 0; i < lkStore.getBboms().size(); ++i) {
                LicLkStoreBbom item = (LicLkStoreBbom)lkStore.getBboms().get(i);
                long feaRunTime = this.getLicDeadlineTime(item.getTimeInfo().getValidInfo().getDeadLine());
                long deadlinetime = feaRunTime / LicConstants.MILLSECOND_ONE_DAY + 1L;
                long currtime = new Date().getTime() / LicConstants.MILLSECOND_ONE_DAY;
                long remainNum = deadlinetime - currtime;
                if (!item.getFeatureName().equals(feaName) || !item.getBbomName().equals(itemName)) continue;
                if (remainNum >= 0L) {
                    return true;
                }
                break;
            }
        }
        catch (LicenseException e) {
            this.logger.error((Object)("checkLicItemValid failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException("checkLicItemValid failed." + (Object)((Object)e));
        }
        return false;
    }

    private void constructFeatureInfo(LicLkStore lkStore, Map<String, FeatureBo> featureMap, String fileEsn) {
        String feaRunTime = ((LicLkStoreBbom)lkStore.getBboms().get(0)).getTimeInfo().getValidInfo().getDeadLine();
        for (int i = 0; i < lkStore.getBboms().size(); ++i) {
            FeatureBo featureInfo;
            LicLkStoreBbom item = (LicLkStoreBbom)lkStore.getBboms().get(i);
            if (featureMap.containsKey(item.getFeatureName())) {
                featureInfo = featureMap.get(item.getFeatureName());
            } else {
                featureInfo = new FeatureBo();
                featureInfo.setFeaname(item.getFeatureName());
                featureInfo.setEsn(fileEsn);
                featureInfo.setOverTime(feaRunTime);
                featureInfo.setReslst(new ArrayList());
                featureInfo.setFunclst(new ArrayList());
                featureMap.put(item.getFeatureName(), featureInfo);
            }
            if (item.getType() == LicLkBbomTypeEnum.ALM_LIC_BBOM_FUNCTION) {
                FunctionItemBo fib = new FunctionItemBo();
                fib.setFeatureName(item.getFeatureName());
                fib.setFunctionItemName(item.getBbomName());
                fib.setValue("" + item.getValue());
                fib.setOverTime(feaRunTime);
                featureInfo.getFunclst().add(fib);
                continue;
            }
            if (item.getType() != LicLkBbomTypeEnum.ALM_LIC_BBOM_RESOURCE) continue;
            ResourceItemBo rib = new ResourceItemBo();
            rib.setFeatureName(item.getFeatureName());
            rib.setItemName(item.getBbomName());
            long itemValue = item.getValue();
            if (ILicenseUseInter.isCapacityRes((String)item.getBbomName())) {
                itemValue *= 1024L;
            }
            rib.setItemValue("" + itemValue);
            rib.setOverTime(feaRunTime);
            featureInfo.getReslst().add(rib);
        }
    }

    private void checkResList(List<FeatureBo> features) {
        if (features == null || features.isEmpty()) {
            throw new LegoCheckedException(1073947422L);
        }
        FeatureBo fo = features.get(0);
        if (fo == null) {
            throw new LegoCheckedException(1073947422L);
        }
        if (fo.getReslst() == null || fo.getReslst().isEmpty()) {
            throw new LegoCheckedException(1073947422L);
        }
    }

    private void handleFeatures(List<FeatureBo> features) {
        Iterator<FeatureBo> featuresInter = features.iterator();
        while (featuresInter.hasNext()) {
            FeatureBo featureItem = featuresInter.next();
            if ("80021997".equals(featureItem.getFeaname())) {
                featuresInter.remove();
            }
            if (!"81700681".equals(featureItem.getFeaname())) continue;
            featuresInter.remove();
        }
    }

    private List<FeatureBo> createFeatureList(LicLkStore lkStore) {
        ArrayList<FeatureBo> features;
        HashMap<String, FeatureBo> featureMap = new HashMap<String, FeatureBo>();
        if (lkStore != null) {
            String fileEsn = (String)lkStore.getGeneral().getEsns().get(0);
            this.constructFeatureInfo(lkStore, featureMap, fileEsn);
        }
        if ((features = new ArrayList<FeatureBo>(featureMap.values())).size() > 1) {
            this.handleFeatures(features);
        }
        return features;
    }

    public LicenseInfoBo convert2LicBo(byte[] licFile) {
        List<FeatureBo> features;
        String softId;
        String proVersion;
        String proName;
        String fileSn;
        LicenseInfoBo licenseBo;
        String feaRunTime = null;
        try {
            licenseBo = new LicenseInfoBo();
            this.logger.info((Object)("Check licFile size:" + licFile.length));
            LicLkStore lkStore = ALM_OPER_SERVICE.licGeneralQuery(0);
            if (lkStore == null) {
                this.logger.error((Object)"convert2LicBo lkStore is null.");
                throw new LegoCheckedException("convert2LicBo lkStore is null.");
            }
            fileSn = (String)lkStore.getGeneral().getEsns().get(0);
            proName = lkStore.getGeneral().getFilePrdName();
            proVersion = lkStore.getGeneral().getFilePrdVer();
            softId = lkStore.getGeneral().getSoftId();
            if (!VerifyUtil.isEmpty((Collection)lkStore.getBboms())) {
                feaRunTime = ((LicLkStoreBbom)lkStore.getBboms().get(0)).getTimeInfo().getValidInfo().getDeadLine();
            }
            features = this.createFeatureList(lkStore);
            this.checkResList(features);
        }
        catch (LicenseException e) {
            this.logger.error((Object)("convert2LicBo LicenseException: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException("convert2LicBo LicenseException." + (Object)((Object)e));
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("licGeneralQuery in convert2LicBo failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException("licGeneralQuery in convert2LicBo failed." + (Object)((Object)e));
        }
        catch (Exception e) {
            this.logger.error((Object)("Unknown LicenseException in convert2LicBo: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException("Unknown LicenseException in convert2LicBo." + e);
        }
        licenseBo.setFeaBolst(features);
        licenseBo.setProductESN(fileSn);
        licenseBo.setProductName(proName);
        licenseBo.setProductVers(proVersion);
        licenseBo.setFile(licFile);
        licenseBo.setDeadlineTime(Long.valueOf(this.getLicDeadlineTime(feaRunTime)));
        licenseBo.setSoftId(softId);
        return licenseBo;
    }
}

