/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.morphological.service.impl;

import com.huawei.ism.drm.morphological.sdk.model.MorphologicalInfo;
import com.huawei.ism.drm.morphological.sdk.service.IMorphologicalInfoBuilder;
import com.huawei.ism.drm.morphological.sdk.service.IMorphologicalInfoService;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

@Service(name="com.huawei.ism.drm.morphological.sdk.service.IMorphologicalInfoService", desc="", interfaceClass=IMorphologicalInfoService.class)
public class MorphologicalInfoServiceImpl
extends BaseService
implements IMorphologicalInfoService {
    private static final Log LOGGER = LogFactory.getInstance(MorphologicalInfoServiceImpl.class);
    private static final MorphologicalInfoServiceImpl INSTANCE = new MorphologicalInfoServiceImpl();
    private Map<Integer, IMorphologicalInfoBuilder> handlers = new HashMap<Integer, IMorphologicalInfoBuilder>();

    private MorphologicalInfoServiceImpl() {
    }

    public static MorphologicalInfoServiceImpl getInstance() {
        return INSTANCE;
    }

    public MorphologicalInfo getMorphologicalInfo(RecoveryProcessorContext context) {
        int type = context.getProtectGroup().getTemplate().getType();
        IMorphologicalInfoBuilder builder = this.handlers.get(type);
        if (VerifyUtil.isEmpty((Object)builder)) {
            LOGGER.warn((Object)"The template do not contains a builder for morphological info, type:%s", new Object[]{String.valueOf(type)});
            return new MorphologicalInfo();
        }
        return builder.buildMorphologicalInfo(context);
    }

    public void onBind(IMorphologicalInfoBuilder builder, Map<String, Object> properties) {
        this.handlers.put(builder.getPolicyTemplateType(), builder);
    }

    public void onUnbind(IMorphologicalInfoBuilder handler, Map<String, Object> properties) {
        this.handlers.remove(handler.getPolicyTemplateType());
    }
}

