/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.util;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class ProtectGroupBlockingQueue {
    private static final Log logger = LogFactory.getInstance(ProtectGroupBlockingQueue.class);
    private static final BlockingQueue<ProtectGroup> QUEUE = new LinkedBlockingQueue<ProtectGroup>(2000);
    private static final BlockingQueue<ProtectGroup> EXCUTING_QUEUE = new LinkedBlockingQueue<ProtectGroup>(30);

    private ProtectGroupBlockingQueue() {
    }

    public static BlockingQueue<ProtectGroup> getQueue() {
        return QUEUE;
    }

    public static BlockingQueue<ProtectGroup> getExcutingQueue() {
        return EXCUTING_QUEUE;
    }

    public static void addToExcutingQueue(ProtectGroup protectGroup) {
        try {
            EXCUTING_QUEUE.add(protectGroup);
        }
        catch (Exception e) {
            logger.error((Object)"add protectGroup from excutingQueue error: %s", new Object[]{ExceptionUtils.getMessage((Throwable)e)});
        }
    }

    public static void removeFromExcutingQueue(ProtectGroup protectGroup) {
        try {
            EXCUTING_QUEUE.remove(protectGroup);
        }
        catch (Exception e) {
            logger.error((Object)"remove protectGroup from excutingQueue error: %s", new Object[]{ExceptionUtils.getMessage((Throwable)e)});
        }
    }

    public static void put(ProtectGroup protectGroup) {
        logger.debug((Object)"Put to queue. protectGroup(%s)", new Object[]{protectGroup.getName()});
        try {
            QUEUE.put(protectGroup);
        }
        catch (InterruptedException e) {
            logger.error((Object)"take protectGroup from queue error: %s", new Object[]{ExceptionUtils.getMessage((Throwable)e)});
        }
    }

    public static boolean offer(ProtectGroup protectGroup) {
        logger.debug((Object)"Offer to queue. protectGroup(%s)", new Object[]{protectGroup.getName()});
        return QUEUE.offer(protectGroup);
    }

    public static ProtectGroup take() {
        logger.debug((Object)"take protectGroup from queue");
        try {
            return QUEUE.take();
        }
        catch (InterruptedException e) {
            logger.error((Object)"take protectGroup from queue error: %s", new Object[]{ExceptionUtils.getMessage((Throwable)e)});
            return new ProtectGroup();
        }
    }

    public static ProtectGroup poll() {
        logger.debug((Object)"poll protectGroup from queue");
        return (ProtectGroup)QUEUE.poll();
    }
}

