/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.protection.framework.service.replica.retention.bean.ReplicaRetentionStrategy;
import com.huawei.ism.drm.protection.framework.service.replica.retention.impl.ReplicaRetentionJob;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyHandler;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.JobDetailImpl;

public class ReplicaRetentionStrategyManagerImpl
implements IReplicaRetentionStrategyManager {
    private static final Log logger = LogFactory.getInstance(ReplicaRetentionStrategyManagerImpl.class);
    private ITaskManager protectionTaskManager;
    private Set<IReplicaRetentionStrategyHandler> handlerList = new HashSet<IReplicaRetentionStrategyHandler>();

    public void onBind(IReplicaRetentionStrategyHandler provider, Map<?, ?> properties) {
        this.handlerList.add(provider);
    }

    public void onUnbind(IReplicaRetentionStrategyHandler provider, Map<?, ?> properties) {
        this.handlerList.remove(provider);
    }

    public void executeStrategy(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (handler == null) {
            logger.error((Object)"Replica handler is null,name: %s.", new Object[]{pg.getName()});
            return;
        }
        handler.executeStrategy(pg);
    }

    public Set<ReplicaRetentionStrategy> getReplicaRetentionStrategy(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (handler == null) {
            logger.error((Object)"Replica handler is null,name: %s.", new Object[]{pg.getName()});
            return new HashSet<ReplicaRetentionStrategy>();
        }
        return handler.convertReplicaStrategy(pg);
    }

    public boolean checkRetentionStrategy(ProtectGroup pg) {
        String strategyValue = (String)pg.getTemplate().getProps().get("ReplicaRetentionPolicy");
        if (VerifyUtil.isEmpty((String)strategyValue)) {
            logger.info((Object)"Retention strategy is empty");
            return true;
        }
        IReplicaRetentionStrategyHandler supportHandler = this.getSupportHandler(pg);
        if (supportHandler == null) {
            logger.error((Object)("Not support any handler" + (String)pg.getTemplate().getProps().get("ReplicaRetentionPolicy")));
            throw new LegoCheckedException(1073947393L);
        }
        return true;
    }

    private IReplicaRetentionStrategyHandler getSupportHandler(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler supportHandler = null;
        for (IReplicaRetentionStrategyHandler handler : this.handlerList) {
            try {
                if (!handler.checkReplicaStrategy(pg)) continue;
                supportHandler = handler;
                break;
            }
            catch (Exception e) {
                logger.error((Object)("not support handler" + handler.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return supportHandler;
    }

    public void createRetentionTask(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler supportHandler = this.getSupportHandler(pg);
        if (supportHandler == null) {
            logger.error((Object)("Not support any handler" + (String)pg.getTemplate().getProps().get("ReplicaRetentionPolicy")));
            return;
        }
        try {
            Scheduler scheduler = this.protectionTaskManager.getquartzScheduler();
            JobKey jobKey = new JobKey(this.getJobName(pg), this.getJobGroupName());
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            if (jobDetail != null) {
                scheduler.deleteJob(jobKey);
            }
            scheduler.scheduleJob(this.buildJobDeatil(pg), this.buildCronTrigger(pg));
            logger.info((Object)"Create replica retention Job for protect group(name: %s) success!", new Object[]{pg.getName()});
        }
        catch (SchedulerException e) {
            logger.error((Object)"Create replica retention Job for protect group(name: %s) failed! Err msg: %s", new Object[]{pg.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(0x300001L, (Throwable)e);
        }
    }

    public void deleteRetentionTask(ProtectGroup pg) {
        try {
            JobKey jobKey = new JobKey(this.getJobName(pg), this.getJobGroupName());
            JobDetail jobDetail = this.protectionTaskManager.getquartzScheduler().getJobDetail(jobKey);
            if (jobDetail != null) {
                this.protectionTaskManager.getquartzScheduler().deleteJob(jobKey);
            }
            logger.info((Object)"Schedule ReplicaRetentionJob success.");
        }
        catch (SchedulerException e) {
            logger.error((Object)"Schedule ReplicaRetentionJob failed. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public List<ProtectGroupReplica> getToReactivateReplicas(ProtectGroup pg, int protectLocation, Integer differ, Integer type) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (handler == null) {
            logger.error((Object)"Replica handler is null,name: %s.", new Object[]{pg.getName()});
            return null;
        }
        return handler.getToReactivateReplicas(pg, protectLocation, differ, type);
    }

    public void deleteReplicas(List<ProtectGroupReplica> toDelete, ProtectGroup pg) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (handler == null) {
            logger.error((Object)"Replica handler is null,name: %s.", new Object[]{pg.getName()});
            return;
        }
        handler.deleteReplicas(toDelete, pg);
    }

    public Set<String> getUsedReplicaIds(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (handler == null) {
            logger.error((Object)"Replica handler is null,name: %s.", new Object[]{pg.getName()});
            return new HashSet<String>();
        }
        return handler.getUsedReplicaIds(pg);
    }

    private JobDetail buildJobDeatil(ProtectGroup pg) {
        JobDetailImpl jobDetail = new JobDetailImpl();
        jobDetail.setJobClass(ReplicaRetentionJob.class);
        jobDetail.setName(this.getJobName(pg));
        jobDetail.setGroup(this.getJobGroupName());
        jobDetail.setDurability(true);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("pg_id_key", pg.getUuid());
        jobDetail.setJobDataMap(jobDataMap);
        return jobDetail;
    }

    private Trigger buildCronTrigger(ProtectGroup pg) {
        String cronExpression = this.buildCronExpression();
        logger.info((Object)"The cron expression of replica retention task of pg(name: %s) is %s", new Object[]{pg.getName(), cronExpression});
        return TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(pg), this.getTriggerGroupName()).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
    }

    private String buildCronExpression() {
        Calendar calendar = Calendar.getInstance();
        int minutes = (calendar.get(12) + 5) % 60;
        return "0 " + minutes + " * * * ?";
    }

    private String getJobName(ProtectGroup pg) {
        return "retention_job_" + pg.getUuid();
    }

    private String getJobGroupName() {
        return "retention_job_group";
    }

    private String getTriggerName(ProtectGroup pg) {
        return "retention_trigger_" + pg.getUuid();
    }

    private String getTriggerGroupName() {
        return "retention_trigger_group";
    }

    public ITaskManager getProtectionTaskManager() {
        return this.protectionTaskManager;
    }

    public void setProtectionTaskManager(ITaskManager protectionTaskManager) {
        this.protectionTaskManager = protectionTaskManager;
    }

    public List<ProtectGroupReplica> getToReactivateReplicas(ProtectGroup pg, int protectLocation, Integer differ, Integer type, Set<ProtectGroupReplica> mappedReplicas) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (handler == null) {
            logger.error((Object)"Replica handler is null,name: %s", new Object[]{pg.getName()});
            return Collections.emptyList();
        }
        return handler.getToReactivateReplicas(pg, protectLocation, differ, type, mappedReplicas);
    }
}

