/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateBaseTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.provider.AbstractBaseRefactorConfigurationProvider;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationBaseProvider;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BaseRefactorConfigurationProvider
extends AbstractBaseRefactorConfigurationProvider
implements IRefactorConfigurationBaseProvider {
    private static final Log logger = LogFactory.getInstance(BaseRefactorConfigurationProvider.class);
    private static final String CACHE_SITE_PREFIX = "CACHE_SITE_PREFIX_";
    private static final String CACHE_LUN_PREFIX = "CACHE_LUN_PREFIX";
    private static final List<Integer> hyperMetroAsynTypeList = ImmutableList.of((Object)18, (Object)26, (Object)20, (Object)23, (Object)24, (Object)31, (Object)32, (Object)35, (Object)36, (Object)58, (Object)59, (Object)40, (Object[])new Integer[]{41, 42, 43});
    private static List<Integer> lagReversalReplicaTypeList = Arrays.asList(33, 39);

    public void afterRefactorConfiguration(Set<ProtectGroup> protectGroups) {
    }

    @Override
    protected void updateRecoveryProcessDef(RecoveryPlan recoveryPlan) {
        IRecoveryPlanBaseService planService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan planWithProcess = planService.getRecoveryPlanWithProcess(recoveryPlan.getPlanId());
        if (null == planWithProcess) {
            logger.error((Object)("The recovery plan does not exist. Name:" + recoveryPlan.getName()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        Set definitions = planWithProcess.getRecoveryProcesses();
        if (VerifyUtil.isEmpty((Collection)definitions)) {
            return;
        }
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            logger.error((Object)("provicer is null: " + recoveryPlan.getPlanId()), 90160758784001L);
            throw new LegoCheckedException(1073947395L);
        }
        Class customProcessorCls = provider.getCustomRecoveryProcessorClass();
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        for (RecoveryProcessDefinition definition : definitions) {
            int oldProtectionType = definition.getProtectionType();
            Integer newProtectionType = (Integer)mapTemplate.get(oldProtectionType);
            if (newProtectionType != null) {
                definition.setProtectionType(newProtectionType.intValue());
                recoveryProcessService.updateRecoveryProcessDefinition(definition);
            }
            if (!this.getIsReversed().booleanValue()) {
                this.deleteCustomRecoveryProcessors(definition, customProcessorCls, provider);
            }
            if (this.getIsReversed().booleanValue() || recoveryPlan.getProtectGroup().getPoType() != 11) continue;
            this.resetRecoveryProcessorEditStatus(recoveryPlan, definition, recoveryProcessService, oldProtectionType);
        }
    }

    public void resetRecoveryProcessorEditStatus(RecoveryPlan recoveryPlan, RecoveryProcessDefinition definition, IRecoveryProcessBaseService recoveryProcessService, int oldProtectionType) {
        RecoveryProcessDefinition initDefinition = definition.getProtectionType() == 20 ? RecoveryServiceUtil.getInitRecoveryProcessDefinition(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)definition.getProcType()), oldProtectionType) : RecoveryServiceUtil.getInitRecoveryProcessDefinition(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)definition.getProcType()));
        if (VerifyUtil.isEmpty((Object)initDefinition)) {
            logger.error((Object)"Current recovery plan do not have a definition, ProtectionType=%s.", (long)definition.getProtectionType());
            return;
        }
        RecoveryProcessDefinition initRecoveryProcessDefinition = initDefinition;
        definition.getRecoveryProcessors().stream().filter(RecoveryProcessor::getIsEditable).forEach(processor -> initRecoveryProcessDefinition.getRecoveryProcessors().stream().filter(e -> e.getProcName().equals(processor.getProcName())).findFirst().ifPresent(recoveryProcessor -> processor.setIsEnabled(recoveryProcessor.getIsEnabled())));
        recoveryProcessService.updateRecoveryProcessDefinition(definition);
    }

    public void deleteCustomRecoveryProcessors(RecoveryProcessDefinition definition, Class<? extends RecoveryProcessor> customProcessorCls, IRecoveryProcessBaseProvider provider) {
        if (null == customProcessorCls || null == definition || VerifyUtil.isEmpty((Collection)definition.getRecoveryProcessors())) {
            logger.debug((Object)"customProcessorCls or definition or definition.getRecoveryProcessors() is null~!");
            return;
        }
        Set processors = definition.getRecoveryProcessors();
        Iterator procIterator = processors.iterator();
        while (procIterator.hasNext()) {
            RecoveryProcessor processor = (RecoveryProcessor)procIterator.next();
            if (!processor.getClass().getName().equals(customProcessorCls.getName()) || !provider.checkIfAllowDelete(processor)) continue;
            provider.deleteRecoveryProcessors(definition, processor.getProcId(), true);
            procIterator = processors.iterator();
        }
    }

    protected Map<String, String> retrieveProductAndDisasterInfos(ProtectObjectReplica poReplica) {
        logger.debug((Object)"retrieveProductAndDisasterInfos");
        HashMap<String, String> infos = new HashMap<String, String>();
        for (RelicaStorageInfo storageInfo : poReplica.getStorageInfos()) {
            infos.put(storageInfo.getSrcStorageProviderSN(), storageInfo.getStorageProviderSN());
            infos.put(storageInfo.getStorageProviderSN(), storageInfo.getSrcStorageProviderSN());
            infos.put(storageInfo.getSrcStorageProviderSN() + ':' + storageInfo.getSrcStorageId(), storageInfo.getStorageProviderSN() + ':' + storageInfo.getStorageId());
            infos.put(storageInfo.getStorageProviderSN() + ':' + storageInfo.getStorageId(), storageInfo.getSrcStorageProviderSN() + ':' + storageInfo.getSrcStorageId());
        }
        return infos;
    }

    @Override
    protected void refactorProtectObjectStorageInfos(ProtectObject protectObject, Map<String, Object> params) {
        ProtectObjectReplica curPoReplica = this.getProtectObjectReplica(protectObject, params);
        Map<String, String> storageInfos = this.retrieveProductAndDisasterInfos(curPoReplica);
        Iterator iterator = protectObject.getUsedStorageResourceSet().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        String devSn = ((ProtectObjectStorageInfo)iterator.next()).getResourceProviderSN();
        Site site = this.getSite(params, devSn);
        ProtectGroup pg = protectObject.getProtectGroup();
        if (null == pg) {
            return;
        }
        int templateType = pg.getTemplate().getType();
        Set<ProtectObjectStorageInfo> poStorageInfos = this.getProtectObjectStorageInfos(protectObject, storageInfos, site, templateType);
        HashMap<String, String> olToNewWwnMap = new HashMap<String, String>();
        for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
            List<Lun> luns;
            if (DrmEnumDefine.ResourceTypeE.LUN.getValue() != poStorageInfo.getResourceType().intValue()) continue;
            Object lunObj = params.get(CACHE_LUN_PREFIX + poStorageInfo.getResourceProviderSN());
            if (VerifyUtil.isEmpty((Object)lunObj)) {
                luns = this.getStorageLunsByDevId(poStorageInfo.getResourceProviderSN());
                params.put(CACHE_LUN_PREFIX + poStorageInfo.getResourceProviderSN(), luns);
            } else {
                luns = (List<Lun>)lunObj;
            }
            Lun matchedLun = this.filterMatchedLun(poStorageInfo.getResourceId(), luns);
            if (null == matchedLun) {
                logger.error((Object)("There is no matched lun. ResId:" + poStorageInfo.getResourceId()), 90160758784001L);
                throw new LegoCheckedException(1073947394L);
            }
            String newWwn = matchedLun.getWwn();
            olToNewWwnMap.put(poStorageInfo.getLunWWN(), newWwn);
            poStorageInfo.setLunWWN(newWwn);
        }
        params.put("olToNewWwnMap", olToNewWwnMap);
    }

    private Set<ProtectObjectStorageInfo> getProtectObjectStorageInfos(ProtectObject protectObject, Map<String, String> storageInfos, Site site, int templateType) {
        Set poStorageInfos = protectObject.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
            String resourceId = poStorageInfo.getResourceId();
            String resourceProviderSN = poStorageInfo.getResourceProviderSN();
            logger.info((Object)("resourceId:" + resourceId + "resourceProviderSN:" + resourceProviderSN));
            if (DrmEnumDefine.ResourceTypeE.LUN.getValue() == poStorageInfo.getResourceType().intValue() && hyperMetroAsynTypeList.contains(templateType)) {
                ArrayList<String> wwnList = new ArrayList<String>();
                wwnList.add(poStorageInfo.getLunWWN());
                List<Lun> lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByWwns(site.getServerUuid(), wwnList, Lun.class);
                logger.info((Object)("lunWwn=" + poStorageInfo.getLunWWN() + ",get lunlist size " + lunList.size() + ",lunList info " + lunList));
                for (Lun lun : lunList) {
                    String key = lun.getDevSn() + ":" + lun.getLunId();
                    if (!storageInfos.containsKey(key)) continue;
                    resourceId = lun.getLunId();
                    resourceProviderSN = lun.getDevSn();
                    break;
                }
            }
            logger.info((Object)("resourceId:" + resourceId + "resourceProviderSN:" + resourceProviderSN));
            poStorageInfo.setResourceProviderSN(storageInfos.get(resourceProviderSN));
            String str = storageInfos.get(resourceProviderSN + ":" + resourceId);
            String[] strArray = str.split(":");
            if (strArray.length <= 1) continue;
            poStorageInfo.setResourceId(strArray[1]);
        }
        return poStorageInfos;
    }

    private Lun filterMatchedLun(String resourceId, List<Lun> luns) {
        logger.debug((Object)("resourceId:" + resourceId));
        Lun matchedLun = null;
        for (Lun lun : luns) {
            if (!lun.getLunId().equals(resourceId)) continue;
            matchedLun = lun;
            break;
        }
        return matchedLun;
    }

    private Site getSite(Map<String, Object> params, String devSn) {
        logger.debug((Object)("devSn:" + devSn));
        Object siteObj = params.get(CACHE_SITE_PREFIX + devSn);
        Site site = siteObj instanceof Site ? (Site)siteObj : this.getSiteByDeviceSn(devSn);
        return site;
    }

    private List<Lun> getStorageLunsByDevId(String deviceId) {
        logger.debug((Object)("deviceId:" + deviceId));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceId);
        List groups = CommonDAOLocator.getMoDao().findMoBy(Lun.class, props);
        return groups;
    }

    private Site getSiteByDeviceSn(String devSn) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (null == drResource) {
            logger.error((Object)("DrResource is null, sn=" + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(drResource.getSiteId());
        if (null == site) {
            logger.error((Object)("Site is null, siteId=" + drResource.getSiteId()));
            throw new LegoCheckedException(1073947393L);
        }
        return site;
    }

    @Override
    protected abstract void reverseProtectObjectAttributes(ProtectObject var1, Map<String, Object> var2);

    @Override
    protected abstract void reverseProtectGroupAttributes(ProtectGroup var1, Map<String, Object> var2);

    @Override
    protected Set<String> getProductSiteByPo(ProtectObject protectObject) {
        HashSet<String> resourceWwnSet = new HashSet<String>();
        HashSet<String> productSiteIds = new HashSet<String>();
        Set storageInfos = protectObject.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)storageInfos)) {
            logger.error((Object)"storageInfos is empty, poName: %s", new Object[]{protectObject.getName()});
            return productSiteIds;
        }
        ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)storageInfos.iterator().next();
        String wwn = protectObjectStorageInfo.getLunWWN();
        resourceWwnSet.add(wwn);
        List luns = new ArrayList();
        try {
            luns = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getLunByWwn(protectObjectStorageInfo.getResourceProviderSN(), resourceWwnSet);
        }
        catch (Exception e) {
            logger.error((Object)"query lun by wwn error, devsn: %s, wwn: %s", new Object[]{protectObjectStorageInfo.getResourceProviderSN(), wwn});
        }
        Set devSns = luns.stream().map(lun -> lun.getDevSn()).collect(Collectors.toSet());
        for (String devSn : devSns) {
            Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteByDeviceSn(devSn);
            if (VerifyUtil.isEmpty((Object)site)) continue;
            productSiteIds.add(site.getSiteId());
        }
        return productSiteIds;
    }

    @Override
    protected void caculateOtoNewWwnMap(List<ProtectObjectStorageInfo> oldStorageInfoList, ProtectObject protectObject, Map<String, Object> params) {
        HashMap oldStorageInfoWwnMap = new HashMap();
        oldStorageInfoList.stream().forEach(storageInfo -> oldStorageInfoWwnMap.put(storageInfo.getResourceProviderSN() + ':' + storageInfo.getResourceId(), storageInfo.getLunWWN()));
        ProtectObjectReplica curPoReplica = this.getProtectObjectReplica(protectObject, params);
        Map<String, String> storageInfos = this.retrieveProductAndDisasterInfos(curPoReplica);
        HashMap devResourceIdList = new HashMap();
        for (Object storageInfo2 : curPoReplica.getStorageInfos()) {
            CommUtil.addToMap(devResourceIdList, (String)storageInfo2.getSrcStorageProviderSN(), (Object)storageInfo2.getSrcStorageId());
            CommUtil.addToMap(devResourceIdList, (String)storageInfo2.getStorageProviderSN(), (Object)storageInfo2.getStorageId());
        }
        HashMap lunWwnMap = new HashMap();
        for (Map.Entry entry : devResourceIdList.entrySet()) {
            String devSn = (String)entry.getKey();
            List lunIdSet = (List)entry.getValue();
            List storageResourceList = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getStorageResources(devSn, new ArrayList(lunIdSet));
            storageResourceList.stream().forEach(storageResource -> {
                if (storageResource instanceof Lun) {
                    Lun lun = (Lun)storageResource;
                    lunWwnMap.put(lun.getDevSn() + ':' + lun.getResourceId(), lun.getWwn());
                }
            });
        }
        HashMap<String, String> olToNewWwnMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : storageInfos.entrySet()) {
            String wwn1 = (String)lunWwnMap.get(entry.getKey());
            String wwn2 = (String)lunWwnMap.get(entry.getValue());
            if (VerifyUtil.isEmpty((String)wwn1) || VerifyUtil.isEmpty((String)wwn2)) continue;
            olToNewWwnMap.put(wwn1, wwn2);
        }
        params.put("olToNewWwnMap", olToNewWwnMap);
    }

    public void refactorConfiguration(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String disasterSiteId = (String)globalSettings.get("DISASTER_SITE_ID");
        if (ServiceInstaceEnumDefine.ObjectType.NAS.getValue().equals(recoveryPlan.getObjectType())) {
            disasterSiteId = recoveryPlan.getProtectGroup().getProductSiteId();
        }
        logger.debug((Object)"disasterSiteId:%s, recoveryPlan name=%s", new Object[]{disasterSiteId, recoveryPlan.getName()});
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Site disasterSite = siteService.getSiteById(disasterSiteId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("DISASTER_SITE_ID", disasterSiteId);
        if (!VerifyUtil.isEmpty((String)((String)globalSettings.get("PRODUCT_SITE_ID")))) {
            params.put("PRODUCT_SITE_ID", globalSettings.get("PRODUCT_SITE_ID"));
        }
        if (!VerifyUtil.isEmpty((String)((String)globalSettings.get("SELECT_DISASTER_SITE_KEY")))) {
            params.put("SELECT_DISASTER_SITE_KEY", globalSettings.get("SELECT_DISASTER_SITE_KEY"));
        }
        this.extractGlobalSettingToParams(globalSettings, params, "pg_hypermetro_domain");
        this.extractGlobalSettingToParams(globalSettings, params, "pg_hypermetro_domain_id");
        HashMap<String, String> pgAndDisasterHosts = new HashMap<String, String>();
        params.put("PG_DISASTER_HOST", pgAndDisasterHosts);
        String isReversedInGlobalSetting = (String)globalSettings.get("isReserved");
        this.setIsReversed(isReversedInGlobalSetting);
        params.put("isReserved", isReversedInGlobalSetting);
        params.put("RecoveryPlan", recoveryPlan);
        this.refactorConfigurationDoMethod(recoveryPlan, disasterSiteId, disasterSite, params, pgAndDisasterHosts);
        this.refactorRecoveryPlan(recoveryPlan, params);
    }

    private void refactorConfigurationDoMethod(RecoveryPlan recoveryPlan, String disasterSiteId, Site disasterSite, Map<String, Object> params, Map<String, String> pgAndDisasterHosts) {
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)protectGroup.getUuid(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
            if (null != setting) {
                pgAndDisasterHosts.put(protectGroup.getUuid(), setting.getValue());
            }
            protectGroup.setProductSiteId(disasterSiteId);
            protectGroup.setProductSiteName(disasterSite.getName());
            this.refactorProtectGroup(protectGroup, params);
            int oldTemplateType = protectGroup.getTemplate().getType();
            PolicyTemplate newTemplate = ProtectGroupHelper.getInstance().matchAvailableTemplate(protectGroup);
            if (!VerifyUtil.isEmpty((Object)newTemplate)) {
                protectGroup.setTemplate(newTemplate);
            } else {
                this.refactorPolicyTemplate(protectGroup);
            }
            if (!lagReversalReplicaTypeList.contains(oldTemplateType)) {
                this.refactorLocalScheduleAndProps(protectGroup, oldTemplateType);
            } else {
                protectGroup.getProps().put("FS_last_recovery_plan_execute_type", String.valueOf(recoveryPlan.getLastExecuteType()));
            }
            logger.debug((Object)"after refactorLocalScheduleAndPropsrecoveryPlan name=%s", new Object[]{recoveryPlan.getName()});
            if (25 != protectGroup.getTemplate().getType() && !PolicyTemplateBaseTools.getInstance().isCshaCsdrWithinRegionRecovery(protectGroup) && protectGroup.getPoType() != 17) {
                logger.debug((Object)"CleanRemote and buildReplica, protectGroupName=%s", new Object[]{protectGroup.getName()});
                ProtectGroupUtil.clearRemoteReplicas(protectGroup.getReplicaList());
                ProtectGroupHelper.getInstance().buildReplica(protectGroup, false);
                this.refactorLocalReplica(protectGroup, params);
            }
            if (lagReversalReplicaTypeList.contains(oldTemplateType)) {
                this.refactorLocalScheduleAndProps(protectGroup, oldTemplateType);
                protectGroup.getProps().remove("FS_last_recovery_plan_execute_type");
            }
            this.resumeGroup(protectGroup);
        }
    }

    private void extractGlobalSettingToParams(Map<String, String> globalSettings, Map<String, Object> params, String key) {
        if (!VerifyUtil.isEmpty((String)globalSettings.get(key))) {
            params.put(key, globalSettings.get(key));
        }
    }

    protected void refactorRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, Object> params) {
        logger.debug((Object)"refactorRecoveryPlan");
        HashMap<String, String> newGlobalSettings = new HashMap<String, String>();
        newGlobalSettings.put("RECOVERY_EXTEND_ATTRIBUTES", String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()));
        newGlobalSettings.put("DISASTER_SITE_ID", params.get("DISASTER_SITE_ID").toString());
        newGlobalSettings.put("isReserved", String.valueOf(params.get("isReserved")));
        if (!VerifyUtil.isEmpty((Object)params.get("PRODUCT_SITE_ID"))) {
            newGlobalSettings.put("PRODUCT_SITE_ID", String.valueOf(params.get("PRODUCT_SITE_ID")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("SELECT_DISASTER_SITE_KEY"))) {
            newGlobalSettings.put("SELECT_DISASTER_SITE_KEY", String.valueOf(params.get("SELECT_DISASTER_SITE_KEY")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("pg_hypermetro_domain"))) {
            newGlobalSettings.put("pg_hypermetro_domain", String.valueOf(params.get("pg_hypermetro_domain")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("pg_hypermetro_domain_id"))) {
            newGlobalSettings.put("pg_hypermetro_domain_id", String.valueOf(params.get("pg_hypermetro_domain_id")));
        }
        recoveryPlan.setGlobalSettings(newGlobalSettings);
        HashSet<RecoverySetting> needRemovedSettings = new HashSet<RecoverySetting>();
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        for (RecoverySetting recoverySetting : recoverySettings) {
            if (!"PG_DISASTER_HOST".equals(recoverySetting.getName())) continue;
            needRemovedSettings.add(recoverySetting);
        }
        for (RecoverySetting setting : needRemovedSettings) {
            recoverySettings.remove(setting);
        }
    }

    protected void caculateOToNewWwnMap(List<ProtectObjectStorageInfo> oldStorageInfoList, ProtectObject protectObject, Map<String, Object> params) {
        HashMap oldStorageInfoWwnMap = new HashMap();
        oldStorageInfoList.stream().forEach(storageInfo -> oldStorageInfoWwnMap.put(storageInfo.getResourceProviderSN() + ':' + storageInfo.getResourceId(), storageInfo.getLunWWN()));
        ProtectObjectReplica curPoReplica = this.getProtectObjectReplica(protectObject, params);
        Map<String, String> storageInfos = this.retrieveProductAndDisasterInfos(curPoReplica);
        HashMap devResourceIdList = new HashMap();
        for (Object storageInfo2 : curPoReplica.getStorageInfos()) {
            CommUtil.addToMap(devResourceIdList, (String)storageInfo2.getSrcStorageProviderSN(), (Object)storageInfo2.getSrcStorageId());
            CommUtil.addToMap(devResourceIdList, (String)storageInfo2.getStorageProviderSN(), (Object)storageInfo2.getStorageId());
        }
        HashMap lunWwnMap = new HashMap();
        for (Map.Entry entry : devResourceIdList.entrySet()) {
            String devSn = (String)entry.getKey();
            List lunIdSet = (List)entry.getValue();
            List storageResourceList = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getStorageResources(devSn, new ArrayList(lunIdSet), DrmEnumDefine.ResourceTypeE.LUN);
            storageResourceList.stream().forEach(storageResource -> {
                if (storageResource instanceof Lun) {
                    Lun lun = (Lun)storageResource;
                    lunWwnMap.put(lun.getDevSn() + ':' + lun.getResourceId(), lun.getWwn());
                }
            });
        }
        HashMap<String, String> olToNewWwnMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : storageInfos.entrySet()) {
            String wwn1 = (String)lunWwnMap.get(entry.getKey());
            String wwn2 = (String)lunWwnMap.get(entry.getValue());
            if (VerifyUtil.isEmpty((String)wwn1) || VerifyUtil.isEmpty((String)wwn2)) continue;
            olToNewWwnMap.put(wwn1, wwn2);
        }
        params.put("olToNewWwnMap", olToNewWwnMap);
    }
}

