/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.reprotect.subscriber;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ReprotectMessageSubscriber
extends MessageTaskManager {
    private static final Log logger = LogFactory.getInstance(ReprotectMessageSubscriber.class);

    public ReprotectMessageSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(100001L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        if (mu == null) {
            return;
        }
        long msgType = mu.getCmdcode();
        if (msgType != 100001L) {
            logger.error((Object)"Message was not subscribed, msgType:%s", new Object[]{String.valueOf(msgType)});
            return;
        }
        Object msg = mu.getObj();
        if (msg == null || !(msg instanceof Set)) {
            return;
        }
        if (MessageTopic.DATA.equals((Object)mu.getMt())) {
            this.processDataMessage(msg);
        } else {
            logger.info((Object)"Not subscribed topic. Type:%s", new Object[]{mu.getMt().name()});
        }
    }

    private void processDataMessage(Object msg) {
        Set objs = (Set)msg;
        for (ProtectGroup protectGroup : objs) {
            this.syncRestoreAlarmToRemoteSite(protectGroup);
            this.deleteProtectGroupHistoryLog(protectGroup);
        }
    }

    private void deleteProtectGroupHistoryLog(ProtectGroup protectGroup) {
        protectGroup.setPgHistoryLogs(new HashSet());
        IProtectGroupBaseService protectGroupService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        protectGroupService.deleteProtectGroupHistory(protectGroup.getUuid());
    }

    private void syncRestoreAlarmToRemoteSite(ProtectGroup protectGroup) {
        Set replicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica replica : replicas) {
            String recoverySiteId = replica.getRecoverySite();
            if (VerifyUtil.isEmpty((String)recoverySiteId)) continue;
            Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(recoverySiteId);
            if (VerifyUtil.isEmpty((Object)site)) {
                logger.error((Object)"Recovery Site is not exsit");
                throw new LegoCheckedException(1073947440L);
            }
            if (1 == site.getSiteType()) {
                HashMap<String, String> uriVariables = new HashMap<String, String>();
                uriVariables.put("protectGroupId", protectGroup.getUuid());
                String errorMsg = "sync Rest Alarm to remote site error";
                RestClient client = SiteUtil.initClient(site);
                try {
                    client.invoke("/ws/protectgroups/{protectGroupId}/action/updateProtectGroupAlarm", uriVariables, HttpMethod.PUT);
                    continue;
                }
                catch (LegoCheckedException le) {
                    logger.error((Object)errorMsg, (Throwable)le, 90160758787071L);
                    throw le;
                }
                catch (Exception e) {
                    ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073947440L, (String[])new String[0], (Log)logger);
                    continue;
                }
            }
            ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).restoreAlarmById(protectGroup.getUuid());
        }
    }
}

