/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchResultUtil {
    private static final Log logger = LogFactory.getInstance(BatchResultUtil.class);

    protected static void setBatchResult(BatchOperationResult batchOperationResult, List<Long> moIds, Long userId) {
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        for (Long moId : moIds) {
            BatchOperation batchOperation = new BatchOperation();
            resultList.add(batchOperation);
            batchOperation.setTargetId(moId.longValue());
            try {
                ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).checkUserGrantedMOObject(userId, new long[]{moId});
                List obs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from TopoObject where moId=?", new Object[]{moId});
                if (VerifyUtil.isEmpty((Collection)obs)) {
                    ++fail;
                    batchOperation.setErrorCode(1073947394L);
                    continue;
                }
                String mainType = ((TopoObject)obs.get(0)).getMainType();
                SiteResourceServiceProxy.getInstance().getSiteResourceService(mainType).isResourceUsed(moId);
            }
            catch (LegoCheckedException ex) {
                logger.error((Object)"checkResourceUsed Exception. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                ++fail;
                batchOperation.setErrorCode(ex.getErrorCode());
                batchOperation.setDetailParam(ex.getParameters());
            }
            catch (Exception ex) {
                logger.error((Object)"checkResourceUsed Error.error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex), 90160758787071L});
                ++fail;
                batchOperation.setErrorCode(-1L);
            }
        }
        batchOperationResult.setFailCount(fail);
        batchOperationResult.setSucceedCount(batchOperationResult.getTotalCount() - fail);
        batchOperationResult.setResult(resultList);
    }
}

