/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.util;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.util.ScopeManagerUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.criterion.Criterion;
import org.springframework.dao.DataAccessException;

public final class SiteResourceManagerUtil {
    private static final Log logger = LogFactory.getInstance(SiteResourceManagerUtil.class);

    private SiteResourceManagerUtil() {
    }

    public static Page pageQueryRessources(String orderBy, int pageNo, int pageSize, boolean isAsc, Class<?> clazz, List<QueryCondition> queryCondition) {
        try {
            List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryCondition);
            return CommonDAOLocator.getBaseDao().pagedQuery(clazz, pageNo, pageSize, criterionList, orderBy, isAsc);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"PageQueryRessources Exception.");
            throw e;
        }
    }

    public static List<String> getResourceSNBySiteId(String siteId, int resType) {
        String queryTable = resType == 1 ? "DrHost" : "DrStorage";
        try {
            return CommonDAOLocator.getBaseDao().getHibernateTemplate().find("select deviceSn from " + queryTable + " where siteId=?", (Object[])new String[]{siteId});
        }
        catch (DataAccessException ex) {
            logger.error((Object)"failed to get sn: %s.", new Object[]{ex, siteId});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public static List<String> getRegisteredResourceSN(int resType) {
        String queryTable = resType == 1 ? "DrHost" : "DrStorage";
        try {
            return CommonDAOLocator.getBaseDao().getHibernateTemplate().find("select deviceSn from " + queryTable + " where siteId in (select siteId from Site where siteType = ? )", new Object[]{0});
        }
        catch (DataAccessException ex) {
            logger.error((Object)"Failed to get sn:%s", new Object[]{ex, String.valueOf(resType)});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public static List translateCriAndGetResource(List<String> sns, Class<?> clazz, String snKey) {
        ArrayList<QueryCondition> queryCondition = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition(snKey, (Object)sns.toArray());
        queryCondition.add(condition);
        List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryCondition);
        return CommonDAOLocator.getBaseDao().createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    public static List translateCriAndGetResource(List<String> sns, Class<?> clazz, String snKey, String siteId) {
        ArrayList<QueryCondition> queryCondition = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition(snKey, (Object)sns.toArray());
        QueryCondition conditionSiteId = new QueryCondition("siteId", (Object)siteId);
        queryCondition.add(condition);
        queryCondition.add(conditionSiteId);
        List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryCondition);
        return CommonDAOLocator.getBaseDao().createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    public static Site isSiteExisted(String siteId) {
        if (null == siteId) {
            logger.error((Object)"unable to get site,siteId is null:", 90160758786873L);
            return null;
        }
        try {
            return (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        }
        catch (DataAccessException ex) {
            logger.error((Object)("unable to get site by siteId when page storage:" + siteId), (Throwable)ex, 90160758786873L);
            return null;
        }
    }

    public static List<Long> getMOIdsBySns(List<String> sns, Long userId) {
        List<NetworkEntity> filterEntities = ScopeManagerUtil.filterManagedObjectByScope(sns, userId, NetworkEntity.class);
        if (filterEntities.isEmpty()) {
            return null;
        }
        ArrayList<Long> fiterMoIds = new ArrayList<Long>();
        for (NetworkEntity entity : filterEntities) {
            fiterMoIds.add(entity.getMoId());
        }
        return fiterMoIds;
    }

    public static List<String> filterDrResourceSN(List<String> sns, Long userId) {
        if (sns.isEmpty()) {
            return new ArrayList<String>();
        }
        List<NetworkEntity> filterEntities = ScopeManagerUtil.filterManagedObjectByScope(sns, userId, NetworkEntity.class);
        if (filterEntities.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> fiterSns = new ArrayList<String>();
        for (NetworkEntity entity : filterEntities) {
            fiterSns.add(entity.getSn());
        }
        return fiterSns;
    }

    public static List<DrResource> filterDrResource(List<DrResource> resources, Long userId) {
        if (null == resources || resources.isEmpty()) {
            return new ArrayList<DrResource>();
        }
        ArrayList<String> devSns = new ArrayList<String>();
        for (DrResource resource : resources) {
            devSns.add(resource.getDeviceSn());
        }
        List<String> filterSns = SiteResourceManagerUtil.filterDrResourceSN(devSns, userId);
        if (null == filterSns || filterSns.isEmpty()) {
            return new ArrayList<DrResource>();
        }
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        block1: for (DrResource resource : resources) {
            for (String sn : filterSns) {
                if (!sn.equals(resource.getDeviceSn())) continue;
                result.add(resource);
                continue block1;
            }
        }
        return result;
    }

    private static List<DrResource> getRegisteredSNs() {
        try {
            return CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrStorage where siteId in (select siteId from Site where siteType=?)", new Object[]{0});
        }
        catch (DataAccessException ex) {
            logger.error((Object)"failed to get sn of host:", (Throwable)ex, 90160758786874L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public static String getResourceName(String sn) {
        try {
            List names = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("select name from DrResource where deviceSn=?", new Object[]{sn});
            if (!VerifyUtil.isEmpty((Collection)names) && !names.isEmpty()) {
                return (String)names.get(0);
            }
        }
        catch (DataAccessException ex) {
            logger.error((Object)("failed to get sn of resource:" + sn), (Throwable)ex, 90160758787071L);
        }
        return null;
    }

    public static DrResource getDrResourceByMoId(Long moId) {
        if (null == moId) {
            throw new LegoCheckedException(1073947393L);
        }
        List resources = null;
        try {
            resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where deviceSn=(select sn from NetworkEntity where moId=?) and siteId in (select siteId from Site where siteType=?)", new Object[]{moId, 0});
        }
        catch (DataAccessException ex) {
            logger.error((Object)("failed to get DrResource of moId:" + moId), (Throwable)ex, 90160758786874L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        if (null != resources && !resources.isEmpty()) {
            return (DrResource)resources.get(0);
        }
        return null;
    }

    public static <T extends DrResource> boolean isResourceExists(Set<T> resources) {
        if (null == resources) {
            return false;
        }
        String[] deviceSns = new String[resources.size()];
        int index = 0;
        for (DrResource resource : resources) {
            deviceSns[index] = resource.getDeviceSn();
            ++index;
        }
        for (String devSn : deviceSns) {
            if (!SiteResourceManagerUtil.isResourceExists(devSn)) continue;
            return true;
        }
        return false;
    }

    public static boolean isResourceExists(String deviceSn) {
        List resourcesInDB = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where deviceSn=?", new Object[]{deviceSn});
        return resourcesInDB != null && !resourcesInDB.isEmpty();
    }

    public static void checkMaxRes(int resType, int currentSize) {
        int maxVal;
        if (2 != resType) {
            return;
        }
        String key = "storage.max.number";
        Map<Object, Object> resMaps = SiteResourceManagerUtil.getResMaxByType();
        Object keyObj = resMaps.get(key);
        if (VerifyUtil.isEmpty(resMaps) || VerifyUtil.isEmpty((Object)keyObj)) {
            return;
        }
        try {
            maxVal = Integer.parseInt(keyObj.toString());
            if (maxVal < 0) {
                return;
            }
        }
        catch (Exception e) {
            logger.error((Object)("read resourceManager file is value  error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786874L);
            return;
        }
        int resSize = 0;
        List<DrResource> ress = SiteResourceManagerUtil.getRegisteredSNs();
        if (!VerifyUtil.isEmpty(ress)) {
            resSize = ress.size();
        }
        if (currentSize + resSize > maxVal) {
            throw new LegoCheckedException(1073947402L, new String[]{maxVal + ""});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<Object, Object> getResMaxByType() {
        ConcurrentHashMap<Object, Object> concurrentHashMap;
        ConcurrentHashMap<Object, Object> resMaps = new ConcurrentHashMap<Object, Object>();
        BufferedInputStream bf = null;
        try {
            ClassLoader clsLoader = SiteResourceManagerUtil.class.getClassLoader();
            if (clsLoader != null) {
                bf = new BufferedInputStream(clsLoader.getResourceAsStream("conf.properties"));
                Properties ress = new Properties();
                ress.load(bf);
                for (Map.Entry<Object, Object> res : ress.entrySet()) {
                    resMaps.put(res.getKey(), res.getValue());
                }
            }
            concurrentHashMap = resMaps;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("failed read resourceManager file is error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786874L);
            }
            catch (Throwable throwable) {
                CommonUtil.close(bf);
                throw throwable;
            }
            CommonUtil.close((Closeable)bf);
            return resMaps;
        }
        CommonUtil.close(bf);
        return concurrentHashMap;
    }
}

