/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroBaseManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.HashMap;
import java.util.Map;

public class StorageHyperMetroManagerProxy
extends BaseStorageManagerProxy {
    private static StorageHyperMetroManagerProxy proxy = new StorageHyperMetroManagerProxy();
    private Map<String, IStorageHyperMetroBaseManager> managers = new HashMap<String, IStorageHyperMetroBaseManager>();

    public static StorageHyperMetroManagerProxy getInstance() {
        return proxy;
    }

    public void onBind(IStorageHyperMetroBaseManager handler, Map<String, Object> properties) {
        this.managers.put(handler.getStorageType() + handler.getVersion(), handler);
    }

    public void onUnbind(IStorageHyperMetroBaseManager handler, Map<String, Object> properties) {
        this.managers.remove(handler.getStorageType() + handler.getVersion());
    }

    public IStorageHyperMetroBaseManager getMgrByDevType(String deviceType) {
        return this.managers.get(deviceType);
    }

    public IStorageHyperMetroBaseManager getMgrByDevId(String deviceId) {
        String deviceType = this.getStorageType(deviceId);
        IStorageHyperMetroBaseManager mgr = this.managers.get(deviceType);
        if (mgr == null) {
            logger.error((Object)"IStorageHyperMetroManager is null, sn=%s.", new Object[]{deviceId});
            throw new LegoCheckedException(1073947393L);
        }
        return mgr;
    }
}

