/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.builder;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceBaseService;
import com.huawei.ism.drm.topo.builder.TopoLegendBuilder;
import com.huawei.ism.drm.topo.sdk.builder.ITopoBaseBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoBuilderManager;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoBaseService;
import com.huawei.ism.drm.topo.utils.TopoBuildUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.twaver.DataBox;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.Group;
import com.huawei.twaver.Node;
import com.huawei.twaver.XMLSerializer;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class GlobalTopoBuilder {
    private static final String USEFUL = "useful";
    private static final String CENTER = "center";
    private static final String COUNT = "count";
    private static final double NUM_TWO = 2.0;
    private static final double NODE_START_X = 300.0;
    private static final double NODE_INTERVAL_X = 200.0;
    private static final double NODE_INTERVAL_X_SMALL = 100.0;
    private static final double NODE_LEVEL_HOST = 100.0;
    private static final double NODE_LEVEL_VIS = 300.0;
    private static final double NODE_LEVEL_STORAGE = 500.0;
    private static final double NODE_LEVEL_SERVER = 700.0;
    private static final double VIS_DOUBLE_ACTIVE_GAP = 100.0;
    private static final List<Integer> RECOVERY_PLAN_STATUS_LIST = new ArrayList<Integer>(Arrays.asList(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING.getValue(), DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING.getValue(), DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING.getValue()));
    private long userId = 1L;
    private final Log logger = LogFactory.getInstance(this.getClass());
    private ITopoResourceManager resourceManager;
    private IProtectGroupBaseService protectGroupService;
    private ISiteBaseService siteService;
    private IStorageBaseService storageService;
    private IRecoveryPlanBaseService recoveryPlanService;
    private ITopoBuilderManager topoBuilderManager;
    private ILicenseBaseControl licenseControl;
    private IReplicaBaseService replicaService;
    private IDrmTopoBaseService topoService;
    private IStorageResourceBaseService storageResourceService;

    public void setResourceManager(ITopoResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setProtectGroupService(IProtectGroupBaseService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.siteService = siteService;
    }

    public void setStorageService(IStorageBaseService storageService) {
        this.storageService = storageService;
    }

    public void setRecoveryPlanService(IRecoveryPlanBaseService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public void setTopoBuilderManager(ITopoBuilderManager topoBuilderManager) {
        this.topoBuilderManager = topoBuilderManager;
    }

    public void setLicenseControl(ILicenseBaseControl licenseControl) {
        this.licenseControl = licenseControl;
    }

    public void setReplicaService(IReplicaBaseService replicaService) {
        this.replicaService = replicaService;
    }

    public void setTopoService(IDrmTopoBaseService topoService) {
        this.topoService = topoService;
    }

    public void setStorageResourceService(IStorageResourceBaseService storageResourceService) {
        this.storageResourceService = storageResourceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> createGlobalTopo() {
        ElementBox box = new ElementBox();
        List<String> results = null;
        try {
            ElementBox layout = this.getLayoutBox("1000001");
            List protectGroups = this.protectGroupService.getAllProtectGroupBasicInfo(Long.valueOf(this.userId), false, true, false);
            TopoBaseContext context = null;
            if (null != protectGroups) {
                context = this.buildTopoForAllProtectGroups(box, layout, protectGroups);
            }
            this.setGlobalTopoLayout(context);
            results = new ArrayList<String>();
            results.add("success");
            String legendBoxStr = new TopoLegendBuilder().getLegendBoxString(box);
            results.add(new XMLSerializer((DataBox)box).serializeCommon());
            results.add(legendBoxStr);
            results.add(String.valueOf(layout.getClient(USEFUL)));
            results.add(this.getClusterFlag(context));
            results.add(this.getVisWWNMap(context));
            results.add(this.getVisTakeBackWWNMap(context));
            results.add(this.getVisNodeMap(context));
        }
        catch (LegoCheckedException exception) {
            this.logger.error((Object)"Get global topo failed. ", (Throwable)exception, 90160758787071L);
            results = this.getErrorResults(exception.getErrorCode());
        }
        catch (Exception exception) {
            this.logger.error((Object)("Get global topo failed. " + ExceptionUtil.getErrorMessage((Throwable)exception)), 90160758787071L);
            results = this.getErrorResults(-1L);
        }
        finally {
            TopoBaseContext.setCurrentTopoContext(null);
        }
        return results;
    }

    private TopoBaseContext buildTopoForAllProtectGroups(ElementBox box, ElementBox layout, List<ProtectGroup> protectGroups) {
        TopoBaseContext context = null;
        Map<String, Long> poNumMap = this.getPoNumMap();
        for (ProtectGroup protectGroup : protectGroups) {
            try {
                int type = protectGroup.getTemplate().getType();
                if (this.checkProtectGroup(protectGroup, poNumMap) || !this.checkPgLicense(protectGroup)) continue;
                ITopoBaseBuilder builder = null;
                int poType = protectGroup.getPoType();
                builder = poType == 12 ? this.topoBuilderManager.getTopoBuilder("Global-Topology-" + type + "-" + poType) : this.topoBuilderManager.getTopoBuilder("Global-Topology-" + type);
                if (builder == null) continue;
                if (context == null) {
                    context = new TopoBaseContext(this.topoBuilderManager, protectGroup, box);
                    context.setProtectGroupService(this.protectGroupService);
                    context.setSiteService(this.siteService);
                    context.setStorageService(this.storageService);
                    context.setReplicaService(this.replicaService);
                    context.setTopoBaseService(this.topoService);
                    context.setStorageResourceService(this.storageResourceService);
                } else {
                    context = new TopoBaseContext(context, protectGroup);
                }
                context.bind((Object)"layout", (Object)layout);
                TopoBaseContext.setCurrentTopoContext((TopoBaseContext)context);
                builder.buildTopo(context);
            }
            catch (Exception e) {
                this.logger.error((Object)("buildTopoForAllProtectGroups failed. PgId: " + protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
        return context;
    }

    private boolean checkPgLicense(ProtectGroup protectGroup) {
        try {
            this.licenseControl.checkEnablePgTopo(protectGroup);
        }
        catch (Exception e) {
            this.logger.debug((Object)("checkPgLicense failed. PgId: " + protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
        return true;
    }

    private Map<String, Long> getPoNumMap() {
        HashMap<String, Long> poNumMap = new HashMap<String, Long>();
        String hql = "select protectGroup.pgId, count(poId) from ProtectObject group by protectGroup.pgId";
        try {
            List listResult = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, null);
            for (Object eachStatus : listResult) {
                Object[] objArr;
                if (!(eachStatus instanceof Object[]) || (objArr = (Object[])eachStatus).length != 2) continue;
                String pgId = (String)objArr[0];
                long lNum = (Long)objArr[1];
                poNumMap.put(pgId, lNum);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("getPoNumMap failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return poNumMap;
    }

    private String getClusterFlag(TopoBaseContext context) {
        if (context == null) {
            return "false";
        }
        return String.valueOf(context.isVisCluster());
    }

    private String getVisWWNMap(TopoBaseContext context) {
        if (context == null) {
            return "";
        }
        Map visWWNMaps = context.getVisWWNMaps();
        return this.buildVisValue(visWWNMaps);
    }

    private String buildVisValue(Map<String, String> visWWNMaps) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> eachEntry : visWWNMaps.entrySet()) {
            builder.append(eachEntry.getKey());
            builder.append("---");
            builder.append(eachEntry.getValue());
            builder.append(";");
        }
        String mapStr = builder.toString();
        if (mapStr == null || mapStr.isEmpty()) {
            return mapStr;
        }
        return mapStr.substring(0, mapStr.length() - 1);
    }

    private String getVisTakeBackWWNMap(TopoBaseContext context) {
        if (context == null) {
            return "";
        }
        Map visWWNMaps = context.getVisTakeBackNodeIdMaps();
        return this.buildVisValue(visWWNMaps);
    }

    private String getVisNodeMap(TopoBaseContext context) {
        StringBuilder builder = new StringBuilder();
        if (context == null) {
            return builder.toString();
        }
        Map visNodeIdMaps = context.getVisNodeIdMaps();
        if (visNodeIdMaps == null || visNodeIdMaps.isEmpty()) {
            return builder.toString();
        }
        for (Map.Entry eachEntry : visNodeIdMaps.entrySet()) {
            builder.append((String)eachEntry.getKey());
            builder.append("+++");
            builder.append((String)eachEntry.getValue());
            builder.append(";");
        }
        return builder.toString();
    }

    private boolean checkProtectGroup(ProtectGroup protectGroup, Map<String, Long> poNumMap) {
        if (protectGroup.isInvalid()) {
            long poNum = 0L;
            if (poNumMap.containsKey(protectGroup.getUuid())) {
                poNum = poNumMap.get(protectGroup.getUuid());
            }
            if (poNum == 0L) {
                this.logger.error((Object)("Po is empty, PgName: " + protectGroup.getName()), 90160758786962L);
                return true;
            }
            String recoveryPlanId = this.recoveryPlanService.getAssociatedRecoveryPlanWithProtectGroup(protectGroup.getUuid());
            if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
                return false;
            }
            RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlan(recoveryPlanId, false, false);
            if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
                this.logger.error((Object)("recoveryPlan is null, PgName: " + protectGroup.getName()), 90160758786962L);
                return true;
            }
            int recoveryPlanStatus = recoveryPlan.getPlanStatus();
            if (RECOVERY_PLAN_STATUS_LIST.contains(recoveryPlanStatus)) {
                this.logger.error((Object)("recoveryPlan is completed, PgName: " + protectGroup.getName()), 90160758786962L);
                return true;
            }
        }
        return false;
    }

    private void setGlobalTopoLayout(TopoBaseContext context) {
        if (context == null) {
            this.logger.debug((Object)"topoContext is null,not set setGlobalTopoLayout.");
            return;
        }
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        if (layout == null) {
            return;
        }
        String isUseSaved = String.valueOf(layout.getClient(USEFUL));
        if (Boolean.valueOf(isUseSaved).booleanValue()) {
            return;
        }
        layout.setClient(USEFUL, (Object)true);
        List visNodeIds = context.getVisNodeIds();
        if (!visNodeIds.isEmpty()) {
            this.setVisGlobalTopoLayout(context);
        } else {
            this.setReplicationGlobalTopoLayout(context);
        }
    }

    private void setVisGlobalTopoLayout(TopoBaseContext context) {
        Node hostNode;
        List hostNodeIds = context.getHostNodeIds();
        List storageNodeIds = context.getStorageNodeIds();
        List visNodeIds = context.getVisNodeIds();
        Map visNodeIdMaps = context.getVisNodeIdMaps();
        Map visSiteNodeIdMaps = context.getVisSiteMapList();
        ArrayList<String> visArrayNodeIds = new ArrayList<String>();
        int hostNodeNum = hostNodeIds.size();
        int storageNodeNum = storageNodeIds.size();
        int visNodeNum = visNodeIds.size();
        double maxNum = Math.max(Math.max((double)hostNodeNum / 2.0, (double)visNodeNum), (double)storageNodeNum);
        ElementBox box = context.getElementBox();
        this.locateHostNode(hostNodeIds, hostNodeNum, maxNum, box, 100.0);
        double visi = (maxNum - (double)visNodeNum) / 2.0;
        double storagei = (maxNum - (double)storageNodeNum) / 2.0;
        double nodeStorageY = 500.0;
        boolean isResetArrayY = true;
        for (String nodeId : visNodeIds) {
            Node slaveNode;
            hostNode = (Node)box.getElementByID((Object)nodeId);
            if (hostNode == null) continue;
            hostNode.setLocation(300.0 + 200.0 * visi, 300.0);
            String slaveNodeId = (String)visNodeIdMaps.get(nodeId);
            if (slaveNodeId != null && (slaveNode = (Node)box.getElementByID((Object)slaveNodeId)) != null) {
                slaveNode.setLocation(300.0 + 200.0 * visi, 400.0);
                if (isResetArrayY) {
                    isResetArrayY = false;
                    nodeStorageY = 600.0;
                }
            }
            visi += 1.0;
            storagei = this.locateVisArray(visSiteNodeIdMaps, visArrayNodeIds, box, storagei, nodeStorageY, nodeId);
        }
        for (String nodeId : storageNodeIds) {
            if (visArrayNodeIds.contains(nodeId) || (hostNode = (Node)box.getElementByID((Object)nodeId)) == null) continue;
            hostNode.setLocation(300.0 + 200.0 * storagei, nodeStorageY);
            storagei += 1.0;
        }
        List serverNodeIds = context.getServerNodeIds();
        this.locateServerNode(serverNodeIds, maxNum, box);
    }

    private void locateServerNode(List<String> serverNodeIds, double maxNum, ElementBox box) {
        if (VerifyUtil.isEmpty(serverNodeIds)) {
            return;
        }
        int serverNodeNum = serverNodeIds.size();
        this.locateHostNode(serverNodeIds, serverNodeNum, maxNum, box, 700.0);
    }

    private void locateHostNode(List<String> hostNodeIds, int hostNodeNum, double maxNum, ElementBox box, double level) {
        double i = (maxNum - (double)hostNodeNum / 2.0) / 2.0;
        for (String nodeId : hostNodeIds) {
            Node hostNode = (Node)box.getElementByID((Object)nodeId);
            if (hostNode == null) continue;
            double interval = (double)hostNodeNum > 2.0 ? 100.0 : 200.0;
            hostNode.setLocation(300.0 + interval * i, level);
            i += 1.0;
        }
    }

    private double locateVisArray(Map<String, List<String>> visSiteNodeIdMaps, List<String> visArrayNodeIds, ElementBox box, double storagei, double nodeStorageY, String nodeId) {
        List<String> arrayIds = visSiteNodeIdMaps.get(nodeId);
        if (arrayIds != null) {
            for (String arrayId : arrayIds) {
                visArrayNodeIds.add(arrayId);
                Node arrayNode = (Node)box.getElementByID((Object)arrayId);
                if (null != arrayNode) {
                    arrayNode.setLocation(300.0 + 200.0 * storagei, nodeStorageY);
                }
                storagei += 1.0;
            }
        }
        return storagei;
    }

    private void setReplicationGlobalTopoLayout(TopoBaseContext context) {
        List hostNodeIds = context.getHostNodeIds();
        List storageNodeIds = context.getStorageNodeIds();
        List serverNodeIds = context.getServerNodeIds();
        ElementBox box = context.getElementBox();
        this.eachNode(hostNodeIds, box, 100.0);
        this.eachNode(storageNodeIds, box, 300.0);
        this.eachNode(serverNodeIds, box, 500.0);
    }

    private void eachNode(List<String> hostNodeIds, ElementBox box, double nodeLevelHost) {
        double i = 0.0;
        for (String nodeId : hostNodeIds) {
            Node hostNode = (Node)box.getElementByID((Object)nodeId);
            if (hostNode == null) continue;
            hostNode.setLocation(300.0 + 200.0 * i, nodeLevelHost);
            i += 1.0;
        }
    }

    private List<String> getErrorResults(long code) {
        ArrayList<String> results = new ArrayList<String>();
        results.add("error");
        results.add(this.resourceManager.getText("ism.drm.topo.err.msg.title"));
        results.add(this.resourceManager.getErrText("lego.err." + code));
        results.add("false");
        results.add("false");
        results.add("");
        results.add("");
        results.add("");
        return results;
    }

    private ElementBox getLayoutBox(String topoIndexId) {
        ElementBox layout = new ElementBox();
        String topoXml = TopoBuildUtil.getLayoutXml(topoIndexId);
        Point center = new Point();
        AtomicInteger count = new AtomicInteger();
        layout.setClient(CENTER, (Object)center);
        layout.setClient(COUNT, (Object)count);
        layout.setClient(USEFUL, (Object)false);
        if (topoXml == null || topoXml.isEmpty()) {
            return layout;
        }
        XMLSerializer serializer = new XMLSerializer((DataBox)layout);
        serializer.deserializeXML(topoXml);
        for (Object data : layout.getDatas()) {
            if (!(data instanceof Group)) continue;
            Group group = (Group)data;
            Point2D location = group.getLocation();
            double v = count.getAndIncrement();
            double x = (center.getX() * v + location.getX()) / (v + 1.0);
            double y = (center.getY() * v + location.getY()) / (v + 1.0);
            center.setLocation(x, y);
        }
        return layout;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }
}

