/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.element;

import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.util.BusinessUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.skin.StorageSkin;
import com.huawei.ism.drm.topo.twaver.TopoElement;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.twaver.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StorageElement
extends TopoElement {
    private static final List<Integer> DO_NOT_SHOW_SNAP_INFO_LIST = new ArrayList<Integer>(Arrays.asList(0, 1, 1, 2, 3, 3, 4, 5, 6, 7, 8, 13, 15, 18, 20, 21, 22, 23, 24, 25, 26, 27, 29, 33, 34, 35, 36, 37, 38, 39, 38, 39, 51, 52, 53, 58, 59, 47, 56, 57));

    public StorageElement() {
    }

    public StorageElement(Object id) {
        this(id, null);
    }

    public StorageElement(Object id, String name) {
        super(id, name);
        this.setImage("/theme/recoverydirector/images/topo/arrayIcon.png");
        this.use(new StorageSkin());
    }

    public StorageElement(StorageNE storage) {
        this(storage.getSn() + ":storage", storage.getName());
        this.setToolTip(StorageElement.createStorageTooltip(storage));
        this.setIconByStatus(this, storage.getStatus());
        this.setStyle("icons.yoffset", 6);
        this.setStyle("label.yoffset", -6);
    }

    public StorageElement(DrStorage storage) {
        this(storage.getDeviceSn() + ":storage", storage.getName());
        this.setToolTip(StorageElement.createStorageTooltip(storage));
        this.setIconByStatus(this, NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0));
        this.setStyle("icons.yoffset", 6);
        this.setStyle("label.yoffset", -6);
    }

    public StorageElement(TopoBaseContext context, DrStorage storage) {
        this(storage.getDeviceSn() + ":storage", storage.getName());
        HashMap snToReplica = new HashMap();
        ProtectGroup protectGroup = context.getProtectGroup();
        Integer location = this.getProtectLocationBySiteId(protectGroup, storage);
        Map<String, Integer> hyperCDPInfoMap = this.getHyperCDPReplicaes(context, protectGroup, location);
        List protectGroupReplicas = context.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), "TIME_STAMP", true);
        for (ProtectGroupReplica pgr : protectGroupReplicas) {
            pgr.setPg(protectGroup);
            if (pgr.isStorageReplicationReplica() || ScheduleProtectedType.CLOUD_BACKUP.getValue() == pgr.getType()) continue;
            String devSn = pgr.getStorageDeviceId();
            if (snToReplica.containsKey(devSn)) {
                ((List)snToReplica.get(devSn)).add(pgr);
                continue;
            }
            ArrayList<ProtectGroupReplica> replicas = new ArrayList<ProtectGroupReplica>();
            replicas.add(pgr);
            snToReplica.put(devSn, replicas);
        }
        String storagedevSn = storage.getDeviceSn();
        Integer totalCount = hyperCDPInfoMap.get("totalCount");
        Integer isHYPERCDP = hyperCDPInfoMap.get("isHYPERCDP");
        List pgReplicaList = (List)snToReplica.get(storagedevSn);
        if (!VerifyUtil.isEmpty((Collection)pgReplicaList) || totalCount > 0) {
            this.setImage("/theme/recoverydirector/images/topo/Snap_Storage.png");
            this.setSnapIconByStatus(this, NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0));
        } else {
            this.setIconByStatus(this, NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0));
        }
        if (1 == isHYPERCDP) {
            this.setToolTip(StorageElement.createStorageHYPERCDPTooltip(storage, totalCount));
        } else if (BusinessUtil.isUltraVR() || DO_NOT_SHOW_SNAP_INFO_LIST.contains(protectGroup.getTemplate().getType())) {
            this.setToolTip(StorageElement.createStorageTooltip(storage));
        } else {
            this.setToolTip(StorageElement.createStorageSnapTooltip(storage, pgReplicaList));
        }
        this.setStyle("icons.yoffset", 6);
        this.setStyle("label.yoffset", -6);
    }

    private Integer getProtectLocationBySiteId(ProtectGroup protectGroup, DrStorage storage) {
        Integer location = DrmEnumDefine.ProtectLocation.A_A.getValue();
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            return location;
        }
        for (Schedule schedule : schedules) {
            String sourceSiteId = schedule.getSourceSiteId();
            if (VerifyUtil.isEmpty((String)sourceSiteId) || !sourceSiteId.equals(storage.getSiteId())) continue;
            location = schedule.getProtectLocation();
            break;
        }
        return location;
    }

    private Map<String, Integer> getHyperCDPReplicaes(TopoBaseContext context, ProtectGroup protectGroup, Integer location) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Integer totalCount = 0;
        Integer isHYPERCDP = 0;
        Set schedules = protectGroup.getTemplate().getSchedules();
        for (Schedule schedule : schedules) {
            if (schedule.getScheduleMode() != 0 || schedule.getPeriodType() != 5 || schedule.getProtectedType() != ScheduleProtectedType.HYPERCDP.getValue() || schedule.getProtectLocation() != location.intValue()) continue;
            isHYPERCDP = 1;
            totalCount = context.getReplicaService().querySecondProtectGroupReplicaCount(protectGroup.getUuid(), schedule, null, null);
        }
        map.put("totalCount", totalCount);
        map.put("isHYPERCDP", isHYPERCDP);
        return map;
    }

    public static String createStorageTooltip(DrStorage storage) {
        StringBuilder builder = new StringBuilder();
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.ip", storage.getIpAddress());
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.name", StringEscapeUtil.escape((String)storage.getName()));
        String devSn = storage.getDeviceSn();
        if (devSn.contains("mock-")) {
            devSn = "--";
        }
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.sn", devSn);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.model", storage.getProductModel());
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.status", StorageElement.getStorageStatus(NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0)));
        return builder.toString();
    }

    public static String createStorageSnapTooltip(DrStorage storage, List<ProtectGroupReplica> pgReplicaList) {
        StringBuilder builder = new StringBuilder();
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.ip", storage.getIpAddress());
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.name", StringEscapeUtil.escape((String)storage.getName()));
        String devSn = storage.getDeviceSn();
        if (devSn.contains("mock-")) {
            devSn = "--";
        }
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.sn", devSn);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.model", storage.getProductModel());
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.status", StorageElement.getStorageStatus(NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0)));
        builder.append(TooltipUtil.getSnapInfo(pgReplicaList));
        return builder.toString();
    }

    public static String createStorageTooltip(StorageNE storage) {
        StringBuilder builder = new StringBuilder();
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.ip", storage.getIpAddress());
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.name", StringEscapeUtil.escape((String)storage.getName()));
        String devSn = storage.getSn();
        if (devSn.contains("mock-")) {
            devSn = "--";
        }
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.sn", devSn);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.model", storage.getSubType());
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.status", StorageElement.getStorageStatus(storage.getStatus()));
        return builder.toString();
    }

    public static void setImageByStatus(Node storageNode, Integer status) {
        if (status == 0) {
            storageNode.setImage("/theme/recoverydirector/images/topo/array.png");
        } else if (status == -1) {
            storageNode.setImage("/theme/recoverydirector/images/topo/array_offline.png");
            storageNode.setStyle("label.color", 0x999999);
        } else if (status == 2) {
            storageNode.setImage("/theme/recoverydirector/images/topo/array_faulty.png");
            storageNode.setStyle("label.color", 15864852);
        } else {
            storageNode.setImage("/theme/recoverydirector/images/topo/array_unknown.png");
            storageNode.setStyle("label.color", 0x999999);
        }
    }

    private void setIconByStatus(Node storageNode, Integer status) {
        if (status == 0) {
            storageNode.setIcon("/theme/recoverydirector/images/topo/arrayIcon.png");
            storageNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/arrayIcon.png");
        } else if (status == -1) {
            storageNode.setIcon("/theme/recoverydirector/images/topo/arrayIcon_offline.png");
            storageNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/arrayIcon_offline.png");
        } else if (status == 2) {
            storageNode.setIcon("/theme/recoverydirector/images/topo/arrayIcon_faulty.png");
            storageNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/arrayIcon_faulty.png");
        } else {
            storageNode.setIcon("/theme/recoverydirector/images/topo/arrayIcon_unknown.png");
            storageNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/arrayIcon_unknown.png");
        }
    }

    private void setSnapIconByStatus(Node storageNode, Integer status) {
        if (status == 0) {
            storageNode.setIcon("/theme/recoverydirector/images/topo/Snap_Storage.png");
            storageNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/Snap_Storage.png");
        } else if (status == -1) {
            storageNode.setIcon("/theme/recoverydirector/images/topo/Snap_Storage_offline.png");
            storageNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/Snap_Storage_offline.png");
        } else if (status == 2) {
            storageNode.setIcon("/theme/recoverydirector/images/topo/Snap_Storage_faulty.png");
            storageNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/Snap_Storage_faulty.png");
        } else {
            storageNode.setIcon("/theme/recoverydirector/images/topo/Snap_Storage_unknown.png");
            storageNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/Snap_Storage_unknown.png");
        }
    }

    public static String getStorageStatus(Integer status) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        String online = null;
        if (status == 0) {
            online = "ism.drm.site.storage.status.online";
        } else if (status == -1) {
            online = "ism.drm.site.storage.status.offline";
        } else if (status == 2) {
            online = "ism.drm.site.storage.status.faulty";
        } else {
            return null;
        }
        return resourceManager.containText(online) ? resourceManager.getText(online) : null;
    }

    public static String createStorageHYPERCDPTooltip(DrStorage storage, Integer totalCount) {
        StringBuilder builder = new StringBuilder();
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.ip", storage.getIpAddress());
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.name", StringEscapeUtil.escape((String)storage.getName()));
        String devSn = storage.getDeviceSn();
        if (devSn.contains("mock-")) {
            devSn = "--";
        }
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.sn", devSn);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.model", storage.getProductModel());
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.status", StorageElement.getStorageStatus(NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0)));
        builder.append(TooltipUtil.getHYPERCDPInfo(totalCount));
        return builder.toString();
    }
}

