/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.agent.action;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.sdk.model.DiskPartition;
import com.huawei.ism.drm.app.sdk.model.HostAgentInfo;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.agent.action.HostRealizeAdapter;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HostAction
extends HostRealizeAdapter {
    private static final Log LOGGER = LogFactory.getInstance(HostAction.class);

    public HostAction(NeMgrProtocolExtend extend, String devSn) {
        super(extend, devSn);
    }

    public Host queryHostInfo() {
        String result = this.getHostHandler().getHostInfo();
        if (this.isResultEmpty(result)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        Host host = new Host();
        host.setName(JsonUtil.getString((JSONObject)jsonObject, (String)"name", (String[])new String[0]));
        host.setHostName(host.getName());
        host.setVersion(JsonUtil.getString((JSONObject)jsonObject, (String)"version", (String[])new String[0]));
        host.setOsVersion(host.getVersion());
        host.setUuid(JsonUtil.getString((JSONObject)jsonObject, (String)"sn", (String[])new String[0]));
        host.setSn(host.getUuid());
        host.setHostSN(host.getUuid());
        host.setOs(JsonUtil.getString((JSONObject)jsonObject, (String)"os", (String[])new String[0]));
        host.setStatus(Integer.valueOf(1));
        host.setHostStatus(Integer.valueOf(1));
        return host;
    }

    public List<Initiator> queryInitiators() {
        ArrayList<Initiator> initiators = new ArrayList<Initiator>();
        String result = this.getHostHandler().getInitiatorsInfo();
        if (this.isResultEmpty(result)) {
            return initiators;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        this.parseInitiators(initiators, jsonObject, "iscsis", DrmEnumDefine.InitiatorType.ISCSI);
        this.parseInitiators(initiators, jsonObject, "fcs", DrmEnumDefine.InitiatorType.FC);
        this.parseInitiators(initiators, jsonObject, "nvme", DrmEnumDefine.InitiatorType.NVME_OVER_ROCE);
        return initiators;
    }

    private void parseInitiators(List<Initiator> initiators, JSONObject jsonObject, String key, DrmEnumDefine.InitiatorType initiatorType) {
        JSONArray jsonArray = JsonUtil.getJSONArray((JSONObject)jsonObject, (String)key);
        if (null == jsonArray) {
            return;
        }
        for (Object obj : jsonArray) {
            String identity = (String)obj;
            Initiator initiator = new Initiator();
            initiator.setHbaType(initiatorType.getName());
            initiator.setIdentity(identity.trim());
            initiators.add(initiator);
        }
    }

    public List<Disk> queryDisks() {
        ArrayList<Disk> disks = new ArrayList<Disk>();
        String result = this.getHostHandler().getDiskInfo();
        if (this.isResultEmpty(result)) {
            return disks;
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)result);
        if (jsonArray.isEmpty()) {
            return disks;
        }
        for (Object obj : jsonArray) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            Disk disk = new Disk();
            disk.setManufacture(JsonUtil.getString((JSONObject)jsonObject, (String)"arrayVendor", (String[])new String[0]));
            String wwn = JsonUtil.getString((JSONObject)jsonObject, (String)"wwn", (String[])new String[0]);
            disk.setDiskSN(wwn);
            disk.setArraySN(JsonUtil.getString((JSONObject)jsonObject, (String)"arraySn", (String[])new String[0]));
            disk.setDiskNum(JsonUtil.getString((JSONObject)jsonObject, (String)"lunId", (String[])new String[0]));
            disk.setDiskType(JsonUtil.getString((JSONObject)jsonObject, (String)"arrayModel", (String[])new String[0]));
            disk.setDiskName(JsonUtil.getString((JSONObject)jsonObject, (String)"deviceName", (String[])new String[0]));
            disk.setUuid(this.getDevSn() + ";" + wwn);
            disk.setDiskBusID(JsonUtil.getString((JSONObject)jsonObject, (String)"diskNumber", (String[])new String[0]));
            if (VerifyUtil.isEmpty((String)disk.getManufacture())) continue;
            disks.add(disk);
        }
        return disks;
    }

    public void scanDisk() {
        this.getHostHandler().scanDisks();
    }

    public void onlineDisks(Set<String> diskNumbers) {
        if (VerifyUtil.isEmpty(diskNumbers)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"diskNumbers", (Object)JSONArray.fromObject(diskNumbers));
            this.getHostHandler().batchOnlineDisks(jsonObject.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Online disk faild, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public List<DiskPartition> queryPartitions() {
        String result = this.getHostHandler().getPartitions();
        if (this.isResultEmpty(result)) {
            return Collections.emptyList();
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)result);
        ArrayList<DiskPartition> diskPartitions = new ArrayList<DiskPartition>();
        for (Object obj : jsonArray) {
            DiskPartition partition = new DiskPartition();
            JSONObject jsonObject = JSONObject.fromObject(obj);
            partition.setPartitionName(JsonUtil.getString((JSONObject)jsonObject, (String)"partitionName", (String[])new String[0]));
            partition.setType(JsonUtil.getInteger((JSONObject)jsonObject, (String)"type", (Integer[])new Integer[0]));
            partition.setCapacity(JsonUtil.getLong((JSONObject)jsonObject, (String)"capacity", (Long[])new Long[0]));
            partition.setDeviceName(JsonUtil.getString((JSONObject)jsonObject, (String)"deviceName", (String[])new String[0]));
            partition.setDiskName(JsonUtil.getString((JSONObject)jsonObject, (String)"diskName", (String[])new String[0]));
            partition.setLba(JsonUtil.getString((JSONObject)jsonObject, (String)"LBA", (String[])new String[0]));
            diskPartitions.add(partition);
        }
        return diskPartitions;
    }

    public List<String> queryThirdPartScriptFiles() {
        ArrayList<String> files = new ArrayList<String>();
        String result = this.getHostHandler().getThirdPartScriptFiles();
        if (this.isResultEmpty(result)) {
            return files;
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)result);
        if (null == jsonArray || jsonArray.isEmpty()) {
            return files;
        }
        for (Object obj : jsonArray) {
            String file = (String)obj;
            files.add(file);
        }
        return files;
    }

    public void execThirdPartScript(String scriptName, String scriptParams) {
        if (VerifyUtil.isEmpty((String)scriptName)) {
            LOGGER.error((Object)"ScriptName is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"fileName", (Object)scriptName);
        if (VerifyUtil.isEmpty((String)scriptParams)) {
            jsonObject.put((Object)"params", (Object)new JSONObject());
            jsonObject.put((Object)"isUserDefined", (Object)"1");
        } else {
            JSONObject data = JSONObject.fromObject((Object)scriptParams);
            Object params = data.get("params");
            JSONObject paramsJson = params instanceof JSONObject ? (JSONObject)params : (params != null ? JSONObject.fromObject((Object)params) : new JSONObject());
            String isUserDefined = (String)data.get("isUserDefined");
            if (paramsJson.containsKey((Object)"isUserDefined")) {
                isUserDefined = paramsJson.getString("isUserDefined");
                paramsJson.remove((Object)"isUserDefined");
            }
            jsonObject.put((Object)"params", (Object)paramsJson.toString());
            jsonObject.put((Object)"isUserDefined", (Object)(VerifyUtil.isEmpty((String)isUserDefined) ? "1" : isUserDefined));
        }
        this.getHostHandler().doExecThirdPartScript(jsonObject.toString());
    }

    public String dataCollect() {
        String fileName = this.getHostHandler().getDataCollectInfo();
        return JsonUtil.getString((JSONObject)JSONObject.fromObject((Object)fileName), (String)"sysInfoFile", (String[])new String[0]);
    }

    public boolean exportDataCollect(String logFileName, String sn) {
        return this.getHostHandler().downloadSystemInfo(logFileName, sn);
    }

    public HostAgentInfo queryHostAgentInfo() {
        String result = this.getHostHandler().getHostAgentInfo();
        if (this.isResultEmpty(result)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        HostAgentInfo agentInfo = new HostAgentInfo();
        agentInfo.setVersion(JsonUtil.getString((JSONObject)jsonObject, (String)"version", (String[])new String[0]));
        agentInfo.setBuildNum(JsonUtil.getString((JSONObject)jsonObject, (String)"buildNum", (String[])new String[0]));
        return agentInfo;
    }

    public void execThirdPartScript(String url, Map<String, String> scriptNames, Map<String, String> scriptParams) {
        if (VerifyUtil.isEmpty(scriptNames)) {
            LOGGER.error((Object)"ScriptName is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll(scriptNames);
        if (!VerifyUtil.isEmpty(scriptParams)) {
            jsonObject.putAll(scriptParams);
        }
        this.getHostHandler().execThirdPartScriptWithUrl(url, jsonObject.toString());
    }

    public String queryHostBlockClientIp() {
        String result = this.getHostHandler().getHostBlockClientIp();
        if (this.isResultEmpty(result)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        String ip = JsonUtil.getString((JSONObject)jsonObject, (String)"dsware", (String[])new String[0]);
        LOGGER.info((Object)"Query host block clientIp ip: %s", new Object[]{ip});
        return ip;
    }
}

